/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.utils.KeyUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ClientSessionContext;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgResponseHandler;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.SDKClientApi;
import java.io.File;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtil {
    static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestUtil.class);
    private static final ValueFilter VALUE_FILTER = (object, name, value) -> {
        if (value != null && KeyUtil.JSON_PICTURE_VALUE_FILTER.contains(name)) {
            return "base64";
        }
        return value;
    };

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgToObjectConvertor<T> msgToObjectConvertor) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, null, msgToObjectConvertor);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgResponseHandler<T> respHandler) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, null, respHandler);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgResponseHandler<T> respHandler) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, objectToMsgConvertor, respHandler);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,request body:" + JSON.toJSONString((Object)objectToMsgConvertor.getObj()) + ",result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, objectToMsgConvertor, msgToObjectConvertor);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,request body:" + JSON.toJSONString((Object)objectToMsgConvertor.getObj()) + ",result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, objectToMsgConvertor, msgToObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,request body:" + JSON.toJSONString((Object)objectToMsgConvertor.getObj()) + ",result:" + JSON.toJSONString((Object)t, (SerializeFilter)VALUE_FILTER, (SerializerFeature[])new SerializerFeature[0]));
        return (T)t;
    }

    public static <T> T requestJsonOrder(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.requestJsonOrder((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, objectToMsgConvertor, msgObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,request body:" + JSON.toJSONString((Object)objectToMsgConvertor.getObj()) + ",result:" + JSON.toJSONString((Object)t, (SerializeFilter)VALUE_FILTER, (SerializerFeature[])new SerializerFeature[0]));
        return (T)t;
    }

    public static <T> T requestDigest(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.requestDigest((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, objectToMsgConvertor, msgToObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,request body:" + JSON.toJSONString((Object)objectToMsgConvertor.getObj()) + ",result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T requestDigest(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, File file, String jsonContent, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.requestDigest((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, (File)file, (String)jsonContent, msgToObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,request body:" + jsonContent + ",result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T requestDigest(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.requestDigest((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, null, msgToObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T requestDigest(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers, int timeout) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.requestDigest((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, null, msgToObjectConvertor, headers, (int)timeout);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers, int timeout) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, objectToMsgConvertor, msgToObjectConvertor, headers, (int)(timeout * 1000));
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,timeout:" + timeout + ",request body:" + JSON.toJSONString((Object)objectToMsgConvertor.getObj()) + ",result:" + JSON.toJSONString((Object)t, (SerializeFilter)VALUE_FILTER, (SerializerFeature[])new SerializerFeature[0]));
        return (T)t;
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, File file, String jsonContent, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, (File)file, (String)jsonContent, msgToObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,request body:" + jsonContent + ",result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpParam, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, (HttpUrlParam)httpParam, null, msgToObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,request params:" + httpParam.encodeUrlParam() + ",result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpParam, MsgToObjectConvertor<T> msgToObjectConvertor) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, (HttpUrlParam)httpParam, null, msgToObjectConvertor);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,request params:" + httpParam.encodeUrlParam() + ",result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpParam, MsgToObjectConvertor<T> msgToObjectConvertor, int timeout) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, (HttpUrlParam)httpParam, null, msgToObjectConvertor, (int)timeout);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,request params:" + httpParam.encodeUrlParam() + ",result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, null, msgToObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,uri:" + msgType.getUri() + ",result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers, int timeout) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, null, msgToObjectConvertor, headers, (int)(timeout * 1000));
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,uri:" + msgType.getUri() + ",result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T request(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgResponseHandler<T> respHandler, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.request((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, objectToMsgConvertor, respHandler, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T requestForm(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers, HttpEntity entity) throws SDKException {
        long beginTime = System.currentTimeMillis();
        int socketTimeout = 35;
        Object t = SDKClientApi.requestForm((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, msgToObjectConvertor, headers, (HttpEntity)entity, (int)socketTimeout);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T requestForm(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers, HttpEntity entity, int socketTimeout) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.requestForm((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, msgToObjectConvertor, headers, (HttpEntity)entity, (int)socketTimeout);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T requestDigestForTianDy(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpParam, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.requestDigestForTianDy((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, (HttpUrlParam)httpParam, null, msgToObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T requestDigestForTianDy(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.requestDigestForTianDy((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, (HttpUrlParam)httpParam, objectToMsgConvertor, msgToObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T requestDigestForTianDy(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgResponseHandler<T> respHandler) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.requestDigestForTianDy((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, null, respHandler);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T requestDigestForHIKVISION(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpParam, ObjectToMsgConvertor<?> objectToMsgConvertor, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.requestDigestForTianDy((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, (HttpUrlParam)httpParam, objectToMsgConvertor, msgToObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T requestDigestForHIKVISION(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, HttpUrlParam httpParam, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.requestDigestForTianDy((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, (HttpUrlParam)httpParam, null, msgToObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }

    public static <T> T requestDigestForDaHua(VcmReqBaseInfo vcmReqBaseInfo, MsgType msgType, MsgToObjectConvertor<T> msgToObjectConvertor, List<Header> headers) throws SDKException {
        long beginTime = System.currentTimeMillis();
        Object t = SDKClientApi.requestDigestForDaHua((ClientSessionContext)new ClientSessionContext(vcmReqBaseInfo), (MsgType)msgType, null, null, msgToObjectConvertor, headers);
        LOGGER.info("CUServer request main device ip:" + vcmReqBaseInfo.getVcmIp() + ",uri:" + msgType.getUri() + ",time:" + (System.currentTimeMillis() - beginTime) + "ms,result:" + JSON.toJSONString((Object)t));
        return (T)t;
    }
}

