/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils;

import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);
    public static final String separator = File.separator;
    public static String systemFilePath = "CuServerFile";

    public static void setSystemFilePath(String filePath) {
        systemFilePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File base64ToImage(String base64) {
        if (base64.contains("data:image")) {
            base64 = base64.substring(base64.indexOf(",") + 1);
        }
        base64 = base64.replace("\r\n", "");
        String prefix = ".jpg";
        File file = null;
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            file = File.createTempFile(UUID.randomUUID().toString(), prefix);
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] bytes = decoder.decodeBuffer(base64);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (IOException e) {
            LOGGER.error("file util base to image error1", (Throwable)e);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("file util base to image error2", (Throwable)e);
            }
        }
        return file;
    }

    public static String getImageBase64(File imgFile) {
        byte[] data = null;
        try {
            FileInputStream in = new FileInputStream(imgFile);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            LOGGER.error("file util get image base error", (Throwable)e);
        }
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);
    }

    public static void deleteFile(String filePath) {
        File file = new File(filePath);
        FileUtil.deleteFile((File)file);
    }

    public static void deleteFile(File file) {
        if (file.isFile()) {
            file.delete();
        } else {
            File[] files = file.listFiles();
            if (files == null) {
                file.delete();
            } else {
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.deleteFile((String)files[i].getAbsolutePath());
                }
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromInputStream(InputStream in, CloseableHttpResponse result) {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int rc = 0;
        try {
            while ((rc = in.read(buffer)) != -1) {
                swapStream.write(buffer, 0, rc);
            }
            byte[] data = swapStream.toByteArray();
            if ("application/json".equalsIgnoreCase(result.getHeader("Content-Type").getValue())) {
                String string = new String(data);
                return string;
            }
            String string = Base64.getEncoder().encodeToString(swapStream.toByteArray());
            return string;
        }
        catch (IOException | ProtocolException e) {
            LOGGER.error(" deal resources", e);
            swapStream.write(buffer, 0, rc);
            String string = Base64.getEncoder().encodeToString(swapStream.toByteArray());
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("resources close failed", (Throwable)e);
                }
            }
        }
    }

    public static File saveMultipartFile(String filePath, String fileName, MultipartFile uploadFile) {
        File file = null;
        try {
            if (Objects.nonNull(uploadFile) && !uploadFile.isEmpty()) {
                String fullPath = filePath + fileName;
                file = new File(FileUtil.getLocalFullPath((String)fullPath));
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (file.exists()) {
                    file.delete();
                }
                uploadFile.transferTo(file);
            }
        }
        catch (Exception e) {
            LOGGER.error("save multipart file error", (Throwable)e);
        }
        return file;
    }

    public static String getLocalFullPath(String relativePath) {
        String fullPath = systemFilePath + separator + relativePath;
        File file = new File(fullPath);
        return file.getAbsolutePath();
    }

    public static boolean deleteFileByFilePath(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
            return true;
        }
        return false;
    }

    public static void saveFile(String filePath, String fileName, String base64ImgStr) {
        OutputStream out = null;
        try {
            String fullPath = systemFilePath + filePath;
            File file = new File(new File(fullPath), fileName);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            out = new FileOutputStream(file);
            out.write(Base64.getDecoder().decode(base64ImgStr));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new InvokeException("500", e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

