/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Locale;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.impl.auth.UnsupportedDigestAlgorithmException;
import org.apache.hc.client5.http.utils.ByteArrayBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class DigestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigestUtils.class);
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String digest(String username, String realm, String password, String nonce, String nc, String cnonce, String qop, String method, String uri, String algorithm) {
        String ha1 = DigestUtils.ha1((String)username, (String)realm, (String)password);
        byte[] md5Byte = DigestUtils.digest((byte[])ha1.getBytes(Charset.defaultCharset()), (String)algorithm);
        ha1 = new String(Hex.encodeHex((byte[])md5Byte));
        md5Byte = DigestUtils.digest((byte[])DigestUtils.ha2((String)method, (String)uri).getBytes(Charset.defaultCharset()), (String)algorithm);
        String ha2 = new String(Hex.encodeHex((byte[])md5Byte));
        String original = ha1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2;
        md5Byte = DigestUtils.digest((byte[])original.getBytes(Charset.defaultCharset()), (String)algorithm);
        return new String(Hex.encodeHex((byte[])md5Byte));
    }

    public static String digest(String username, String realm, String password, String nonce, String method, String uri, String algorithm) throws AuthenticationException {
        MessageDigest digester;
        try {
            digester = DigestUtils.createMessageDigest((String)algorithm);
        }
        catch (UnsupportedDigestAlgorithmException ex) {
            throw new AuthenticationException("Unsuppported digest algorithm: " + algorithm);
        }
        ByteArrayBuilder buffer = new ByteArrayBuilder(128);
        buffer.append(username).append(":").append(realm).append(":").append(password);
        byte[] a1 = buffer.toByteArray();
        String hasha1 = DigestUtils.formatHex((byte[])digester.digest(a1));
        buffer.reset();
        byte[] a2 = buffer.append(method).append(":").append(uri).toByteArray();
        String hasha2 = DigestUtils.formatHex((byte[])digester.digest(a2));
        buffer.reset();
        buffer.append(hasha1).append(":").append(nonce).append(":").append(hasha2);
        byte[] digestInput = buffer.toByteArray();
        return DigestUtils.formatHex((byte[])digester.digest(digestInput));
    }

    private static MessageDigest createMessageDigest(String digAlg) throws UnsupportedDigestAlgorithmException {
        try {
            return MessageDigest.getInstance(digAlg);
        }
        catch (Exception e) {
            throw new UnsupportedDigestAlgorithmException("Unsupported algorithm in HTTP Digest authentication: " + digAlg);
        }
    }

    static String formatHex(byte[] binaryData) {
        int n = binaryData.length;
        char[] buffer = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
        }
        return new String(buffer);
    }

    private static String ha1(String username, String realm, String password) {
        return username + ":" + realm + ":" + password;
    }

    private static String ha2(String method, String uri) {
        return method + ":" + uri;
    }

    private static byte[] digest(byte[] input, String algorithm) {
        return DigestUtils.digest((byte[])input, (String)algorithm, null, (int)1);
    }

    private static byte[] digest(byte[] input, String algorithm, byte[] salt, int iterations) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            if (salt != null) {
                digest.update(salt);
            }
            byte[] result = digest.digest(input);
            for (int i = 1; i < iterations; ++i) {
                digest.reset();
                result = digest.digest(result);
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            return new byte[0];
        }
    }

    public static String generateSalt(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = RANDOM.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = RANDOM.nextInt(2) % 2 == 0 ? 65 : 97;
                sb.append((char)(RANDOM.nextInt(26) + temp));
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            sb.append(RANDOM.nextInt(10));
        }
        return sb.toString().toLowerCase(Locale.ROOT);
    }

    public static String encrypt(String str, String publicKey) {
        String outStr;
        try {
            byte[] decoded = Base64.decodeBase64((String)publicKey);
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pubKey);
            outStr = Base64.encodeBase64String((byte[])cipher.doFinal(str.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            LOGGER.error("RSA encrypt error", (Throwable)e);
            outStr = str;
        }
        return outStr;
    }

    public static String getAuthorization(String username, String realm, String password, String nonce, String method, String url, String algorithm, String cnonce, String nc, String qop, String opaque) throws NoSuchAlgorithmException {
        String ha1 = DigestUtils.computeHash((String)(username + ":" + realm + ":" + password), (String)algorithm);
        String ha2 = DigestUtils.computeHash((String)(method + ":" + url), (String)algorithm);
        String hash = DigestUtils.computeHash((String)(ha1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2), (String)algorithm);
        String authorization = "Digest algorithm=" + algorithm;
        if (opaque != null && !opaque.isEmpty()) {
            authorization = authorization + ", opaque=\"" + opaque + "\"";
        }
        authorization = authorization + ", username=\"" + username + "\", realm=\"" + realm + "\", nonce=\"" + nonce + "\", uri=\"" + url + "\", qop=\"" + qop + "\", nc=" + nc + ", cnonce=\"" + cnonce + "\", response=\"" + hash + "\"";
        return authorization;
    }

    public static String computeHash(String input, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] hashBytes = md.digest(input.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        String line;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            String[] keyValue = line.split("=");
            if (keyValue.length != 2) continue;
            resultMap.put(keyValue[0], keyValue[1]);
        }
        return JSON.toJSONString(resultMap);
    }
}

