/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.zkteco.zkbiosecurity.cuserver.config.ConfigHolder;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmCodeTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DeviceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceUtil.class);
    public static final List<String> BEHAVIOR_ALARM_CODE_LIST = new ArrayList();
    public static final List<String> FACE_ALARM_CODE_LIST = new ArrayList();
    public static final List<String> SITUATION_ALARM_CODE_LIST = new ArrayList();
    public static final List<String> GENERAL_ALARM_CODE_LIST = new ArrayList();
    public static final List<String> VEHICLE_ALARM_CODE_LIST = new ArrayList();
    public static final List<String> THIRD_ALARM_CODE_LIST = new ArrayList();
    public static final List<String> OPERATIONS_ALARM_CODE_LIST = new ArrayList();
    public static final List<String> SYSTEM_ALARM_CODE_LIST = new ArrayList();
    public static final Map<String, String> CLOUD_ALARM_CODE = new HashMap();
    public static String CAMERA_BIT_RANGE;
    public static String CU_FACE_REPOSITORY_NOT_EXIST;
    public static String CU_FACE_REPOSITORY_EXIST;
    public static String CU_FACE_NOT_EXIST;
    public static final String ALGORITHM_LOCAL_PATH = "upload/algorithm/local/";
    public static final String LICENSE_LOCAL_PATH = "upload/license/local/";
    public static final String ALGORITHM_UPGRADE_PATH = "upload/algorithm/upgrade/";
    public static final String VEHICLE_IMAGE_LOCAL_PATH = "upload/hw/vehicle/image/";
    public static final Predicate<InetAddress> FILTER_IPV4;
    public static final Predicate<InetAddress> FILTER_NOT_LINK_LOCAL;
    private static byte[][] invalidMacs;

    public static int getModelType(String model) {
        int type;
        block14: {
            if (StringUtils.isBlank((CharSequence)model)) {
                return 0;
            }
            type = 0;
            String deviceType = model.toUpperCase();
            if (deviceType.contains("NVR800")) {
                return 9999;
            }
            if (!Character.isDigit((deviceType = deviceType.replace("IPC", "C")).charAt(1))) {
                return type;
            }
            try {
                if (!deviceType.startsWith("X") && !deviceType.startsWith("M") && !deviceType.startsWith("C") && !deviceType.startsWith("D")) break block14;
                int i1 = Integer.parseInt(deviceType.substring(1, 2));
                switch (i1) {
                    case 1: {
                        type = 1;
                        break;
                    }
                    case 2: {
                        type = 2;
                        break;
                    }
                    case 3: {
                        type = 3;
                        break;
                    }
                    case 6: {
                        type = 6;
                        break;
                    }
                    case 7: {
                        type = Integer.parseInt(deviceType.substring(2, 3));
                        break;
                    }
                    case 8: {
                        int i22 = Integer.parseInt(deviceType.substring(2, 3));
                        if (i22 == 5) {
                            type = 6;
                        }
                        break;
                    }
                    default: {
                        type = 0;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("get model error,model:" + model, (Throwable)e);
            }
        }
        return type;
    }

    public static String getAlarmCodeType(String alarmCode) {
        if (BEHAVIOR_ALARM_CODE_LIST.contains(alarmCode)) {
            return AlarmCodeTypeEnum.ALARM_BEHAVIOR.toString();
        }
        if (VEHICLE_ALARM_CODE_LIST.contains(alarmCode)) {
            return AlarmCodeTypeEnum.ALARM_VEHICLE.toString();
        }
        if (GENERAL_ALARM_CODE_LIST.contains(alarmCode)) {
            return AlarmCodeTypeEnum.ALARM_GENERAL_BUSINESS.toString();
        }
        if (FACE_ALARM_CODE_LIST.contains(alarmCode)) {
            return AlarmCodeTypeEnum.ALARM_FACE.toString();
        }
        if (SITUATION_ALARM_CODE_LIST.contains(alarmCode)) {
            return AlarmCodeTypeEnum.ALARM_SITUATION_ANALYSIS.toString();
        }
        if (THIRD_ALARM_CODE_LIST.contains(alarmCode)) {
            return AlarmCodeTypeEnum.ALARM_THIRD_ALGORITHM.toString();
        }
        if (OPERATIONS_ALARM_CODE_LIST.contains(alarmCode)) {
            return AlarmCodeTypeEnum.ALARM_OPERATIONS.toString();
        }
        return "";
    }

    public static String getCloudAlarmCode(String alarmCode) {
        for (String s : CLOUD_ALARM_CODE.keySet()) {
            if (!((String)CLOUD_ALARM_CODE.get(s)).equals(alarmCode)) continue;
            return s;
        }
        return null;
    }

    public static String getAlarmCode(String alarmCode) {
        return (String)CLOUD_ALARM_CODE.get(alarmCode);
    }

    public static String getCallBackUrl(String domainCode) {
        String template = "%s://%s:%s/rest/ics/v1/zk/callback/ivs1800/";
        String callbackUrl = String.format(template, ConfigHolder.getHttpSchema(), ConfigHolder.getIp(), ConfigHolder.getPort());
        return callbackUrl + domainCode;
    }

    public static String getCallBackUrl(VcmReqBaseInfo vcmReqBaseInfo) {
        String template = "%s://%s:%s/rest/ics/v1/zk/callback/ivs1800/";
        String ip = ConfigHolder.getIpByParentDeviceId((String)vcmReqBaseInfo.getParentDeviceId());
        if (StringUtils.isBlank((CharSequence)ip)) {
            ip = ConfigHolder.getIp();
        }
        String[] ips = ip.split("_");
        String callbackUrl = String.format(template, ConfigHolder.getHttpSchema(), ips[0], ConfigHolder.getPort());
        return callbackUrl + vcmReqBaseInfo.getDomainCode();
    }

    public static String getListenIp(VcmReqBaseInfo vcmReqBaseInfo) {
        String ip = null;
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.connect(InetAddress.getByName(vcmReqBaseInfo.getVcmIp()), Integer.parseInt(vcmReqBaseInfo.getVcmPort()));
            ip = socket.getLocalAddress().getHostAddress();
            socket.close();
        }
        catch (Exception e) {
            LOGGER.error("get listen ip error, IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMulticast(InetAddress group, int port, byte[] message, Integer ttl, NetworkInterface nic) {
        UnmodifiableIterator nifAddresses = Iterators.filter((Iterator)Iterators.forEnumeration(nic.getInetAddresses()), (Predicate)Predicates.and((Predicate)FILTER_IPV4, (Predicate)FILTER_NOT_LINK_LOCAL));
        if (!nifAddresses.hasNext()) {
            return;
        }
        InetSocketAddress inetAddr = new InetSocketAddress((InetAddress)nifAddresses.next(), port);
        try (DatagramSocket ds = null;){
            if (group.isMulticastAddress()) {
                ds = new MulticastSocket(inetAddr);
            } else {
                ds = new DatagramSocket(inetAddr);
                ds.setBroadcast(true);
            }
            ds.send(new DatagramPacket(message, message.length, group, port));
        }
    }

    @SafeVarargs
    public static Set<NetworkInterface> getNICs(Predicate<NetworkInterface> ... filters) {
        if (null == filters) {
            filters = new Predicate[]{Filter.ALL};
        }
        try {
            UnmodifiableIterator filtered = Iterators.filter((Iterator)Iterators.forEnumeration(NetworkInterface.getNetworkInterfaces()), (Predicate)Predicates.and(filters));
            return ImmutableSet.copyOf((Iterator)filtered);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isVMMac(byte[] mac) {
        if (null == mac) {
            return false;
        }
        for (byte[] invalid : invalidMacs) {
            if (invalid[0] != mac[0] || invalid[1] != mac[1] || invalid[2] != mac[2]) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean access$000(byte[] x0) {
        return DeviceUtil.isVMMac((byte[])x0);
    }

    static {
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_TRIP_LINE");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_BEHAVIOR_ANALYSIS_TRIPWIRE");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_INTRUSION");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_BEHAVIOR_ANALYSIS_INVASION");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_OBJECT_ABANDONED");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_OBJECT_REMOVAL");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_OBJECT_WANDER");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_BEHAVIOR_ANALYSIS_WANDER");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_ENTER");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_BEHAVIOR_ANALYSIS_ENTER");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_EXIT");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_BEHAVIOR_ANALYSIS_EXIT");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_FASTMOVE");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_BEHAVIOR_ANALYSIS_FASTMOVE");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_FIRE_DETECT");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_BEHAVIOR_ANALYSIS_FIRE");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_ELE_BICYCLE");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_MOVE");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_SCENE_CHANGE");
        BEHAVIOR_ALARM_CODE_LIST.add("SDC_ALARM_SHIELD");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_SDC_CROWD_ANALYSIS");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_LIFT_ELE_BICYCLE");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_BEHAVIOR_ANALYSIS_LEGACY");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_BEHAVIOR_ANALYSIS_REMOVE");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_CAR_DETECTION");
        BEHAVIOR_ALARM_CODE_LIST.add("ALARM_BEHAVIOR_ANALYSIS_CARDET");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_DISK_FULL");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_DISK_FULL_START");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_DISK_FULL_END");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_NO_DISK");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_NO_DISK_START");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_NO_DISK_END");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_DISK_LOST_CONNECTION");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_DISK_LOST_CONNECTION_START");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_DISK_LOST_CONNECTION_END");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_DISK_SMART_ERROR");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_DISK_SMART_ERROR_START");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_DISK_SMART_ERROR_END");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_NETWORK_INTERRUPTION");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_NETWORK_INTERRUPTION_START");
        SYSTEM_ALARM_CODE_LIST.add("ALARM_NETWORK_INTERRUPTION_END");
        FACE_ALARM_CODE_LIST.add("ALARM_FACE_MASK");
        FACE_ALARM_CODE_LIST.add("ALARM_FACE_MASK_PLATFORM");
        FACE_ALARM_CODE_LIST.add("ALARM_FACE_DETECTION");
        FACE_ALARM_CODE_LIST.add("ALARM_FACE_RECOGNITION");
        FACE_ALARM_CODE_LIST.add("Face_White");
        FACE_ALARM_CODE_LIST.add("Face_Black");
        FACE_ALARM_CODE_LIST.add("ALARM_PERSON");
        FACE_ALARM_CODE_LIST.add("REPEAT_VISITOR");
        FACE_ALARM_CODE_LIST.add("ALARM_HEATIMG_TEMPER_PLATFORM");
        SITUATION_ALARM_CODE_LIST.add("ALARM_HUMAN_COUNT");
        SITUATION_ALARM_CODE_LIST.add("ALARM_QUEUE_DETECT");
        SITUATION_ALARM_CODE_LIST.add("ALARM_CROWD_DENSITY_DETECT");
        SITUATION_ALARM_CODE_LIST.add("ALARM_CROWD_ANALYSIS");
        SITUATION_ALARM_CODE_LIST.add("ALARM_PERSON_LEAVE_DETECT");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TYPE_MOVE_DECTION");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TYPE_MOVE_DECTION_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TYPE_MOVE_DECTION_END");
        GENERAL_ALARM_CODE_LIST.add("ALARM_SHIELD");
        GENERAL_ALARM_CODE_LIST.add("ALARM_SHIELD_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_SHIELD_END");
        GENERAL_ALARM_CODE_LIST.add("ALARM_AUDIO_UP");
        GENERAL_ALARM_CODE_LIST.add("ALARM_AUDIO_DOWN");
        GENERAL_ALARM_CODE_LIST.add("ALARM_NO_SIGNAL");
        GENERAL_ALARM_CODE_LIST.add("ALARM_NO_SIGNAL_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_NO_SIGNAL_END");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TYPE_DI");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TYPE_SELF_DI");
        GENERAL_ALARM_CODE_LIST.add("Face_Temp");
        GENERAL_ALARM_CODE_LIST.add("ALARM_Sound");
        GENERAL_ALARM_CODE_LIST.add("ALARM_HEATIMG_TEMPER");
        GENERAL_ALARM_CODE_LIST.add("ALARM_FACE_RECOGNITION_WARNING");
        GENERAL_ALARM_CODE_LIST.add("ALARM_BRIGHT_DIAGNOSIS");
        GENERAL_ALARM_CODE_LIST.add("ALARM_COLORCAST_DIAGNOSIS");
        GENERAL_ALARM_CODE_LIST.add("ALARM_STRIPENOISE_DIAGNOSIS");
        GENERAL_ALARM_CODE_LIST.add("ALARM_SNOW_NOISE_DIAGNOSIS");
        GENERAL_ALARM_CODE_LIST.add("ALARM_FROZEN_DIAGNOSIS");
        GENERAL_ALARM_CODE_LIST.add("ALARM_SHAKE_DIAGNOSIS");
        GENERAL_ALARM_CODE_LIST.add("ALARM_OUTOFFOCUS_DETECT");
        GENERAL_ALARM_CODE_LIST.add("ALARM_SCENECHANGE");
        GENERAL_ALARM_CODE_LIST.add("ALARM_OBJECT_DETECTION");
        GENERAL_ALARM_CODE_LIST.add("ALARM_OBJECT_DETECTION_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_OBJECT_DETECTION_END");
        GENERAL_ALARM_CODE_LIST.add("ALARM_MOTION_DETECTION_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_MOTION_DETECTION_END");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TARGET_COUNT_PERSON");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TARGET_COUNT_PERSON_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TARGET_COUNT_PERSON_END");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TARGET_COUNT_CAR");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TARGET_COUNT_CAR_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TARGET_COUNT_CAR_END");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TRIPWIRE_DETECTION_PERSON");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TRIPWIRE_DETECTION_PERSON_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TRIPWIRE_DETECTION_PERSON_END");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TRIPWIRE_DETECTION_CAR");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TRIPWIRE_DETECTION_CAR_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_TRIPWIRE_DETECTION_CAR_END");
        GENERAL_ALARM_CODE_LIST.add("ALARM_AREA_DETECTION_PERSON");
        GENERAL_ALARM_CODE_LIST.add("ALARM_AREA_DETECTION_PERSON_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_AREA_DETECTION_PERSON_END");
        GENERAL_ALARM_CODE_LIST.add("ALARM_AREA_DETECTION_CAR");
        GENERAL_ALARM_CODE_LIST.add("ALARM_AREA_DETECTION_CAR_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_AREA_DETECTION_CAR_END");
        GENERAL_ALARM_CODE_LIST.add("ALARM_MOTION_DETECTION_PERSON");
        GENERAL_ALARM_CODE_LIST.add("ALARM_MOTION_DETECTION_PERSON_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_MOTION_DETECTION_PERSON_END");
        GENERAL_ALARM_CODE_LIST.add("ALARM_MOTION_DETECTION_CAR");
        GENERAL_ALARM_CODE_LIST.add("ALARM_MOTION_DETECTION_CAR_START");
        GENERAL_ALARM_CODE_LIST.add("ALARM_MOTION_DETECTION_CAR_END");
        VEHICLE_ALARM_CODE_LIST.add("ALARM_VEHICLE_RECOGNITION");
        VEHICLE_ALARM_CODE_LIST.add("ALARM_VE_ILLEGAL_PARKING");
        VEHICLE_ALARM_CODE_LIST.add("Vehicle_Black");
        VEHICLE_ALARM_CODE_LIST.add("ALARM_NON_VEHICLE_DETECTION");
        VEHICLE_ALARM_CODE_LIST.add("ALARM_VEHICLE_DETECTION");
        THIRD_ALARM_CODE_LIST.add("ALARM_THIRD_ALGORITHM");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_IPC_OFFLINE");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_DEVICE_OFFLINE");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_SAFEVIDEO_OFFLINE");
        OPERATIONS_ALARM_CODE_LIST.add("SMIO_RAID_MTR_FS_ERROR");
        OPERATIONS_ALARM_CODE_LIST.add("SMIO_JBOD_SYS_DISK_OUT");
        OPERATIONS_ALARM_CODE_LIST.add("SMIO_JBOD_DATA_DISK_OUT");
        OPERATIONS_ALARM_CODE_LIST.add("SMIO_JBOD_DISK_FAULT");
        OPERATIONS_ALARM_CODE_LIST.add("SMIO_JBOD_SLOW_DISK");
        OPERATIONS_ALARM_CODE_LIST.add("SMIO_GROUP_DEGRADE");
        OPERATIONS_ALARM_CODE_LIST.add("SMIO_GROUP_NO_SPARE");
        OPERATIONS_ALARM_CODE_LIST.add("SMIO_JBOD_RAID_SYS_DISK_DEGRADE");
        OPERATIONS_ALARM_CODE_LIST.add("SMIO_GROUP_INIT_FAIL");
        OPERATIONS_ALARM_CODE_LIST.add("SMIO_GROUP_NOT_AVAIL");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_MEM_HIGH_ON");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_OMU_DISK_BAD_SECTOR");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_CPU_HIGH_ON");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_NETWORK_STATE");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_CERTIFICATE_OVERDUE");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_CERTIFICATE_MATURING");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_PORTAL_CERTIFICATE_OVERDUE");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_PORTAL_CERTIFICATE_MATURING");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_MU_OVERLOAD_ON");
        OPERATIONS_ALARM_CODE_LIST.add("SMIO_JBOD_DISK_FAIL_IMPEND");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_D_CHIP_PCIE_ERROR");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_DISK_TEM_HIGH_ON");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_OMU_TEMPERATURE_ON");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_OMU_FAN_ERROR_ON");
        OPERATIONS_ALARM_CODE_LIST.add("ALARM_OMU_ACTIVE_RAID_ON");
        CLOUD_ALARM_CODE.put("motion_detection", "ALARM_TYPE_MOVE_DECTION");
        CLOUD_ALARM_CODE.put("over_line_alarm", "ALARM_TRIP_LINE");
        CLOUD_ALARM_CODE.put("region_invasion_alarm", "ALARM_INTRUSION");
        CLOUD_ALARM_CODE.put("linger_alarm", "ALARM_OBJECT_WANDER");
        CLOUD_ALARM_CODE.put("region_in_alarm", "ALARM_ENTER");
        CLOUD_ALARM_CODE.put("region_out_alarm", "ALARM_EXIT");
        CLOUD_ALARM_CODE.put("fast_move_alarm", "ALARM_FASTMOVE");
        CLOUD_ALARM_CODE.put("abandon_alarm", "ALARM_OBJECT_ABANDONED");
        CLOUD_ALARM_CODE.put("removed_alarm", "ALARM_OBJECT_REMOVAL");
        CLOUD_ALARM_CODE.put("electric_bicycle_alarm", "ALARM_ELE_BICYCLE");
        CLOUD_ALARM_CODE.put("people_count_line_alarm", "ALARM_HUMAN_COUNT");
        CLOUD_ALARM_CODE.put("people_queue_alarm", "ALARM_QUEUE_DETECT");
        CLOUD_ALARM_CODE.put("people_count_region_alarm", "ALARM_CROWD_DENSITY_DETECT");
        CLOUD_ALARM_CODE.put("crowd_alarm", "ALARM_CROWD_ANALYSIS");
        CLOUD_ALARM_CODE.put("people_leave_station_alarm", "ALARM_PERSON_LEAVE_DETECT");
        CLOUD_ALARM_CODE.put("thirdparty_intelligent", "ALARM_THIRD_ALGORITHM");
        CLOUD_ALARM_CODE.put("target_alarm", "ALARM_FACE_RECOGNITION");
        CLOUD_ALARM_CODE.put("mask_alarm", "ALARM_FACE_MASK");
        CLOUD_ALARM_CODE.put("high_frequency_alarm", "REPEAT_VISITOR");
        CLOUD_ALARM_CODE.put("io_event", "ALARM_TYPE_DI");
        CLOUD_ALARM_CODE.put("channel_offline", "ALARM_IPC_OFFLINE");
        CLOUD_ALARM_CODE.put("device_offline", "ALARM_DEVICE_OFFLINE");
        CAMERA_BIT_RANGE = "512,640,768,896,1024,1280,1536,1792,2048,3072,4096,5120,6144,7168,8192,10240,12288,16384";
        CU_FACE_REPOSITORY_NOT_EXIST = "CU_FACE_REPOSITORY_NOT_EXIST";
        CU_FACE_REPOSITORY_EXIST = "CU_FACE_REPOSITORY_EXIST";
        CU_FACE_NOT_EXIST = "CU_FACE_NOT_EXIST";
        FILTER_IPV4 = addr -> addr instanceof Inet4Address;
        FILTER_NOT_LINK_LOCAL = addr -> !addr.isLinkLocalAddress();
        invalidMacs = new byte[][]{{0, 5, 105}, {0, 28, 20}, {0, 12, 41}, {0, 80, 86}, {8, 0, 39}, {10, 0, 39}, {0, 3, -1}, {0, 21, 93}};
    }
}

