/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.zknvr.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PresetPositionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PresetPositionRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.AbstractZKNvrService;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PresetPositionV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="presetPositionZkNvrV2Service")
public class PresetPositionZkNvrV2ServiceImpl
extends AbstractZKNvrService
implements PresetPositionV2Service<IServerType.ZKNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PresetPositionZkNvrV2ServiceImpl.class);

    public PresetPositionRespond add(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        this.editPresetPosition(vcmInfo, Integer.valueOf(req.getChannelCode().substring(2)), req.getPresetIndex(), Integer.valueOf(8));
        PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
        presetPositionRespond.setPresetIndex(req.getPresetIndex().intValue());
        if (req.getPointCruiseTime() != null) {
            presetPositionRespond.setPointCruiseTime(req.getPointCruiseTime().intValue());
        }
        return presetPositionRespond;
    }

    public PresetPositionRespond del(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        this.editPresetPosition(vcmInfo, Integer.valueOf(req.getChannelCode().substring(2)), req.getPresetIndex(), Integer.valueOf(40));
        PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
        presetPositionRespond.setPresetIndex(req.getPresetIndex().intValue());
        return presetPositionRespond;
    }

    public PresetPositionRespond upt(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        this.editPresetPosition(vcmInfo, Integer.valueOf(req.getChannelCode().substring(2)), req.getPresetIndex(), Integer.valueOf(8));
        PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
        presetPositionRespond.setPresetIndex(req.getPresetIndex().intValue());
        return presetPositionRespond;
    }

    public List<PresetPositionRespond> list(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        ArrayList<PresetPositionRespond> presetPositionResponds = new ArrayList<PresetPositionRespond>();
        JSONArray presetPointStatus = this.getList(vcmInfo, Integer.valueOf(req.getChannelCode().substring(2)));
        if (Objects.nonNull(presetPointStatus) && presetPointStatus.size() > 0) {
            for (int i = 0; i < presetPointStatus.size(); ++i) {
                Integer status = presetPointStatus.getInteger(i);
                if (1 != status) continue;
                PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
                presetPositionRespond.setPresetIndex(i + 1);
                presetPositionRespond.setPresetName(String.valueOf(i + 1));
                presetPositionResponds.add(presetPositionRespond);
            }
        }
        return presetPositionResponds;
    }

    private void editPresetPosition(VcmReqBaseInfo vcmInfo, Integer ch, Integer index, Integer cmd) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)1);
        jsonObject.put("Ch", (Object)ch);
        JSONObject data = new JSONObject();
        data.put("Cmd", (Object)cmd);
        data.put("Index", (Object)index);
        jsonObject.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_PTZ_PRESET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.debug("ZKTECO NVR PTZ CONTROL ERROR..");
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONArray getList(VcmReqBaseInfo vcmInfo, Integer ch) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)1);
        jsonObject.put("Ch", (Object)ch);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_PTZ_PRESET_POINT_STATUS, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONArray presetPointStatus = rsp.getJSONObject("Data").getJSONArray("PresetPointStatus");
            return presetPointStatus;
        }
        catch (SDKException e) {
            LOGGER.debug("ZKTECO NVR PTZ CONTROL ERROR..");
            throw new InvokeException("500", e.getMessage());
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

