/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.zknvr.impl;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.bean.PTZCmdEnum;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.GuardPointSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PTZControlRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.GuardPointRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PTZControlRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.AbstractZKNvrService;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PTZV2Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.zknvr.impl.PTZZKNvrV2ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ptzZKNvrV2ServiceImpl")
public class PTZZKNvrV2ServiceImpl
extends AbstractZKNvrService
implements PTZV2Service<IServerType.ZKNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PTZZKNvrV2ServiceImpl.class);

    public PTZControlRespond control(VcmReqBaseInfo vcmReqBaseInfo, PTZControlRequest request) {
        PTZControlRespond ptzControlRespond = new PTZControlRespond();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)1);
        jsonObject.put("Ch", (Object)Integer.valueOf(request.getChannelCode().substring(2)));
        JSONObject data = new JSONObject();
        if (request.getSpeed() != null) {
            data.put("Speed", (Object)request.getSpeed());
            if (request.getSpeed() <= 0) {
                data.put("IsStop", (Object)1);
            } else {
                data.put("IsStop", (Object)0);
            }
        } else {
            data.put("Speed", (Object)0);
        }
        PTZCmdEnum ptzCmdEnum = request.getPtzCmdEnum();
        Integer cmd = 0;
        switch (1.$SwitchMap$com$zkteco$zkbiosecurity$cuserver$dto$request$cu$bean$PTZCmdEnum[ptzCmdEnum.ordinal()]) {
            case 1: {
                data.put("IsStop", (Object)1);
                break;
            }
            case 2: {
                cmd = 21;
                break;
            }
            case 3: {
                cmd = 22;
                break;
            }
            case 4: {
                cmd = 23;
                break;
            }
            case 5: {
                cmd = 24;
                break;
            }
            case 6: {
                cmd = 25;
                break;
            }
            case 7: {
                cmd = 26;
                break;
            }
            case 8: {
                cmd = 27;
                break;
            }
            case 9: {
                cmd = 28;
                break;
            }
            case 10: {
                cmd = 29;
                break;
            }
            case 11: {
                cmd = 11;
                break;
            }
            case 12: {
                cmd = 12;
                break;
            }
            case 13: {
                cmd = 15;
                break;
            }
            case 14: {
                cmd = 16;
                break;
            }
            case 15: {
                cmd = 13;
                break;
            }
            case 16: {
                cmd = 14;
                break;
            }
            case 17: {
                return this.ptzCruise(vcmReqBaseInfo, request.getCruiseNo(), ptzControlRespond, jsonObject, Integer.valueOf(1));
            }
            case 18: {
                return this.ptzCruise(vcmReqBaseInfo, request.getCruiseNo(), ptzControlRespond, jsonObject, Integer.valueOf(0));
            }
            case 19: {
                return this.setPtzCruiseTime(vcmReqBaseInfo, request.getPresetIndex(), request.getPointCruiseTime(), ptzControlRespond, jsonObject);
            }
            case 20: {
                return this.ptzPreset(vcmReqBaseInfo, ptzControlRespond, request.getPresetIndex(), jsonObject);
            }
            case 21: {
                return this.ptzFastLocate(vcmReqBaseInfo, request.getX1(), request.getX2(), request.getY1(), request.getY2(), ptzControlRespond, jsonObject);
            }
            default: {
                ptzControlRespond.setResult("zkteco nvr nonsupport this cmd...");
                return ptzControlRespond;
            }
        }
        data.put("Cmd", (Object)cmd);
        jsonObject.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.FRM_PTZ_CONTROL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            ptzControlRespond.setResult("success");
            return ptzControlRespond;
        }
        catch (SDKException e) {
            LOGGER.debug("zkteco nvr ptz control error..");
            throw new InvokeException("500", e.getMessage());
        }
    }

    private PTZControlRespond setPtzCruiseTime(VcmReqBaseInfo vcmReqBaseInfo, Integer presetIndex, Integer pointCruiseTime, PTZControlRespond ptzControlRespond, JSONObject jsonObject) {
        return null;
    }

    private PTZControlRespond ptzPreset(VcmReqBaseInfo vcmReqBaseInfo, PTZControlRespond ptzControlRespond, Integer presetIndex, JSONObject reqParams) {
        JSONObject data = new JSONObject();
        data.put("Cmd", (Object)39);
        data.put("Index", (Object)presetIndex);
        reqParams.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.FRM_PTZ_PRESET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqParams, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            ptzControlRespond.setResult("success");
            return ptzControlRespond;
        }
        catch (SDKException e) {
            LOGGER.debug("ZKTECO NVR PTZ CONTROL ERROR..");
            throw new InvokeException("500", e.getMessage());
        }
    }

    private PTZControlRespond ptzFastLocate(VcmReqBaseInfo vcmReqBaseInfo, int x1, int x2, int y1, int y2, PTZControlRespond ptzControlRespond, JSONObject reqParams) {
        JSONObject data = new JSONObject();
        data.put("StartX", (Object)x1);
        data.put("StartY", (Object)y1);
        data.put("StopX", (Object)x2);
        data.put("StopY", (Object)y2);
        reqParams.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.FRM_PTZ_EXTEND_3D_POSITION, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqParams, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            ptzControlRespond.setResult("success");
            return ptzControlRespond;
        }
        catch (SDKException e) {
            LOGGER.debug("ZKTECO NVR PTZ CONTROL ERROR..");
            throw new InvokeException("500", e.getMessage());
        }
    }

    private PTZControlRespond ptzCruise(VcmReqBaseInfo vcmReqBaseInfo, String cruiseNo, PTZControlRespond ptzControlRespond, JSONObject reqParams, Integer run) {
        reqParams.put("Type", (Object)4);
        JSONObject data = new JSONObject();
        data.put("CruisePath", (Object)Integer.valueOf(cruiseNo));
        data.put("Run", (Object)run);
        reqParams.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.FRM_PTZ_CRUISE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqParams, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            ptzControlRespond.setResult("success");
            return ptzControlRespond;
        }
        catch (SDKException e) {
            LOGGER.debug("ZKTECO NVR PTZ CONTROL ERROR..");
            throw new InvokeException("500", e.getMessage());
        }
    }

    public boolean setGuardPoint(ParamBean<GuardPointSetRequest> obj) {
        JSONObject reqParams = new JSONObject();
        GuardPointSetRequest requestBody = (GuardPointSetRequest)obj.getRequestBody();
        reqParams.put("Type", (Object)1);
        reqParams.put("Ch", (Object)Integer.valueOf(((GuardPointSetRequest)obj.getRequestBody()).getChannelCode().substring(2)));
        JSONObject data = new JSONObject();
        data.put("Enable", (Object)0);
        data.put("ParkTimeOut", (Object)requestBody.getWaitSeconds());
        data.put("ParkType", (Object)0);
        data.put("ParkIdx", (Object)requestBody.getPresetIndex());
        data.put("ParkSpeed", (Object)8);
        reqParams.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)ZKNvrMsgType.FRM_PTZ_DOME_PARK, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqParams, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.debug("ZKTECO NVR SET GUARD POINT ERROR..");
            throw new InvokeException("500", e.getMessage());
        }
    }

    public GuardPointRespond getGuardPoint(ParamBean<ChannelRequest> obj) {
        GuardPointRespond guardPointRespond = new GuardPointRespond();
        JSONObject reqParams = new JSONObject();
        reqParams.put("Type", (Object)0);
        reqParams.put("Ch", (Object)Integer.valueOf(((ChannelRequest)obj.getRequestBody()).getChannelCode().substring(2)));
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)ZKNvrMsgType.FRM_PTZ_DOME_PARK, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqParams, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            JSONObject data = rsp.getJSONObject("Data");
            guardPointRespond.setEnable(data.getBoolean("Enable").booleanValue());
            guardPointRespond.setChannelCode(((ChannelRequest)obj.getRequestBody()).getChannelCode());
            guardPointRespond.setWaitSeconds(data.getInteger("ParkTimeOut").intValue());
            guardPointRespond.setPresetIndex(data.getInteger("ParkIdx").intValue());
            return guardPointRespond;
        }
        catch (SDKException e) {
            LOGGER.debug("ZKTECO NVR GET GUARD POINT ERROR...");
            throw new InvokeException("500", e.getMessage());
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

