/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.zknvr.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrConstants;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.device.CameraAddV2Request;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.respond.cu.device.CameraAddV2Respond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.AbstractZKNvrService;
import com.zkteco.zkbiosecurity.cuserver.service.v2.DeviceManageV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="deviceManageZkNvrV2Service")
public class DeviceManageZkNvrV2ServiceImpl
extends AbstractZKNvrService
implements DeviceManageV2Service<IServerType.ZKNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageZkNvrV2ServiceImpl.class);

    public CameraAddV2Respond addCamera(ParamBean<CameraAddV2Request> obj) {
        JSONArray channelCodejsonArray = new JSONArray();
        JSONArray resultArray = new JSONArray();
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        List channelInfos = ((CameraAddV2Request)obj.getRequestBody()).getChannelInfo();
        List emptyChannelCode = this.getEmptyChannelCode(obj.getVcmInfo());
        for (int i = 0; i < channelInfos.size(); ++i) {
            if (emptyChannelCode.size() > 0 && emptyChannelCode.size() > i) {
                CameraAddV2Request.ChannelInfo channelInfo = (CameraAddV2Request.ChannelInfo)channelInfos.get(i);
                Integer channelIndex = (Integer)emptyChannelCode.get(i);
                JSONObject jsonObject = this.buildAddCameraReq(channelInfo, channelIndex);
                channelCodejsonArray.add((Object)("CH" + channelIndex));
                try {
                    JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_SET_DEV_CHN_INFO, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
                    this.checkJsonRespond(rsp);
                    resultArray.add((Object)0);
                }
                catch (InvokeException e) {
                    resultArray.add((Object)1);
                    LOGGER.error("zk nvr set camera InvokeException error -- name:{} ip:{}", (Object)channelInfo.getName(), (Object)channelInfo.getIp());
                }
                catch (SDKException e) {
                    resultArray.add((Object)1);
                    LOGGER.error("zk nvr set camera error -- name:{} ip:{}", (Object)channelInfo.getName(), (Object)channelInfo.getIp());
                }
                continue;
            }
            channelCodejsonArray.add((Object)("CH" + (i + 1)));
            resultArray.add((Object)7001);
        }
        CameraAddV2Respond cameraAddRespond = new CameraAddV2Respond();
        cameraAddRespond.setCameraCode(channelCodejsonArray);
        cameraAddRespond.setResult(resultArray);
        return cameraAddRespond;
    }

    private JSONObject buildAddCameraReq(CameraAddV2Request.ChannelInfo channelInfo, Integer chIdx) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)1);
        JSONObject data = new JSONObject();
        JSONObject netChannelList = new JSONObject();
        netChannelList.put("ChIdx", (Object)chIdx);
        netChannelList.put("Domain", (Object)channelInfo.getIp());
        netChannelList.put("DomainAux", (Object)channelInfo.getDomainAux());
        netChannelList.put("UserName", (Object)channelInfo.getDeviceUser());
        netChannelList.put("Password", (Object)channelInfo.getDevicePassword());
        netChannelList.put("ProtocolType", ZKNvrConstants.PROTOCOL_TYPE_MAP_NAME.get(channelInfo.getProtocol()));
        netChannelList.put("VideoPort", (Object)Integer.valueOf(channelInfo.getPort()));
        netChannelList.put("LinkProtocol", (Object)0);
        netChannelList.put("Mac", (Object)"");
        netChannelList.put("PhyIdx", (Object)0);
        netChannelList.put("IP", (Object)channelInfo.getIp());
        netChannelList.put("Enable", (Object)1);
        netChannelList.put("Description", (Object)"");
        data.put("NetChannelList", (Object)netChannelList);
        jsonObject.put("Data", (Object)data);
        return jsonObject;
    }

    private List<Integer> getEmptyChannelCode(VcmReqBaseInfo vcmInfo) {
        int i;
        ArrayList<Integer> emptyChannels = new ArrayList<Integer>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        JSONObject channelList = this.getChannelList(vcmInfo, jsonObject);
        JSONObject data = channelList.getJSONObject("Data");
        JSONArray netChannelList = data.getJSONArray("NetChannelList");
        Integer maxChNum = data.getInteger("MaxChNum");
        ArrayList<Integer> existChannelCode = new ArrayList<Integer>();
        if (Objects.nonNull(netChannelList) && netChannelList.size() > 0 && netChannelList.size() < maxChNum) {
            for (i = 0; i < netChannelList.size(); ++i) {
                Integer chIdx = netChannelList.getJSONObject(i).getInteger("ChIdx");
                existChannelCode.add(chIdx);
            }
        }
        for (i = 1; i <= maxChNum; ++i) {
            if (existChannelCode.contains(i)) continue;
            emptyChannels.add(i);
        }
        return emptyChannels;
    }

    private JSONObject getChannelList(VcmReqBaseInfo vcmReqBaseInfo, JSONObject reqJson) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.FRM_GET_DEV_CHN_INFO, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

