/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.tianDy.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.TianDyMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.tiandy.TianDyChannelInfoStatusBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.tiandy.TianDyDeviceBasicCapBean;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.device.CameraAddV2Request;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.respond.cu.device.CameraAddV2Respond;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy.AbstractTIANDYService;
import com.zkteco.zkbiosecurity.cuserver.service.v2.DeviceManageV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.TDYUtils;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="deviceManageTIANDYV2Service")
public class DeviceManageTIANDYV2ServiceImpl
extends AbstractTIANDYService
implements DeviceManageV2Service<IServerType.Tiandy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageTIANDYV2ServiceImpl.class);

    public CameraAddV2Respond addCamera(ParamBean<CameraAddV2Request> obj) {
        JSONArray channelCodejsonArray = new JSONArray();
        JSONArray resultArray = new JSONArray();
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        List channelInfos = ((CameraAddV2Request)obj.getRequestBody()).getChannelInfo();
        List emptyChannelCode = this.getEmptyChannelCode(obj.getVcmInfo());
        for (int i = 0; i < channelInfos.size(); ++i) {
            if (emptyChannelCode.size() > 0 && emptyChannelCode.size() > i) {
                CameraAddV2Request.ChannelInfo channelInfo = (CameraAddV2Request.ChannelInfo)channelInfos.get(i);
                Integer channelIndex = (Integer)emptyChannelCode.get(i);
                String xmlStr = this.buildAddCameraReq(vcmInfo, channelInfo, channelIndex);
                channelCodejsonArray.add((Object)("CH" + channelIndex));
                try {
                    HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new TianDyMsgType(HttpMethodEnum.HTTP_METHOD_PUT, TianDyMsgType.UPDATE_CHANNEL_INFO.getUri() + channelIndex), null, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)xmlStr, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
                    resultArray.add((Object)0);
                }
                catch (InvokeException e) {
                    resultArray.add((Object)1);
                    LOGGER.error("TianDy nvr set camera InvokeException error -- name:{} ip:{}", (Object)channelInfo.getName(), (Object)channelInfo.getIp());
                }
                catch (SDKException e) {
                    resultArray.add((Object)1);
                    LOGGER.error("TianDy nvr set camera error -- name:{} ip:{}", (Object)channelInfo.getName(), (Object)channelInfo.getIp());
                }
                continue;
            }
            channelCodejsonArray.add((Object)("CH" + (i + 1)));
            resultArray.add((Object)7001);
        }
        CameraAddV2Respond cameraAddRespond = new CameraAddV2Respond();
        cameraAddRespond.setCameraCode(channelCodejsonArray);
        cameraAddRespond.setResult(resultArray);
        return cameraAddRespond;
    }

    private String buildAddCameraReq(VcmReqBaseInfo vcmInfo, CameraAddV2Request.ChannelInfo channelInfo, Integer chIdx) {
        String rsp = null;
        try {
            rsp = (String)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmInfo, (MsgType)TianDyMsgType.GET_DIGITAL_CHANNEL_OPERATE, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
            Document doc = DocumentHelper.parseText((String)rsp);
            Element root = doc.getRootElement();
            root.element("id").setText(String.valueOf(chIdx));
            root.element("quickAdd").setText("false");
            Element childElement = root.element("sourceInputPortDescriptor");
            childElement.element("access").setText(channelInfo.getConnectCode());
            childElement.element("enable").setText("true");
            childElement.element("channel").setText(String.valueOf(chIdx));
            childElement.element("channelName").setText(channelInfo.getName());
            childElement.element("adminProtocol").setText(channelInfo.getProtocol());
            childElement.element("addressingFormatType").setText("ipaddress");
            childElement.element("ipAddress").setText(channelInfo.getIp());
            childElement.element("adminPortNo").setText(channelInfo.getPort());
            childElement.element("srcInputPort").setText("1");
            childElement.element("userName").setText(channelInfo.getDeviceUser());
            childElement.element("password").setText(channelInfo.getDevicePassword());
            childElement.element("activated").setText("active");
            childElement.element("synchroToIpc").setText("true");
            childElement.element("streamType").setText("tcp");
            childElement.element("mainstreamRtspURL").setText("rtsp://");
            childElement.element("substreamRtspURL").setText("rtsp://");
            return doc.getRootElement().asXML();
        }
        catch (SDKException e) {
            LOGGER.error("build AddCamera Req fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
        catch (DocumentException e) {
            LOGGER.error("Document Exception", (Throwable)e);
            return rsp;
        }
    }

    private List<Integer> getEmptyChannelCode(VcmReqBaseInfo vcmInfo) {
        ArrayList<Integer> emptyChannels = new ArrayList<Integer>();
        List existChannelCode = this.getChannelStatus(vcmInfo);
        JSONObject channelSum = this.getChannelSum(vcmInfo);
        Integer maxChNum = Integer.parseInt(channelSum.getString("iDigitalChanNums"));
        for (int i = 1; i <= maxChNum; ++i) {
            if (existChannelCode.contains(i)) continue;
            emptyChannels.add(i);
        }
        return emptyChannels;
    }

    private List<Integer> getChannelStatus(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            TianDyChannelInfoStatusBean rsp = (TianDyChannelInfoStatusBean)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)TianDyMsgType.GET_ALL_CHANNELS_STATUS, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, TianDyChannelInfoStatusBean.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            JSONArray infoJson = JSONObject.parseObject((String)JSON.toJSONString((Object)rsp)).getJSONArray("inputProxyChnBasicStatus");
            ArrayList<Integer> res = new ArrayList<Integer>();
            for (int i = 0; i < infoJson.size(); ++i) {
                res.add(Integer.parseInt(infoJson.getJSONObject(i).getString("id")));
            }
            return res;
        }
        catch (SDKException e) {
            LOGGER.error("get Channel Status fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject getChannelSum(VcmReqBaseInfo vcmInfo) {
        try {
            TianDyDeviceBasicCapBean rsp = (TianDyDeviceBasicCapBean)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmInfo, (MsgType)TianDyMsgType.GET_DEVICE_BASIC_CAPABILITIES, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, TianDyDeviceBasicCapBean.class), (List)this.getJSONHeaders(vcmInfo));
            return JSONObject.parseObject((String)JSON.toJSONString((Object)rsp));
        }
        catch (SDKException e) {
            LOGGER.error("get Channel Sum  fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

