/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.sdc.impl;

import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositoryRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.FaceLibraryParaRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.FaceLibraryParaRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.FaceLibraryService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SessionCheck;
import com.zkteco.zkbiosecurity.cuserver.service.v2.FaceRepositoryManagementV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.SdcReasonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@SdcServiceType
public class FaceRepositorySdcV2SdkServiceImpl
implements FaceRepositoryManagementV2Service<IServerType.SDC> {
    @Autowired
    private FaceLibraryService faceLibraryService;

    @SessionCheck
    public FaceRepositoryRespond add(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        FaceRepositoryRespond faceRepositoryRespond = new FaceRepositoryRespond();
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepository);
        if (!CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            this.updateFaceRepository(vcmReqBaseInfo, faceRepository, ((FaceRepository)faceRepositoryList.get(0)).getGroupId());
            faceRepositoryRespond.setSuccess(true);
            return faceRepositoryRespond;
        }
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        FaceLibraryParaRequest faceLibraryParaRequest = new FaceLibraryParaRequest();
        faceLibraryParaRequest.setOnControl(faceRepository.getEnabled());
        faceLibraryParaRequest.setThreshold(faceRepository.getThreshold() == null ? 80 : faceRepository.getThreshold());
        faceLibraryParaRequest.setFaceListName(faceRepository.getName());
        this.setFaceLibraryType(faceRepository, request, faceLibraryParaRequest);
        try {
            this.faceLibraryService.addFaceLibrary(request);
            faceRepositoryRespond.setSuccess(true);
            return faceRepositoryRespond;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    private boolean updateFaceRepository(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository, String groupStrId) {
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        FaceLibraryParaRequest faceLibraryParaRequest = new FaceLibraryParaRequest();
        faceLibraryParaRequest.setId(groupStrId);
        faceLibraryParaRequest.setOnControl(faceRepository.getEnabled());
        faceLibraryParaRequest.setThreshold(faceRepository.getThreshold() == null ? 80 : faceRepository.getThreshold());
        if (Objects.nonNull(faceRepository.getNewName())) {
            faceLibraryParaRequest.setFaceListName(faceRepository.getNewName());
        } else {
            faceLibraryParaRequest.setFaceListName(faceRepository.getName());
        }
        this.setFaceLibraryType(faceRepository, request, faceLibraryParaRequest);
        try {
            return this.faceLibraryService.updateFaceLibrary(request);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    public List<FaceRepository> searchCommon(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        List<Object> faceRepositoryList = new ArrayList<FaceRepository>();
        FaceRepositorySearchRespond searchRespond = this.search(vcmReqBaseInfo, faceRepository);
        if (!CollectionUtils.isEmpty((Collection)searchRespond.getRepositories())) {
            faceRepositoryList = searchRespond.getRepositories();
            faceRepositoryList.removeIf(item -> !faceRepository.getName().equals(item.getName()));
        }
        return faceRepositoryList;
    }

    private void setFaceLibraryType(FaceRepositoryRequest faceRepository, DeviceRequest<FaceLibraryParaRequest> request, FaceLibraryParaRequest faceLibraryParaRequest) {
        if (Objects.nonNull(faceRepository.getType())) {
            if ("2".equals(faceRepository.getType())) {
                faceLibraryParaRequest.setFaceListType(1);
            } else if ("3".equals(faceRepository.getType())) {
                faceLibraryParaRequest.setFaceListType(2);
            } else {
                faceLibraryParaRequest.setFaceListType(0);
            }
        } else {
            faceLibraryParaRequest.setFaceListType(0);
        }
        request.setRequest((Object)faceLibraryParaRequest);
    }

    @SessionCheck
    public FaceRepositoryRespond update(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        FaceRepositoryRespond faceRepositoryRespond = new FaceRepositoryRespond();
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepository);
        if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_NOT_EXIST);
        }
        if (StringUtils.isNotBlank((CharSequence)faceRepository.getNewName()) && this.isExistFaceRepository(vcmReqBaseInfo, faceRepository) && !faceRepository.getNewName().equals(faceRepository.getName())) {
            throw new InvokeException("500", SdcReasonUtil.CU_FACE_REPOSITORY_EXIST);
        }
        this.updateFaceRepository(vcmReqBaseInfo, faceRepository, ((FaceRepository)faceRepositoryList.get(0)).getGroupId());
        faceRepositoryRespond.setSuccess(true);
        return faceRepositoryRespond;
    }

    private boolean isExistFaceRepository(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        FaceRepositorySearchRespond searchRespond = this.search(vcmReqBaseInfo, faceRepository);
        if (!CollectionUtils.isEmpty((Collection)searchRespond.getRepositories())) {
            for (FaceRepository repository : searchRespond.getRepositories()) {
                if (!faceRepository.getNewName().equals(repository.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @SessionCheck
    public boolean delete(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        List faceRepositoryList = this.searchCommon(vcmReqBaseInfo, faceRepository);
        if (CollectionUtils.isEmpty((Collection)faceRepositoryList)) {
            return true;
        }
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        FaceLibraryParaRequest faceLibraryParaRequest = new FaceLibraryParaRequest();
        faceLibraryParaRequest.setId(((FaceRepository)faceRepositoryList.get(0)).getGroupId());
        faceLibraryParaRequest.setFaceListName(faceRepository.getName());
        request.setRequest((Object)faceLibraryParaRequest);
        try {
            return this.faceLibraryService.deleteFaceLibrary(request);
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    @SessionCheck
    public FaceRepositorySearchRespond search(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        DeviceRequest request = new DeviceRequest();
        request.setSession(vcmReqBaseInfo.getVcmSession());
        try {
            FaceRepositorySearchRespond faceRepositoryRespond = new FaceRepositorySearchRespond();
            List faceLibraryParaResponds = this.faceLibraryService.getFaceLibraryList(request);
            List faceRepositories = this.copyList(faceLibraryParaResponds);
            faceRepositoryRespond.setTotal(String.valueOf(faceLibraryParaResponds.size()));
            faceRepositoryRespond.setRepositories(faceRepositories);
            return faceRepositoryRespond;
        }
        catch (IpcException e) {
            throw new InvokeException("500", e.getMessage());
        }
    }

    private List<FaceRepository> copyList(List<FaceLibraryParaRespond> copiedList) {
        ArrayList<FaceRepository> faceRepositories = new ArrayList<FaceRepository>();
        for (int i = 0; i < copiedList.size(); ++i) {
            FaceRepository faceRepository = new FaceRepository();
            String type = "";
            switch (copiedList.get(i).getFaceListType()) {
                case 0: {
                    type = "2";
                    break;
                }
                case 1: {
                    type = "2";
                    break;
                }
                case 2: {
                    type = "3";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + copiedList.get(i).getFaceListType());
                }
            }
            faceRepository.setType(type);
            faceRepository.setName(copiedList.get(i).getFaceListName());
            faceRepository.setGroupId(copiedList.get(i).getId());
            faceRepositories.add(faceRepository);
        }
        return faceRepositories;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return null;
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return null;
    }
}

