/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.nvr800.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.bean.PTZCmdEnum;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.GuardPointSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PTZControlRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.GuardPointRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.PTZControlRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.SingleChannelRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.bean.PTZCmdInfoNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.GuardPointRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PTZControlRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.PTZControlRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.PTZIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PTZV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ptzNVR800V2Service")
public class PtzNvr800V2ServiceImpl
extends AbstractNvr800Service
implements PTZV2Service<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PTZIvs1800ServiceImpl.class);

    public PTZControlRespond control(VcmReqBaseInfo vcmInfo, PTZControlRequest request) {
        if (PTZCmdEnum.PTZ_FAST_LOCATE.equals((Object)request.getPtzCmdEnum())) {
            PTZControlRequestNvr800 ptzControlRequestNvr800 = new PTZControlRequestNvr800();
            JSONObject data = ptzControlRequestNvr800.getData();
            data.put("channel", (Object)request.getChannelCode());
            data.put("cmd", (Object)52);
            data.put("point", (Object)new JSONArray());
            JSONObject point1 = new JSONObject();
            point1.put("x", (Object)request.getX1());
            point1.put("y", (Object)request.getY1());
            JSONObject point2 = new JSONObject();
            point2.put("x", (Object)request.getX2());
            point2.put("y", (Object)request.getY2());
            data.getJSONArray("point").add((Object)point1);
            data.getJSONArray("point").add((Object)point2);
            ptzControlRequestNvr800.setData(data);
            return this.sendControl(vcmInfo, ptzControlRequestNvr800);
        }
        if (PTZCmdEnum.PTZ_STOP.equals((Object)request.getPtzCmdEnum())) {
            PTZControlRequestNvr800 ptzControlRequestNvr800 = this.requestToNvr800(request);
            try {
                this.sendControl(vcmInfo, ptzControlRequestNvr800);
            }
            catch (Exception data) {
                // empty catch block
            }
            try {
                JSONObject data = ptzControlRequestNvr800.getData();
                data.put("cmd", (Object)15);
                this.sendControl(vcmInfo, ptzControlRequestNvr800);
            }
            catch (Exception data) {}
        } else {
            PTZControlRequestNvr800 ptzControlRequestNvr800 = this.requestToNvr800(request);
            JSONObject data = ptzControlRequestNvr800.getData();
            if (data.getInteger("cmd") == 16) {
                data.put("cmd", (Object)56);
                JSONObject curiseTrack = new JSONObject();
                curiseTrack.put("track_index", (Object)Integer.valueOf(request.getCruiseNo()));
                data.put("curise_track", (Object)curiseTrack);
                if (data.getBoolean("ctl_stop").booleanValue()) {
                    data.put("cmd", (Object)57);
                }
            }
            return this.sendControl(vcmInfo, ptzControlRequestNvr800);
        }
        PTZControlRespond ptzControlRespond = new PTZControlRespond();
        ptzControlRespond.setResult("success");
        return ptzControlRespond;
    }

    private PTZControlRespond sendControl(VcmReqBaseInfo vcmInfo, PTZControlRequestNvr800 ptzControlRequestNvr800) {
        PTZControlRespond ptzControlRespond = new PTZControlRespond();
        try {
            PTZControlRespondNvr800 ptzControlRespondNvr800 = (PTZControlRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.PTZ_CONTROL_NVR800_V2_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)ptzControlRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PTZControlRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)ptzControlRespondNvr800);
            ptzControlRespond.setResult(ptzControlRespondNvr800.getResult());
            return ptzControlRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setGuardPoint(ParamBean<GuardPointSetRequest> obj) {
        try {
            GuardPointRequestNvr800 requestNvr800 = new GuardPointRequestNvr800((GuardPointSetRequest)obj.getRequestBody());
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.GUARD_POINT_SET_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            LOGGER.debug("Set guardPoint from sdk is end.");
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public GuardPointRespond getGuardPoint(ParamBean<ChannelRequest> obj) {
        try {
            SingleChannelRequestNvr800 requestNvr800 = new SingleChannelRequestNvr800(((ChannelRequest)obj.getRequestBody()).getChannelCode());
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.GUARD_POINT_GET_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            LOGGER.debug("Set guardPoint from sdk is end.");
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            GuardPointRespond respond = new GuardPointRespond();
            respond.setChannelCode(((ChannelRequest)obj.getRequestBody()).getChannelCode());
            respond.setEnable(respondNvr800.getData().getBoolean("enable").booleanValue());
            respond.setWaitSeconds(respondNvr800.getData().getIntValue("wait_time"));
            respond.setPresetIndex(respondNvr800.getData().getIntValue("preset_index"));
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private PTZControlRequestNvr800 requestToNvr800(PTZControlRequest req) {
        PTZControlRequestNvr800 ptzControlRequestNvr800 = new PTZControlRequestNvr800();
        PTZCmdInfoNvr800 ptzCmdInfoNvr800 = new PTZCmdInfoNvr800();
        Map cmdInfo = ptzCmdInfoNvr800.getCmdInfoMap(req.getPtzCmdEnum().toString());
        JSONObject data = ptzControlRequestNvr800.getData();
        if (null != req.getSpeed()) {
            cmdInfo.put("speed", req.getSpeed());
            data.put("speed", cmdInfo.get("speed"));
        }
        if (null != req.getPointCruiseTime()) {
            cmdInfo.put("point_cruise_time", req.getPointCruiseTime());
            data.put("point_cruise_time", cmdInfo.get("point_cruise_time"));
        }
        if (null != req.getPresetIndex()) {
            cmdInfo.put("preset_index", req.getPresetIndex());
            data.put("preset_index", cmdInfo.get("preset_index"));
        }
        data.put("channel", (Object)req.getChannelCode());
        data.put("cmd", cmdInfo.get("cmd"));
        data.put("ctl_stop", cmdInfo.get("ctl_stop"));
        return ptzControlRequestNvr800;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

