/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.nvr800.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PresetPositionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.PresetPositionRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PresetPositionRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PtzDetailRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.PresetPositionRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PresetPositionV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="presetPositionNvr800V2Service")
public class PresetPositionNvr800V2ServiceImpl
extends AbstractNvr800Service
implements PresetPositionV2Service<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PresetPositionNvr800V2ServiceImpl.class);

    public PresetPositionRespond add(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRequestNvr800 presetPositionRequestNvr800 = this.addRequestToNvr800(req);
        try {
            PresetPositionRespondNvr800 presetPositionRespondNvr800 = (PresetPositionRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.PTZ_CONTROL_NVR800_V2_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)presetPositionRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PresetPositionRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)presetPositionRespondNvr800);
            PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
            presetPositionRespond.setPresetIndex(req.getPresetIndex().intValue());
            return presetPositionRespond;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public PresetPositionRespond del(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRequestNvr800 presetPositionRequestNvr800 = this.delRequestToNvr800(req);
        try {
            PresetPositionRespondNvr800 presetPositionRespondNvr800 = (PresetPositionRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.PTZ_CONTROL_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)presetPositionRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PresetPositionRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)presetPositionRespondNvr800);
            PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
            presetPositionRespond.setPresetIndex(req.getPresetIndex().intValue());
            return presetPositionRespond;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public PresetPositionRespond upt(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        this.del(vcmInfo, req);
        return this.add(vcmInfo, req);
    }

    public List<PresetPositionRespond> list(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        try {
            PresetPositionRespondNvr800 presetPositionRespondNvr800 = this.getPtzList(vcmInfo, req);
            JSONArray presetPointArray = presetPositionRespondNvr800.getData().getJSONArray("preset_point");
            ArrayList<PresetPositionRespond> respondList = new ArrayList<PresetPositionRespond>();
            for (int i = 0; i < presetPointArray.size(); ++i) {
                JSONObject presetPoint = (JSONObject)presetPointArray.get(i);
                PresetPositionRespond respond = new PresetPositionRespond();
                respond.setPresetIndex(presetPoint.getInteger("preset_index").intValue());
                respond.setPresetName(presetPoint.getString("preset_name"));
                respond.setFocusSwitch(Integer.valueOf(presetPoint.getBoolean("focus_enable") != false ? 1 : 0));
                respond.setHasTime(false);
                respondList.add(respond);
            }
            return respondList;
        }
        catch (Exception e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", "500");
        }
    }

    public PresetPositionRespondNvr800 getPtzList(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRequestNvr800 presetPositionRequestNvr800 = this.listRequestToNvr800(req);
        try {
            PresetPositionRespondNvr800 presetPositionRespondNvr800 = (PresetPositionRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.PTZ_PRESET_POSITION_NVR800_V2_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)presetPositionRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PresetPositionRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            return presetPositionRespondNvr800;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public PtzDetailRespond getPtzDetail(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRequestNvr800 presetPositionRequestNvr800 = this.listRequestToNvr800(req);
        PtzDetailRespond detailRespond = new PtzDetailRespond();
        try {
            PresetPositionRespondNvr800 presetPositionRespondNvr800 = (PresetPositionRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.PTZ_PRESET_POSITION_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)presetPositionRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PresetPositionRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            JSONArray presetPointArray = presetPositionRespondNvr800.getData().getJSONArray("preset_point");
            ArrayList<PresetPositionRespond> respondList = new ArrayList<PresetPositionRespond>();
            for (int i = 0; i < presetPointArray.size(); ++i) {
                int time = presetPointArray.getIntValue(i);
                if (time <= 0) continue;
                PresetPositionRespond respond = new PresetPositionRespond();
                respond.setPresetIndex(i + 1);
                respond.setPointCruiseTime(time);
                respond.setSpeed(Integer.valueOf(5));
                respondList.add(respond);
            }
            detailRespond.setPresetPositionList(respondList);
            detailRespond.setCruiseState(presetPositionRespondNvr800.getData().getBooleanValue("cruise_state"));
            detailRespond.setLineScanState(presetPositionRespondNvr800.getData().getBooleanValue("line_scan_state"));
            return detailRespond;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private PresetPositionRequestNvr800 addRequestToNvr800(PresetPositionRequest req) {
        PresetPositionRequestNvr800 presetPositionRequestNvr800 = new PresetPositionRequestNvr800();
        JSONObject data = new JSONObject();
        data.put("cmd", (Object)18);
        data.put("channel", (Object)req.getChannelCode());
        JSONObject presetPoint = new JSONObject();
        presetPoint.put("preset_index", (Object)req.getPresetIndex());
        presetPoint.put("preset_name", (Object)req.getPresetName());
        presetPoint.put("focus_enable", (Object)(req.getFocusSwitch() == 1 ? 1 : 0));
        data.put("preset_point", (Object)presetPoint);
        presetPositionRequestNvr800.setData(data);
        return presetPositionRequestNvr800;
    }

    private PresetPositionRequestNvr800 delRequestToNvr800(PresetPositionRequest req) {
        PresetPositionRequestNvr800 presetPositionRequestNvr800 = new PresetPositionRequestNvr800();
        JSONObject data = new JSONObject();
        data.put("cmd", (Object)19);
        data.put("channel", (Object)req.getChannelCode());
        data.put("preset_index", (Object)req.getPresetIndex());
        presetPositionRequestNvr800.setData(data);
        return presetPositionRequestNvr800;
    }

    private PresetPositionRequestNvr800 listRequestToNvr800(PresetPositionRequest req) {
        PresetPositionRequestNvr800 presetPositionRequestNvr800 = new PresetPositionRequestNvr800();
        JSONObject data = new JSONObject();
        data.put("channel", (Object)req.getChannelCode());
        data.put("command_flag", (Object)false);
        presetPositionRequestNvr800.setData(data);
        return presetPositionRequestNvr800;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

