/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.nvr800.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.FaceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.FaceSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.picturesearch.FaceSearchV2Request;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PictureSearchV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PictureSearchNVR800V2ServiceImpl
extends AbstractNvr800Service
implements PictureSearchV2Service<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PictureSearchNVR800V2ServiceImpl.class);

    public FaceSearchRespond faceSearch(ParamBean<FaceSearchV2Request> obj) {
        ParamBean faceSearch = new ParamBean();
        FaceSearchRequest faceSearchNVR800 = new FaceSearchRequest();
        faceSearchNVR800.setSearchCount(((FaceSearchV2Request)obj.getRequestBody()).getSearchCount());
        ArrayList<String> cameraList = new ArrayList<String>();
        for (int i = 0; i < ((FaceSearchV2Request)obj.getRequestBody()).getCameraList().size(); ++i) {
            String str = (String)((FaceSearchV2Request)obj.getRequestBody()).getCameraList().get(i);
            String str1 = str.substring(0, str.indexOf("#"));
            cameraList.add(str1);
        }
        faceSearchNVR800.setChannelCodes(cameraList);
        ArrayList<Integer> sexArray = new ArrayList<Integer>();
        if (((FaceSearchV2Request)obj.getRequestBody()).getGender() != -1) {
            if (((FaceSearchV2Request)obj.getRequestBody()).getGender() == 0) {
                sexArray.add(0);
            } else if (((FaceSearchV2Request)obj.getRequestBody()).getGender() == 1) {
                sexArray.add(1);
            } else if (((FaceSearchV2Request)obj.getRequestBody()).getGender() == 2) {
                sexArray.add(2);
            }
        }
        faceSearchNVR800.setSex(sexArray);
        ArrayList<Integer> ageArray = new ArrayList<Integer>();
        for (int i = 0; i < ((FaceSearchV2Request)obj.getRequestBody()).getAgeValue().size(); ++i) {
            int a2 = (Integer)((FaceSearchV2Request)obj.getRequestBody()).getAgeValue().get(i);
            if (a2 == -1) continue;
            if (a2 == 0) {
                ageArray.add(7);
                faceSearchNVR800.setAge(ageArray);
                faceSearchNVR800.setAgeGrpType(((FaceSearchV2Request)obj.getRequestBody()).getAgeValue());
                continue;
            }
            if (a2 == 1 || a2 == 2) {
                ageArray.add(0);
                faceSearchNVR800.setAge(ageArray);
                faceSearchNVR800.setAgeGrpType(((FaceSearchV2Request)obj.getRequestBody()).getAgeValue());
                continue;
            }
            if (a2 == 3) {
                ageArray.add(1);
                ageArray.add(2);
                ageArray.add(3);
                faceSearchNVR800.setAge(ageArray);
                faceSearchNVR800.setAgeGrpType(((FaceSearchV2Request)obj.getRequestBody()).getAgeValue());
                continue;
            }
            if (a2 == 4) {
                ageArray.add(4);
                ageArray.add(5);
                faceSearchNVR800.setAge(ageArray);
                faceSearchNVR800.setAgeGrpType(((FaceSearchV2Request)obj.getRequestBody()).getAgeValue());
                continue;
            }
            if (a2 != 5) continue;
            ageArray.add(6);
            faceSearchNVR800.setAge(ageArray);
            faceSearchNVR800.setAgeGrpType(((FaceSearchV2Request)obj.getRequestBody()).getAgeValue());
        }
        ArrayList<Integer> mouthMaskTypeArray = new ArrayList<Integer>();
        if (((FaceSearchV2Request)obj.getRequestBody()).getMouthmask() != -1) {
            if (((FaceSearchV2Request)obj.getRequestBody()).getMouthmask() == 0) {
                mouthMaskTypeArray.add(0);
            } else if (((FaceSearchV2Request)obj.getRequestBody()).getMouthmask() == 1) {
                mouthMaskTypeArray.add(2);
            } else if (((FaceSearchV2Request)obj.getRequestBody()).getMouthmask() == 2) {
                mouthMaskTypeArray.add(1);
            }
        }
        faceSearchNVR800.setMouthMaskType(mouthMaskTypeArray);
        faceSearchNVR800.setHairType(((FaceSearchV2Request)obj.getRequestBody()).getHairType());
        ArrayList<Integer> hatTypeArray = new ArrayList<Integer>();
        if (((FaceSearchV2Request)obj.getRequestBody()).getHat() != -1) {
            if (((FaceSearchV2Request)obj.getRequestBody()).getHat() == 0) {
                hatTypeArray.add(0);
            } else if (((FaceSearchV2Request)obj.getRequestBody()).getHat() == 1) {
                hatTypeArray.add(2);
            } else if (((FaceSearchV2Request)obj.getRequestBody()).getHat() == 2) {
                hatTypeArray.add(1);
            }
        }
        faceSearchNVR800.setHatType(hatTypeArray);
        ArrayList<Integer> glassTypeArray = new ArrayList<Integer>();
        if (((FaceSearchV2Request)obj.getRequestBody()).getEyeglass() != -1) {
            if (((FaceSearchV2Request)obj.getRequestBody()).getEyeglass() == 0) {
                glassTypeArray.add(0);
            } else if (((FaceSearchV2Request)obj.getRequestBody()).getEyeglass() == 1) {
                glassTypeArray.add(2);
                glassTypeArray.add(3);
            } else if (((FaceSearchV2Request)obj.getRequestBody()).getEyeglass() == 2) {
                glassTypeArray.add(1);
            }
        }
        faceSearchNVR800.setGlassType(glassTypeArray);
        faceSearchNVR800.setGroupIds(((FaceSearchV2Request)obj.getRequestBody()).getGroupIds());
        faceSearchNVR800.setStartTime(PictureSearchNVR800V2ServiceImpl.dateToStamp((String)((FaceSearchV2Request)obj.getRequestBody()).getStartTime()));
        faceSearchNVR800.setEndTime(PictureSearchNVR800V2ServiceImpl.dateToStamp((String)((FaceSearchV2Request)obj.getRequestBody()).getEndTime()));
        faceSearch.setRequestBody((Object)faceSearchNVR800);
        faceSearch.setVcmInfo(obj.getVcmInfo());
        JSONObject countInfo = this.faceSearchCount(faceSearch, -1);
        int count = countInfo.getIntValue("Count");
        FaceSearchRespond faceSearchRespond = new FaceSearchRespond();
        if (count > 0 && ((FaceSearchV2Request)obj.getRequestBody()).getSearchCount() > 0) {
            faceSearchRespond = this.faceSearchInfo(faceSearch, ((FaceSearchV2Request)obj.getRequestBody()).getSearchCount(), ((FaceSearchV2Request)obj.getRequestBody()).getStartIndex());
        }
        FaceSearchRespond faceSearch800 = new FaceSearchRespond();
        ArrayList peoplefaces = new ArrayList();
        FaceSearchRespond finalFaceSearchRespond = faceSearchRespond;
        finalFaceSearchRespond.getFaceInfos().forEach(a -> {
            Date parse;
            FaceSearchRespond.FaceInfo1800 faceInfo1800 = new FaceSearchRespond.FaceInfo1800();
            faceInfo1800.setPicfileId(a.getFileId().replace("/", "_"));
            faceInfo1800.setCameraCode(a.getChannelCode());
            faceInfo1800.setCameraName(a.getAlias());
            try {
                parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(a.getStartTime());
            }
            catch (ParseException e) {
                LOGGER.error("Date parse happen exception", (Throwable)e);
                throw new InvokeException("500", "param_error");
            }
            Long time1 = parse.getTime();
            faceInfo1800.setRecordTime(String.valueOf(time1));
            faceInfo1800.setGender(a.getGender());
            if (a.getAgeGrp() == -1) {
                faceInfo1800.setAge(PictureSearchNVR800V2ServiceImpl.ageValueToAge((int)a.getAge()));
            } else {
                faceInfo1800.setAge(a.getAgeGrp());
            }
            if (a.getGlassType() == 2 || a.getGlassType() == 3) {
                faceInfo1800.setEyeglass(1);
            } else if (a.getGlassType() == 1) {
                faceInfo1800.setEyeglass(2);
            }
            if (a.getMouthMask() == 1) {
                faceInfo1800.setMouthmask(2);
            } else if (a.getMouthMask() == 2) {
                faceInfo1800.setMouthmask(1);
            }
            if (a.getHat() == 1) {
                faceInfo1800.setHat(2);
            } else if (a.getHat() == 2) {
                faceInfo1800.setHat(1);
            }
            faceInfo1800.setHair(a.getHair());
            faceInfo1800.setDomainCode(obj.getVcmInfo().getDomainCode());
            FaceSearchRespond.FaceInfo1800.PosInfo posInfo = new FaceSearchRespond.FaceInfo1800.PosInfo();
            posInfo.setLeft(a.getLeftTopX());
            posInfo.setRight(a.getRightBtmX());
            posInfo.setBottom(a.getRightBtmY());
            posInfo.setTop(a.getLeftTopY());
            faceInfo1800.setPos(posInfo);
            peoplefaces.add(faceInfo1800);
        });
        faceSearch800.setCount(faceSearchRespond.getCount());
        faceSearch800.setPeoplefaces(peoplefaces);
        return faceSearch800;
    }

    public static int ageValueToAge(int s) {
        if (1 <= s && s < 12) {
            return 1;
        }
        if (12 <= s && s < 18) {
            return 2;
        }
        if (18 <= s && s < 36) {
            return 3;
        }
        if (36 <= s && s < 60) {
            return 4;
        }
        if (60 <= s && s < 99) {
            return 5;
        }
        return 0;
    }

    public static String dateToStamp(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(Long.parseLong(String.valueOf(s))));
    }

    public FaceSearchRespond faceSearchByImage(ParamBean<FaceSearchV2Request> obj) {
        ParamBean faceSearch = new ParamBean();
        FaceSearchRequest faceSearchNVR800 = new FaceSearchRequest();
        faceSearchNVR800.setSearchCount(((FaceSearchV2Request)obj.getRequestBody()).getSearchCount());
        ArrayList<String> cameraList = new ArrayList<String>();
        for (int i = 0; i < ((FaceSearchV2Request)obj.getRequestBody()).getCameraList().size(); ++i) {
            String str = (String)((FaceSearchV2Request)obj.getRequestBody()).getCameraList().get(i);
            String str1 = str.substring(0, str.indexOf("#"));
            cameraList.add(str1);
        }
        faceSearchNVR800.setChannelCodes(cameraList);
        faceSearchNVR800.setStartTime(PictureSearchNVR800V2ServiceImpl.dateToStamp((String)((FaceSearchV2Request)obj.getRequestBody()).getStartTime()));
        faceSearchNVR800.setEndTime(PictureSearchNVR800V2ServiceImpl.dateToStamp((String)((FaceSearchV2Request)obj.getRequestBody()).getEndTime()));
        for (JSONObject key : ((FaceSearchV2Request)obj.getRequestBody()).getPictures()) {
            faceSearchNVR800.setImageBase64(key.getString("base64"));
        }
        if (((FaceSearchV2Request)obj.getRequestBody()).getConfidenceThreshold().contains(".")) {
            String intConfidence = ((FaceSearchV2Request)obj.getRequestBody()).getConfidenceThreshold();
            ((FaceSearchV2Request)obj.getRequestBody()).setConfidenceThreshold(intConfidence.substring(0, intConfidence.lastIndexOf(".")));
        }
        faceSearchNVR800.setSimilarity(Integer.parseInt(((FaceSearchV2Request)obj.getRequestBody()).getConfidenceThreshold()));
        faceSearch.setRequestBody((Object)faceSearchNVR800);
        faceSearch.setVcmInfo(obj.getVcmInfo());
        int faceID = this.addToDeviceGetId(faceSearch);
        JSONObject countInfo = this.faceSearchCount(faceSearch, faceID);
        int count = countInfo.getIntValue("Count");
        FaceSearchRespond faceSearchRespond = new FaceSearchRespond();
        if (count > 0 && ((FaceSearchV2Request)obj.getRequestBody()).getSearchCount() > 0) {
            faceSearchRespond = this.faceSearchInfo(faceSearch, ((FaceSearchV2Request)obj.getRequestBody()).getSearchCount(), ((FaceSearchV2Request)obj.getRequestBody()).getStartIndex());
        }
        FaceSearchRespond faceSearch800 = new FaceSearchRespond();
        ArrayList peoplefaces = new ArrayList();
        FaceSearchRespond finalFaceSearchRespond = faceSearchRespond;
        finalFaceSearchRespond.getFaceInfos().forEach(a -> {
            Date parse;
            FaceSearchRespond.FaceInfo1800 faceInfo1800 = new FaceSearchRespond.FaceInfo1800();
            faceInfo1800.setPicfileId(a.getFileId().replace("/", "_"));
            faceInfo1800.setCameraCode(a.getChannelCode());
            faceInfo1800.setCameraName(a.getAlias());
            try {
                parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(a.getStartTime());
            }
            catch (ParseException e) {
                LOGGER.error("Date parse happen exception", (Throwable)e);
                throw new InvokeException("500", e.getMessage());
            }
            Long time1 = parse.getTime();
            faceInfo1800.setRecordTime(String.valueOf(time1));
            faceInfo1800.setGender(a.getGender());
            if (a.getAgeGrp() == -1) {
                faceInfo1800.setAge(PictureSearchNVR800V2ServiceImpl.ageValueToAge((int)a.getAge()));
            } else {
                faceInfo1800.setAge(a.getAgeGrp());
            }
            if (a.getGlassType() == 2 || a.getGlassType() == 3) {
                faceInfo1800.setEyeglass(1);
            } else if (a.getGlassType() == 1) {
                faceInfo1800.setEyeglass(2);
            }
            if (a.getMouthMask() == 1) {
                faceInfo1800.setMouthmask(2);
            } else if (a.getMouthMask() == 2) {
                faceInfo1800.setMouthmask(1);
            }
            if (a.getHat() == 1) {
                faceInfo1800.setHat(2);
            } else if (a.getHat() == 2) {
                faceInfo1800.setHat(1);
            }
            faceInfo1800.setHair(a.getHair());
            faceInfo1800.setDomainCode(obj.getVcmInfo().getDomainCode());
            FaceSearchRespond.FaceInfo1800.PosInfo posInfo = new FaceSearchRespond.FaceInfo1800.PosInfo();
            posInfo.setLeft(a.getLeftTopX());
            posInfo.setRight(a.getRightBtmX());
            posInfo.setBottom(a.getRightBtmY());
            posInfo.setTop(a.getLeftTopY());
            faceInfo1800.setPos(posInfo);
            peoplefaces.add(faceInfo1800);
            faceInfo1800.setConfidence(new Double(a.getSimilarity()).intValue());
        });
        faceSearch800.setCount(faceSearchRespond.getCount());
        faceSearch800.setPeoplefaces(peoplefaces);
        return faceSearch800;
    }

    public int addToDeviceGetId(ParamBean<FaceSearchRequest> obj) {
        JSONObject data = new JSONObject();
        data.put("Count", (Object)1);
        data.put("WithImage", (Object)1);
        data.put("WithFeature", (Object)0);
        JSONObject faceInfo = new JSONObject();
        faceInfo.put("Image", (Object)((FaceSearchRequest)obj.getRequestBody()).getImageBase64());
        JSONArray faceInfos = new JSONArray();
        faceInfos.add((Object)faceInfo);
        data.put("FaceInfo", (Object)faceInfos);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FACE_SEARCH_BY_IMAGE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            int resultCode = rsp.getData().getJSONArray("Result").getIntValue(0);
            if (!"0".equals(String.valueOf(resultCode))) {
                throw new InvokeException("500", Nvr800Utils.get((int)resultCode));
            }
            return rsp.getData().getJSONArray("FaceInfo").getJSONObject(0).getIntValue("Id");
        }
        catch (SDKException e) {
            LOGGER.error("search face image info happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject faceSearchCount(ParamBean<FaceSearchRequest> obj, int faceId) {
        FaceSearchRequest request = (FaceSearchRequest)obj.getRequestBody();
        JSONObject data = new JSONObject();
        if (!CollectionUtils.isEmpty((Collection)request.getChannelCodes())) {
            JSONArray chn = new JSONArray();
            request.getChannelCodes().forEach(code -> chn.add((Object)(Integer.parseInt(code.substring(2)) - 1)));
            data.put("Chn", (Object)chn);
        }
        data.put("StartTime", (Object)request.getStartTime());
        data.put("EndTime", (Object)request.getEndTime());
        data.put("AlarmGroup", (Object)request.getGroupIds());
        data.put("SortType", (Object)(StringUtils.isBlank((CharSequence)request.getSortType()) ? 1 : Integer.parseInt(request.getSortType())));
        if (faceId > -1) {
            data.put("Similarity", (Object)((FaceSearchRequest)obj.getRequestBody()).getSimilarity());
            JSONObject faceInfo = new JSONObject();
            faceInfo.put("Id", (Object)faceId);
            JSONArray faceInfos = new JSONArray();
            faceInfos.add((Object)faceInfo);
            data.put("FaceInfo", (Object)faceInfos);
        } else {
            if (!CollectionUtils.isEmpty((Collection)request.getSex())) {
                data.put("Sex", (Object)request.getSex());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getAge())) {
                data.put("Age", (Object)request.getAge());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getMouthMaskType())) {
                data.put("MouthMaskType", (Object)request.getMouthMaskType());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getHairType())) {
                data.put("HairType", (Object)request.getHairType());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getGlassType())) {
                data.put("GlassesType", (Object)request.getGlassType());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getHatType())) {
                data.put("HatType", (Object)request.getHatType());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getGroupIds())) {
                data.put("AlarmGroup", (Object)request.getGroupIds());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getAgeGrpType())) {
                data.put("AgeGrpType", (Object)request.getAgeGrpType());
            }
        }
        JSONObject countReq = new JSONObject();
        countReq.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FACE_SEARCH_COUNT, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)countReq, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)120);
            return rsp.getData();
        }
        catch (SDKException e) {
            LOGGER.error("search face count happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceSearchRespond faceSearchInfo(ParamBean<FaceSearchRequest> obj, int searchCount, int startIndex) {
        JSONObject data = new JSONObject();
        data.put("Engine", (Object)0);
        data.put("SimpleInfo", (Object)0);
        data.put("WithFaceImage", (Object)0);
        data.put("WithBackgroud", (Object)0);
        data.put("StartIndex", (Object)Math.max(startIndex, 0));
        data.put("Count", (Object)searchCount);
        data.put("MatchedFaces", (Object)1);
        JSONObject request = new JSONObject();
        request.put("data", (Object)data);
        try {
            CommonRespondNvr800 rsp = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.FACE_SEARCH_INFO, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)120);
            this.checkJsonRespond((JSONObject)JSONObject.toJSON((Object)rsp));
            return this.faceSearchRspConvert(obj.getVcmInfo(), rsp.getData());
        }
        catch (SDKException e) {
            LOGGER.error("search face info happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceSearchRespond faceSearchRspConvert(VcmReqBaseInfo vcmInfo, JSONObject object) {
        FaceSearchRespond faceSearchRespond = new FaceSearchRespond();
        faceSearchRespond.setTotalCount(object.getIntValue("TotalCount"));
        faceSearchRespond.setCount(object.getIntValue("Count"));
        JSONArray faceInfosJson = object.getJSONArray("SnapedFaceInfo");
        for (int i = 0; i < faceInfosJson.size(); ++i) {
            FaceSearchRespond.FaceInfo faceInfo = new FaceSearchRespond.FaceInfo();
            JSONObject faceJson = faceInfosJson.getJSONObject(i);
            faceInfo.setFileId(faceJson.getString("UUId"));
            faceInfo.setChannelCode("CH" + (faceJson.getIntValue("Chn") + 1));
            faceInfo.setStartTime(faceJson.getString("StartTime"));
            faceInfo.setEndTime(faceJson.getString("EndTime"));
            faceInfo.setGender(faceJson.getIntValue("Gender"));
            faceInfo.setAge(faceJson.getIntValue("Age"));
            if (faceJson.containsKey((Object)"AgeGrp")) {
                faceInfo.setAgeGrp(faceJson.getIntValue("AgeGrp"));
            } else {
                faceInfo.setAgeGrp(-1);
            }
            faceInfo.setHat(faceJson.getIntValue("Hat"));
            faceInfo.setHair(faceJson.getIntValue("Hair"));
            faceInfo.setSimilarity(faceJson.getDoubleValue("Similarity"));
            faceInfo.setGlassType(faceJson.getIntValue("GlassType"));
            faceInfo.setMouthMask(faceJson.getIntValue("MouthMask"));
            faceInfo.setFaceImage(faceJson.getString("FaceImage"));
            faceInfo.setAlias(vcmInfo.getVcmIp() + "_" + faceInfo.getChannelCode());
            faceInfo.setBackground(faceJson.getString("Background"));
            faceInfo.setSnapId(faceJson.getString("SnapId"));
            if (faceJson.containsKey((Object)"FaceRect")) {
                JSONObject faceRect = faceJson.getJSONObject("FaceRect");
                faceInfo.setLeftTopX(faceRect.getIntValue("X"));
                faceInfo.setLeftTopY(faceRect.getIntValue("Y"));
                faceInfo.setRightBtmX(faceInfo.getLeftTopX() + faceRect.getIntValue("Width"));
                faceInfo.setRightBtmY(faceInfo.getLeftTopY() + faceRect.getIntValue("Height"));
            }
            faceSearchRespond.getFaceInfos().add(faceInfo);
        }
        return faceSearchRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

