/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.nvr800.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.Page;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.PeopleRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositoryRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.People;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.PeopleSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.FaceRepositoryManagementV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="faceRepositoryNvr800V2Service")
public class FaceRepositoryNvr800V2ServiceImpl
extends AbstractNvr800Service
implements FaceRepositoryManagementV2Service<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceRepositoryNvr800V2ServiceImpl.class);

    public FaceRepositoryRespond add(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        FaceRepositoryRespond respond = new FaceRepositoryRespond();
        respond.setIp(vcmReqBaseInfo.getVcmIp());
        respond.setSuccess(true);
        try {
            FaceRepositorySearchRespond searchRespond = this.search(vcmReqBaseInfo, faceRepository);
            if (!CollectionUtils.isEmpty((Collection)searchRespond.getRepositories())) {
                respond.setRepositoryId(((FaceRepository)searchRespond.getRepositories().get(0)).getGroupId());
                return respond;
            }
            JSONObject data = new JSONObject();
            JSONObject groupInfo = new JSONObject();
            if ("2".equals(faceRepository.getType())) {
                groupInfo.put("Policy", (Object)1);
            } else {
                groupInfo.put("Policy", (Object)0);
            }
            groupInfo.put("Name", (Object)faceRepository.getName());
            JSONArray groupArray = new JSONArray();
            groupArray.add((Object)groupInfo);
            data.put("Group", (Object)groupArray);
            JSONObject request = new JSONObject();
            request.put("data", (Object)data);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.ADD_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            JSONObject result = rsp.getJSONObject("data").getJSONArray("Group").getJSONObject(0);
            respond.setRepositoryId(result.getString("Id"));
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("v2 addGroup happen exception", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceRepositoryRespond update(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        FaceRepositoryRespond respond = new FaceRepositoryRespond();
        respond.setIp(vcmReqBaseInfo.getVcmIp());
        respond.setSuccess(true);
        try {
            String groupId = faceRepository.getRepositoryId();
            if (StringUtils.isBlank((CharSequence)groupId)) {
                FaceRepositorySearchRespond res = this.search(vcmReqBaseInfo, faceRepository);
                if (CollectionUtils.isEmpty((Collection)res.getRepositories())) {
                    throw new InvokeException("500", Nvr800Utils.CU_FACE_REPOSITORY_NOT_EXIST);
                }
                groupId = ((FaceRepository)res.getRepositories().get(0)).getGroupId();
            }
            JSONObject groupInfo = new JSONObject();
            groupInfo.put("Id", (Object)Integer.parseInt(groupId));
            groupInfo.put("Name", (Object)faceRepository.getNewName());
            groupInfo.put("Policy", (Object)0);
            if ("2".equals(faceRepository.getType())) {
                groupInfo.put("Policy", (Object)1);
            }
            groupInfo.put("Enabled", (Object)faceRepository.getEnabled());
            groupInfo.put("AlarmEnabled", (Object)faceRepository.getAlarmEnabled());
            groupInfo.put("Similarity", (Object)faceRepository.getSimilarity());
            groupInfo.put("ChnAlarmOut", (Object)faceRepository.getChnAlarmOut());
            groupInfo.put("ChnBuzzerOpt", (Object)faceRepository.getChnBuzzerOpt());
            groupInfo.put("LatchTimeOpt", (Object)faceRepository.getLatchTimeOpt());
            groupInfo.put("SendEmail", (Object)faceRepository.getSendEmail());
            groupInfo.put("ShowThumbnail", (Object)faceRepository.getShowThumbnail());
            groupInfo.put("AlarmSchedule", (Object)faceRepository.getAlarmSchedule());
            groupInfo.put("EnableChnAlarm", (Object)faceRepository.getEnableChnAlarm());
            groupInfo.put("EnableAudio", (Object)faceRepository.getEnableAudio());
            groupInfo.put("AudioName", (Object)faceRepository.getAudioName());
            groupInfo.put("AudioPlayCnt", (Object)faceRepository.getAudioPlayCnt());
            JSONArray groupArray = new JSONArray();
            groupArray.add((Object)groupInfo);
            JSONObject data = new JSONObject();
            data.put("Group", (Object)groupArray);
            JSONObject request = new JSONObject();
            request.put("data", (Object)data);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.UPDATE_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            respond.setRepositoryId(groupId);
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("updateGroup happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean delete(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        try {
            FaceRepositorySearchRespond searchRespond = this.search(vcmReqBaseInfo, faceRepository);
            if (CollectionUtils.isEmpty((Collection)searchRespond.getRepositories())) {
                return true;
            }
            JSONObject request = new JSONObject();
            JSONObject data = new JSONObject();
            JSONObject groupInfo = new JSONObject();
            groupInfo.put("Id", (Object)Integer.parseInt(((FaceRepository)searchRespond.getRepositories().get(0)).getGroupId()));
            JSONArray groupArray = new JSONArray();
            groupArray.add((Object)groupInfo);
            data.put("Group", (Object)groupArray);
            request.put("data", (Object)data);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.DELETE_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("deleteGroup happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceRepositorySearchRespond search(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        try {
            JSONObject rsp;
            block8: {
                JSONObject data = new JSONObject();
                data.put("DefaultVal", (Object)0);
                data.put("WithInternal", (Object)0);
                data.put("SimpleInfo", (Object)0);
                if (faceRepository != null && !StringUtils.isEmpty((CharSequence)faceRepository.getName())) {
                    data.put("Name", (Object)faceRepository.getName());
                }
                JSONObject request = new JSONObject();
                request.put("data", (Object)data);
                rsp = new JSONObject();
                try {
                    rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.SEARCH_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                    if (-9 != rsp.getJSONObject("data").getIntValue("Result")) {
                        this.checkJsonRespond(rsp);
                    }
                }
                catch (SDKException e) {
                    String error = Nvr800Utils.reasonHelper((SDKException)e);
                    if ("AORT_NOT_EXIST".equals(error)) break block8;
                    LOGGER.error("---search repository request error----", (Throwable)e);
                    throw new InvokeException("500", (Object)JsonUtil.convertBeanToJSON((Object)((Object)e)), error);
                }
            }
            FaceRepositorySearchRespond faceRepositorySearchRespond = new FaceRepositorySearchRespond();
            if (Objects.nonNull(rsp.getJSONObject("data")) && !CollectionUtils.isEmpty((Collection)rsp.getJSONObject("data").getJSONArray("Group"))) {
                JSONArray array = rsp.getJSONObject("data").getJSONArray("Group");
                array.stream().filter(obj -> {
                    if (faceRepository != null && !StringUtils.isEmpty((CharSequence)faceRepository.getName())) {
                        return ((JSONObject)obj).getIntValue("Id") > 4 && faceRepository.getName().equals(((JSONObject)obj).getString("Name"));
                    }
                    return ((JSONObject)obj).getIntValue("Id") > 4;
                }).forEach(obj -> {
                    FaceRepository face = new FaceRepository();
                    face.setName(((JSONObject)obj).getString("Name"));
                    face.setType(((JSONObject)obj).getIntValue("Policy") == 0 ? "3" : "2");
                    face.setGroupId(((JSONObject)obj).getString("Id"));
                    face.setEnabled(((JSONObject)obj).getIntValue("Enabled"));
                    face.setAlarmEnabled(((JSONObject)obj).getIntValue("AlarmEnabled"));
                    face.setSimilarity(((JSONObject)obj).getIntValue("Similarity"));
                    face.setChnAlarmOut(((JSONObject)obj).getJSONArray("ChnAlarmOut"));
                    face.setChnBuzzerOpt(((JSONObject)obj).getJSONArray("ChnBuzzerOpt"));
                    face.setLatchTimeOpt(((JSONObject)obj).getJSONArray("LatchTimeOpt"));
                    face.setSendEmail(((JSONObject)obj).getJSONArray("SendEmail"));
                    face.setShowThumbnail(((JSONObject)obj).getJSONArray("ShowThumbnail"));
                    face.setAlarmSchedule(((JSONObject)obj).getJSONArray("AlarmSchedule"));
                    face.setEnableChnAlarm(((JSONObject)obj).getJSONArray("EnableChnAlarm"));
                    face.setAudioName(((JSONObject)obj).getJSONArray("AudioName"));
                    face.setAudioPlayCnt(((JSONObject)obj).getJSONArray("AudioPlayCnt"));
                    face.setEnableAudio(((JSONObject)obj).getJSONArray("EnableAudio"));
                    faceRepositorySearchRespond.getRepositories().add(face);
                });
                faceRepositorySearchRespond.setTotal(String.valueOf(faceRepositorySearchRespond.getRepositories().size()));
            }
            return faceRepositorySearchRespond;
        }
        catch (Exception e) {
            if (e instanceof InvokeException) {
                throw e;
            }
            LOGGER.error("searchGroup happen exception,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", "unknown_error");
        }
    }

    public FaceRepositorySearchRespond searchAll(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        try {
            JSONObject rsp;
            block8: {
                JSONObject data = new JSONObject();
                data.put("SimpleInfo", (Object)1);
                if (faceRepository != null && !StringUtils.isEmpty((CharSequence)faceRepository.getName())) {
                    data.put("Name", (Object)faceRepository.getName());
                }
                JSONObject request = new JSONObject();
                request.put("data", (Object)data);
                rsp = new JSONObject();
                try {
                    rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.SEARCH_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                    if (-9 != rsp.getJSONObject("data").getIntValue("Result")) {
                        this.checkJsonRespond(rsp);
                    }
                }
                catch (SDKException e) {
                    String error = Nvr800Utils.reasonHelper((SDKException)e);
                    if ("AORT_NOT_EXIST".equals(error)) break block8;
                    LOGGER.error("---search repository request error----", (Throwable)e);
                    throw new InvokeException("500", (Object)JsonUtil.convertBeanToJSON((Object)((Object)e)), error);
                }
            }
            FaceRepositorySearchRespond faceRepositorySearchRespond = new FaceRepositorySearchRespond();
            if (Objects.nonNull(rsp.getJSONObject("data")) && !CollectionUtils.isEmpty((Collection)rsp.getJSONObject("data").getJSONArray("Group"))) {
                JSONArray array = rsp.getJSONObject("data").getJSONArray("Group");
                array.forEach(obj -> {
                    FaceRepository face = new FaceRepository();
                    face.setName(((JSONObject)obj).getString("Name"));
                    face.setType(((JSONObject)obj).getIntValue("Policy") == 0 ? "3" : "2");
                    face.setGroupId(((JSONObject)obj).getString("Id"));
                    faceRepositorySearchRespond.getRepositories().add(face);
                });
                faceRepositorySearchRespond.setTotal(String.valueOf(faceRepositorySearchRespond.getRepositories().size()));
            }
            return faceRepositorySearchRespond;
        }
        catch (Exception e) {
            if (e instanceof InvokeException) {
                throw e;
            }
            LOGGER.error("searchGroup happen exception,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", "unknown_error");
        }
    }

    public PeopleSearchRespond searchPeople(VcmReqBaseInfo vcmReqBaseInfo, FaceRequest request) {
        PeopleSearchRespond peopleSearchRespond = new PeopleSearchRespond();
        JSONObject paramObject = new JSONObject();
        if (!CollectionUtils.isEmpty((Collection)request.getPersonIdList())) {
            JSONArray faceIdArray = new JSONArray();
            for (String faceId : request.getPersonIdList()) {
                if (!StringUtils.isNotBlank((CharSequence)faceId)) continue;
                faceIdArray.add((Object)Integer.parseInt(faceId));
            }
            paramObject.put("FacesId", (Object)faceIdArray);
        }
        paramObject.put("WithImage", (Object)request.getWithImage());
        JSONObject dataObject = new JSONObject();
        dataObject.put("data", (Object)paramObject);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.SEARCH_PEOPLE_BY_ID, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            if (!CollectionUtils.isEmpty((Collection)rsp.getJSONObject("data").getJSONArray("FaceInfo"))) {
                for (int i = 0; i < rsp.getJSONObject("data").getJSONArray("FaceInfo").size(); ++i) {
                    JSONObject peopleObject = rsp.getJSONObject("data").getJSONArray("FaceInfo").getJSONObject(i);
                    People people = new People();
                    people.setName(peopleObject.getString("Name"));
                    people.setGroupId(peopleObject.getString("GrpId"));
                    people.setId(peopleObject.getString("Remark"));
                    people.setGroupImageId(peopleObject.getString("MD5"));
                    people.setImage(peopleObject.getString("Image"));
                    people.setDevicePeopleId(peopleObject.getString("Id"));
                    peopleSearchRespond.getPeopleList().add(people);
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("NVR 800 search people error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return peopleSearchRespond;
    }

    public JSONArray searchPeopleCommon(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        try {
            JSONObject data = new JSONObject();
            JSONObject faceInfo = new JSONObject();
            if (!StringUtils.isEmpty((CharSequence)people.getId())) {
                faceInfo.put("Remark", (Object)people.getId());
            }
            if (people.getFaceRepositoryInfo() != null) {
                FaceRepositorySearchRespond res = this.search(vcmReqBaseInfo, people.getFaceRepositoryInfo());
                if (CollectionUtils.isEmpty((Collection)res.getRepositories())) {
                    throw new InvokeException("500", Nvr800Utils.CU_FACE_REPOSITORY_NOT_EXIST);
                }
                faceInfo.put("GrpId", (Object)Integer.parseInt(((FaceRepository)res.getRepositories().get(0)).getGroupId()));
            }
            JSONArray faceArray = new JSONArray();
            faceArray.add((Object)faceInfo);
            data.put("FaceInfo", (Object)faceArray);
            JSONObject request = new JSONObject();
            request.put("data", (Object)data);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.SEARCH_PEOPLE_COUNT_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            if (rsp.getJSONObject("data").getIntValue("Count") > 0) {
                JSONObject data1 = new JSONObject();
                if (people.getPage() == null) {
                    Page page = new Page();
                    page.setSize("1000");
                    page.setNo("1");
                    people.setPage(page);
                }
                if ("0".equals(people.getPage().getNo())) {
                    people.getPage().setNo("1");
                }
                data1.put("StartIndex", (Object)(Integer.parseInt(people.getPage().getSize()) * (Integer.parseInt(people.getPage().getNo()) - 1)));
                data1.put("Count", (Object)Integer.parseInt(people.getPage().getSize()));
                JSONObject req = new JSONObject();
                req.put("data", (Object)data1);
                JSONObject rsp1 = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.SEARCH_PEOPLE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)req, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                this.checkJsonRespond(rsp1);
                if (rsp1.getJSONObject("data").getJSONArray("FaceInfo").size() > 0) {
                    return rsp1.getJSONObject("data").getJSONArray("FaceInfo");
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("searchPeople happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return new JSONArray();
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

