/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.nvr800.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.EncPasswordBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.MasterDeviceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.EmptyRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.SearchMasterDeviceNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.MasterDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.PubKeyRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.device.SearchMasterDeviceResponseNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.device.CameraAddV2Request;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.respond.cu.device.CameraAddV2Respond;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.DeviceManageNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.PasswordServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.v2.DeviceManageV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DeviceManageNvr800V2ServiceImpl
extends AbstractNvr800Service
implements DeviceManageV2Service<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageNvr800V2ServiceImpl.class);
    private static final Predicate<InetAddress> FILTER_IPV4 = addr -> addr instanceof Inet4Address;
    private static final Predicate<InetAddress> FILTER_NOT_LINK_LOCAL = addr -> !addr.isLinkLocalAddress();
    @Autowired
    private PasswordServiceImpl passwordService;
    @Autowired
    private WebSocketService webSocketService;

    public CameraAddV2Respond addCamera(ParamBean<CameraAddV2Request> obj) {
        CameraAddV2Request addRequest = (CameraAddV2Request)obj.getRequestBody();
        JSONArray channelCodejsonArray = new JSONArray();
        JSONObject dataObject = new JSONObject();
        JSONObject channelInfoObj = new JSONObject();
        String emptyChannel = this.getEmptyChannel(obj.getVcmInfo());
        PubKeyRespondNvr800 pubKey = this.passwordService.getKey(obj.getVcmInfo());
        addRequest.getChannelInfo().stream().forEach(a -> {
            String channelCode;
            if (StringUtils.isNotBlank((CharSequence)a.getChannelCode())) {
                channelCode = a.getChannelCode();
                channelCodejsonArray.add((Object)channelCode);
            } else {
                channelCode = emptyChannel;
                channelCodejsonArray.add((Object)emptyChannel);
            }
            EncPasswordBean encPasswordBean = this.passwordService.getEncPassword(pubKey, a.getDevicePassword());
            JSONObject contentObj = new JSONObject();
            contentObj.put("alias", (Object)a.getName());
            contentObj.put("ip_address", (Object)a.getIp());
            contentObj.put("port", (Object)Integer.valueOf(a.getPort()));
            if ("ONVIF".equals(a.getProtocol())) {
                contentObj.put("protocol", (Object)"Onvif");
            } else {
                contentObj.put("protocol", (Object)a.getProtocol());
            }
            contentObj.put("username", (Object)a.getDeviceUser());
            contentObj.put("alias_pos", (Object)"LeftTop");
            contentObj.put("cipher", (Object)encPasswordBean.getCipher());
            channelInfoObj.put(channelCode, (Object)contentObj);
            dataObject.put("seq", (Object)encPasswordBean.getSeq());
        });
        dataObject.put("channel_info", (Object)channelInfoObj);
        dataObject.put("operation_type", (Object)"AddOrEditChannel");
        dataObject.put("version", (Object)"1.0");
        JSONObject data = new JSONObject();
        data.put("data", (Object)dataObject);
        try {
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SET_CHANNEL_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondNvr800);
            if (!"success".equals(respondNvr800.getResult())) {
                throw new InvokeException("500", respondNvr800.getResult());
            }
            CameraAddV2Respond cameraAddRespond = new CameraAddV2Respond();
            cameraAddRespond.setCameraCode(channelCodejsonArray);
            return cameraAddRespond;
        }
        catch (SDKException e) {
            LOGGER.error("Set channel fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private String getEmptyChannel(VcmReqBaseInfo vcmReqBaseInfo) {
        Map channelMap = this.getIpcInfo(vcmReqBaseInfo);
        for (String key : channelMap.keySet()) {
            JSONObject channelObject = (JSONObject)channelMap.get(key);
            if (!"NotConfigured".equalsIgnoreCase(channelObject.getString("state")) || "AutoMode".equalsIgnoreCase(channelObject.getString("switch_mode"))) continue;
            return key;
        }
        throw new InvokeException("500", "no_empty_channel");
    }

    private Map<String, JSONObject> getIpcInfo(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.IP_CHANNEL_INFO_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)new EmptyRequestNvr800(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>();
            if (respondNvr800.getData() == null || respondNvr800.getData().getJSONObject("channel_info") == null) {
                return resultMap;
            }
            JSONObject infoJson = respondNvr800.getData().getJSONObject("channel_info");
            for (String key : infoJson.keySet()) {
                resultMap.put(key, infoJson.getJSONObject(key));
            }
            return resultMap;
        }
        catch (SDKException e) {
            LOGGER.error("List IPChannel fail", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public void searchMasterDevice(MasterDeviceSearchRequest request) {
        SearchMasterDeviceNvr800 data = new SearchMasterDeviceNvr800();
        data.setSeq(1);
        data.setMsgType((short)11);
        try {
            InetAddress group = InetAddress.getByName("255.255.255.255");
            for (NetworkInterface nic : DeviceManageNvr800V2ServiceImpl.getNICs((Predicate[])new Predicate[]{DeviceUtil.Filter.UP, DeviceUtil.Filter.PHYICAL_ONLY})) {
                DeviceManageNvr800V2ServiceImpl.sendMulticast((InetAddress)group, (int)9333, (byte[])data.toByteArray(), (Integer)20, (NetworkInterface)nic);
                this.receiveDeviceRespond();
            }
        }
        catch (Exception e) {
            LOGGER.error("NVR 800 search master device error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveDeviceRespond() {
        DatagramSocket ds = null;
        try {
            try {
                byte[] buffer = new byte[0x100000];
                DatagramPacket receivePacket = new DatagramPacket(buffer, buffer.length);
                ds = new DatagramSocket(9333);
                ds.setSoTimeout(10000);
                ds.setBroadcast(true);
                DeviceEventRespond respond = new DeviceEventRespond();
                respond.setSubtype("searchMasterDevice");
                respond.setType(EventTypeEnum.OPERATE_RESULT);
                ArrayList<MasterDeviceRespond> deviceRespondList = new ArrayList<MasterDeviceRespond>();
                while (true) {
                    deviceRespondList.clear();
                    ds.receive(receivePacket);
                    SearchMasterDeviceResponseNvr800 responseNvr800 = new SearchMasterDeviceResponseNvr800();
                    responseNvr800.unPacket(receivePacket.getData());
                    LOGGER.info("DatagramPacket receive data IP:{},iePort:{},devVersion:{},macAddress:{}", new Object[]{responseNvr800.getIp(), responseNvr800.getIePort(), responseNvr800.getDevVer(), responseNvr800.getMacAddress()});
                    MasterDeviceRespond deviceRespond = new MasterDeviceRespond();
                    deviceRespond.setIp(responseNvr800.getIp());
                    deviceRespond.setWebPort("443");
                    deviceRespond.setVersion(responseNvr800.getDevVer());
                    deviceRespond.setMacAddress(responseNvr800.getMacAddress());
                    deviceRespond.setType("2");
                    deviceRespond.setDeviceType("NVR800");
                    deviceRespond.setSearchVersion("0001");
                    deviceRespondList.add(deviceRespond);
                    respond.getData().setParentDevices(deviceRespondList);
                    this.webSocketService.send((BaseEventRespond)respond);
                }
            }
            catch (Exception e) {
                LOGGER.error("NVR 800 search master device error", (Throwable)e);
                if (ds != null) {
                    ds.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (ds != null) {
                ds.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMulticast(InetAddress group, int port, byte[] message, Integer ttl, NetworkInterface nic) throws IOException {
        UnmodifiableIterator nifAddresses = Iterators.filter((Iterator)Iterators.forEnumeration(nic.getInetAddresses()), (Predicate)Predicates.and((Predicate)FILTER_IPV4, (Predicate)FILTER_NOT_LINK_LOCAL));
        if (!nifAddresses.hasNext()) {
            return;
        }
        InetSocketAddress inetAddr = new InetSocketAddress((InetAddress)nifAddresses.next(), port);
        try (DatagramSocket ds = null;){
            if (group.isMulticastAddress()) {
                ds = new MulticastSocket(inetAddr);
            } else {
                ds = new DatagramSocket(inetAddr);
                ds.setBroadcast(true);
            }
            ds.send(new DatagramPacket(message, message.length, group, port));
        }
    }

    @SafeVarargs
    public static Set<NetworkInterface> getNICs(Predicate<NetworkInterface> ... filters) {
        if (null == filters) {
            filters = new Predicate[]{DeviceManageNvr800ServiceImpl.Filter.ALL};
        }
        try {
            UnmodifiableIterator filtered = Iterators.filter((Iterator)Iterators.forEnumeration(NetworkInterface.getNetworkInterfaces()), (Predicate)Predicates.and(filters));
            return ImmutableSet.copyOf((Iterator)filtered);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

