/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.nvr800.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.CruiseRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PresetPositionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.PresetPositionRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseDetailRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PresetPositionRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.bean.CruisePoint;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.bean.CruiseTrack;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.PresetPositionRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.CruiseV2Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.nvr800.impl.PresetPositionNvr800V2ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cruiseNvr800V2Service")
public class CruiseNvr800V2ServiceImpl
extends AbstractNvr800Service
implements CruiseV2Service<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CruiseNvr800V2ServiceImpl.class);
    @Autowired
    private PresetPositionNvr800V2ServiceImpl presetPositionNvr800Service;

    public JSONObject getCruiseNo(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("resultCode", (Object)"0");
        jsonObject.put("content", (Object)new JSONObject());
        jsonObject.getJSONObject("content").put("cruiseNo", (Object)"1");
        return jsonObject;
    }

    public CruiseRespond upt(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        return this.add(vcmInfo, req);
    }

    public CruiseRespond add(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        this.ptzRequestToNvr800(vcmInfo, req, Integer.valueOf(54));
        cruiseRespond.setCruiseNo(req.getCruiseNo());
        return cruiseRespond;
    }

    public CruiseRespond del(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        this.ptzRequestToNvr800(vcmInfo, req, Integer.valueOf(55));
        cruiseRespond.setCruiseNo(req.getCruiseNo());
        return cruiseRespond;
    }

    private PresetPositionRequestNvr800 ptzRequestToNvr800(VcmReqBaseInfo vcmInfo, CruiseRequest req, Integer cmd) {
        PresetPositionRequestNvr800 presetPositionRequestNvr800 = new PresetPositionRequestNvr800();
        JSONObject data = new JSONObject();
        data.put("cmd", (Object)cmd);
        data.put("channel", (Object)req.getChannelCode());
        JSONObject curiseTrack = new JSONObject();
        curiseTrack.put("track_index", (Object)Integer.valueOf(req.getCruiseNo()));
        curiseTrack.put("track_name", (Object)req.getName());
        JSONArray trackPresets = new JSONArray();
        if (CollectionUtils.isNotEmpty((Collection)req.getCruisePoints())) {
            for (CruisePoint cruisePoint : req.getCruisePoints()) {
                JSONObject trackPreset = new JSONObject();
                trackPreset.put("preset_index", (Object)cruisePoint.getPresetIndex());
                trackPreset.put("cruise_time", (Object)cruisePoint.getDwellTime());
                trackPreset.put("cruise_speed", (Object)cruisePoint.getSpeed());
                trackPresets.add((Object)trackPreset);
            }
        }
        curiseTrack.put("track_preset", (Object)trackPresets);
        data.put("curise_track", (Object)curiseTrack);
        presetPositionRequestNvr800.setData(data);
        try {
            PresetPositionRespondNvr800 presetPositionRespondNvr800 = (PresetPositionRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.PTZ_CONTROL_NVR800_V2_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)presetPositionRequestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PresetPositionRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)presetPositionRespondNvr800);
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return presetPositionRequestNvr800;
    }

    public CruiseListRespond list(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        PresetPositionRequest request = new PresetPositionRequest();
        request.setChannelCode(req.getChannelCode());
        PresetPositionRespondNvr800 ptzList = this.presetPositionNvr800Service.getPtzList(vcmInfo, request);
        CruiseListRespond cruiseListRespond = new CruiseListRespond();
        JSONArray curiseTracks = ptzList.getData().getJSONArray("curise_track");
        ArrayList<CruiseTrack> cruiseTrackRes = new ArrayList<CruiseTrack>(curiseTracks.size());
        int cruiseStateIndex = 0;
        if (ptzList.getData().getBoolean("cruise_state").booleanValue()) {
            cruiseStateIndex = ptzList.getData().getInteger("cruise_state_index");
        }
        for (int i = 0; i < curiseTracks.size(); ++i) {
            JSONObject curiseTrack = (JSONObject)curiseTracks.get(i);
            CruiseTrack cruiseTrack = new CruiseTrack();
            cruiseTrack.setCruiseNo(curiseTrack.getString("track_index"));
            cruiseTrack.setName(curiseTrack.getString("track_name"));
            if (cruiseStateIndex == curiseTrack.getInteger("track_index")) {
                cruiseTrack.setCruiseStatus("1");
            }
            cruiseTrackRes.add(cruiseTrack);
        }
        cruiseListRespond.setChannelCode(req.getChannelCode());
        cruiseListRespond.setCruiseTracks(cruiseTrackRes);
        return cruiseListRespond;
    }

    public CruiseDetailRespond detail(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseDetailRespond cruiseDetailRespond = new CruiseDetailRespond();
        PresetPositionRequest positionRequest = new PresetPositionRequest();
        positionRequest.setChannelCode(req.getChannelCode());
        positionRequest.setDomainCode(req.getDomainCode());
        PresetPositionRequest request = new PresetPositionRequest();
        request.setChannelCode(req.getChannelCode());
        PresetPositionRespondNvr800 ptzList = this.presetPositionNvr800Service.getPtzList(vcmInfo, request);
        JSONArray presetPointArray = ptzList.getData().getJSONArray("preset_point");
        HashMap<Integer, String> positionRespondMap = new HashMap<Integer, String>();
        if (CollectionUtils.isNotEmpty((Collection)presetPointArray)) {
            for (int i = 0; i < presetPointArray.size(); ++i) {
                JSONObject presetPoint = (JSONObject)presetPointArray.get(i);
                positionRespondMap.put(presetPoint.getInteger("preset_index"), presetPoint.getString("preset_name"));
            }
        }
        JSONArray curiseTrackList = ptzList.getData().getJSONArray("curise_track");
        JSONArray curiseTracks = curiseTrackList.stream().filter(json -> req.getCruiseNo().equals(((JSONObject)json).getString("track_index"))).collect(Collectors.toCollection(JSONArray::new));
        ArrayList<PresetPositionRespond> positionResponds = new ArrayList<PresetPositionRespond>();
        if (CollectionUtils.isNotEmpty((Collection)curiseTracks)) {
            JSONObject track = (JSONObject)curiseTracks.get(0);
            JSONArray trackPreset = track.getJSONArray("track_preset");
            for (int i = 0; i < trackPreset.size(); ++i) {
                JSONObject curiseTrack = (JSONObject)trackPreset.get(i);
                PresetPositionRespond positionRespond = new PresetPositionRespond();
                positionRespond.setPresetIndex(curiseTrack.getInteger("preset_index").intValue());
                positionRespond.setPresetName((String)positionRespondMap.get(curiseTrack.getInteger("preset_index")));
                positionRespond.setPointCruiseTime(curiseTrack.getInteger("cruise_time").intValue());
                positionRespond.setSpeed(curiseTrack.getInteger("cruise_speed"));
                positionResponds.add(positionRespond);
            }
        }
        cruiseDetailRespond.setCruiseNo(req.getCruiseNo());
        cruiseDetailRespond.setCruisePoints(positionResponds);
        cruiseDetailRespond.setChannelCode(req.getChannelCode());
        return cruiseDetailRespond;
    }

    public CruiseRespond set(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond respond = new CruiseRespond();
        if (!CollectionUtils.isEmpty((Collection)req.getCruisePoints())) {
            this.updatePresetPosition(vcmInfo, req);
            JSONArray customPositionArray = new JSONArray();
            for (CruisePoint cruisePoint : req.getCruisePoints()) {
                customPositionArray.add((Object)cruisePoint.getPresetIndex());
            }
            JSONObject paramObject = new JSONObject();
            paramObject.put("cmd", (Object)16);
            paramObject.put("channel", (Object)req.getChannelCode());
            paramObject.put("custom_preset_array", (Object)customPositionArray);
            JSONObject dataObject = new JSONObject();
            dataObject.put("data", (Object)paramObject);
            try {
                JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.PTZ_CONTROL_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
                this.checkJsonRespond(rsp);
            }
            catch (SDKException e) {
                LOGGER.error("NVR 800 set cruise error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
                throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
            }
        }
        return respond;
    }

    private void updatePresetPosition(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        if (!CollectionUtils.isEmpty((Collection)req.getCruisePoints())) {
            JSONObject paramObject = new JSONObject();
            paramObject.put("channel", (Object)req.getChannelCode());
            paramObject.put("cmd", (Object)17);
            JSONArray pointArray = new JSONArray();
            for (CruisePoint cruisePoint : req.getCruisePoints()) {
                JSONObject pointObject = new JSONObject();
                pointObject.put("preset_index", (Object)cruisePoint.getPresetIndex());
                pointObject.put("point_cruise_time", (Object)cruisePoint.getDwellTime());
                pointArray.add((Object)pointObject);
            }
            paramObject.put("preset_point_time_array", (Object)pointArray);
            JSONObject dataObject = new JSONObject();
            dataObject.put("data", (Object)paramObject);
            try {
                CruisePoint cruisePoint;
                cruisePoint = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.PTZ_CONTROL_NVR800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            }
            catch (Exception e) {
                LOGGER.error("NVR 800 update preset position error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            }
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E eTemplate, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(eTemplate);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

