/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.nvr800.impl;

import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.behavior.BehaviorSetRequestV2Nvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.behavior.BehaviorSetV2Request;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.BehaviorAnalysisV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="behaviorAnalysisV2Service")
public class BehaviorAnalysisNvr800V2ServiceImpl
extends AbstractNvr800Service
implements BehaviorAnalysisV2Service<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BehaviorAnalysisNvr800V2ServiceImpl.class);

    public Boolean setItemLeave(ParamBean<BehaviorSetV2Request> obj) {
        return this.setBehavior(obj, Nvr800MsgType.PERIMETER_ITEM_LEAVE_SET_URI);
    }

    public Boolean setItemMove(ParamBean<BehaviorSetV2Request> obj) {
        return this.setBehavior(obj, Nvr800MsgType.PERIMETER_ITEM_MOVE_SET_URI);
    }

    public Boolean setVehicleIllegal(ParamBean<BehaviorSetV2Request> obj) {
        return this.setVehicleConfigParameter(obj, Nvr800MsgType.PERIMETER_VEHICLE_ILLEGAL_SET_URI);
    }

    public Boolean setElectroMobile(ParamBean<BehaviorSetV2Request> obj) {
        return this.setBehavior(obj, Nvr800MsgType.PERIMETER_ELECTOR_MOBILE_SET_URI);
    }

    public Boolean setPerimeterZone(ParamBean<BehaviorSetV2Request> obj) {
        return this.setBehavior(obj, Nvr800MsgType.PERIMETER_ZONE_SET_URI);
    }

    public Boolean setPerimeterLine(ParamBean<BehaviorSetV2Request> obj) {
        return this.setBehavior(obj, Nvr800MsgType.PERIMETER_LINE_SET_URI);
    }

    public Boolean setAreaEnter(ParamBean<BehaviorSetV2Request> obj) {
        return this.setBehavior(obj, Nvr800MsgType.AREA_ENTER_SET_URI);
    }

    public Boolean setAreaExit(ParamBean<BehaviorSetV2Request> obj) {
        return this.setBehavior(obj, Nvr800MsgType.AREA_EXIT_SET_URI);
    }

    public Boolean setLoitering(ParamBean<BehaviorSetV2Request> obj) {
        return this.setBehavior(obj, Nvr800MsgType.LOITERING_SET_URI);
    }

    public Boolean setFastMovement(ParamBean<BehaviorSetV2Request> obj) {
        return this.setBehavior(obj, Nvr800MsgType.FAST_MOVEMENT_SET_URI);
    }

    public Boolean setParkingDetect(ParamBean<BehaviorSetV2Request> obj) {
        return this.setBehavior(obj, Nvr800MsgType.PARKING_DETECT_SET);
    }

    private Boolean setBehavior(ParamBean<BehaviorSetV2Request> obj, Nvr800MsgType nvr800MsgType) {
        BehaviorSetV2Request request = (BehaviorSetV2Request)obj.getRequestBody();
        BehaviorSetRequestV2Nvr800 requestNvr800 = new BehaviorSetRequestV2Nvr800(JsonUtil.convertBeanToJSON((Object)request));
        try {
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)nvr800MsgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)20);
            this.checkRespond(respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("setBehavior error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    private Boolean setVehicleConfigParameter(ParamBean<BehaviorSetV2Request> obj, Nvr800MsgType nvr800MsgType) {
        BehaviorSetV2Request request = (BehaviorSetV2Request)obj.getRequestBody();
        BehaviorSetRequestV2Nvr800 requestNvr800 = new BehaviorSetRequestV2Nvr800(JsonUtil.convertBeanToJSON((Object)request));
        try {
            BaseRespondNvr800 respondNvr800 = (BaseRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)nvr800MsgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("setVehicleConfigParameter error", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

