/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.ivs1800.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.suspecttask.CameraInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.suspecttask.GroupInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.suspecttask.SuspectTaskRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.suspecttask.TaskTime;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.suspecttask.SuspectTaskInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.suspecttask.SuspectTaskRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.SuspectTaskV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="suspectTaskV2ServiceIvs1800Impl")
public class SuspectTaskV2ServiceIvs1800Impl
extends AbstractIvs1800Service
implements SuspectTaskV2Service<IServerType.IVS1800> {
    public SuspectTaskRespond add(VcmReqBaseInfo vcmReqBaseInfo, SuspectTaskRequest suspectTaskRequest) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_MONITOR_CREATE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)suspectTaskRequest, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            SuspectTaskRespond taskRespond = new SuspectTaskRespond();
            taskRespond.setSuspectId(rsp.getString("suspectId"));
            return taskRespond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public List<SuspectTaskInfo> search(VcmReqBaseInfo vcmReqBaseInfo, SuspectTaskRequest suspectTaskRequest) {
        ArrayList groups = new ArrayList();
        JSONObject request = this.requestToIvs1800(suspectTaskRequest);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_MONITOR_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            if (!CollectionUtils.isEmpty((Collection)rsp.getJSONArray("suspectList"))) {
                JSONArray suspectList = rsp.getJSONArray("suspectList");
                suspectList.forEach(obj -> {
                    SuspectTaskInfo suspectTaskInfo = this.respondToIvs1800((JSONObject)obj);
                    groups.add(suspectTaskInfo);
                });
            }
            return groups.stream().sorted(Comparator.comparing(SuspectTaskInfo::getCreateTime).reversed()).collect(Collectors.toList());
        }
        catch (SDKException e) {
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private JSONObject requestToIvs1800(SuspectTaskRequest req) {
        JSONObject request = new JSONObject();
        request.put("suspectId", (Object)req.getSuspectId());
        request.put("name", (Object)req.getName());
        request.put("createUser", (Object)req.getTaskUser());
        request.put("type", (Object)req.getType());
        request.put("enable", (Object)req.getEnable());
        JSONObject page = new JSONObject();
        request.put("page", (Object)page);
        page.put("no", (Object)"1");
        page.put("pageSize", (Object)"1000");
        return request;
    }

    private SuspectTaskInfo respondToIvs1800(JSONObject obj) {
        Optional optionalLoginRespondNvr800 = JsonUtil.convertJsonToBean((String)obj.toJSONString(), SuspectTaskInfo.class);
        SuspectTaskInfo suspectTaskInfo = (SuspectTaskInfo)optionalLoginRespondNvr800.get();
        ArrayList cameraInfoList = new ArrayList();
        obj.getJSONArray("cameraList").forEach(camera -> {
            CameraInfo cameraInfo = new CameraInfo();
            cameraInfo.setCameraName(((JSONObject)camera).getString("cameraName"));
            cameraInfo.setCameraCode(((JSONObject)camera).getString("cameraCode"));
            cameraInfoList.add(cameraInfo);
        });
        suspectTaskInfo.setCameraList(cameraInfoList);
        ArrayList groupInfoList = new ArrayList();
        obj.getJSONArray("groupList").forEach(group -> {
            GroupInfo groupInfo = new GroupInfo();
            groupInfo.setEnable(((JSONObject)group).getString("enable"));
            groupInfo.setGroupId(((JSONObject)group).getString("groupid"));
            groupInfo.setName(((JSONObject)group).getString("name"));
            groupInfoList.add(groupInfo);
        });
        suspectTaskInfo.setGroupList(groupInfoList);
        ArrayList taskTimeList = new ArrayList();
        obj.getJSONArray("timeList").forEach(group -> {
            TaskTime taskTime = new TaskTime();
            taskTime.setDay(((JSONObject)group).getInteger("day").intValue());
            taskTime.setEndTime(((JSONObject)group).getString("endTime"));
            taskTime.setStartTime(((JSONObject)group).getString("startTime"));
            taskTimeList.add(taskTime);
        });
        suspectTaskInfo.setTimeList(taskTimeList);
        return suspectTaskInfo;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

