/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.ivs1800.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PresetPositionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.ptz.PresetPositionRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PresetPositionRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.PresetPositionRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PresetPositionV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="presetPositionIvs1800V2Service")
public class PresetPositionIvs1800V2ServiceImpl
extends AbstractIvs1800Service
implements PresetPositionV2Service<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PresetPositionIvs1800V2ServiceImpl.class);

    public PresetPositionRespond add(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
        PresetPositionRequestIvs1800 presetPositionRequestIvs1800 = this.addRequestToIvs1800(req);
        try {
            PresetPositionRespondIvs1800 presetPositionRespondIvs1800 = (PresetPositionRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_ADD_PRESET_POSITION_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)presetPositionRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PresetPositionRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)presetPositionRespondIvs1800);
            presetPositionRespond.setPresetIndex(presetPositionRespondIvs1800.getPresetIndex().intValue());
            return presetPositionRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 add preset position error, IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public PresetPositionRespond del(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
        String urlTemplate = "/ptz/presetposition/%s/%s/%s/v1.0";
        String url = String.format(urlTemplate, req.getChannelCode(), req.getDomainCode(), req.getPresetIndex());
        Ivs1800MsgType uri = new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_DELETE, url);
        try {
            PresetPositionRespondIvs1800 presetPositionRespondIvs1800 = (PresetPositionRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, PresetPositionRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)presetPositionRespondIvs1800);
            presetPositionRespond.setPresetIndex(req.getPresetIndex().intValue());
            return presetPositionRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 del preset position error, IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public PresetPositionRespond upt(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
        PresetPositionRequestIvs1800 presetPositionRequestIvs1800 = this.uptRequestToIvs1800(req);
        try {
            PresetPositionRespondIvs1800 presetPositionRespondIvs1800 = (PresetPositionRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_UPT_PRESET_POSITION_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)presetPositionRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PresetPositionRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)presetPositionRespondIvs1800);
            presetPositionRespond.setPresetIndex(req.getPresetIndex().intValue());
            return presetPositionRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 update preset position error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public List<PresetPositionRespond> list(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        String urlTemplate = "/device/ptzpresetlist/%s/%s";
        String url = String.format(urlTemplate, req.getChannelCode(), req.getDomainCode());
        Ivs1800MsgType uri = new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, url);
        try {
            PresetPositionRespondIvs1800 presetPositionRespondIvs1800 = (PresetPositionRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, PresetPositionRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)presetPositionRespondIvs1800);
            JSONArray presetArray = presetPositionRespondIvs1800.getPtzPresetInfoList().getJSONArray("ptzPresetInfo");
            ArrayList<PresetPositionRespond> respondList = new ArrayList<PresetPositionRespond>();
            for (int i = 0; i < presetArray.size(); ++i) {
                PresetPositionRespond respond = new PresetPositionRespond();
                JSONObject presetPosition = presetArray.getJSONObject(i);
                respond.setPresetIndex(presetPosition.getIntValue("presetIndex"));
                respond.setPresetName(presetPosition.getString("presetName"));
                respond.setFocusSwitch(presetPosition.getInteger("focusSwitch"));
                respond.setHasTime(false);
                respondList.add(respond);
            }
            return respondList;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private PresetPositionRequestIvs1800 addRequestToIvs1800(PresetPositionRequest req) {
        PresetPositionRequestIvs1800 presetPositionRequestIvs1800 = new PresetPositionRequestIvs1800();
        presetPositionRequestIvs1800.setFocusSwitch(req.getFocusSwitch());
        presetPositionRequestIvs1800.setPresetName(req.getPresetName());
        presetPositionRequestIvs1800.setCameraCode(req.getChannelCode() + "#" + req.getDomainCode());
        return presetPositionRequestIvs1800;
    }

    private PresetPositionRequestIvs1800 uptRequestToIvs1800(PresetPositionRequest req) {
        PresetPositionRequestIvs1800 presetPositionRequestIvs1800 = new PresetPositionRequestIvs1800();
        presetPositionRequestIvs1800.setCameraCode(req.getChannelCode() + "#" + req.getDomainCode());
        JSONObject ptzPresetInfo = new JSONObject();
        ptzPresetInfo.put("presetName", (Object)req.getPresetName());
        ptzPresetInfo.put("presetIndex", (Object)req.getPresetIndex());
        ptzPresetInfo.put("focusSwitch", (Object)req.getFocusSwitch());
        presetPositionRequestIvs1800.setPtzPresetInfo(ptzPresetInfo);
        return presetPositionRequestIvs1800;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

