/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.ivs1800.impl;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.FaceSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.picturesearch.FaceSearchV2Request;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PictureSearchV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="PictureSearchV2Service")
public class PictureSearchIvs1800V2ServiceImpl
extends AbstractIvs1800Service
implements PictureSearchV2Service<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PictureSearchIvs1800V2ServiceImpl.class);

    public FaceSearchRespond faceSearch(ParamBean<FaceSearchV2Request> obj) {
        FaceSearchRespond faceSearchRespond;
        try {
            if (Objects.isNull(obj.getRequestBody())) {
                throw new InvokeException("500", "param_error");
            }
            if (!CollectionUtils.isEmpty((Collection)((FaceSearchV2Request)obj.getRequestBody()).getAgeValue())) {
                for (int i = 0; i < ((FaceSearchV2Request)obj.getRequestBody()).getAgeValue().size(); ++i) {
                    int a = (Integer)((FaceSearchV2Request)obj.getRequestBody()).getAgeValue().get(i);
                    if (a == 1) {
                        ((FaceSearchV2Request)obj.getRequestBody()).setAgeBegin("1");
                        ((FaceSearchV2Request)obj.getRequestBody()).setAgeEnd("12");
                        ((FaceSearchV2Request)obj.getRequestBody()).setAge(a);
                        continue;
                    }
                    if (a == 2) {
                        ((FaceSearchV2Request)obj.getRequestBody()).setAgeBegin("12");
                        ((FaceSearchV2Request)obj.getRequestBody()).setAgeEnd("18");
                        ((FaceSearchV2Request)obj.getRequestBody()).setAge(a);
                        continue;
                    }
                    if (a == 3) {
                        ((FaceSearchV2Request)obj.getRequestBody()).setAgeBegin("18");
                        ((FaceSearchV2Request)obj.getRequestBody()).setAgeEnd("36");
                        ((FaceSearchV2Request)obj.getRequestBody()).setAge(a);
                        continue;
                    }
                    if (a == 4) {
                        ((FaceSearchV2Request)obj.getRequestBody()).setAgeBegin("36");
                        ((FaceSearchV2Request)obj.getRequestBody()).setAgeEnd("60");
                        ((FaceSearchV2Request)obj.getRequestBody()).setAge(a);
                        continue;
                    }
                    if (a == 5) {
                        ((FaceSearchV2Request)obj.getRequestBody()).setAgeBegin("60");
                        ((FaceSearchV2Request)obj.getRequestBody()).setAgeEnd("99");
                        ((FaceSearchV2Request)obj.getRequestBody()).setAge(a);
                        continue;
                    }
                    if (a == 0) {
                        ((FaceSearchV2Request)obj.getRequestBody()).setAgeBegin("0");
                        ((FaceSearchV2Request)obj.getRequestBody()).setAgeEnd("0");
                        ((FaceSearchV2Request)obj.getRequestBody()).setAge(a);
                        continue;
                    }
                    if (a != -1) continue;
                    ((FaceSearchV2Request)obj.getRequestBody()).setAge(a);
                }
            }
            FaceSearchV2Request objObject = (FaceSearchV2Request)obj.getRequestBody();
            JSONObject rspObject = new JSONObject();
            rspObject.put("algorithmCode", (Object)objObject.getAlgorithmCode());
            rspObject.put("cameraList", (Object)objObject.getCameraList());
            rspObject.put("confidenceThreshold", (Object)objObject.getConfidenceThreshold());
            rspObject.put("endTime", (Object)objObject.getEndTime());
            rspObject.put("eyeglass", (Object)objObject.getEyeglass());
            rspObject.put("gender", (Object)objObject.getGender());
            if (!CollectionUtils.isEmpty((Collection)objObject.getGroupIds())) {
                for (int i = 0; i < objObject.getGroupIds().size(); ++i) {
                    rspObject.put("groupid", (Object)String.valueOf(objObject.getGroupIds().get(i)));
                }
            } else {
                rspObject.put("groupid", (Object)"");
            }
            rspObject.put("hairType", (Object)objObject.getHairType());
            rspObject.put("hat", (Object)objObject.getHat());
            rspObject.put("mouthmask", (Object)objObject.getMouthmask());
            rspObject.put("page", (Object)objObject.getPage());
            rspObject.put("startTime", (Object)objObject.getStartTime());
            rspObject.put("ageEnd", (Object)objObject.getAgeEnd());
            rspObject.put("ageBegin", (Object)objObject.getAgeBegin());
            rspObject.put("age", (Object)objObject.getAge());
            LOGGER.info("IVS 1800 picture search data:{}", (Object)rspObject.toJSONString());
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.FACE_DYNAMIC_DATABASE_RETRIEVAL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)rspObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), FaceSearchRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            faceSearchRespond = (FaceSearchRespond)operateBean.get();
            if (!CollectionUtils.isEmpty((Collection)faceSearchRespond.getPeoplefaces())) {
                faceSearchRespond.getPeoplefaces().forEach(faceInfo1800 -> {
                    faceInfo1800.setDomainCode(obj.getVcmInfo().getDomainCode());
                    if (faceInfo1800.getAgeValue() != null) {
                        faceInfo1800.setAge(PictureSearchIvs1800V2ServiceImpl.ageValueToAge((int)faceInfo1800.getAgeValue()));
                    }
                });
            }
        }
        catch (SDKException e) {
            LOGGER.error("faceSearch happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return faceSearchRespond;
    }

    public static int ageValueToAge(int s) {
        if (1 <= s && s < 12) {
            return 1;
        }
        if (12 <= s && s < 18) {
            return 2;
        }
        if (18 <= s && s < 36) {
            return 3;
        }
        if (36 <= s && s < 60) {
            return 4;
        }
        if (60 <= s && s < 99) {
            return 5;
        }
        return 0;
    }

    public FaceSearchRespond faceSearchByImage(ParamBean<FaceSearchV2Request> obj) {
        FaceSearchRespond faceSearchRespond;
        try {
            if (Objects.isNull(obj.getRequestBody())) {
                throw new InvokeException("500", "param_error");
            }
            FaceSearchV2Request objObject = (FaceSearchV2Request)obj.getRequestBody();
            if (objObject.getConfidenceThreshold().contains(".")) {
                String intConfidence = objObject.getConfidenceThreshold();
                objObject.setConfidenceThreshold(intConfidence.substring(0, intConfidence.lastIndexOf(".")));
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.FACE_DYNAMIC_DATABASE_RETRIEVAL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)objObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), FaceSearchRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            faceSearchRespond = (FaceSearchRespond)operateBean.get();
            if (!CollectionUtils.isEmpty((Collection)faceSearchRespond.getPeoplefaces())) {
                faceSearchRespond.getPeoplefaces().forEach(faceInfo1800 -> faceInfo1800.setDomainCode(obj.getVcmInfo().getDomainCode()));
            }
        }
        catch (SDKException e) {
            LOGGER.error("faceSearchByImage happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return faceSearchRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

