/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.ivs1800.impl;

import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.CommonResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.facerepository.FaceRepositoryRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositoryRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.People;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.PeopleSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.FaceRepositoryIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.FaceRepositoryRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.FaceRepositorySearchRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.PeopleSearchRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.FaceRepositoryManagementV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="faceRepositoryIvs1800V2Service")
public class FaceRepositoryIvs1800V2ServiceImpl
extends AbstractIvs1800Service
implements FaceRepositoryManagementV2Service<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceRepositoryIvs1800V2ServiceImpl.class);

    public FaceRepositoryRespond add(VcmReqBaseInfo vcmInfo, FaceRepositoryRequest faceRepository) {
        FaceRepositoryRespond respond = new FaceRepositoryRespond();
        respond.setIp(vcmInfo.getVcmIp());
        respond.setSuccess(true);
        try {
            FaceRepositorySearchRespondIvs1800 searchRsp = this.searchCommon(vcmInfo, faceRepository);
            if (!CollectionUtils.isEmpty((Collection)searchRsp.getRepositories())) {
                respond.setRepositoryId(((FaceRepositoryIvs1800)searchRsp.getRepositories().get(0)).getId());
                return respond;
            }
            FaceRepositoryRequestIvs1800 faceRepositoryRequestIvs1800 = this.requestConverter(faceRepository);
            FaceRepositoryRespondIvs1800 rsp = (FaceRepositoryRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.ADD_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)faceRepositoryRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(CommonResponse.class, FaceRepositoryRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)rsp);
            respond.setRepositoryId(rsp.getGroupId());
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("v2 add face repository happen exception", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceRepositoryRespond update(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        FaceRepositoryRespond respond = new FaceRepositoryRespond();
        respond.setIp(vcmReqBaseInfo.getVcmIp());
        respond.setSuccess(true);
        try {
            String groupId = faceRepository.getRepositoryId();
            if (StringUtils.isBlank((CharSequence)groupId)) {
                FaceRepositorySearchRespondIvs1800 searchRsp = this.searchCommon(vcmReqBaseInfo, faceRepository);
                if (CollectionUtils.isEmpty((Collection)searchRsp.getRepositories())) {
                    throw new InvokeException("500", Nvr800Utils.CU_FACE_REPOSITORY_NOT_EXIST);
                }
                groupId = ((FaceRepositoryIvs1800)searchRsp.getRepositories().get(0)).getId();
            }
            FaceRepositoryRequestIvs1800 faceRepositoryRequestIvs1800 = this.requestConverter(faceRepository);
            faceRepositoryRequestIvs1800.setName(faceRepository.getNewName());
            BaseRespondIvs1800 updateResponse = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_PATCH, "/sdk_service/rest/facerepositories/" + groupId), (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)faceRepositoryRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(BaseRespondIvs1800.class, BaseRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond(updateResponse);
            respond.setRepositoryId(groupId);
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("update FaceRepository happen exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean delete(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        try {
            FaceRepositorySearchRespondIvs1800 searchRsp = this.searchCommon(vcmReqBaseInfo, faceRepository);
            if (CollectionUtils.isEmpty((Collection)searchRsp.getRepositories())) {
                return true;
            }
            BaseRespondIvs1800 delResponse = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_DELETE, "/sdk_service/rest/facerepositories/" + ((FaceRepositoryIvs1800)searchRsp.getRepositories().get(0)).getId()), (HttpUrlParam)null, (MsgToObjectConvertor)this.msgToObjectConvertor(BaseRespondIvs1800.class, BaseRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond(delResponse);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("delete face repository happen exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceRepositorySearchRespond search(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        FaceRepositorySearchRespond faceRepositorySearchRespond;
        try {
            FaceRepositorySearchRespondIvs1800 rsp = this.searchCommon(vcmReqBaseInfo, faceRepository);
            faceRepositorySearchRespond = this.searchRespondConvert(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("search face repository happen exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return faceRepositorySearchRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public FaceRepositoryRequestIvs1800 requestConverter(FaceRepositoryRequest faceRepositoryRequest) {
        FaceRepositoryRequestIvs1800 faceRepositoryRequestIvs1800 = new FaceRepositoryRequestIvs1800();
        faceRepositoryRequestIvs1800.setName(faceRepositoryRequest.getName());
        faceRepositoryRequestIvs1800.setType(faceRepositoryRequest.getType());
        faceRepositoryRequestIvs1800.setGroupStrId(faceRepositoryRequest.getGroupStrId());
        return faceRepositoryRequestIvs1800;
    }

    public FaceRepositorySearchRespond searchRespondConvert(FaceRepositorySearchRespondIvs1800 repositorySearchRespondIvs1800) {
        FaceRepositorySearchRespond faceRepositorySearchRespond = new FaceRepositorySearchRespond();
        faceRepositorySearchRespond.setTotal(repositorySearchRespondIvs1800.getTotal());
        if (!CollectionUtils.isEmpty((Collection)repositorySearchRespondIvs1800.getRepositories())) {
            repositorySearchRespondIvs1800.getRepositories().forEach(res -> {
                FaceRepository faceRepository = new FaceRepository();
                faceRepository.setGroupId(res.getId());
                faceRepository.setType(res.getType());
                faceRepository.setName(res.getName());
                faceRepositorySearchRespond.getRepositories().add(faceRepository);
            });
        }
        return faceRepositorySearchRespond;
    }

    public FaceRepositorySearchRespondIvs1800 searchCommon(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) throws SDKException {
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("size", "1000");
        httpUrlParam.addParam("no", "1");
        httpUrlParam.addParam("ordername", "name");
        httpUrlParam.addParam("sort", "asc");
        if (faceRepository != null) {
            if (StringUtils.isNotBlank((CharSequence)faceRepository.getType())) {
                httpUrlParam.addParam("type", faceRepository.getType());
            }
            if (StringUtils.isNotBlank((CharSequence)faceRepository.getName())) {
                httpUrlParam.addParam("name", faceRepository.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)faceRepository.getRepositoryId())) {
                httpUrlParam.addParam("groupid", faceRepository.getRepositoryId());
            }
        }
        FaceRepositorySearchRespondIvs1800 rsp = (FaceRepositorySearchRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.SEARCH_FACE_REPOSITORY_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(FaceRepositorySearchRespondIvs1800.class, FaceRepositorySearchRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkRespond((BaseRespondIvs1800)rsp);
        return rsp;
    }

    public PeopleSearchRespond searchPeopleRespondConvert(PeopleSearchRespondIvs1800 peopleSearchRespondIvs1800) {
        PeopleSearchRespond peopleSearchRespond = new PeopleSearchRespond();
        peopleSearchRespond.setTotal(peopleSearchRespondIvs1800.getTotal());
        if (!CollectionUtils.isEmpty((Collection)peopleSearchRespondIvs1800.getPeopleList())) {
            peopleSearchRespondIvs1800.getPeopleList().forEach(res -> {
                People people = new People();
                people.setId(res.getTag());
                people.setName(res.getName());
                people.setGender(res.getGender());
                people.setNationality(res.getNationality());
                people.setOccupation(res.getOccupation());
                people.setCredentialType(res.getCredentialType());
                people.setCredentialNumber(res.getCredentialNumber());
                people.setCountry(res.getCountry());
                people.setBornTime(res.getBornTime());
                people.setDescription(res.getDescription());
                peopleSearchRespond.getPeopleList().add(people);
            });
        }
        return peopleSearchRespond;
    }
}

