/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.ivs1800.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.device.CameraAddV2Request;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.respond.cu.device.CameraAddV2Respond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.DeviceManageV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceManageIvs1800V2ServiceImpl
extends AbstractIvs1800Service
implements DeviceManageV2Service<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageIvs1800V2ServiceImpl.class);

    public CameraAddV2Respond addCamera(ParamBean<CameraAddV2Request> obj) {
        CameraAddV2Request addRequest = (CameraAddV2Request)obj.getRequestBody();
        JSONObject requestCameraAdd = this.buildCameraAddRespondIvs1800(addRequest);
        try {
            JSONObject respondIvs1800 = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.CAMERA_ADD_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestCameraAdd, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)240);
            this.checkJsonRespond(respondIvs1800);
            JSONArray resultArray = respondIvs1800.getJSONObject("deviceOperResultInfos").getJSONArray("deviceOperResultList");
            JSONArray deviceCodeArray = new JSONArray();
            JSONArray nvrCodeArray = new JSONArray();
            JSONArray sequenceArray = new JSONArray();
            JSONArray resArray = new JSONArray();
            CameraAddV2Respond cameraAddRespond = new CameraAddV2Respond();
            for (int i = 0; i < resultArray.size(); ++i) {
                JSONObject jsonObject = resultArray.getJSONObject(i);
                resArray.add((Object)jsonObject.getString("result"));
                deviceCodeArray.add((Object)jsonObject.getString("deviceCode"));
                nvrCodeArray.add((Object)jsonObject.getString("nvrCode"));
                sequenceArray.add((Object)jsonObject.getIntValue("sequence"));
            }
            cameraAddRespond.setResult(resArray);
            cameraAddRespond.setCameraCode(deviceCodeArray);
            cameraAddRespond.setNvrCode(nvrCodeArray);
            cameraAddRespond.setSequence(sequenceArray);
            return cameraAddRespond;
        }
        catch (SDKException e) {
            LOGGER.error("Add camera fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private JSONObject buildCameraAddRespondIvs1800(CameraAddV2Request addRequest) {
        JSONObject data = new JSONObject();
        JSONObject deviceOperInfos = new JSONObject();
        JSONArray deviceOperInfoArray = new JSONArray();
        data.put("deviceNum", (Object)addRequest.getChannelInfo().size());
        data.put("deviceOperInfos", (Object)deviceOperInfos);
        for (int i = 0; i < addRequest.getChannelInfo().size(); ++i) {
            CameraAddV2Request.ChannelInfo a = (CameraAddV2Request.ChannelInfo)addRequest.getChannelInfo().get(i);
            JSONObject deviceOperInfoObj = new JSONObject();
            deviceOperInfoObj.put("sequence", (Object)(i + 1));
            JSONObject deviceConfigObj = new JSONObject();
            deviceOperInfoObj.put("deviceConfig", (Object)deviceConfigObj);
            deviceConfigObj.put("protocolType", (Object)a.getProtocol());
            deviceConfigObj.put("loginType", (Object)a.getLoginType());
            deviceConfigObj.put("enableAlarm", (Object)a.getEnableAlarm());
            deviceConfigObj.put("directConnectFirst", (Object)a.getDirectConnectFirst());
            deviceConfigObj.put("deviceUser", (Object)a.getDeviceUser());
            deviceConfigObj.put("devicePassword", (Object)a.getDevicePassword());
            deviceConfigObj.put("deviceRegPassword", (Object)a.getDeviceRegPassword());
            if (StringUtils.isNotBlank((CharSequence)a.getSubProtocolType())) {
                deviceConfigObj.put("subProtocolType", (Object)Integer.valueOf(a.getSubProtocolType()));
            }
            if (StringUtils.isNotBlank((CharSequence)a.getRtspPort())) {
                deviceConfigObj.put("rtspPort", (Object)Integer.valueOf(a.getRtspPort()));
            }
            deviceConfigObj.put("mainResourcePath", (Object)a.getMainResourcePath());
            deviceConfigObj.put("subResourcePath", (Object)a.getSubResourcePath());
            JSONObject deviceBasicInfoObj = new JSONObject();
            deviceConfigObj.put("deviceBasicInfo", (Object)deviceBasicInfoObj);
            deviceBasicInfoObj.put("type", (Object)a.getType());
            deviceBasicInfoObj.put("name", (Object)a.getName());
            if ("T28181".equals(a.getProtocol())) {
                deviceBasicInfoObj.put("port", (Object)0);
            } else {
                deviceBasicInfoObj.put("port", (Object)Integer.valueOf(a.getPort()));
            }
            deviceBasicInfoObj.put("connectCode", (Object)a.getConnectCode());
            if (StringUtils.isNotBlank((CharSequence)a.getVendorType())) {
                deviceBasicInfoObj.put("vendorType", (Object)a.getVendorType());
            }
            JSONObject ipInfoObj = new JSONObject();
            deviceBasicInfoObj.put("ipInfo", (Object)ipInfoObj);
            ipInfoObj.put("ipType", (Object)0);
            ipInfoObj.put("ip", (Object)a.getIp());
            deviceOperInfoArray.add((Object)deviceOperInfoObj);
        }
        deviceOperInfos.put("deviceOperInfo", (Object)deviceOperInfoArray);
        return data;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

