/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.ivs1800.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.ColorConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.penetrate.PenetrateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.ColorConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.penetrate.PenetrateRespond;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.CommonIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.DeviceConfigManageIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.v2.DeviceInfoConfigV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DeviceInfoConfigIvs1800V2ServiceImpl")
public class DeviceInfoConfigIvs1800V2ServiceImpl
extends AbstractIvs1800Service
implements DeviceInfoConfigV2Service<IServerType.IVS1800> {
    @Autowired
    private DeviceConfigManageIvs1800ServiceImpl deviceConfigManageIvs1800Service;
    @Autowired
    private CommonIvs1800ServiceImpl commonIvs1800Service;

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public ColorConfigRespond getColorConfig(ParamBean<ColorConfigRequest> obj) {
        ColorConfigRespond configRespond = new ColorConfigRespond();
        PenetrateRequest request = new PenetrateRequest();
        request.setRequestMethod("GET");
        request.setChannelCode(((ColorConfigRequest)obj.getRequestBody()).getChannelCode() + "#" + ((ColorConfigRequest)obj.getRequestBody()).getDomainCode());
        request.setRequestUrl(SdcMsgType.CNS_PAAS_GET.getUri());
        ParamBean paramBean = new ParamBean();
        paramBean.setVcmInfo(obj.getVcmInfo());
        paramBean.setRequestBody((Object)request);
        PenetrateRespond respond = this.commonIvs1800Service.penetrate(paramBean);
        JSONArray uuidArray = JSONArray.parseArray((String)respond.getResultInfo());
        String uuid = uuidArray.getJSONObject(0).getJSONObject("Data").getJSONArray("CnsChnParam").getJSONObject(0).getString("uuid");
        paramBean = new ParamBean();
        request.setRequestUrl(SdcMsgType.ABILITY_IMAGE_QUALITY.getUri() + "?UUID=" + uuid);
        paramBean.setVcmInfo(obj.getVcmInfo());
        paramBean.setRequestBody((Object)request);
        request.setRequestUrl(SdcMsgType.IMAGE_QUALITY_QUERY.getUri() + "?UUID=" + uuid);
        paramBean.setRequestBody((Object)request);
        JSONObject configObject = JSONArray.parseArray((String)this.commonIvs1800Service.penetrate(paramBean).getResultInfo()).getJSONObject(0).getJSONObject("Data");
        configRespond.setSharpness(configObject.getIntValue("sharpenValue"));
        configRespond.setContrast(configObject.getIntValue("contrastValue"));
        configRespond.setHue(configObject.getIntValue("hueValue"));
        configRespond.setSaturation(configObject.getIntValue("saturationValue"));
        configRespond.setBright(configObject.getIntValue("brightValue"));
        return configRespond;
    }

    public boolean setColorConfig(ParamBean<ColorConfigRequest> obj) {
        ColorConfigRequest request = (ColorConfigRequest)obj.getRequestBody();
        JSONObject configObject = new JSONObject();
        configObject.put("hue", (Object)request.getColorConfig().getHue());
        configObject.put("brightness", (Object)request.getColorConfig().getBright());
        configObject.put("contrast", (Object)request.getColorConfig().getBright());
        configObject.put("saturation", (Object)request.getColorConfig().getSaturation());
        configObject.put("reserve", (Object)"");
        JSONObject dataObject = new JSONObject();
        dataObject.put("cameraDisplayConfig", (Object)configObject);
        return this.deviceConfigManageIvs1800Service.setCameraConfig(obj.getVcmInfo(), Integer.valueOf(6), dataObject, request.getChannelCode());
    }
}

