/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.ivs1800.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.CruiseRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PresetPositionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.ptz.CruiseRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseDetailRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PresetPositionRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.CruiseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.bean.CruiseTrack;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.CruiseV2Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.ivs1800.impl.PresetPositionIvs1800V2ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="cruiseIvs1800V2Service")
public class CruiseIvs1800V2ServiceImpl
extends AbstractIvs1800Service
implements CruiseV2Service<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CruiseIvs1800V2ServiceImpl.class);
    @Autowired
    private PresetPositionIvs1800V2ServiceImpl presetPositionIvs1800V2Service;

    public JSONObject getCruiseNo(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("resultCode", (Object)"0");
        jsonObject.put("content", (Object)new JSONObject());
        jsonObject.getJSONObject("content").put("cruiseNo", (Object)"1");
        return jsonObject;
    }

    public JSONObject getCruiseNoByCondition(VcmReqBaseInfo vcmReqBaseInfo, CruiseRequest req) {
        CruiseListRespond cruiseListRespond = this.list(vcmReqBaseInfo, req);
        List cruiseTracks = cruiseListRespond.getCruiseTracks();
        JSONObject result = new JSONObject();
        for (CruiseTrack cruiseTrack : cruiseTracks) {
            String name = cruiseTrack.getName();
            if (!req.getName().equals(name)) continue;
            result.put("cruiseNo", (Object)cruiseTrack.getCruiseNo());
        }
        return result;
    }

    public CruiseRespond add(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        CruiseRequestIvs1800 cruiseRequestIvs1800 = this.addRequestToIvs1800(req);
        try {
            CruiseRespondIvs1800 cruiseRespondIvs1800 = (CruiseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_ADD_CRUISE_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)cruiseRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CruiseRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)cruiseRespondIvs1800);
            cruiseRespond.setCruiseNo(cruiseRespondIvs1800.getCruiseNo());
            return cruiseRespond;
        }
        catch (SDKException e) {
            LOGGER.error("PTZ add error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public CruiseRespond upt(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        CruiseRequestIvs1800 cruiseRequestIvs1800 = this.uptRequestToIvs1800(vcmInfo, req);
        try {
            CruiseRespondIvs1800 cruiseRespondIvs1800 = (CruiseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_UPT_CRUISE_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)cruiseRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CruiseRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)cruiseRespondIvs1800);
            cruiseRespond.setCruiseNo(cruiseRequestIvs1800.getCruiseNo());
            return cruiseRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 update cruise error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public CruiseRespond del(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        CruiseRequestIvs1800 cruiseRequestIvs1800 = this.delRequestToIvs1800(req);
        try {
            CruiseRespondIvs1800 cruiseRespondIvs1800 = (CruiseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_DEL_CRUISE_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)cruiseRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CruiseRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)cruiseRespondIvs1800);
            cruiseRespond.setCruiseNo(req.getCruiseNo());
            return cruiseRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 del cruise error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public CruiseListRespond list(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseListRespond cruiseListRespond = new CruiseListRespond();
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("domainCode", req.getDomainCode());
        httpUrlParam.addParam("cameraCode", req.getChannelCode());
        try {
            CruiseRespondIvs1800 cruiseRespondIvs1800 = (CruiseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_LIST_CRUISE_IVS1800_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CruiseRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)cruiseRespondIvs1800);
            cruiseListRespond.setChannelCode(cruiseRespondIvs1800.getCruiseTrackList().getString("cameraCode"));
            JSONArray cruiseTracks = cruiseRespondIvs1800.getCruiseTrackList().getJSONArray("cruiseTracks");
            List cruiseTrackRes = JSONObject.parseArray((String)cruiseTracks.toJSONString(), CruiseTrack.class);
            cruiseListRespond.setCruiseTracks(cruiseTrackRes);
            return cruiseListRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 list cruise error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public CruiseDetailRespond detail(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseDetailRespond cruiseDetailRespond = new CruiseDetailRespond();
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("domainCode", req.getDomainCode());
        httpUrlParam.addParam("cameraCode", req.getChannelCode());
        httpUrlParam.addParam("cruiseNo", req.getCruiseNo());
        try {
            CruiseRespondIvs1800 cruiseRespondIvs1800 = (CruiseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_DETAIL_CRUISE_IVS1800_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CruiseRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)cruiseRespondIvs1800);
            JSONObject cruiseObject = cruiseRespondIvs1800.getCruiseInfo();
            cruiseDetailRespond.setCruiseNo(cruiseObject.getString("cruiseNo"));
            cruiseDetailRespond.setChannelCode(cruiseObject.getString("cameraCode"));
            cruiseDetailRespond.setCruiseName(cruiseObject.getString("name"));
            ArrayList<PresetPositionRespond> positionResponds = new ArrayList<PresetPositionRespond>();
            JSONArray points = cruiseObject.getJSONArray("cruisePoints");
            if (!CollectionUtils.isEmpty((Collection)points)) {
                PresetPositionRequest positionRequest = new PresetPositionRequest();
                positionRequest.setChannelCode(req.getChannelCode());
                positionRequest.setDomainCode(req.getDomainCode());
                List positionRespondList = this.presetPositionIvs1800V2Service.list(vcmInfo, positionRequest);
                HashMap<Integer, PresetPositionRespond> positionRespondMap = new HashMap<Integer, PresetPositionRespond>();
                if (!CollectionUtils.isEmpty((Collection)positionRespondList)) {
                    for (PresetPositionRespond respond : positionRespondList) {
                        positionRespondMap.put(respond.getPresetIndex(), respond);
                    }
                }
                for (int i = 0; i < points.size(); ++i) {
                    JSONObject point = points.getJSONObject(i);
                    PresetPositionRespond positionRespond = new PresetPositionRespond();
                    positionRespond.setPresetIndex(point.getIntValue("presetIndex"));
                    positionRespond.setPointCruiseTime(point.getIntValue("dwellTime"));
                    positionRespond.setSpeed(point.getInteger("speed"));
                    if (positionRespondMap.containsKey(positionRespond.getPresetIndex())) {
                        positionRespond.setPresetName(((PresetPositionRespond)positionRespondMap.get(positionRespond.getPresetIndex())).getPresetName());
                    } else {
                        positionRespond.setPresetName("");
                    }
                    positionResponds.add(positionRespond);
                }
            }
            cruiseDetailRespond.setCruisePoints(positionResponds);
            return cruiseDetailRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get cruise detail error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public CruiseRespond set(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        CruiseRequestIvs1800 cruiseRequestIvs1800 = this.uptRequestToIvs1800(vcmInfo, req);
        try {
            if (CollectionUtils.isEmpty((Collection)cruiseRequestIvs1800.getCruisePoints()) && StringUtils.isNotEmpty((CharSequence)cruiseRequestIvs1800.getCruiseNo())) {
                req.setCruiseNo(cruiseRequestIvs1800.getCruiseNo());
                this.del(vcmInfo, req);
            } else if (StringUtils.isNotEmpty((CharSequence)cruiseRequestIvs1800.getCruiseNo())) {
                CruiseRespondIvs1800 cruiseRespondIvs1800 = (CruiseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_UPT_CRUISE_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)cruiseRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CruiseRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
                this.checkRespond((BaseRespondIvs1800)cruiseRespondIvs1800);
                cruiseRespond.setCruiseNo(cruiseRequestIvs1800.getCruiseNo());
            } else {
                this.add(vcmInfo, req);
            }
            return cruiseRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 update cruise error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private JSONObject getDefaultCruiseNo(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRequest cruise = new CruiseRequest();
        cruise.setChannelCode(req.getChannelCode());
        cruise.setDomainCode(req.getDomainCode());
        cruise.setName("defaultCruise");
        cruise.setCruiseType(Integer.valueOf(1));
        return this.getCruiseNoByCondition(vcmInfo, cruise);
    }

    private CruiseRequestIvs1800 addRequestToIvs1800(CruiseRequest req) {
        CruiseRequestIvs1800 cruiseRequestIvs1800 = new CruiseRequestIvs1800();
        cruiseRequestIvs1800.setDomainCode(req.getDomainCode());
        cruiseRequestIvs1800.setCameraCode(req.getChannelCode());
        cruiseRequestIvs1800.setName(req.getName());
        cruiseRequestIvs1800.setCruisePoints(req.getCruisePoints());
        return cruiseRequestIvs1800;
    }

    private CruiseRequestIvs1800 uptRequestToIvs1800(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRequestIvs1800 cruiseRequestIvs1800 = new CruiseRequestIvs1800();
        cruiseRequestIvs1800.setCameraCode(req.getChannelCode());
        cruiseRequestIvs1800.setDomainCode(req.getDomainCode());
        cruiseRequestIvs1800.setName(req.getName());
        cruiseRequestIvs1800.setCruisePoints(req.getCruisePoints());
        cruiseRequestIvs1800.setCruiseNo(req.getCruiseNo());
        return cruiseRequestIvs1800;
    }

    private CruiseRequestIvs1800 delRequestToIvs1800(CruiseRequest req) {
        CruiseRequestIvs1800 cruiseRequestIvs1800 = new CruiseRequestIvs1800();
        cruiseRequestIvs1800.setDomainCode(req.getDomainCode());
        cruiseRequestIvs1800.setCameraCode(req.getChannelCode());
        cruiseRequestIvs1800.setCruiseNo(req.getCruiseNo());
        return cruiseRequestIvs1800;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

