/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.impl.onvif;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.OnvifMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.bean.PTZCmdEnum;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.GuardPointSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PTZControlRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.onvif.Device;
import com.zkteco.zkbiosecurity.cuserver.dto.request.onvif.MediaProfile;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.GuardPointRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PTZControlRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.onvif.AbstractOnvifService;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PTZV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.OnvifUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToXmlMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XmlMsgToObjectConvertor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="PtzOnvifV2ServiceImpl")
public class PtzOnvifV2ServiceImpl
extends AbstractOnvifService
implements PTZV2Service<IServerType.Onvif> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PtzOnvifV2ServiceImpl.class);

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToXmlMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new XmlMsgToObjectConvertor(cClass);
    }

    public PTZControlRespond control(VcmReqBaseInfo vcmInfo, PTZControlRequest request) {
        PTZControlRespond respond = new PTZControlRespond();
        try {
            Device device = OnvifUtils.getDevice((String)vcmInfo.getVcmSession());
            if (Objects.isNull(device)) {
                throw new InvokeException("500", "cu_offline_error");
            }
            List mediaProfiles = OnvifUtils.getMediaProfiles((VcmReqBaseInfo)vcmInfo);
            List<String> tokenList = Arrays.asList(StringUtils.split((String)request.getChannelCode(), (String)"&"));
            MediaProfile mediaProfile = null;
            for (int i = 0; i < mediaProfiles.size(); ++i) {
                if (!tokenList.get(0).equals(((MediaProfile)mediaProfiles.get(i)).getToken())) continue;
                mediaProfile = (MediaProfile)mediaProfiles.get(i);
                break;
            }
            if (Objects.isNull(mediaProfile)) {
                throw new InvokeException("500", "object_not_exist");
            }
            double x = 0.0;
            double y = 0.0;
            double zoomx = 0.0;
            double speed = 0.0;
            if (PTZCmdEnum.PTZ_LEFT == request.getPtzCmdEnum()) {
                x = (double)request.getSpeed().intValue() * -0.1;
            }
            if (PTZCmdEnum.PTZ_RIGHT == request.getPtzCmdEnum()) {
                x = (double)request.getSpeed().intValue() * 0.1;
            }
            if (PTZCmdEnum.PTZ_UP == request.getPtzCmdEnum()) {
                y = (double)request.getSpeed().intValue() * 0.1;
            }
            if (PTZCmdEnum.PTZ_DOWN == request.getPtzCmdEnum()) {
                y = (double)request.getSpeed().intValue() * -0.1;
            }
            if (PTZCmdEnum.PTZ_LENS_ZOOM_IN == request.getPtzCmdEnum()) {
                zoomx = (double)request.getSpeed().intValue() * 0.1;
            }
            if (PTZCmdEnum.PTZ_LENS_ZOOM_OUT == request.getPtzCmdEnum()) {
                zoomx = (double)request.getSpeed().intValue() * -0.1;
            }
            if (PTZCmdEnum.PTZ_LENS_FOCAL_FAR == request.getPtzCmdEnum()) {
                speed = (double)request.getSpeed().intValue() * 0.1;
            }
            if (PTZCmdEnum.PTZ_LENS_FOCAL_NEAR == request.getPtzCmdEnum()) {
                speed = (double)request.getSpeed().intValue() * -0.1;
            }
            LOGGER.info("profile token data:{}", (Object)mediaProfile.getVideSource().getVideoSourceToken());
            String ret = "";
            vcmInfo.setVcmIp(device.getPtzUrl());
            if (PTZCmdEnum.PTZ_STOP == request.getPtzCmdEnum()) {
                ret = this.getPostString(vcmInfo, "ptzStop.xml", OnvifMsgType.DEVICE_EMPTY, new String[]{mediaProfile.getToken()});
            } else if (PTZCmdEnum.PTZ_LENS_FOCAL_NEAR == request.getPtzCmdEnum() || PTZCmdEnum.PTZ_LENS_FOCAL_FAR == request.getPtzCmdEnum()) {
                ret = this.getPostString(vcmInfo, "focus.xml", OnvifMsgType.DEVICE_IMAGE, new String[]{mediaProfile.getVideSource().getVideoSourceToken(), String.valueOf(speed)});
            } else if (PTZCmdEnum.PTZ_LENS_APERTURE_OPEN == request.getPtzCmdEnum() || PTZCmdEnum.PTZ_LENS_APERTURE_CLOSE == request.getPtzCmdEnum()) {
                JSONObject data = this.getImageSetting(vcmInfo, request);
                JSONObject setData = data.getJSONObject("Body").getJSONObject("GetImagingSettingsResponse").getJSONObject("ImagingSettings");
                if (PTZCmdEnum.PTZ_LENS_APERTURE_OPEN == request.getPtzCmdEnum()) {
                    if (setData.getJSONObject("Exposure").getFloatValue("Iris") < (float)setData.getJSONObject("Exposure").getIntValue("MaxIris")) {
                        setData.getJSONObject("Exposure").put("Iris", (Object)((double)setData.getJSONObject("Exposure").getFloatValue("Iris") + 0.1));
                    }
                } else if (setData.getJSONObject("Exposure").getFloatValue("Iris") > (float)setData.getJSONObject("Exposure").getIntValue("MinIris")) {
                    setData.getJSONObject("Exposure").put("Iris", (Object)((double)setData.getJSONObject("Exposure").getFloatValue("Iris") - 0.1));
                }
                ParamBean paramBean = new ParamBean();
                paramBean.setVcmInfo(vcmInfo);
                paramBean.setRequestBody((Object)setData);
                this.setImageSetting(paramBean, request);
                LOGGER.info("set image data: {}", (Object)data);
            } else {
                vcmInfo.setVcmIp(device.getPtzUrl());
                ret = this.getPostString(vcmInfo, "continuousMove.xml", OnvifMsgType.DEVICE_EMPTY, new String[]{mediaProfile.getToken(), String.valueOf(x), String.valueOf(y), String.valueOf(zoomx)});
            }
            LOGGER.info("ptz data: {}", (Object)ret);
            respond.setResult(ret);
        }
        catch (SDKException e) {
            LOGGER.error("ptz control error", (Throwable)e);
            respond.setResult(e.getMessage());
        }
        return respond;
    }

    private String getPostString(VcmReqBaseInfo vcmInfo, String fileName, OnvifMsgType msgType, String ... params) throws SDKException {
        String xml = OnvifUtils.getPostStringByVcmInfo((String)fileName, (VcmReqBaseInfo)vcmInfo, (String[])params);
        LOGGER.info("ptz request xml data: {}", (Object)xml);
        return (String)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)msgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)xml, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(vcmInfo));
    }

    public boolean setGuardPoint(ParamBean<GuardPointSetRequest> obj) {
        return false;
    }

    public GuardPointRespond getGuardPoint(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public JSONObject getImageSetting(VcmReqBaseInfo vcmReqBaseInfo, PTZControlRequest request) {
        try {
            List mediaProfiles = OnvifUtils.getMediaProfiles((VcmReqBaseInfo)vcmReqBaseInfo);
            List<String> tokenList = Arrays.asList(StringUtils.split((String)request.getChannelCode(), (String)"&"));
            MediaProfile mediaProfile = null;
            if (!CollectionUtils.isEmpty((Collection)mediaProfiles) && mediaProfiles.size() > 0) {
                for (int i = 0; i < mediaProfiles.size(); ++i) {
                    if (!tokenList.get(0).equals(((MediaProfile)mediaProfiles.get(i)).getToken())) continue;
                    mediaProfile = (MediaProfile)mediaProfiles.get(i);
                    break;
                }
            }
            if (Objects.isNull(mediaProfile)) {
                throw new InvokeException("500", "object_not_exist");
            }
            String ret = this.getPostString(vcmReqBaseInfo, "getImagingSettings.xml", OnvifMsgType.DEVICE_IMAGE, new String[]{mediaProfile.getVideSource().getVideoSourceToken()});
            return OnvifUtils.xml2Json((String)ret);
        }
        catch (SDKException e) {
            LOGGER.error("get onvif image set error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public boolean setImageSetting(ParamBean<JSONObject> obj, PTZControlRequest request) {
        Device device = OnvifUtils.getDevice((String)obj.getVcmInfo().getVcmSession());
        if (device == null) {
            throw new InvokeException("500", "cu_offline_error");
        }
        try {
            List mediaProfiles = OnvifUtils.getMediaProfiles((VcmReqBaseInfo)obj.getVcmInfo());
            List<String> tokenList = Arrays.asList(StringUtils.split((String)request.getChannelCode(), (String)"&"));
            MediaProfile mediaProfile = null;
            for (int i = 0; i < mediaProfiles.size(); ++i) {
                if (!tokenList.get(0).equals(((MediaProfile)mediaProfiles.get(i)).getToken())) continue;
                mediaProfile = (MediaProfile)mediaProfiles.get(i);
                break;
            }
            if (Objects.isNull(mediaProfile)) {
                throw new InvokeException("500", "object_not_exist");
            }
            String xml = OnvifUtils.getPostString((VcmReqBaseInfo)obj.getVcmInfo(), (String)device.getMediaUrl(), (String)"setImagingSettings.xml", (String[])new String[]{mediaProfile.getVideSource().getVideoSourceToken(), OnvifUtils.jsonObjToXml((JSONObject)((JSONObject)obj.getRequestBody()), (String)"ImagingSettings").replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "")});
            LOGGER.info("set image data: {}", (Object)xml);
            HttpRequestUtil.requestDigest((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)OnvifMsgType.DEVICE_IMAGE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)xml, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(obj.getVcmInfo()));
        }
        catch (SDKException e) {
            LOGGER.error("set onvif image set error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return true;
    }
}

