/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.impl.onvif;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.OnvifMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PresetPositionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PresetPositionRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.onvif.AbstractOnvifService;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PresetPositionV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.OnvifUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToXmlMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XmlMsgToObjectConvertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="PresetPositionOnvifV2ServiceImpl")
public class PresetPositionOnvifV2ServiceImpl
extends AbstractOnvifService
implements PresetPositionV2Service<IServerType.Onvif> {
    private static final Logger log = LoggerFactory.getLogger(PresetPositionOnvifV2ServiceImpl.class);

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToXmlMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new XmlMsgToObjectConvertor(cClass);
    }

    public PresetPositionRespond add(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        Object result = null;
        try {
            List<String> tokenList = Arrays.asList(StringUtils.split((String)req.getChannelCode(), (String)"&"));
            String result2 = this.getPostString(vcmInfo, OnvifMsgType.DEVICE_PTZ, "setPresetPosition.xml", new String[]{tokenList.get(0), req.getPresetName()});
            JSONObject data = OnvifUtils.xml2Json((String)result2);
            PresetPositionRespond respond = new PresetPositionRespond();
            respond.setIndex(data.getJSONObject("Body").getJSONObject("SetPresetResponse").getString("PresetToken"));
            return respond;
        }
        catch (SDKException e) {
            log.error("onvif preset add error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public PresetPositionRespond del(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        return null;
    }

    public PresetPositionRespond upt(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        return null;
    }

    public List<PresetPositionRespond> list(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        ArrayList<PresetPositionRespond> respondList = new ArrayList<PresetPositionRespond>();
        try {
            List<String> tokenList = Arrays.asList(StringUtils.split((String)req.getChannelCode(), (String)"&"));
            String result2 = this.getPostString(vcmInfo, OnvifMsgType.DEVICE_PTZ, "getPresetPosition.xml", new String[]{tokenList.get(0)});
            JSONObject data = OnvifUtils.xml2Json((String)result2);
            for (int i = 0; i < data.getJSONObject("Body").getJSONObject("GetPresetsResponse").getJSONArray("Preset").size(); ++i) {
                JSONObject preset = data.getJSONObject("Body").getJSONObject("GetPresetsResponse").getJSONArray("Preset").getJSONObject(i);
                PresetPositionRespond positionRespond = new PresetPositionRespond();
                positionRespond.setIndex(preset.getString("@token"));
                positionRespond.setPresetName(preset.getString("Name"));
                respondList.add(positionRespond);
            }
        }
        catch (SDKException e) {
            log.error("list preset position error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return respondList;
    }

    private String getPostString(VcmReqBaseInfo vcmInfo, OnvifMsgType msgType, String fileName, String ... params) throws SDKException {
        String xml = OnvifUtils.getPostStringByVcmInfo((String)fileName, (VcmReqBaseInfo)vcmInfo, (String[])params);
        return (String)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)msgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)xml, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(vcmInfo));
    }
}

