/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.impl.onvif;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.MasterDeviceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.device.CameraAddV2Request;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.respond.cu.device.CameraAddV2Respond;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.DeviceManageNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.onvif.AbstractOnvifService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.DeviceManageZKNvrServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.v2.DeviceManageV2Service;
import com.zkteco.zkbiosecurity.cuserver.service.v2.impl.onvif.DeviceManageOnvifV2ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.OnvifUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToXmlMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XmlMsgToObjectConvertor;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DeviceManageOnvifV2ServiceImpl
extends AbstractOnvifService
implements DeviceManageV2Service<IServerType.Onvif> {
    private static final Logger log = LoggerFactory.getLogger(DeviceManageOnvifV2ServiceImpl.class);
    public static final Predicate<InetAddress> FILTER_IPV4 = addr -> addr instanceof Inet4Address;
    public static final Predicate<InetAddress> FILTER_NOT_LINK_LOCAL = addr -> !addr.isLinkLocalAddress();

    public CameraAddV2Respond addCamera(ParamBean<CameraAddV2Request> obj) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchMasterDevice(MasterDeviceSearchRequest request) {
        ArrayList respondList = new ArrayList();
        ArrayList ipList = new ArrayList();
        log.info("start listen");
        try {
            DatagramSocket socket = new DatagramSocket(3702);
            InetAddress group = InetAddress.getByName("239.255.255.250");
            OnvifSearchDeviceThread searchDeviceThread = new OnvifSearchDeviceThread(this, "OnvifSearchDeviceThread", socket);
            searchDeviceThread.start();
            String str = OnvifUtils.getPostStringByFileName((String)"probe.xml", (String[])new String[0]);
            byte[] sendData = str.getBytes();
            for (NetworkInterface nic : DeviceManageOnvifV2ServiceImpl.getNICs((Predicate[])new Predicate[]{DeviceManageZKNvrServiceImpl.Filter.UP, DeviceManageZKNvrServiceImpl.Filter.PHYICAL_ONLY})) {
                DeviceManageOnvifV2ServiceImpl.sendMulticast((InetAddress)group, (int)3702, (byte[])sendData, (DatagramSocket)socket, (NetworkInterface)nic);
            }
        }
        catch (Exception e) {
            log.error("Onvif search master device error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMulticast(InetAddress group, int port, byte[] message, DatagramSocket socket, NetworkInterface nic) {
        UnmodifiableIterator nifAddresses = Iterators.filter((Iterator)Iterators.forEnumeration(nic.getInetAddresses()), (Predicate)Predicates.and((Predicate)FILTER_IPV4, (Predicate)FILTER_NOT_LINK_LOCAL));
        if (!nifAddresses.hasNext()) {
            return;
        }
        try {
            log.info("port: {}, ip:{}", (Object)port, (Object)((InetAddress)nifAddresses.next()).getHostAddress());
            socket.setBroadcast(true);
            socket.send(new DatagramPacket(message, message.length, group, port));
        }
        catch (Exception e) {
            log.error("sendMulticast error", (Throwable)e);
        }
    }

    @SafeVarargs
    public static Set<NetworkInterface> getNICs(Predicate<NetworkInterface> ... filters) {
        if (null == filters) {
            filters = new Predicate[]{DeviceManageNvr800ServiceImpl.Filter.ALL};
        }
        try {
            UnmodifiableIterator filtered = Iterators.filter((Iterator)Iterators.forEnumeration(NetworkInterface.getNetworkInterfaces()), (Predicate)Predicates.and(filters));
            return ImmutableSet.copyOf((Iterator)filtered);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToXmlMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new XmlMsgToObjectConvertor(cClass);
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

