/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.v2.hikvison.impl;

import com.alibaba.fastjson.JSONArray;
import com.zkteco.zkbiosecurity.cuserver.contants.HIKVISONMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.device.CameraAddV2Request;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.respond.cu.device.CameraAddV2Respond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.hikvision.AbstractHIKVISIONService;
import com.zkteco.zkbiosecurity.cuserver.service.v2.DeviceManageV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="deviceManageHIKVISONV2Service")
public class DeviceManageHIKVISONV2ServiceImpl
extends AbstractHIKVISIONService
implements DeviceManageV2Service<IServerType.HIKVISION> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageHIKVISONV2ServiceImpl.class);

    public CameraAddV2Respond addCamera(ParamBean<CameraAddV2Request> obj) {
        JSONArray channelCodejsonArray = new JSONArray();
        JSONArray resultArray = new JSONArray();
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        List channelInfos = ((CameraAddV2Request)obj.getRequestBody()).getChannelInfo();
        try {
            for (CameraAddV2Request.ChannelInfo channelInfo : channelInfos) {
                Document document = DocumentHelper.createDocument();
                Element InputProxyChannel2 = document.addElement("InputProxyChannel");
                InputProxyChannel2.addElement("id").setText("0");
                InputProxyChannel2.addElement("quickAdd").setText("false");
                Element sourceInputPortDescriptor = InputProxyChannel2.addElement("sourceInputPortDescriptor");
                sourceInputPortDescriptor.addElement("proxyProtocol").setText(channelInfo.getProtocol());
                sourceInputPortDescriptor.addElement("addressingFormatType").setText("ipaddress");
                sourceInputPortDescriptor.addElement("ipAddress").setText(channelInfo.getIp());
                sourceInputPortDescriptor.addElement("managePortNo").setText(channelInfo.getPort());
                sourceInputPortDescriptor.addElement("srcInputPort").setText("1");
                sourceInputPortDescriptor.addElement("userName").setText(channelInfo.getDeviceUser());
                sourceInputPortDescriptor.addElement("password").setText(channelInfo.getDevicePassword());
                sourceInputPortDescriptor.addElement("streamType").setText("auto");
                String rsp = (String)HttpRequestUtil.requestDigestForHIKVISION((VcmReqBaseInfo)vcmInfo, (MsgType)HIKVISONMsgType.ADD_DEVICE, null, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)document.asXML(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
                document = DocumentHelper.parseText((String)rsp);
                Element rootElement = document.getRootElement();
                channelCodejsonArray.add((Object)("CH" + rootElement.elementText("id")));
                resultArray.add((Object)0);
            }
        }
        catch (SDKException e) {
            LOGGER.error("HIKVISON add Camera error :", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        catch (DocumentException e) {
            LOGGER.error("HIKVISON add Camera result to xml error :", (Throwable)e);
        }
        CameraAddV2Respond cameraAddRespond = new CameraAddV2Respond();
        cameraAddRespond.setCameraCode(channelCodejsonArray);
        cameraAddRespond.setResult(resultArray);
        return cameraAddRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

