/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrConstants;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RecordConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.VideoItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordStatusRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoBookMarkRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.RecordTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VideoService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.AbstractZKNvrService;
import com.zkteco.zkbiosecurity.cuserver.utils.DateUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="videoZKNvrService")
public class VideoZKNvrServiceImpl
extends AbstractZKNvrService
implements VideoService<IServerType.ZKNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoZKNvrServiceImpl.class);
    private static final String TIME_STYLE = "%s-%s-%s %s:%s:%s";

    public VideoRespond videoList(VcmReqBaseInfo vcmInfo, VideoListRequest req) {
        VideoRespond videoRespond = new VideoRespond();
        JSONObject frmNetNtpPara = this.frmNetNtpPara(vcmInfo);
        String timeZone = (String)ZKNvrConstants.TIME_ZONE_TYPE_MAP.get(frmNetNtpPara.getJSONObject("Data").getInteger("TimeZoneType"));
        JSONObject jsonObject = this.buildVideoReq(req, timeZone);
        try {
            JSONArray searchResults;
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_VIDEO_RECORDS_QUERY, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            if (null == rsp) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            Integer resultCode = rsp.getInteger("Result");
            if ("-1".equals(String.valueOf(resultCode))) {
                return videoRespond;
            }
            if ("0".equals(String.valueOf(resultCode)) && (searchResults = rsp.getJSONObject("Data").getJSONArray("SearchResults")).size() > 0) {
                videoRespond = this.buildVideoList(searchResults, timeZone);
            }
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr videoList error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
        return videoRespond;
    }

    private VideoRespond buildVideoList(JSONArray searchResults, String timeZone) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        VideoRespond videoRespond = new VideoRespond();
        ArrayList<VideoItem> videoItemList = new ArrayList<VideoItem>();
        JSONObject searchResult = searchResults.getJSONObject(0);
        JSONArray records = searchResult.getJSONArray("Records");
        String plusOrMinus = timeZone.substring(3, 4);
        Integer hour = Integer.valueOf(timeZone.substring(4, 6));
        Integer minute = Integer.valueOf(timeZone.substring(7, 9));
        for (int i = 0; i < records.size(); ++i) {
            JSONArray record = (JSONArray)records.get(i);
            VideoItem videoItem = new VideoItem();
            Integer type = record.getInteger(0);
            Integer supType = 0;
            int size = record.size();
            if (size > 3) {
                supType = record.getInteger(3);
            }
            if (type == 0 && supType == 0 || type < 1 && supType < 1) continue;
            RecordTypeEnum recordType = RecordTypeEnum.PLAN;
            recordType = 1 == type && supType == 0 ? RecordTypeEnum.PLAN : RecordTypeEnum.ALARM;
            videoItem.setType(recordType);
            videoItem.setStartTime(sdf.format(new Date(this.getTimeZone(Long.valueOf(Long.parseLong(record.getString(1))), plusOrMinus, hour, minute, Boolean.valueOf(false)) * 1000L)));
            videoItem.setEndTime(sdf.format(new Date(this.getTimeZone(Long.valueOf(Long.parseLong(record.getString(2))), plusOrMinus, hour, minute, Boolean.valueOf(false)) * 1000L)));
            videoItemList.add(videoItem);
        }
        videoRespond.setVideoItemList(videoItemList);
        return videoRespond;
    }

    private long getTimeZone(Long time, String plusOrMinus, Integer hour, Integer minute, Boolean isReq) {
        long plusOrMinusCount = 0L;
        if (hour != 0) {
            plusOrMinusCount += (long)(hour * 3600);
        }
        if (minute != 0) {
            plusOrMinusCount += 1800L;
        }
        if (isReq.booleanValue()) {
            if ("+".equals(plusOrMinus)) {
                return time + plusOrMinusCount;
            }
            if ("-".equals(plusOrMinus)) {
                return time - plusOrMinusCount;
            }
        } else {
            if ("-".equals(plusOrMinus)) {
                return time + plusOrMinusCount;
            }
            if ("+".equals(plusOrMinus)) {
                return time - plusOrMinusCount;
            }
        }
        return time;
    }

    JSONObject frmNetNtpPara(VcmReqBaseInfo vcmReqBaseInfo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        try {
            JSONObject frmNetNtpPara = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.FRM_NET_NTP_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(frmNetNtpPara);
            return frmNetNtpPara;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr frmNetNtpPara error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject buildVideoReq(VideoListRequest req, String timeZone) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        jsonObject.put("Ch", (Object)Integer.valueOf(req.getChannelCode().substring(2)));
        JSONObject data = new JSONObject();
        int[] channels = new int[]{Integer.valueOf(req.getChannelCode().substring(2))};
        data.put("Channels", (Object)channels);
        String plusOrMinus = timeZone.substring(3, 4);
        Integer hour = Integer.valueOf(timeZone.substring(4, 6));
        Integer minute = Integer.valueOf(timeZone.substring(7, 9));
        Integer supQueryType = 0;
        if (req.getTypeList().contains(RecordTypeEnum.HUMAN)) {
            supQueryType = (Integer)ZKNvrConstants.ZK_NVR_VIDEO_SUPP_QUERY_TYPE.get(RecordTypeEnum.HUMAN.toString());
        }
        if (req.getTypeList().contains(RecordTypeEnum.VEHICLE)) {
            supQueryType = supQueryType + (Integer)ZKNvrConstants.ZK_NVR_VIDEO_SUPP_QUERY_TYPE.get(RecordTypeEnum.VEHICLE.toString());
        }
        data.put("SuppQueryType", (Object)supQueryType);
        Integer queryType = 0;
        if (req.getTypeList().contains(RecordTypeEnum.PLAN)) {
            queryType = (Integer)ZKNvrConstants.ZK_NVR_VIDEO_QUERY_TYPE.get(RecordTypeEnum.PLAN.toString());
        }
        if (req.getTypeList().contains(RecordTypeEnum.ALARM)) {
            queryType = queryType + (Integer)ZKNvrConstants.ZK_NVR_VIDEO_QUERY_TYPE.get(RecordTypeEnum.ALARM.toString());
            queryType = supQueryType != 0 ? Integer.valueOf(queryType + 64) : Integer.valueOf(queryType + 120);
        }
        System.out.println("queryType = " + queryType + "---supQueryType = " + supQueryType);
        data.put("QueryType", (Object)queryType);
        Date beginDateTime = DateUtil.stringToDate((String)req.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss.SSS");
        data.put("BeginDateTime", (Object)this.getTimeZone(Long.valueOf(beginDateTime.getTime() / 1000L), plusOrMinus, hour, minute, Boolean.valueOf(true)));
        Date endDateTime = DateUtil.stringToDate((String)req.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss.SSS");
        data.put("EndDateTime", (Object)this.getTimeZone(Long.valueOf(endDateTime.getTime() / 1000L), plusOrMinus, hour, minute, Boolean.valueOf(true)));
        data.put("QueryCondition", (Object)0);
        jsonObject.put("Data", (Object)data);
        return jsonObject;
    }

    public Boolean videoStart(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        Integer videoManualRecordStatus = this.getVideoManualRecordStatus(vcmInfo, req);
        if (videoManualRecordStatus == 1) {
            this.videoStop(vcmInfo, req);
        }
        return this.setVideoStartAndStop(vcmInfo, req, Integer.valueOf(1));
    }

    public Boolean videoStop(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        Integer videoManualRecordStatus = this.getVideoManualRecordStatus(vcmInfo, req);
        if (videoManualRecordStatus == 0) {
            return true;
        }
        return this.setVideoStartAndStop(vcmInfo, req, Integer.valueOf(0));
    }

    public List<VideoBookMarkRespond> getVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkSearchRequest req) {
        JSONArray labelInfos;
        ArrayList<VideoBookMarkRespond> videoBookMarkResponds = new ArrayList<VideoBookMarkRespond>();
        JSONObject data = new JSONObject();
        data.put("StartTime", (Object)this.timeStrToStyle(req.getFromTime()));
        data.put("EndTime", (Object)this.timeStrToStyle(req.getToTime()));
        JSONObject jsonObject = this.requestVideoBookmark(vcmInfo, Integer.valueOf(0), null, data);
        if (Objects.nonNull(jsonObject) && ObjectUtils.isNotEmpty((Object)(labelInfos = jsonObject.getJSONObject("Data").getJSONArray("LabelInfo"))) && labelInfos.size() > 0) {
            for (int i = 0; i < labelInfos.size(); ++i) {
                VideoBookMarkRespond videoBookMarkRespond = new VideoBookMarkRespond();
                JSONObject labelInfo = labelInfos.getJSONObject(i);
                String ch = labelInfo.getString("Ch");
                if (!ch.equals(req.getChannelCode().substring(2))) continue;
                videoBookMarkRespond.setId(labelInfo.getLong("LabelID").longValue());
                videoBookMarkRespond.setLabelId(labelInfo.getLong("LabelID").longValue());
                videoBookMarkRespond.setCameraCode("CH" + ch);
                videoBookMarkRespond.setName(labelInfo.getString("Name"));
                videoBookMarkRespond.setTime(labelInfo.getString("Time").replaceAll("[[\\s-:punct:]]", ""));
                videoBookMarkResponds.add(videoBookMarkRespond);
            }
        }
        return videoBookMarkResponds;
    }

    private String timeStrToStyle(String time) {
        return String.format(TIME_STYLE, time.substring(0, 4), time.substring(4, 6), time.substring(6, 8), time.substring(8, 10), time.substring(10, 12), time.substring(12, 14));
    }

    public String createVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        JSONObject data = new JSONObject();
        Integer ch = Integer.valueOf(req.getChannelCode().substring(2));
        data.put("Name", (Object)req.getName());
        data.put("Ch", (Object)ch);
        data.put("Time", (Object)this.timeStrToStyle(req.getTime()));
        JSONObject jsonObject = this.requestVideoBookmark(vcmInfo, Integer.valueOf(2), ch, data);
        JSONObject resultData = jsonObject.getJSONObject("Data");
        String labelID = resultData.getString("LabelID");
        return labelID + "#" + labelID;
    }

    public boolean uptVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        JSONObject data = new JSONObject();
        data.put("Name", (Object)req.getName());
        data.put("LabelID", (Object)req.getLabelId());
        this.requestVideoBookmark(vcmInfo, Integer.valueOf(1), null, data);
        return true;
    }

    public boolean delVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        JSONObject data = new JSONObject();
        Integer ch = Integer.valueOf(req.getChannelCode().substring(2));
        data.put("LabelID", (Object)req.getLabelId());
        this.requestVideoBookmark(vcmInfo, Integer.valueOf(3), ch, data);
        return true;
    }

    private JSONObject requestVideoBookmark(VcmReqBaseInfo vcmInfo, Integer type, Integer ch, JSONObject data) {
        JSONObject result = null;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)type);
        if (ch != null) {
            jsonObject.put("Ch", (Object)ch);
        }
        if (ObjectUtils.isNotEmpty((Object)data)) {
            jsonObject.put("Data", (Object)data);
        }
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_RECORD_LABEL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            Integer resultCode = rsp.getInteger("Result");
            if ("0".equals(String.valueOf(resultCode))) {
                result = rsp;
            }
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr requestVideoBookmark error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
        return result;
    }

    public VideoLockInfoListRespond getVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoListRequest req) {
        return null;
    }

    public VideoLockInfoRespond createVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public VideoLockInfoRespond delVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public VideoLockInfoRespond uptVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public List<RecordStatusRespond> getRecordStatus(ParamBean<ChannelListRequest> obj) {
        return null;
    }

    public RecordConfigRespond getConfig(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public boolean setConfig(ParamBean<RecordConfigRequest> obj) {
        return false;
    }

    private boolean setVideoStartAndStop(VcmReqBaseInfo vcmInfo, VideoRequest req, Integer type) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)1);
        jsonObject.put("Ch", (Object)Integer.valueOf(req.getChannelCode().substring(2)));
        JSONObject data = new JSONObject();
        data.put("ManualRecordEnable", (Object)type);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_MANUAL_RECORD, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr setVideoStartAndStop error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private Integer getVideoManualRecordStatus(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        jsonObject.put("Ch", (Object)Integer.valueOf(req.getChannelCode().substring(2)));
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_MANUAL_RECORD, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp.getJSONObject("Data").getInteger("ManualRecordEnable");
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr getVideoManualRecordStatus error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

