/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrConstants;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.SystemConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.TimeConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.TimeConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.SystemConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SystemConfigService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.AbstractZKNvrService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="systemConfigZKNvrService")
public class SystemConfigZKNvrServiceImpl
extends AbstractZKNvrService
implements SystemConfigService<IServerType.ZKNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfigZKNvrServiceImpl.class);
    private static final String TIME_TEMPLATE = "%s-%s-%s %s:%s:%s";

    public boolean setTimeConfig(ParamBean<TimeConfigRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        TimeConfigRequest requestBody = (TimeConfigRequest)obj.getRequestBody();
        JSONObject frmGetTimeZoneCapGetReq = new JSONObject();
        frmGetTimeZoneCapGetReq.put("Type", (Object)0);
        JSONObject frmGetTimeZoneCapGet = this.frmNetNtpPara(vcmInfo, frmGetTimeZoneCapGetReq);
        JSONObject frmGetTimeZoneCapSetReq = new JSONObject();
        frmGetTimeZoneCapSetReq.put("Type", (Object)1);
        JSONObject data = frmGetTimeZoneCapGet.getJSONObject("Data");
        String ntpServer = requestBody.getNtpServer();
        if (StringUtils.isNotBlank((CharSequence)ntpServer)) {
            data.put("NTPServer", (Object)ntpServer);
        }
        data.put("TimeZoneType", ZKNvrConstants.TIME_ZONE_TYPE_NAME_MAP.get(requestBody.getTimezone()));
        data.put("enableNTP", (Object)(requestBody.isEnableNTP() ? 1 : 0));
        frmGetTimeZoneCapSetReq.put("Data", (Object)data);
        this.frmNetNtpPara(vcmInfo, frmGetTimeZoneCapSetReq);
        this.setFrmDeviceTimeCtrl(vcmInfo, requestBody.getTime());
        return true;
    }

    private void setFrmDeviceTimeCtrl(VcmReqBaseInfo vcmInfo, String time) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)1);
        JSONObject data = new JSONObject();
        JSONArray timeArr = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)time) && time.length() >= 14) {
            timeArr.add((Object)Integer.valueOf(time.substring(0, 4)));
            timeArr.add((Object)Integer.valueOf(time.substring(4, 6)));
            timeArr.add((Object)Integer.valueOf(time.substring(6, 8)));
            timeArr.add((Object)Integer.valueOf(time.substring(8, 10)));
            timeArr.add((Object)Integer.valueOf(time.substring(10, 12)));
            timeArr.add((Object)Integer.valueOf(time.substring(12, 14)));
        }
        data.put("Time", (Object)timeArr);
        jsonObject.put("Data", (Object)data);
        this.frmDeviceTimeCtrl(vcmInfo, jsonObject);
    }

    public TimeConfigRespond getDateConfig(ParamBean<EmptyRequest> obj) {
        TimeConfigRespond timeConfigRespond = new TimeConfigRespond();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        JSONObject frmNetNtpPara = this.frmNetNtpPara(obj.getVcmInfo(), jsonObject);
        JSONObject frmDeviceTimeCtrl = this.frmDeviceTimeCtrl(obj.getVcmInfo(), jsonObject);
        JSONObject frmNetNtpParaData = frmNetNtpPara.getJSONObject("Data");
        JSONObject frmDeviceTimeCtrlData = frmDeviceTimeCtrl.getJSONObject("Data");
        timeConfigRespond.setTimezone((String)ZKNvrConstants.TIME_ZONE_TYPE_MAP.get(frmNetNtpPara.getJSONObject("Data").getInteger("TimeZoneType")));
        timeConfigRespond.setTime(this.buildTimeArrToStr(frmDeviceTimeCtrlData.getJSONArray("Time")));
        timeConfigRespond.setEnableNTP(frmNetNtpParaData.getInteger("EnableNTP") == 1);
        timeConfigRespond.setNtpServer(frmNetNtpParaData.getString("NTPServer"));
        return timeConfigRespond;
    }

    JSONObject frmGetTimeZoneCap(VcmReqBaseInfo vcmReqBaseInfo, JSONObject requestJson) {
        try {
            JSONObject frmGetTimeZoneCap = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.FRM_GET_TIME_ZONE_CAP, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(frmGetTimeZoneCap);
            return frmGetTimeZoneCap;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr frmGetTimeZoneCap error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    JSONObject frmDeviceTimeCtrl(VcmReqBaseInfo vcmReqBaseInfo, JSONObject requestJson) {
        try {
            JSONObject frmDeviceTimeCtrl = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.FRM_DEVICE_TIME_CTRL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(frmDeviceTimeCtrl);
            return frmDeviceTimeCtrl;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr frmDeviceTimeCtrl error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    JSONObject frmNetNtpPara(VcmReqBaseInfo vcmReqBaseInfo, JSONObject requestJson) {
        try {
            JSONObject frmNetNtpPara = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.FRM_NET_NTP_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(frmNetNtpPara);
            return frmNetNtpPara;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr frmNetNtpPara error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private String buildTimeArrToStr(JSONArray timeArr) {
        String second;
        String minute;
        String hour;
        String day;
        String year = timeArr.getString(0);
        String month = timeArr.getString(1);
        if (month.length() == 1) {
            month = "0" + month;
        }
        if ((day = timeArr.getString(2)).length() == 1) {
            day = "0" + day;
        }
        if ((hour = timeArr.getString(3)).length() == 1) {
            hour = "0" + hour;
        }
        if ((minute = timeArr.getString(4)).length() == 1) {
            minute = "0" + minute;
        }
        if ((second = timeArr.getString(5)).length() == 1) {
            second = "0" + second;
        }
        return String.format(TIME_TEMPLATE, year, month, day, hour, minute, second);
    }

    private JSONArray buildTimeStrToArr(String time) {
        int i;
        JSONArray result = new JSONArray();
        String[] timeArr = time.split(" ");
        String[] timeArr1 = timeArr[0].split("-");
        String[] timeArr2 = timeArr[1].split(":");
        for (i = 0; i < 3; ++i) {
            result.add((Object)timeArr1[i]);
        }
        for (i = 0; i < 3; ++i) {
            result.add((Object)timeArr2[i]);
        }
        return result;
    }

    public boolean setSystemConfig(ParamBean<SystemConfigRequest> obj) {
        return false;
    }

    public SystemConfigRespond getSystemConfig(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

