/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SnapshotService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.AbstractZKNvrService;
import com.zkteco.zkbiosecurity.cuserver.utils.FileUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="snapshotZKNvrServiceImpl")
public class SnapshotZKNvrServiceImpl
extends AbstractZKNvrService
implements SnapshotService<IServerType.ZKNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotZKNvrServiceImpl.class);

    public SnapshotRespond createSnapshot(VcmReqBaseInfo vcmReqBaseInfo, SnapshotRequest req) {
        SnapshotRespond snapshotRespond = new SnapshotRespond();
        JSONObject jsonObject = new JSONObject();
        String channelCode = req.getChannelCode();
        if (channelCode.startsWith("CH")) {
            channelCode = channelCode.substring(2);
        }
        jsonObject.put("Ch", (Object)Integer.valueOf(channelCode));
        CloseableHttpResponse result = null;
        try {
            result = (CloseableHttpResponse)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.CAPTURE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), response -> (CloseableHttpResponse)response);
        }
        catch (SDKException e) {
            throw new InvokeException("500", e.getMessage());
        }
        String content = "";
        try (InputStream inputStream = result.getEntity().getContent();){
            content = FileUtil.getContentFromInputStream((InputStream)inputStream, (CloseableHttpResponse)result);
        }
        catch (IOException e) {
            LOGGER.error("stream failed", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        if (content.length() > 0) {
            content = content.replaceAll("[\\s*\t\n\r]", "");
            snapshotRespond.setImgBase64Str(content);
        }
        return snapshotRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

