/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPPlayBackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPRealPlayRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVideoDownloadRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVoiceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPPlayBackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPRealPlayRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVideoDownloadRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVoiceRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.RTSPService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.AbstractZKNvrService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.ZKNvrUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="rtspZKNvrService")
public class RTSPZKNvrServiceImpl
extends AbstractZKNvrService
implements RTSPService<IServerType.ZKNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTSPZKNvrServiceImpl.class);
    private static final String RTSP_STR_SUB = "rtsp://%s:%s@%s:%s/%s.%s?ptype=udp";
    private static final String RTSP_STR_RECORDING = "rtsp://%s:%s@%s:%s/recording%s?ch=%s&stream=%s&start=%s&stop=%s";

    public RTSPRealPlayRespond realPlay(VcmReqBaseInfo vcmInfo, RTSPRealPlayRequest request) {
        String videoEncodeType;
        JSONObject rtspUrl;
        String exRtspPort;
        RTSPRealPlayRespond rtspRealPlayRespond = new RTSPRealPlayRespond();
        ArrayList<JSONObject> rtspUrls = new ArrayList<JSONObject>();
        String channelCode = this.splitChannelCode(request.getChannelCode());
        if (channelCode.length() < 2) {
            channelCode = "0" + channelCode;
        }
        if (StringUtils.isBlank((CharSequence)(exRtspPort = ZKNvrUtils.getConfig((String)(vcmInfo.getVcmIp() + "_" + vcmInfo.getVcmPort()))))) {
            exRtspPort = this.getExRtspPort(vcmInfo);
            ZKNvrUtils.setConfig((String)(vcmInfo.getVcmIp() + "_" + vcmInfo.getVcmPort()), (String)exRtspPort);
        }
        if (request.getType() == 0 || request.getType() == 1) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                videoEncodeType = this.getVideoEncodeType(vcmInfo, channelCode, Integer.valueOf(request.getType()));
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "living_comb" + channelCode, videoEncodeType));
                rtspUrl.put("type", (Object)1);
                rtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "ch" + channelCode, 264));
                rtspUrl.put("type", (Object)1);
                rtspUrls.add(rtspUrl);
            }
        }
        if (request.getType() == 0 || request.getType() == 2) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                videoEncodeType = this.getVideoEncodeType(vcmInfo, channelCode, Integer.valueOf(request.getType()));
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "living_comb" + channelCode + "_sub", videoEncodeType));
                rtspUrl.put("type", (Object)2);
                rtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "ch" + channelCode + "_sub", 264));
                rtspUrl.put("type", (Object)2);
                rtspUrls.add(rtspUrl);
            }
        }
        rtspRealPlayRespond.setRtspUrls(rtspUrls);
        return rtspRealPlayRespond;
    }

    public RTSPPlayBackRespond playBack(VcmReqBaseInfo vcmInfo, RTSPPlayBackRequest request) {
        JSONObject rtspUrl;
        RTSPPlayBackRespond rtspPlayBackRespond = new RTSPPlayBackRespond();
        ArrayList<JSONObject> playBackRtspUrls = new ArrayList<JSONObject>();
        String channelCode = this.splitChannelCode(request.getChannelCode());
        String startDate = request.getStartDate().replace("-", "").replace(":", "").replace(" ", "");
        String endDate = request.getEndDate().replace("-", "").replace(":", "").replace(" ", "");
        String exRtspPort = this.getExRtspPort(vcmInfo);
        if (request.getType() == 0 || request.getType() == 1) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "_comb", channelCode, 0, startDate, endDate + "&rec_inquiry_type=2147483647"));
                rtspUrl.put("type", (Object)1);
                playBackRtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "", channelCode, 0, startDate, endDate));
                rtspUrl.put("type", (Object)1);
                playBackRtspUrls.add(rtspUrl);
            }
        }
        if (request.getType() == 0 || request.getType() == 2) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "_comb", channelCode, 1, startDate, endDate + "&rec_inquiry_type=2147483647"));
                rtspUrl.put("type", (Object)2);
                playBackRtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "", channelCode, 1, startDate, endDate));
                rtspUrl.put("type", (Object)2);
                playBackRtspUrls.add(rtspUrl);
            }
        }
        rtspPlayBackRespond.setRtspUrls(playBackRtspUrls);
        return rtspPlayBackRespond;
    }

    public RTSPVoiceRespond voice(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        String channelCode = request.getChannelCode();
        if (StringUtils.isNotBlank((CharSequence)channelCode)) {
            channelCode = this.splitChannelCode(channelCode);
            JSONObject json = new JSONObject();
            json.put("Type", (Object)1);
            JSONObject data = new JSONObject();
            data.put("Channel", (Object)Integer.valueOf(channelCode));
            data.put("Ip", (Object)request.getIp());
            data.put("AudioType", (Object)1);
            json.put("Data", (Object)data);
            try {
                JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_GET_RTSP_URL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)json, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
                this.checkJsonRespond(rsp);
                JSONObject resultData = rsp.getJSONObject("Data");
                if (Objects.nonNull(resultData)) {
                    RTSPVoiceRespond rtspVoiceRespond = new RTSPVoiceRespond();
                    rtspVoiceRespond.setRtspUrl(resultData.getString("RtspUrl"));
                    return rtspVoiceRespond;
                }
            }
            catch (Exception e) {
                LOGGER.error("get zkNvr voice exception ", (Throwable)e);
                throw new InvokeException("500", e.getMessage());
            }
        }
        return null;
    }

    private String getNetInterfaceCap(VcmReqBaseInfo vcmInfo) {
        JSONObject json = new JSONObject();
        json.put("Type", (Object)0);
        json.put("Ch", (Object)0);
        json.put("Data", (Object)new JSONObject());
        JSONObject rsp = null;
        try {
            JSONArray netInterfaceCap;
            rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_NETWORK_CAP, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)json, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONObject resultData = rsp.getJSONObject("Data");
            if (Objects.nonNull(resultData) && Objects.nonNull(netInterfaceCap = resultData.getJSONArray("NetInterfaceCap"))) {
                return netInterfaceCap.getJSONArray(0).getString(1);
            }
        }
        catch (SDKException e) {
            LOGGER.error("get zkNvr netInterfaceCap exception ", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        this.checkJsonRespond(rsp);
        return null;
    }

    private String getVideoEncodeType(VcmReqBaseInfo vcmInfo, String channelCode, Integer streamType) {
        Integer videoEncTypeCode;
        JSONObject compressPara;
        String videoEncodeType = "264";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        jsonObject.put("Ch", (Object)Integer.valueOf(channelCode));
        int abilityType = 0;
        JSONObject data = new JSONObject();
        if (streamType == 2) {
            abilityType = 1;
        }
        data.put("AbilityType", (Object)abilityType);
        jsonObject.put("Data", (Object)data);
        JSONObject videoCompressPara = this.getVideoCompressPara(vcmInfo, jsonObject);
        if (Objects.nonNull(videoCompressPara) && Objects.nonNull(compressPara = videoCompressPara.getJSONObject("Data").getJSONObject("CompressPara")) && (videoEncTypeCode = compressPara.getInteger("VideoEncType")) != null && videoEncTypeCode == 8) {
            videoEncodeType = "265";
        }
        return videoEncodeType;
    }

    private JSONObject getVideoCompressPara(VcmReqBaseInfo vcmInfo, JSONObject jsonObject) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_VIDEO_COMPRESS_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr frmVideoCompressPara error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private String getExRtspPort(VcmReqBaseInfo vcmInfo) {
        String netInterfaceCap = this.getNetInterfaceCap(vcmInfo);
        if (StringUtils.isNotBlank((CharSequence)netInterfaceCap)) {
            JSONObject json = new JSONObject();
            json.put("Type", (Object)0);
            json.put("Ch", (Object)0);
            JSONObject data = new JSONObject();
            data.put("NetworkCardIdx", (Object)netInterfaceCap);
            json.put("Data", (Object)data);
            JSONObject rsp = null;
            try {
                rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_NET_SETTING_MULTI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)json, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
                this.checkJsonRespond(rsp);
                JSONObject resultData = rsp.getJSONObject("Data");
                if (Objects.nonNull(resultData)) {
                    if (this.isLAN(vcmInfo.getVcmIp())) {
                        return resultData.getString("RtspPort");
                    }
                    return resultData.getString("ExRtspPort");
                }
                return "554";
            }
            catch (SDKException e) {
                LOGGER.error("get zkNvr exRtspPort exception ", (Throwable)e);
                throw new InvokeException("500", e.getMessage());
            }
            catch (IOException e) {
                LOGGER.error("test ip exRtspPort exception ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return "554";
    }

    public boolean isLAN(String ip) throws IOException {
        Pattern reg = Pattern.compile("^(127\\.0\\.0\\.1)|(localhost)|(10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})|(172\\.((1[6-9])|(2\\d)|(3[01]))\\.\\d{1,3}\\.\\d{1,3})|(192\\.168\\.\\d{1,3}\\.\\d{1,3})$");
        Matcher match = reg.matcher(ip);
        return match.find();
    }

    public RTSPVoiceRespond broadcast(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVideoDownloadRespond videoDownload(VcmReqBaseInfo vcmInfo, RTSPVideoDownloadRequest request) {
        return null;
    }

    private String splitChannelCode(String channelCode) {
        if (StringUtils.isNotBlank((CharSequence)channelCode)) {
            String[] channelCodeArray = channelCode.split("\\$");
            if (channelCodeArray.length >= 2) {
                return channelCodeArray[1].substring(2, channelCode.length());
            }
            if (channelCode.startsWith("CH")) {
                return channelCode.substring(2, channelCode.length());
            }
            return channelCode;
        }
        return "";
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

