/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.HeatMapConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.MotionConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.NormalIntelligentRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.OcclusionConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.QueueDetectionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.RepeatVisitorRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.SoundDetectionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.VideoCoverRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraModeRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.EmailConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.FaceCaptureRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.MaskAlarmItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.MotionConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.OcclusionConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.Point;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.RepeatVisitorGetRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.SituationalConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.SoundDetectionConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.VideoCoverRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.VideoLostRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.ZoneInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrAudioConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrCounterPara;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrDetectionCommonConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrMotionChannelConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrMotionDetParam;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrMotionHandleType;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrOcclusionChannelConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrPtz;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrSmartMotionChannelConfig;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.NormalIntelligentService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.AbstractZKNvrService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.ZKNvrUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NormalIntelligentZKNvrServiceImpl
extends AbstractZKNvrService
implements NormalIntelligentService<IServerType.ZKNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NormalIntelligentZKNvrServiceImpl.class);

    public MotionConfigRespond getMotionConfig(ParamBean<MotionConfigRequest> obj) {
        MotionConfigRespond motionConfigRespond = new MotionConfigRespond();
        JSONObject jsonObject = this.motionConfig(Integer.valueOf(0), obj.getVcmInfo(), ((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        if (Objects.nonNull(data)) {
            ZKNvrMotionChannelConfig motionChannelConfig = new ZKNvrMotionChannelConfig();
            motionChannelConfig.setIsLocal(Boolean.valueOf(data.getInteger("IsLocal") == 1));
            JSONObject motionDetetionJson = data.getJSONObject("MotionDetetion");
            if (Objects.nonNull(motionDetetionJson)) {
                ZKNvrMotionChannelConfig.MotionDetetion motionDetetion = new ZKNvrMotionChannelConfig.MotionDetetion(motionChannelConfig);
                motionDetetion.setEnableWriteLog(Boolean.valueOf(motionDetetionJson.getInteger("EnableWriteLog") == 1));
                motionDetetion.setEnableHandleMotion(Boolean.valueOf(motionDetetionJson.getInteger("EnableHandleMotion") == 1));
                motionDetetion.setMotionSensitive(motionDetetionJson.getInteger("MotionSensitive"));
                JSONObject motionHandleTypeJson = motionDetetionJson.getJSONObject("MotionHandleType");
                if (Objects.nonNull(motionHandleTypeJson)) {
                    ZKNvrMotionHandleType motionHandleType = new ZKNvrMotionHandleType();
                    motionHandleType.setHandleType(motionHandleTypeJson.getInteger("HandleType"));
                    try {
                        motionHandleType.setRelAlarmOut(motionHandleTypeJson.getJSONArray("RelAlarmOut").toJavaList(Integer.class));
                    }
                    catch (ClassCastException e) {
                        motionHandleType.setRelAlarmOut(new ArrayList());
                    }
                    motionDetetion.setMotionHandleType(motionHandleType);
                }
                motionChannelConfig.setMotionDetetion(motionDetetion);
            }
            motionChannelConfig.setMotionAreaMode(data.getInteger("MotionAreaMode"));
            motionChannelConfig.setMotionScope((List)JSONArray.parse((String)data.getString("MotionScope")));
            motionChannelConfig.setDetScale(data.getInteger("DetScale"));
            List alarmTimes = ZKNvrUtils.buildJsonToAlarmTime((JSONArray)data.getJSONArray("AlarmTime"));
            if (Objects.nonNull(alarmTimes)) {
                motionChannelConfig.setAlarmTime(alarmTimes);
            }
            motionChannelConfig.setRelRecordChan(data.getJSONArray("RelRecordChan").toJavaList(Integer.class));
            motionChannelConfig.setRelPreviewChan(data.getJSONArray("RelPreviewChan").toJavaList(Integer.class));
            motionChannelConfig.setRelSnapChan(data.getJSONArray("RelSnapChan").toJavaList(Integer.class));
            motionChannelConfig.setPtz(ZKNvrUtils.buildJsonToPtz((JSONObject)data.getJSONObject("PTZ")));
            motionChannelConfig.setSupportLocalNum(data.getInteger("SupportLocalNum"));
            motionConfigRespond.setZknvrMotionChannelConfig(motionChannelConfig);
        }
        return motionConfigRespond;
    }

    public MotionConfigRespond getSmartMotionConfig(ParamBean<MotionConfigRequest> obj) {
        MotionConfigRespond motionConfigRespond = new MotionConfigRespond();
        JSONObject jsonObject = this.smartMotionConfig(Integer.valueOf(0), obj.getVcmInfo(), ((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        if (Objects.nonNull(data)) {
            JSONArray audioConfigJsonArr;
            ZKNvrSmartMotionChannelConfig smartMotionChannelConfig = new ZKNvrSmartMotionChannelConfig();
            smartMotionChannelConfig.setSmartVersion(data.getInteger("SmartVersion"));
            smartMotionChannelConfig.setSupportRegionNum(data.getInteger("SupportRegionNum"));
            smartMotionChannelConfig.setSupportPointNum(data.getInteger("SupportPointNum"));
            smartMotionChannelConfig.setEnableMotionDect(Boolean.valueOf(data.getInteger("EnableMotionDect") == 1));
            smartMotionChannelConfig.setEnablePreviewDisplay(Boolean.valueOf(data.getInteger("EnablePreviewDisplay") == 1));
            smartMotionChannelConfig.setDetectionMode(data.getString("DetectionMode"));
            JSONArray motionDetParamJsonArr = data.getJSONArray("MotionDetParam");
            if (Objects.nonNull(motionDetParamJsonArr)) {
                ArrayList<ZKNvrMotionDetParam> motionDetParams = new ArrayList<ZKNvrMotionDetParam>();
                for (int i = 0; i < motionDetParamJsonArr.size(); ++i) {
                    JSONObject motionDetParamJson = (JSONObject)motionDetParamJsonArr.get(i);
                    ZKNvrMotionDetParam motionDetParam = new ZKNvrMotionDetParam();
                    motionDetParam.setSensitive(motionDetParamJson.getInteger("Sensitive"));
                    motionDetParam.setObjType(motionDetParamJson.getInteger("ObjType"));
                    motionDetParam.setScale(motionDetParamJson.getInteger("Scale"));
                    motionDetParam.setPointNum(motionDetParamJson.getString("PointNum"));
                    motionDetParam.setCounterPoint(motionDetParamJson.getJSONArray("CounterPoint").toJavaList(Integer[].class));
                    motionDetParams.add(motionDetParam);
                }
                smartMotionChannelConfig.setMotionDetParam(motionDetParams);
            }
            if (Objects.nonNull(audioConfigJsonArr = data.getJSONArray("AudioConfig"))) {
                ArrayList<ZKNvrAudioConfig> audioConfigs = new ArrayList<ZKNvrAudioConfig>();
                for (int i = 0; i < audioConfigJsonArr.size(); ++i) {
                    JSONObject audioConfigJson = (JSONObject)audioConfigJsonArr.get(i);
                    ZKNvrAudioConfig audioConfig = new ZKNvrAudioConfig();
                    audioConfig.setAudioIdx(audioConfigJson.getInteger("AudioIdx"));
                    audioConfig.setAudioName(audioConfigJson.getString("AudioName"));
                    audioConfigs.add(audioConfig);
                }
                smartMotionChannelConfig.setAudioConfig(audioConfigs);
            }
            smartMotionChannelConfig.setAudioEnable(Boolean.valueOf(data.getInteger("AudioEnable") == 1));
            smartMotionChannelConfig.setCurrentAudio(data.getString("CurrentAudio"));
            smartMotionChannelConfig.setLightEnable(Boolean.valueOf(data.getInteger("LightEnable") == 1));
            List alarmTimes = ZKNvrUtils.buildJsonToAlarmTime((JSONArray)data.getJSONArray("AlarmTime"));
            if (Objects.nonNull(alarmTimes)) {
                smartMotionChannelConfig.setAlarmTime(alarmTimes);
            }
            JSONObject motionDetHandleType = data.getJSONObject("MotionDetHandleType");
            ZKNvrMotionHandleType smartMotionHandleType = new ZKNvrMotionHandleType();
            smartMotionHandleType.setHandleType(motionDetHandleType.getInteger("HandleType"));
            try {
                smartMotionHandleType.setRelAlarmOut(motionDetHandleType.getJSONArray("RelAlarmOut").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                smartMotionHandleType.setRelAlarmOut(new ArrayList());
            }
            smartMotionChannelConfig.setMotionDetHandleType(smartMotionHandleType);
            try {
                smartMotionChannelConfig.setRelRecordChan(data.getJSONArray("RelRecordChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                smartMotionChannelConfig.setRelRecordChan(new ArrayList());
            }
            try {
                smartMotionChannelConfig.setRelPreviewChan(data.getJSONArray("RelPreviewChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                smartMotionChannelConfig.setRelPreviewChan(new ArrayList());
            }
            try {
                smartMotionChannelConfig.setRelSnapChan(data.getJSONArray("RelSnapChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                smartMotionChannelConfig.setRelSnapChan(new ArrayList());
            }
            smartMotionChannelConfig.setPtz(ZKNvrUtils.buildJsonToPtz((JSONObject)data.getJSONObject("PTZ")));
            motionConfigRespond.setZknvrSmartMotionChannelConfig(smartMotionChannelConfig);
        }
        return motionConfigRespond;
    }

    public boolean setMotionConfig(ParamBean<MotionConfigRequest> obj) {
        Integer supportLocalNum;
        ZKNvrPtz ptz;
        List relSnapChan;
        List relPreviewChan;
        List relRecordChan;
        List alarmTime;
        Integer detScale;
        List motionScope;
        Integer motionAreaMode;
        ZKNvrMotionChannelConfig.MotionDetetion motionDetetion;
        MotionConfigRequest requestBody = (MotionConfigRequest)obj.getRequestBody();
        ZKNvrMotionChannelConfig zknvrMotionChannelConfig = requestBody.getZknvrMotionChannelConfig();
        JSONObject motionConfig = this.motionConfig(Integer.valueOf(0), obj.getVcmInfo(), ((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = motionConfig.getJSONObject("Data");
        Boolean isLocal = zknvrMotionChannelConfig.getIsLocal();
        if (Objects.nonNull(isLocal)) {
            data.put("IsLocal", (Object)(isLocal != false ? 1 : 0));
        }
        if (Objects.nonNull(motionDetetion = zknvrMotionChannelConfig.getMotionDetetion())) {
            JSONObject motionHandleType;
            Integer motionSensitive;
            Boolean enableHandleMotion;
            JSONObject motionDetetionJson = data.getJSONObject("MotionDetetion");
            Boolean enableWriteLog = motionDetetion.getEnableWriteLog();
            if (Objects.nonNull(enableWriteLog)) {
                motionDetetionJson.put("EnableWriteLog", (Object)(enableWriteLog != false ? 1 : 0));
            }
            if (Objects.nonNull(enableHandleMotion = motionDetetion.getEnableHandleMotion())) {
                motionDetetionJson.put("EnableHandleMotion", (Object)(enableHandleMotion != false ? 1 : 0));
            }
            if (Objects.nonNull(motionSensitive = motionDetetion.getMotionSensitive())) {
                motionDetetionJson.put("MotionSensitive", (Object)motionSensitive);
            }
            if (Objects.nonNull(motionHandleType = motionDetetionJson.getJSONObject("MotionHandleType"))) {
                motionDetetionJson.put("MotionHandleType", (Object)ZKNvrUtils.buildMotionHandleTypeToJson((JSONObject)motionHandleType, (ZKNvrMotionHandleType)motionDetetion.getMotionHandleType()));
            }
            data.put("MotionDetetion", (Object)motionDetetionJson);
        }
        if (Objects.nonNull(motionAreaMode = zknvrMotionChannelConfig.getMotionAreaMode())) {
            data.put("MotionAreaMode", (Object)motionAreaMode);
        }
        if (Objects.nonNull(motionScope = zknvrMotionChannelConfig.getMotionScope())) {
            data.put("MotionScope", (Object)motionScope.toArray());
        }
        if (Objects.nonNull(detScale = zknvrMotionChannelConfig.getDetScale())) {
            data.put("DetScale", (Object)detScale);
        }
        if (Objects.nonNull(alarmTime = zknvrMotionChannelConfig.getAlarmTime())) {
            data.put("AlarmTime", (Object)ZKNvrUtils.buildAlarmTimeToJson((List)alarmTime));
        }
        if (Objects.nonNull(relRecordChan = zknvrMotionChannelConfig.getRelRecordChan())) {
            data.put("RelRecordChan", (Object)relRecordChan.toArray());
        }
        if (Objects.nonNull(relPreviewChan = zknvrMotionChannelConfig.getRelPreviewChan())) {
            data.put("RelPreviewChan", (Object)relPreviewChan.toArray());
        }
        if (Objects.nonNull(relSnapChan = zknvrMotionChannelConfig.getRelSnapChan())) {
            data.put("RelSnapChan", (Object)relSnapChan.toArray());
        }
        if (Objects.nonNull(ptz = zknvrMotionChannelConfig.getPtz())) {
            data.put("PTZ", (Object)ZKNvrUtils.buildPtzToJson((JSONObject)data.getJSONObject("PTZ"), (ZKNvrPtz)ptz));
        }
        if (Objects.nonNull(supportLocalNum = zknvrMotionChannelConfig.getSupportLocalNum())) {
            data.put("SupportLocalNum", (Object)supportLocalNum);
        }
        this.motionConfig(Integer.valueOf(1), obj.getVcmInfo(), ((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), data);
        return true;
    }

    public boolean setSmartMotionConfig(ParamBean<MotionConfigRequest> obj) {
        ZKNvrPtz ptz;
        List relSnapChan;
        List relPreviewChan;
        List relRecordChan;
        ZKNvrMotionHandleType motionDetHandleType;
        Boolean lightEnable;
        String currentAudio;
        List audioConfig;
        Boolean audioEnable;
        List alarmTime;
        List motionDetParam;
        Boolean enablePreviewDisplay;
        MotionConfigRequest requestBody = (MotionConfigRequest)obj.getRequestBody();
        ZKNvrSmartMotionChannelConfig config = requestBody.getZknvrSmartMotionChannelConfig();
        JSONObject motionConfig = this.smartMotionConfig(Integer.valueOf(0), obj.getVcmInfo(), ((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = motionConfig.getJSONObject("Data");
        Boolean enableMotionDect = config.getEnableMotionDect();
        if (Objects.nonNull(enableMotionDect)) {
            data.put("EnableMotionDect", (Object)(enableMotionDect != false ? 1 : 0));
        }
        if (Objects.nonNull(enablePreviewDisplay = config.getEnablePreviewDisplay())) {
            data.put("EnablePreviewDisplay", (Object)(enablePreviewDisplay != false ? 1 : 0));
        }
        if (Objects.nonNull(motionDetParam = config.getMotionDetParam())) {
            data.put("MotionDetParam", JSONArray.toJSON((Object)motionDetParam));
        }
        if (Objects.nonNull(alarmTime = config.getAlarmTime())) {
            data.put("AlarmTime", (Object)ZKNvrUtils.buildAlarmTimeToJson((List)alarmTime));
        }
        if (Objects.nonNull(audioEnable = config.getAudioEnable())) {
            data.put("AudioEnable", (Object)(audioEnable != false ? 1 : 0));
        }
        if (Objects.nonNull(audioConfig = config.getAudioConfig())) {
            data.put("AudioConfig", JSONArray.toJSON((Object)audioConfig));
        }
        if (Objects.nonNull(currentAudio = config.getCurrentAudio())) {
            data.put("CurrentAudio", (Object)Integer.valueOf(currentAudio));
        }
        if (Objects.nonNull(lightEnable = config.getLightEnable())) {
            data.put("LightEnable", (Object)(lightEnable != false ? 1 : 0));
        }
        if (Objects.nonNull(motionDetHandleType = config.getMotionDetHandleType())) {
            data.put("MotionDetHandleType", (Object)ZKNvrUtils.buildMotionHandleTypeToJson((JSONObject)data.getJSONObject("MotionDetHandleType"), (ZKNvrMotionHandleType)motionDetHandleType));
        }
        if (Objects.nonNull(relRecordChan = config.getRelRecordChan())) {
            data.put("RelRecordChan", (Object)relRecordChan.toArray());
        }
        if (Objects.nonNull(relPreviewChan = config.getRelPreviewChan())) {
            data.put("RelPreviewChan", (Object)relPreviewChan.toArray());
        }
        if (Objects.nonNull(relSnapChan = config.getRelSnapChan())) {
            data.put("RelSnapChan", (Object)relSnapChan.toArray());
        }
        if (Objects.nonNull(ptz = config.getPtz())) {
            data.put("PTZ", (Object)ZKNvrUtils.buildPtzToJson((JSONObject)data.getJSONObject("PTZ"), (ZKNvrPtz)ptz));
        }
        this.smartMotionConfig(Integer.valueOf(1), obj.getVcmInfo(), ((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), data);
        return true;
    }

    public VideoCoverRespond getVideoCoverConfig(ParamBean<VideoCoverRequest> obj) {
        JSONObject videoShelter;
        VideoCoverRespond videoCoverRespond = new VideoCoverRespond();
        JSONObject jsonObject = this.videoCoverConfig(Integer.valueOf(0), obj.getVcmInfo(), ((VideoCoverRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        if (Objects.nonNull(data) && Objects.nonNull(videoShelter = data.getJSONObject("VideoShelter"))) {
            Integer enableHide = videoShelter.getInteger("EnableHide");
            videoCoverRespond.setEnable(Boolean.valueOf(enableHide == 1));
            videoCoverRespond.setMaxNum(4);
            int curNum = 4;
            JSONArray shelters = videoShelter.getJSONArray("Shelters");
            if (Objects.nonNull(shelters) && shelters.size() > 0) {
                ArrayList<ZoneInfo> zoneInfos = new ArrayList<ZoneInfo>();
                for (int i = 0; i < shelters.size() && curNum >= 0; ++i) {
                    ZoneInfo zoneInfo = new ZoneInfo();
                    JSONObject shelter = shelters.getJSONObject(i);
                    Integer hideAreaTopLeftX = shelter.getInteger("HideAreaTopLeftX");
                    Integer hideAreaTopLeftY = shelter.getInteger("HideAreaTopLeftY");
                    Integer hideAreaWidth = shelter.getInteger("HideAreaWidth");
                    Integer hideAreaHeight = shelter.getInteger("HideAreaHeight");
                    if (hideAreaTopLeftX == 0 && hideAreaTopLeftY == 0 && hideAreaWidth == 0 && hideAreaHeight == 0) {
                        --curNum;
                    }
                    zoneInfo.setNo(i + 1);
                    zoneInfo.setColor(0);
                    ArrayList<Point> points = new ArrayList<Point>();
                    Point point = new Point();
                    point.setLeft(hideAreaTopLeftX.intValue());
                    point.setTop(hideAreaTopLeftY.intValue());
                    points.add(point);
                    point = new Point();
                    point.setLeft(hideAreaTopLeftX + hideAreaWidth);
                    point.setTop(hideAreaTopLeftY.intValue());
                    points.add(point);
                    point = new Point();
                    point.setLeft(hideAreaTopLeftX.intValue());
                    point.setTop(hideAreaTopLeftY + hideAreaHeight);
                    points.add(point);
                    point = new Point();
                    point.setLeft(hideAreaTopLeftX + hideAreaWidth);
                    point.setTop(hideAreaTopLeftY + hideAreaHeight);
                    points.add(point);
                    zoneInfo.setPoints(points);
                    zoneInfos.add(zoneInfo);
                }
                videoCoverRespond.setCurNum(curNum);
                videoCoverRespond.setZones(zoneInfos);
            }
        }
        return videoCoverRespond;
    }

    public boolean setVideoCoverConfig(ParamBean<VideoCoverRequest> obj) {
        VideoCoverRequest requestBody = (VideoCoverRequest)obj.getRequestBody();
        VideoCoverRespond config = requestBody.getConfig();
        if (Objects.nonNull(config)) {
            JSONObject data = new JSONObject();
            JSONObject videoShelter = new JSONObject();
            videoShelter.put("EnableHide", (Object)(config.getEnable() != false ? 1 : 0));
            JSONArray shelters = new JSONArray();
            List zones = config.getZones();
            if (Objects.nonNull(zones) && zones.size() > 0) {
                for (ZoneInfo zone : zones) {
                    List points;
                    if (!Objects.nonNull(zone) || !Objects.nonNull(points = zone.getPoints()) || points.size() <= 0) continue;
                    JSONObject shelter = new JSONObject();
                    Point leftTopPoint = (Point)points.get(0);
                    Point rightDownPoint = (Point)points.get(2);
                    shelter.put("HideAreaTopLeftX", (Object)leftTopPoint.getLeft());
                    shelter.put("HideAreaTopLeftY", (Object)leftTopPoint.getTop());
                    shelter.put("HideAreaWidth", (Object)(rightDownPoint.getLeft() - leftTopPoint.getLeft()));
                    shelter.put("HideAreaHeight", (Object)(rightDownPoint.getTop() - leftTopPoint.getTop()));
                    shelters.add((Object)shelter);
                }
            }
            if (zones.size() < 4) {
                for (int j = 0; j < 4 - zones.size(); ++j) {
                    JSONObject shelter = new JSONObject();
                    shelter.put("HideAreaTopLeftX", (Object)0);
                    shelter.put("HideAreaTopLeftY", (Object)0);
                    shelter.put("HideAreaWidth", (Object)0);
                    shelter.put("HideAreaHeight", (Object)0);
                    shelters.add((Object)shelter);
                }
            }
            videoShelter.put("Shelters", (Object)shelters);
            data.put("VideoShelter", (Object)videoShelter);
            this.videoCoverConfig(Integer.valueOf(1), obj.getVcmInfo(), requestBody.getChannelCode(), data);
        }
        return true;
    }

    public OcclusionConfigRespond getOcclusionConfig(ParamBean<OcclusionConfigRequest> obj) {
        OcclusionConfigRespond occlusionConfigRespond = new OcclusionConfigRespond();
        JSONObject jsonObject = this.occlusionConfig(Integer.valueOf(0), obj.getVcmInfo(), ((OcclusionConfigRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        if (Objects.nonNull(data)) {
            JSONObject hideAlarmHandleType;
            ZKNvrOcclusionChannelConfig config = new ZKNvrOcclusionChannelConfig();
            config.setEnableHideAlarm(Boolean.valueOf(data.getInteger("EnableHideAlarm") == 1));
            config.setSensitivity(data.getInteger("Sensitivity"));
            config.setHideRect(data.getJSONArray("HideRect").toJavaList(Integer.class));
            List alarmTimes = ZKNvrUtils.buildJsonToAlarmTime((JSONArray)data.getJSONArray("AlarmTime"));
            if (Objects.nonNull(alarmTimes)) {
                config.setAlarmTime(alarmTimes);
            }
            if (Objects.nonNull(hideAlarmHandleType = data.getJSONObject("HideAlarmHandleType"))) {
                ZKNvrMotionHandleType motionHandleType = new ZKNvrMotionHandleType();
                motionHandleType.setHandleType(hideAlarmHandleType.getInteger("HandleType"));
                try {
                    motionHandleType.setRelAlarmOut(hideAlarmHandleType.getJSONArray("RelAlarmOut").toJavaList(Integer.class));
                }
                catch (ClassCastException e) {
                    motionHandleType.setRelAlarmOut(new ArrayList());
                }
                config.setMotionHandleType(motionHandleType);
            }
            config.setPtz(ZKNvrUtils.buildJsonToPtz((JSONObject)data.getJSONObject("PTZ")));
            occlusionConfigRespond.setZknvrOcclusionChannelConfig(config);
        }
        return occlusionConfigRespond;
    }

    public boolean setOcclusionConfig(ParamBean<OcclusionConfigRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        OcclusionConfigRequest config = (OcclusionConfigRequest)obj.getRequestBody();
        ZKNvrOcclusionChannelConfig zknvrOcclusionChannelConfig = config.getZknvrOcclusionChannelConfig();
        if (Objects.nonNull(zknvrOcclusionChannelConfig)) {
            JSONObject ptz;
            JSONObject hideAlarmHandleType;
            List alarmTime;
            List hideRect;
            Integer sensitivity;
            JSONObject jsonObject = this.occlusionConfig(Integer.valueOf(0), vcmInfo, ((OcclusionConfigRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
            JSONObject data = jsonObject.getJSONObject("Data");
            Boolean enableHideAlarm = zknvrOcclusionChannelConfig.getEnableHideAlarm();
            if (Objects.nonNull(enableHideAlarm)) {
                data.put("EnableHideAlarm", (Object)(enableHideAlarm != false ? 1 : 0));
            }
            if (Objects.nonNull(sensitivity = zknvrOcclusionChannelConfig.getSensitivity())) {
                data.put("Sensitivity", (Object)sensitivity);
            }
            if (Objects.nonNull(hideRect = zknvrOcclusionChannelConfig.getHideRect())) {
                data.put("HideRect", (Object)hideRect.toArray());
            }
            if (Objects.nonNull(alarmTime = zknvrOcclusionChannelConfig.getAlarmTime())) {
                data.put("AlarmTime", (Object)ZKNvrUtils.buildAlarmTimeToJson((List)alarmTime));
            }
            if (Objects.nonNull(hideAlarmHandleType = data.getJSONObject("HideAlarmHandleType"))) {
                data.put("HideAlarmHandleType", (Object)ZKNvrUtils.buildMotionHandleTypeToJson((JSONObject)hideAlarmHandleType, (ZKNvrMotionHandleType)zknvrOcclusionChannelConfig.getMotionHandleType()));
            }
            if (Objects.nonNull(ptz = data.getJSONObject("PTZ"))) {
                data.put("PTZ", (Object)ZKNvrUtils.buildPtzToJson((JSONObject)ptz, (ZKNvrPtz)zknvrOcclusionChannelConfig.getPtz()));
            }
            this.occlusionConfig(Integer.valueOf(1), vcmInfo, ((OcclusionConfigRequest)obj.getRequestBody()).getChannelCode(), data);
        }
        return true;
    }

    public FaceCaptureRespond getPerimeterFaceConfig(ParamBean<NormalIntelligentRequest> obj) {
        return null;
    }

    public JSONObject setPerimeterFaceConfig(ParamBean<NormalIntelligentRequest> obj) {
        return null;
    }

    public CameraModeRespond getCameraModeConfig(ParamBean<NormalIntelligentRequest> obj) {
        return null;
    }

    public boolean setCameraModeConfig(ParamBean<NormalIntelligentRequest> obj) {
        return false;
    }

    public MaskAlarmItemRespond getMaskAlarmConfig(ParamBean<NormalIntelligentRequest> obj) {
        return null;
    }

    public boolean setMaskAlarmConfig(ParamBean<NormalIntelligentRequest> obj) {
        return false;
    }

    public JSONObject getFaceRecognitionConfig(ParamBean<NormalIntelligentRequest> obj) {
        return null;
    }

    public boolean setFaceRecognitionConfig(ParamBean<NormalIntelligentRequest> obj) {
        return false;
    }

    public SoundDetectionConfig get(VcmReqBaseInfo vcmInfo, SoundDetectionRequest soundDetectionRequest) {
        return null;
    }

    public Boolean set(ParamBean<SoundDetectionRequest> obj) {
        return null;
    }

    public SituationalConfigRespond getQueueDetect(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        return null;
    }

    public Boolean setQueueDetect(ParamBean<QueueDetectionRequest> obj) {
        return null;
    }

    public SituationalConfigRespond getCrowdDensity(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        return null;
    }

    public Boolean setCrowdDensity(ParamBean<QueueDetectionRequest> obj) {
        return null;
    }

    public JSONObject getThirdPartyAlgorithm(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        return null;
    }

    public Boolean setThirdPartyAlgorithm(ParamBean<QueueDetectionRequest> obj) {
        return null;
    }

    public SituationalConfigRespond getCrossCounting(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        SituationalConfigRespond situationalConfigRespond = new SituationalConfigRespond();
        JSONObject jsonObject = this.crossCountingConfig(Integer.valueOf(0), vcmInfo, queueDetectionRequest.getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        ZKNvrDetectionCommonConfig config = new ZKNvrDetectionCommonConfig();
        if (Objects.nonNull(data)) {
            List alarmTimes;
            JSONArray audioConfigJsonArr;
            config.setSmartVersion(data.getInteger("SmartVersion"));
            config.setSupportNum(data.getInteger("SupportLineNum"));
            config.setSupportPointNum(data.getInteger("SupportPointNum"));
            config.setEnable(Boolean.valueOf(data.getInteger("EnableTargetCount") == 1));
            config.setEnablePreviewDisplay(Boolean.valueOf(data.getInteger("EnablePreviewDisplay") == 1));
            JSONArray counterParaJsonArr = data.getJSONArray("CounterPara");
            if (Objects.nonNull(counterParaJsonArr)) {
                ArrayList<ZKNvrCounterPara> counterPara = new ArrayList<ZKNvrCounterPara>();
                for (int i = 0; i < counterParaJsonArr.size(); ++i) {
                    ZKNvrCounterPara zkNvrCounterPara = new ZKNvrCounterPara();
                    JSONObject counterParaJson = (JSONObject)counterParaJsonArr.get(i);
                    zkNvrCounterPara.setDetType(counterParaJson.getInteger("DetType"));
                    zkNvrCounterPara.setObjType(counterParaJson.getInteger("ObjType"));
                    zkNvrCounterPara.setCounterPoint(counterParaJson.getJSONArray("CounterPoint").toJavaList(Integer[].class));
                    zkNvrCounterPara.setScale(counterParaJson.getInteger("Scale"));
                    zkNvrCounterPara.setEnableFlowCount(Boolean.valueOf(counterParaJson.getInteger("EnableFlowCount") == 1));
                    zkNvrCounterPara.setIntervalTime(counterParaJson.getInteger("CountIntervalTime"));
                    zkNvrCounterPara.setCountAlarmThreshold(counterParaJson.getInteger("CountAlarmThreshold"));
                    zkNvrCounterPara.setEnableTimeFlowCount(Boolean.valueOf(counterParaJson.getInteger("EnableTimeFlowCount") == 1));
                    zkNvrCounterPara.setCountTime(counterParaJson.getJSONArray("CountTime").toJavaList(Integer.class));
                    zkNvrCounterPara.setTotalAlarmThreshold(counterParaJson.getInteger("TotalAlarmThreshold"));
                    zkNvrCounterPara.setPointNum(counterParaJson.getInteger("PointNum"));
                    counterPara.add(zkNvrCounterPara);
                }
                config.setCounterPara(counterPara);
            }
            if (Objects.nonNull(audioConfigJsonArr = data.getJSONArray("AudioConfig"))) {
                ArrayList<ZKNvrAudioConfig> audioConfigs = new ArrayList<ZKNvrAudioConfig>();
                for (int i = 0; i < audioConfigJsonArr.size(); ++i) {
                    JSONObject audioConfigJson = (JSONObject)audioConfigJsonArr.get(i);
                    ZKNvrAudioConfig audioConfig = new ZKNvrAudioConfig();
                    audioConfig.setAudioIdx(audioConfigJson.getInteger("AudioIdx"));
                    audioConfig.setAudioName(audioConfigJson.getString("AudioName"));
                    audioConfigs.add(audioConfig);
                }
                config.setAudioConfig(audioConfigs);
            }
            if (data.getInteger("AudioEnable") != null) {
                config.setAudioEnable(Boolean.valueOf(data.getInteger("AudioEnable") == 1));
            }
            if (data.getInteger("CurrentAudio") != null) {
                config.setCurrentAudio(data.getInteger("CurrentAudio"));
            }
            if (data.getInteger("LightEnable") != null) {
                config.setLightEnable(Boolean.valueOf(data.getInteger("LightEnable") == 1));
            }
            if (Objects.nonNull(alarmTimes = ZKNvrUtils.buildJsonToAlarmTime((JSONArray)data.getJSONArray("AlarmTime")))) {
                config.setAlarmTime(alarmTimes);
            }
            config.setSupportLocalChNum(data.getInteger("SupportLocalChNum"));
            JSONObject motionDetHandleType = data.getJSONObject("CounterHandleType");
            ZKNvrMotionHandleType smartMotionHandleType = new ZKNvrMotionHandleType();
            smartMotionHandleType.setHandleType(motionDetHandleType.getInteger("HandleType"));
            try {
                smartMotionHandleType.setRelAlarmOut(motionDetHandleType.getJSONArray("RelAlarmOut").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                smartMotionHandleType.setRelAlarmOut(new ArrayList());
            }
            config.setCounterHandleType(smartMotionHandleType);
            try {
                config.setRelRecordChan(data.getJSONArray("RelRecordChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                config.setRelRecordChan(new ArrayList());
            }
            try {
                config.setRelPreviewChan(data.getJSONArray("RelPreviewChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                config.setRelPreviewChan(new ArrayList());
            }
            try {
                config.setRelSnapChan(data.getJSONArray("RelSnapChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                config.setRelSnapChan(new ArrayList());
            }
            config.setPtz(ZKNvrUtils.buildJsonToPtz((JSONObject)data.getJSONObject("PTZ")));
        }
        situationalConfigRespond.setZknvrDetectionCommonConfig(config);
        return situationalConfigRespond;
    }

    public Boolean setCrossCounting(ParamBean<QueueDetectionRequest> obj) {
        ZKNvrPtz ptz;
        List relSnapChan;
        List relPreviewChan;
        List relRecordChan;
        ZKNvrMotionHandleType counterHandleType;
        Integer supportLocalChNum;
        List alarmTime;
        Boolean lightEnable;
        Integer currentAudio;
        Boolean audioEnable;
        List audioConfig;
        List counterPara;
        Boolean enableTargetCount;
        Integer supportPointNum;
        ZKNvrDetectionCommonConfig config = ((QueueDetectionRequest)obj.getRequestBody()).getZknvrDetectionCommonConfig();
        JSONObject jsonObject = this.crossCountingConfig(Integer.valueOf(0), obj.getVcmInfo(), ((QueueDetectionRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        Integer supportLineNum = config.getSupportNum();
        if (Objects.nonNull(supportLineNum)) {
            data.put("SupportLineNum", (Object)supportLineNum);
        }
        if (Objects.nonNull(supportPointNum = config.getSupportPointNum())) {
            data.put("SupportPointNum", (Object)supportPointNum);
        }
        if (Objects.nonNull(enableTargetCount = config.getEnable())) {
            data.put("EnableTargetCount", (Object)(enableTargetCount != false ? 1 : 0));
        }
        if (Objects.nonNull(counterPara = config.getCounterPara())) {
            data.put("CounterPara", JSONArray.toJSON((Object)counterPara));
            for (int i = 0; i < data.getJSONArray("CounterPara").size(); ++i) {
                data.getJSONArray("CounterPara").getJSONObject(i).put("EnableFlowCount", (Object)(((ZKNvrCounterPara)counterPara.get(i)).getEnableFlowCount() != false ? 1 : 0));
                data.getJSONArray("CounterPara").getJSONObject(i).put("EnableTimeFlowCount", (Object)(((ZKNvrCounterPara)counterPara.get(i)).getEnableTimeFlowCount() != false ? 1 : 0));
            }
        }
        if (Objects.nonNull(audioConfig = config.getAudioConfig())) {
            data.put("AudioConfig", JSONArray.toJSON((Object)audioConfig));
        }
        if (Objects.nonNull(audioEnable = config.getAudioEnable())) {
            data.put("AudioEnable", (Object)(audioEnable != false ? 1 : 0));
        }
        if (Objects.nonNull(currentAudio = config.getCurrentAudio())) {
            data.put("CurrentAudio", (Object)currentAudio);
        }
        if (Objects.nonNull(lightEnable = config.getLightEnable())) {
            data.put("LightEnable", (Object)(lightEnable != false ? 1 : 0));
        }
        if (Objects.nonNull(alarmTime = config.getAlarmTime())) {
            data.put("AlarmTime", (Object)ZKNvrUtils.buildAlarmTimeToJson((List)alarmTime));
        }
        if (Objects.nonNull(supportLocalChNum = config.getSupportLocalChNum())) {
            data.put("SupportLocalChNum", (Object)supportLocalChNum);
        }
        if (Objects.nonNull(counterHandleType = config.getCounterHandleType())) {
            data.put("CounterHandleType", (Object)ZKNvrUtils.buildMotionHandleTypeToJson((JSONObject)data.getJSONObject("CounterHandleType"), (ZKNvrMotionHandleType)counterHandleType));
        }
        if (Objects.nonNull(relRecordChan = config.getRelRecordChan())) {
            data.put("RelRecordChan", (Object)relRecordChan.toArray());
        }
        if (Objects.nonNull(relPreviewChan = config.getRelPreviewChan())) {
            data.put("RelPreviewChan", (Object)relPreviewChan.toArray());
        }
        if (Objects.nonNull(relSnapChan = config.getRelSnapChan())) {
            data.put("RelSnapChan", (Object)relSnapChan.toArray());
        }
        if (Objects.nonNull(ptz = config.getPtz())) {
            data.put("PTZ", (Object)ZKNvrUtils.buildPtzToJson((JSONObject)data.getJSONObject("PTZ"), (ZKNvrPtz)ptz));
        }
        this.crossCountingConfig(Integer.valueOf(1), obj.getVcmInfo(), ((QueueDetectionRequest)obj.getRequestBody()).getChannelCode(), data);
        return true;
    }

    public JSONObject clearCrossCounting(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        return null;
    }

    public HeatMapConfigRespond getHeatMapConfig(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        return null;
    }

    public RepeatVisitorGetRespond getRepeatVisitor(ParamBean<RepeatVisitorRequest> obj) {
        return null;
    }

    public SituationalConfigRespond getLeaveDetect(VcmReqBaseInfo vcmInfo, QueueDetectionRequest requestBody) {
        return null;
    }

    public Boolean setLeaveDetect(ParamBean<QueueDetectionRequest> obj) {
        return null;
    }

    public VideoLostRespond getVideoLost(ParamBean<NormalIntelligentRequest> obj) {
        VideoLostRespond videoLostRespond = new VideoLostRespond();
        JSONObject jsonObject = this.videoLost(Integer.valueOf(0), obj.getVcmInfo(), ((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        if (Objects.nonNull(data)) {
            videoLostRespond.setEnableVideoLost(Boolean.valueOf(data.getInteger("EnableVideoLost") == 1));
            videoLostRespond.setAlarmTime(ZKNvrUtils.buildJsonToAlarmTime((JSONArray)data.getJSONArray("AlarmTime")));
            JSONObject videoLostType = data.getJSONObject("VideoLostType");
            if (Objects.nonNull(videoLostType)) {
                ZKNvrMotionHandleType motionHandleType = new ZKNvrMotionHandleType();
                motionHandleType.setHandleType(videoLostType.getInteger("HandleType"));
                try {
                    motionHandleType.setRelAlarmOut(videoLostType.getJSONArray("RelAlarmOut").toJavaList(Integer.class));
                }
                catch (ClassCastException e) {
                    motionHandleType.setRelAlarmOut(new ArrayList());
                }
                videoLostRespond.setVideoLostType(motionHandleType);
            }
            videoLostRespond.setPtz(ZKNvrUtils.buildJsonToPtz((JSONObject)data.getJSONObject("PTZ")));
        }
        return videoLostRespond;
    }

    public Boolean setVideoLost(ParamBean<VideoLostRespond> obj) {
        VideoLostRespond requestBody = (VideoLostRespond)obj.getRequestBody();
        if (Objects.nonNull(requestBody)) {
            JSONObject jsonObject = this.videoLost(Integer.valueOf(0), obj.getVcmInfo(), ((VideoLostRespond)obj.getRequestBody()).getChannelCode(), new JSONObject());
            JSONObject data = jsonObject.getJSONObject("Data");
            if (Objects.nonNull(data)) {
                ZKNvrPtz ptz;
                ZKNvrMotionHandleType videoLostType;
                List alarmTime;
                Boolean enableVideoLost = requestBody.getEnableVideoLost();
                if (Objects.nonNull(enableVideoLost)) {
                    data.put("EnableVideoLost", (Object)(enableVideoLost != false ? 1 : 0));
                }
                if (Objects.nonNull(alarmTime = requestBody.getAlarmTime())) {
                    data.put("AlarmTime", (Object)ZKNvrUtils.buildAlarmTimeToJson((List)alarmTime));
                }
                if (Objects.nonNull(videoLostType = requestBody.getVideoLostType())) {
                    List relAlarmOut;
                    JSONObject videoLostTypeJson = data.getJSONObject("VideoLostType");
                    Integer handleType = videoLostType.getHandleType();
                    if (Objects.nonNull(handleType)) {
                        videoLostTypeJson.put("HandleType", (Object)handleType);
                    }
                    if (Objects.nonNull(relAlarmOut = videoLostType.getRelAlarmOut())) {
                        videoLostTypeJson.put("RelAlarmOut", (Object)relAlarmOut.toArray());
                    }
                    data.put("VideoLostType", (Object)videoLostTypeJson);
                }
                if (Objects.nonNull(ptz = requestBody.getPtz())) {
                    data.put("PTZ", (Object)ZKNvrUtils.buildPtzToJson((JSONObject)data.getJSONObject("PTZ"), (ZKNvrPtz)ptz));
                }
            }
            this.videoLost(Integer.valueOf(1), obj.getVcmInfo(), ((VideoLostRespond)obj.getRequestBody()).getChannelCode(), data);
        }
        return true;
    }

    public EmailConfigRespond getEmailConfig(ParamBean<EmptyRequest> obj) {
        EmailConfigRespond emailConfig = new EmailConfigRespond();
        JSONObject jsonObject = this.emailConfig(Integer.valueOf(0), obj.getVcmInfo(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        if (Objects.nonNull(data)) {
            emailConfig.setSenderAddress(data.getString("SenderAddress"));
            emailConfig.setPassword(data.getString("Password"));
            emailConfig.setEnableSSL(Boolean.valueOf(data.getInteger("EnableSSL") == 1));
            emailConfig.setSmtpServer(data.getString("SmtpServer"));
            emailConfig.setSmtpPort(data.getInteger("SmtpPort"));
            JSONArray recvArray = data.getJSONArray("RecvArray");
            if (Objects.nonNull(recvArray) && recvArray.size() > 0) {
                ArrayList<String> recvList = new ArrayList<String>();
                for (int i = 0; i < recvArray.size(); ++i) {
                    JSONObject recv = recvArray.getJSONObject(i);
                    recvList.add(recv.getString("RecvAddress"));
                }
                emailConfig.setRecvArray(recvList);
            }
            emailConfig.setAttachment(Boolean.valueOf(data.getInteger("Attachment") == 1));
            emailConfig.setEnableVerify(Boolean.valueOf(data.getInteger("EnableVerify") == 1));
        }
        return emailConfig;
    }

    public Boolean setEmailConfig(ParamBean<EmailConfigRespond> obj) {
        EmailConfigRespond requestBody = (EmailConfigRespond)obj.getRequestBody();
        if (Objects.nonNull(requestBody)) {
            JSONObject data = new JSONObject();
            data.put("SenderAddress", (Object)requestBody.getSenderAddress());
            data.put("Password", (Object)requestBody.getPassword());
            data.put("EnableSSL", (Object)(requestBody.getEnableSSL() != false ? 1 : 0));
            data.put("Attachment", (Object)(requestBody.getAttachment() != false ? 1 : 0));
            data.put("SmtpServer", (Object)requestBody.getSmtpServer());
            data.put("SmtpPort", (Object)requestBody.getSmtpPort());
            JSONArray recvArray = new JSONArray();
            List recvList = requestBody.getRecvArray();
            for (String recv : recvList) {
                JSONObject recvJson = new JSONObject();
                recvJson.put("RecvAddress", (Object)recv);
                recvArray.add((Object)recvJson);
            }
            if (recvList.size() < 4) {
                for (int j = 0; j < 4 - recvList.size(); ++j) {
                    JSONObject recvJson = new JSONObject();
                    recvJson.put("RecvAddress", (Object)"");
                    recvArray.add((Object)recvJson);
                }
            }
            data.put("RecvArray", (Object)recvArray);
            this.emailConfig(Integer.valueOf(1), obj.getVcmInfo(), data);
        }
        return true;
    }

    public Boolean testEmailConfig(ParamBean<EmailConfigRespond> obj) {
        EmailConfigRespond requestBody = (EmailConfigRespond)obj.getRequestBody();
        if (Objects.nonNull(requestBody)) {
            JSONObject data = new JSONObject();
            data.put("SenderAddress", (Object)requestBody.getSenderAddress());
            data.put("Password", (Object)requestBody.getPassword());
            data.put("EnableSSL", (Object)(requestBody.getEnableSSL() != false ? 1 : 0));
            data.put("Attachment", (Object)(requestBody.getAttachment() != false ? 1 : 0));
            data.put("SmtpServer", (Object)requestBody.getSmtpServer());
            data.put("SmtpPort", (Object)requestBody.getSmtpPort());
            data.put("RecvAddress", requestBody.getRecvArray().get(0));
            this.emailConfig(Integer.valueOf(3), obj.getVcmInfo(), data);
        }
        return true;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    private JSONObject motionConfig(Integer type, VcmReqBaseInfo vcmInfo, String channel, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)Integer.valueOf(channel.substring(2)));
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_MOTION_DET_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr motionConfig error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject smartMotionConfig(Integer type, VcmReqBaseInfo vcmInfo, String channel, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)Integer.valueOf(channel.substring(2)));
        reqJson.put("IsLocal", (Object)1);
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_MOTION_DET_PARA_V2, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr smartMotionConfig error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject crossCountingConfig(Integer type, VcmReqBaseInfo vcmInfo, String channel, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)Integer.valueOf(channel.substring(2)));
        reqJson.put("IsLocal", (Object)1);
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_TARGET_COUNT_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr crossCountingConfig error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject videoCoverConfig(Integer type, VcmReqBaseInfo vcmInfo, String channel, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)Integer.valueOf(channel.substring(2)));
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_VIDEO_SHELTER_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr videoCoverConfig error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject occlusionConfig(Integer type, VcmReqBaseInfo vcmInfo, String channel, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)Integer.valueOf(channel.substring(2)));
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_VIDEO_HIDE_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr occlusionConfig error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject videoLost(Integer type, VcmReqBaseInfo vcmInfo, String channel, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)Integer.valueOf(channel.substring(2)));
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_VIDEO_LOST_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr videoLost error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject emailConfig(Integer type, VcmReqBaseInfo vcmInfo, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_EMAIL_SETTING, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr emailConfig error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }
}

