/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrConstants;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.EventRespondZKnvr;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmCodeTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.MetaTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.util.DateUtil;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.SnapshotZKNvrServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.EventNameHelper;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventZkGetThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventZkGetThread.class);
    private final String domainCode;
    private Integer readerId;
    private Integer sequence;
    private Integer lapNumber;
    private final WebSocketService webSocketService;
    private final SubscriptionHelp subscriptionHelp;
    private final SnapshotZKNvrServiceImpl snapshotZKNvrService;
    private final Map<String, String> zknvrAlarmMap;

    public EventZkGetThread(String domainCode, String ip) {
        super("ZKNVR-" + ip + "-eventThread");
        this.domainCode = domainCode;
        this.webSocketService = (WebSocketService)SpringContextUtil.getBean((String)"webSocketService");
        this.subscriptionHelp = (SubscriptionHelp)SpringContextUtil.getBean((String)"subscriptionHelp");
        this.snapshotZKNvrService = (SnapshotZKNvrServiceImpl)SpringContextUtil.getBean((String)"snapshotZKNvrServiceImpl");
        this.zknvrAlarmMap = new HashMap();
    }

    @Override
    public void run() {
        int errorCount = 0;
        while (this.subscriptionHelp.get(this.domainCode) != null) {
            boolean getFail = false;
            VcmReqBaseInfo vcmReqBaseInfo = this.subscriptionHelp.get(this.domainCode);
            if (StringUtils.isBlank((CharSequence)vcmReqBaseInfo.getSdcUserName()) || StringUtils.isBlank((CharSequence)vcmReqBaseInfo.getSdcPassword())) {
                LOGGER.error("ZkNvr re-subscription failed :" + vcmReqBaseInfo.getVcmIp() + " please manually open");
                return;
            }
            JSONObject json = new JSONObject();
            JSONObject rsp = null;
            try {
                rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.EVENT_CHECK_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)json, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
            }
            catch (Exception e) {
                LOGGER.error("ZkNvr get event fail,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
                this.readerId = null;
                this.sequence = null;
                this.lapNumber = null;
                getFail = true;
                try {
                    if (errorCount < 300) {
                        ++errorCount;
                    }
                    Thread.sleep(1000 * errorCount);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.error("sleep error", (Throwable)interruptedException);
                }
            }
            if (getFail) continue;
            errorCount = 0;
            if (rsp != null && "0".equals(String.valueOf(rsp.getInteger("Result")))) {
                try {
                    EventRespondZKnvr eventRespondZKnvr = (EventRespondZKnvr)JSON.parseObject((String)rsp.toJSONString(), EventRespondZKnvr.class);
                    if (eventRespondZKnvr != null && eventRespondZKnvr.getData() != null) {
                        this.dealData(eventRespondZKnvr.getData(), vcmReqBaseInfo.getParentDeviceId());
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    LOGGER.error("deal data error", (Throwable)e);
                }
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.error("sleep error", (Throwable)interruptedException);
            }
        }
        this.subscriptionHelp.remove(this.domainCode);
        LOGGER.info("Event check exit,domainCode:{}", (Object)this.domainCode);
    }

    private void dealData(JSONObject data, String parentDeviceId) {
        if (!data.containsKey((Object)"AlarmInfo")) {
            return;
        }
        JSONArray alarmListJson = data.getJSONArray("AlarmInfo");
        for (int i = 0; i < alarmListJson.size(); ++i) {
            JSONObject alarmJson = alarmListJson.getJSONObject(i);
            String minorType = (String)ZKNvrConstants.ZK_NVR_ALARM_CODE_MAP.get(alarmJson.getInteger("MinorType"));
            if (!DeviceUtil.GENERAL_ALARM_CODE_LIST.contains(minorType) && !DeviceUtil.SYSTEM_ALARM_CODE_LIST.contains(minorType) || this.zknvrAlarmMap.get(minorType + alarmJson.getString("Source")) != null && ((String)this.zknvrAlarmMap.get(minorType + alarmJson.getString("Source"))).equals(alarmJson.getString("StartTime"))) continue;
            this.zknvrAlarmMap.put(minorType + alarmJson.getString("Source"), alarmJson.getString("StartTime"));
            AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
            alarmEventRespond.setType(EventTypeEnum.ALARM);
            TimeZone timeZone1 = TimeZone.getTimeZone("GMT");
            TimeZone timeZone2 = TimeZone.getDefault();
            int rawOffset = timeZone2.getRawOffset() - timeZone1.getRawOffset();
            long startTimeLong = alarmJson.getLongValue("StartTime") * 1000L - (long)rawOffset;
            alarmEventRespond.setTime(DateUtil.dateToString((Date)new Date(startTimeLong), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
            alarmEventRespond.setDomainCode(this.domainCode);
            alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
            alarmEventRespond.setCode(minorType);
            alarmEventRespond.setName(EventNameHelper.getEventName((String)minorType));
            alarmEventRespond.setId(UUID.randomUUID().toString());
            if (DeviceUtil.SYSTEM_ALARM_CODE_LIST.contains(minorType)) {
                alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_OPERATIONS.toString());
                alarmEventRespond.setAlarmLevel(AlarmLevelEnum.IMPORTANT);
            } else {
                alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_GENERAL_BUSINESS.toString());
                alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
                alarmEventRespond.setChannelCode("CH" + alarmJson.getString("Source"));
            }
            alarmEventRespond.setParentDeviceId(parentDeviceId);
            alarmEventRespond.setStatus(0);
            alarmEventRespond.setDeviceSubType(String.valueOf(DeviceTypeEnum.ZKNVR.val()));
            this.webSocketService.send((BaseEventRespond)alarmEventRespond);
        }
    }

    private String snapShot(String channelCode) {
        try {
            SnapshotRequest snapshotRequest = new SnapshotRequest();
            snapshotRequest.setChannelCode(channelCode);
            SnapshotRespond snapshotRespond = this.snapshotZKNvrService.createSnapshot(this.subscriptionHelp.get(this.domainCode), snapshotRequest);
            return snapshotRespond.getImgBase64Str();
        }
        catch (Exception e) {
            LOGGER.error("Snapshot fail", (Throwable)e);
            return "";
        }
    }

    List<Header> getHeaders(VcmReqBaseInfo vcmInfo) {
        ArrayList<Header> headers = new ArrayList<Header>();
        this.addOtherHeaders(vcmInfo, headers);
        return headers;
    }

    void addOtherHeaders(VcmReqBaseInfo vcmInfo, List<Header> headers) {
        if (null != vcmInfo.getHeaders() && !vcmInfo.getHeaders().isEmpty()) {
            for (VcmReqBaseInfo.Header header : vcmInfo.getHeaders()) {
                headers.add((Header)new BasicHeader(header.getKey(), (Object)header.getValue()));
            }
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

