/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.ColorConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.DateTimeRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.OsdConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.zknvr.ZkNvrConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.ColorConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.DateTimeRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.OsdConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZkNvrCaptureConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZkNvrCompressAbilityRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZkNvrCompressParaRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZkNvrConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZkNvrEffectRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZkNvrSingleLineOsdRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZkNvrVidCameraInfoItem;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceInfoConfigService;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.AbstractZKNvrService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deviceInfoConfigZKNvrService")
public class DeviceInfoConfigZKNvrServiceImpl
extends AbstractZKNvrService
implements DeviceInfoConfigService<IServerType.ZKNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceInfoConfigZKNvrServiceImpl.class);
    @Autowired
    private DeviceManageService<IServerType.ZKNVR> deviceManageZKNvrService;

    public DateTimeRespond getTimeConfig(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean setTimeConfig(ParamBean<DateTimeRequest> obj) {
        return false;
    }

    public OsdConfigRespond getOsdConfig(ParamBean<OsdConfigRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject json = new JSONObject();
        json.put("Type", (Object)0);
        Integer ch = Integer.valueOf(((OsdConfigRequest)obj.getRequestBody()).getChannelCode().substring(2));
        json.put("Ch", (Object)ch);
        JSONObject rsp = this.operationOSD(vcmInfo, json);
        JSONObject jsonObject = rsp.getJSONObject("Data").getJSONObject("OSD");
        OsdConfigRespond osdConfigRespond = new OsdConfigRespond();
        osdConfigRespond.setCovert(Boolean.valueOf(false));
        osdConfigRespond.getTime().setShow(Boolean.valueOf(jsonObject.getInteger("IsDisplayWeek") == 1));
        osdConfigRespond.getTime().getPos().setTextX(String.valueOf(Math.round(jsonObject.getFloatValue("OSDTopLeftX") / 352.0f * 704.0f)));
        osdConfigRespond.getTime().getPos().setTextY(String.valueOf(Math.round(jsonObject.getFloatValue("OSDTopLeftY") / 288.0f * 579.0f)));
        ArrayList<OsdConfigRespond.OsdName> texts = new ArrayList<OsdConfigRespond.OsdName>();
        OsdConfigRespond.OsdName text = new OsdConfigRespond.OsdName();
        text.setShow(Boolean.valueOf(jsonObject.getInteger("IsShowChanName") == 1));
        text.setText(jsonObject.getString("ChanName"));
        OsdConfigRespond.Position position = new OsdConfigRespond.Position();
        position.setTextX(String.valueOf(Math.round(jsonObject.getFloatValue("ChanNameTopLeftX") / 352.0f * 704.0f)));
        position.setTextY(String.valueOf(Math.round(jsonObject.getFloatValue("ChanNameTopLeftY") / 288.0f * 579.0f)));
        text.setPos(position);
        texts.add(text);
        osdConfigRespond.setTexts(texts);
        return osdConfigRespond;
    }

    public boolean setOsdConfig(ParamBean<OsdConfigRequest> obj) {
        OsdConfigRespond osdConfig = ((OsdConfigRequest)obj.getRequestBody()).getOsdConfig();
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject json = new JSONObject();
        json.put("Type", (Object)0);
        Integer ch = Integer.valueOf(((OsdConfigRequest)obj.getRequestBody()).getChannelCode().substring(2));
        json.put("Ch", (Object)ch);
        JSONObject getRsp = this.operationOSD(vcmInfo, json);
        JSONObject data = getRsp.getJSONObject("Data");
        if (Objects.nonNull(data)) {
            JSONObject osd = data.getJSONObject("OSD");
            JSONObject setJson = new JSONObject();
            JSONObject setData = new JSONObject();
            setJson.put("Type", (Object)1);
            setJson.put("Ch", (Object)ch);
            List texts = osdConfig.getTexts();
            osd.put("ChanName", (Object)((OsdConfigRespond.OsdName)texts.get(0)).getText());
            osd.put("IsShowChanName", (Object)((OsdConfigRespond.OsdName)texts.get(0)).getShow());
            osd.put("ChanNameTopLeftX", (Object)Float.valueOf(Float.parseFloat(((OsdConfigRespond.OsdName)texts.get(0)).getPos().getTextX()) / 704.0f * 352.0f));
            osd.put("ChanNameTopLeftY", (Object)Float.valueOf(Float.parseFloat(((OsdConfigRespond.OsdName)texts.get(0)).getPos().getTextY()) / 576.0f * 288.0f));
            OsdConfigRespond.OsdTime time = osdConfig.getTime();
            osd.put("IsDisplayWeek", (Object)time.getShow());
            osd.put("OSDTopLeftX", (Object)Float.valueOf(Float.parseFloat(time.getPos().getTextX()) / 704.0f * 352.0f));
            osd.put("OSDTopLeftY", (Object)Float.valueOf(Float.parseFloat(time.getPos().getTextY()) / 576.0f * 288.0f));
            setData.put("OSD", (Object)osd);
            setData.put("CopyChannels", (Object)this.getAllChannel(vcmInfo));
            setJson.put("Data", (Object)setData);
            this.operationOSD(vcmInfo, setJson);
            return true;
        }
        return false;
    }

    public ColorConfigRespond getColorConfig(ParamBean<ColorConfigRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        jsonObject.put("Ch", (Object)Integer.valueOf(((ColorConfigRequest)obj.getRequestBody()).getChannelCode().substring(2)));
        JSONObject rsp = this.getVideoEffect(vcmInfo, jsonObject);
        return this.buildColorConfigRep(rsp.getJSONObject("Data"));
    }

    private JSONObject getVideoEffect(VcmReqBaseInfo vcmInfo, JSONObject jsonObject) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_VIDEO_EFFECT, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr getVideoEffect error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private ColorConfigRespond buildColorConfigRep(JSONObject data) {
        ColorConfigRespond colorConfigRespond = new ColorConfigRespond();
        JSONObject videoEffect = data.getJSONObject("VideoEffect");
        if (Objects.nonNull(videoEffect)) {
            colorConfigRespond.setBright(videoEffect.getInteger("Brightness").intValue());
            colorConfigRespond.setContrast(videoEffect.getInteger("Contrast").intValue());
            colorConfigRespond.setHue(videoEffect.getInteger("Hue").intValue());
            colorConfigRespond.setSaturation(videoEffect.getInteger("Saturation").intValue());
            ColorConfigRespond.ColorRange colorRange = new ColorConfigRespond.ColorRange();
            colorRange.setHueMin(0);
            colorRange.setHueMax(255);
            colorRange.setContrastMin(0);
            colorRange.setContrastMax(255);
            colorRange.setBrightMin(0);
            colorRange.setBrightMax(255);
            colorRange.setSaturationMin(0);
            colorRange.setSaturationMax(255);
            colorRange.setSharpnessMin(0);
            colorRange.setSharpnessMax(0);
            colorConfigRespond.setRange(colorRange);
        }
        return colorConfigRespond;
    }

    public boolean setColorConfig(ParamBean<ColorConfigRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)1);
        jsonObject.put("Ch", (Object)Integer.valueOf(((ColorConfigRequest)obj.getRequestBody()).getChannelCode().substring(2)));
        jsonObject.put("Data", (Object)this.buildColorConfigReq(vcmInfo, ((ColorConfigRequest)obj.getRequestBody()).getColorConfig()));
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_VIDEO_EFFECT, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr setColorConfig error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject buildColorConfigReq(VcmReqBaseInfo vcmInfo, ColorConfigRespond colorConfigRespond) {
        JSONObject data = new JSONObject();
        JSONObject videoEffect = new JSONObject();
        videoEffect.put("Brightness", (Object)colorConfigRespond.getBright());
        videoEffect.put("Contrast", (Object)colorConfigRespond.getContrast());
        videoEffect.put("Saturation", (Object)colorConfigRespond.getSaturation());
        videoEffect.put("Hue", (Object)colorConfigRespond.getHue());
        data.put("VideoEffect", (Object)videoEffect);
        data.putIfAbsent((Object)"CopyChannels", (Object)this.getAllChannel(vcmInfo));
        return data;
    }

    private JSONArray getAllChannel(VcmReqBaseInfo vcmInfo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_GET_DEV_CHN_INFO, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            Integer maxChNum = rsp.getJSONObject("Data").getInteger("MaxChNum");
            JSONArray channelArr = new JSONArray();
            for (int i = 0; i < maxChNum; ++i) {
                channelArr.add((Object)0);
            }
            return channelArr;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr getAllChannel error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject operationOSD(VcmReqBaseInfo vcmInfo, JSONObject json) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_SINGLE_LINE_OSD, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)json, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr operationOSD error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    public ZkNvrConfigRespond getZkNvrConfig(ParamBean<ZkNvrConfigRequest> obj) {
        ZkNvrConfigRespond zkNvrConfigRespond = new ZkNvrConfigRespond();
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        String channelCode = ((ZkNvrConfigRequest)obj.getRequestBody()).getChannelCode();
        String type = ((ZkNvrConfigRequest)obj.getRequestBody()).getType();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        jsonObject.put("Ch", (Object)Integer.valueOf(channelCode.substring(2)));
        switch (type) {
            case "0": {
                zkNvrConfigRespond.setCameraInfo(this.getCameraInfo(vcmInfo, channelCode));
                zkNvrConfigRespond.setSingleLineOsd((ZkNvrSingleLineOsdRespond)this.operationOSD(vcmInfo, jsonObject).getJSONObject("Data").getJSONObject("OSD").toJavaObject(ZkNvrSingleLineOsdRespond.class));
                zkNvrConfigRespond.setVideoEffect((ZkNvrEffectRespond)this.getVideoEffect(vcmInfo, jsonObject).getJSONObject("Data").getJSONObject("VideoEffect").toJavaObject(ZkNvrEffectRespond.class));
                break;
            }
            case "1": {
                zkNvrConfigRespond.setMainCompressAbility(this.getCompressAbility(vcmInfo, jsonObject, true));
                zkNvrConfigRespond.setMainCompressPara(this.getCompressPara(vcmInfo, jsonObject, true));
                zkNvrConfigRespond.setSubCompressAbility(this.getCompressAbility(vcmInfo, jsonObject, false));
                zkNvrConfigRespond.setSubCompressPara(this.getCompressPara(vcmInfo, jsonObject, false));
                break;
            }
            case "2": {
                zkNvrConfigRespond.setCaptureConfig(this.buildCaptureConfig(this.getCaptureConfig(vcmInfo, jsonObject)));
            }
        }
        return zkNvrConfigRespond;
    }

    private ZkNvrVidCameraInfoItem getCameraInfo(VcmReqBaseInfo vcmInfo, String channelCode) {
        Integer cameraType = 0;
        ZkNvrVidCameraInfoItem zkNvrVidCameraInfoItem = new ZkNvrVidCameraInfoItem();
        ParamBean channelRequestParamBean = new ParamBean();
        ChannelRequest channelRequest = new ChannelRequest();
        channelRequest.setChannelCode(channelCode);
        channelRequestParamBean.setVcmInfo(vcmInfo);
        channelRequestParamBean.setRequestBody((Object)channelRequest);
        ChannelRespond channel = this.deviceManageZKNvrService.getChannel(channelRequestParamBean);
        switch (channel.getType()) {
            case 0: {
                cameraType = 1;
                break;
            }
            case 1: {
                cameraType = 2;
                break;
            }
            case 2: {
                cameraType = 3;
                break;
            }
            case 3: {
                cameraType = 4;
                break;
            }
            case 4: {
                cameraType = 5;
            }
        }
        zkNvrVidCameraInfoItem.setCameraType(cameraType);
        return zkNvrVidCameraInfoItem;
    }

    public boolean setZkNvrConfig(ParamBean<ZkNvrConfigRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        ZkNvrConfigRespond zkNvrConfigRespond = ((ZkNvrConfigRequest)obj.getRequestBody()).getZkNvrConfigRespond();
        String channelCode = ((ZkNvrConfigRequest)obj.getRequestBody()).getChannelCode();
        String type = ((ZkNvrConfigRequest)obj.getRequestBody()).getType();
        Integer ch = Integer.valueOf(channelCode.substring(2));
        JSONObject setJson = new JSONObject();
        setJson.put("Type", (Object)1);
        setJson.put("Ch", (Object)ch);
        JSONArray allChannel = this.getAllChannel(vcmInfo);
        switch (type) {
            case "0": {
                this.setCameraType(vcmInfo, ch, zkNvrConfigRespond.getCameraInfo().getCameraType());
                this.setSingleLineOsd(vcmInfo, allChannel, setJson, zkNvrConfigRespond.getSingleLineOsd());
                this.setVideoEffect(vcmInfo, allChannel, setJson, zkNvrConfigRespond.getVideoEffect());
                break;
            }
            case "1": {
                this.setCompressPara(vcmInfo, allChannel, setJson, zkNvrConfigRespond.getMainCompressPara(), true);
                this.setCompressPara(vcmInfo, allChannel, setJson, zkNvrConfigRespond.getSubCompressPara(), false);
                break;
            }
            case "2": {
                this.setCaptureConfig(vcmInfo, allChannel, setJson, zkNvrConfigRespond.getCaptureConfig());
            }
        }
        return true;
    }

    private Boolean setCameraType(VcmReqBaseInfo vcmInfo, Integer ch, Integer cameraType) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)1);
        JSONObject data = new JSONObject();
        data.put("ChIdx", (Object)ch);
        data.put("IPCTypeLocal", (Object)cameraType);
        jsonObject.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_SET_CHANNEL_TYPE_LOCAL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr setCameraType error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private boolean setCaptureConfig(VcmReqBaseInfo vcmInfo, JSONArray allChannel, JSONObject setJson, ZkNvrCaptureConfigRespond captureConfig) {
        JSONObject getJson = new JSONObject();
        getJson.put("Type", (Object)0);
        getJson.put("Ch", (Object)setJson.getInteger("Ch"));
        JSONObject jsonObject = this.getCaptureConfig(vcmInfo, getJson);
        JSONObject data = jsonObject.getJSONObject("Data");
        data.put("DwCaptResolution", (Object)captureConfig.getDwCaptResolution());
        data.put("CaptTimeDelay", (Object)captureConfig.getCaptTimeDelay());
        data.put("CopyChannels", (Object)allChannel);
        setJson.put("Data", (Object)data);
        this.getCaptureConfig(vcmInfo, setJson);
        return true;
    }

    private boolean setVideoEffect(VcmReqBaseInfo vcmInfo, JSONArray allChannel, JSONObject setJson, ZkNvrEffectRespond videoEffect) {
        JSONObject data = new JSONObject();
        JSONObject videoEffectJson = new JSONObject();
        videoEffectJson.put("Brightness", (Object)videoEffect.getBrightness());
        videoEffectJson.put("Contrast", (Object)videoEffect.getContrast());
        videoEffectJson.put("Saturation", (Object)videoEffect.getSaturation());
        videoEffectJson.put("Hue", (Object)videoEffect.getHue());
        data.put("VideoEffect", (Object)videoEffect);
        data.put("CopyChannels", (Object)allChannel);
        setJson.put("Data", (Object)data);
        this.getVideoEffect(vcmInfo, setJson);
        return true;
    }

    private boolean setSingleLineOsd(VcmReqBaseInfo vcmInfo, JSONArray allChannel, JSONObject setJson, ZkNvrSingleLineOsdRespond singleLineOsd) {
        JSONObject getJson = new JSONObject();
        getJson.put("Type", (Object)0);
        getJson.put("Ch", (Object)setJson.getInteger("Ch"));
        JSONObject jsonObject = this.operationOSD(vcmInfo, getJson);
        JSONObject osdJson = jsonObject.getJSONObject("Data").getJSONObject("OSD");
        osdJson.put("IsShowChanName", (Object)singleLineOsd.getIsShowChanName());
        osdJson.put("ChanName", (Object)singleLineOsd.getChanName());
        osdJson.put("IsDisplayWeek", (Object)singleLineOsd.getIsDisplayWeek());
        osdJson.put("OSDType", (Object)singleLineOsd.getOsdType());
        osdJson.put("OSDHourType", (Object)singleLineOsd.getOsdHourType());
        JSONObject data = new JSONObject();
        data.put("OSD", (Object)osdJson);
        data.put("CopyChannels", (Object)allChannel);
        setJson.put("Data", (Object)data);
        this.operationOSD(vcmInfo, setJson);
        return true;
    }

    private boolean setCompressPara(VcmReqBaseInfo vcmInfo, JSONArray allChannel, JSONObject setJson, ZkNvrCompressParaRespond mainCompressPara, boolean isMainStream) {
        JSONObject data = new JSONObject();
        if (isMainStream) {
            data.put("AbilityType", (Object)0);
        } else {
            data.put("AbilityType", (Object)1);
        }
        JSONObject mainCompressParaJson = new JSONObject();
        mainCompressParaJson.put("StreamType", (Object)mainCompressPara.getStreamType());
        mainCompressParaJson.put("AbilityType", (Object)mainCompressPara.getAbilityType());
        mainCompressParaJson.put("VideoH264Profile", (Object)(mainCompressPara.getVideoH264Profile() == null ? 0 : mainCompressPara.getVideoH264Profile()));
        mainCompressParaJson.put("Resolution", (Object)mainCompressPara.getResolution());
        mainCompressParaJson.put("BitrateType", (Object)mainCompressPara.getBitrateType());
        mainCompressParaJson.put("VideoBitrate", (Object)mainCompressPara.getVideoBitrate());
        mainCompressParaJson.put("VideoEncType", (Object)(mainCompressPara.getVideoEncType() == null ? 0 : mainCompressPara.getVideoEncType()));
        mainCompressParaJson.put("VideoFrameRate", (Object)mainCompressPara.getVideoFrameRate());
        mainCompressParaJson.put("PicQuality", (Object)mainCompressPara.getPicQuality());
        mainCompressParaJson.put("InBit", (Object)mainCompressPara.getInBit());
        mainCompressParaJson.put("IFrameInterval", (Object)mainCompressPara.getVideoIFrameInterval());
        data.put("CompressPara", (Object)mainCompressParaJson);
        data.put("CopyChannels", (Object)allChannel);
        setJson.put("Data", (Object)data);
        this.reqCompressPara(vcmInfo, setJson, isMainStream);
        return true;
    }

    private JSONObject getCaptureConfig(VcmReqBaseInfo vcmInfo, JSONObject jsonObject) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_CAPTURE_CONFIG, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr getCaptureConfig error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private ZkNvrCaptureConfigRespond buildCaptureConfig(JSONObject rsp) {
        ZkNvrCaptureConfigRespond zkNvrCaptureConfigRespond = new ZkNvrCaptureConfigRespond();
        JSONObject data = rsp.getJSONObject("Data");
        JSONArray captResolutions = data.getJSONArray("CaptResolution");
        for (int i = 0; i < captResolutions.size(); ++i) {
            JSONArray captResolution = captResolutions.getJSONArray(i);
            HashMap<String, String> captResolutionMap = new HashMap<String, String>();
            captResolutionMap.put(captResolution.getString(0), captResolution.getString(0));
            zkNvrCaptureConfigRespond.getCaptResolution().add(captResolutionMap);
        }
        zkNvrCaptureConfigRespond.setDwCaptResolution(data.getString("DwCaptResolution"));
        zkNvrCaptureConfigRespond.setCaptTimeDelay(data.getInteger("CaptTimeDelay"));
        return zkNvrCaptureConfigRespond;
    }

    private ZkNvrCompressParaRespond getCompressPara(VcmReqBaseInfo vcmInfo, JSONObject jsonObject, boolean isMainStream) {
        JSONObject data = new JSONObject();
        Integer abilityType = 0;
        if (!isMainStream) {
            abilityType = 1;
        }
        data.put("AbilityType", (Object)abilityType);
        jsonObject.put("Data", (Object)data);
        JSONObject rsp = this.reqCompressPara(vcmInfo, jsonObject, isMainStream);
        JSONObject compressPara = rsp.getJSONObject("Data").getJSONObject("CompressPara");
        return (ZkNvrCompressParaRespond)compressPara.toJavaObject(ZkNvrCompressParaRespond.class);
    }

    private JSONObject reqCompressPara(VcmReqBaseInfo vcmInfo, JSONObject jsonObject, boolean isMainStream) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_VIDEO_COMPRESS_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr reqCompressPara error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private ZkNvrCompressAbilityRespond getCompressAbility(VcmReqBaseInfo vcmInfo, JSONObject jsonObject, boolean isMainStream) {
        JSONObject data = new JSONObject();
        Integer abilityType = 0;
        if (!isMainStream) {
            abilityType = 1;
        }
        data.put("AbilityType", (Object)abilityType);
        jsonObject.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_VIDEO_COMPRESS_ABILITY, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONObject compressAbility = rsp.getJSONObject("Data").getJSONObject("CompressAbility");
            return this.buildCompressAbility(compressAbility);
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr getCompressAbility error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private ZkNvrCompressAbilityRespond buildCompressAbility(JSONObject compressAbility) {
        JSONArray videoEncTypes;
        JSONArray bitrates;
        JSONArray frameRates;
        ZkNvrCompressAbilityRespond zkNvrCompressAbilityRespond = new ZkNvrCompressAbilityRespond();
        JSONArray resolutions = compressAbility.getJSONArray("Resolution");
        if (Objects.nonNull(resolutions) && resolutions.size() > 0) {
            for (int i = 0; i < resolutions.size(); ++i) {
                HashMap<String, String> resolutionMap = new HashMap<String, String>();
                JSONArray resolution = resolutions.getJSONArray(i);
                resolutionMap.put(resolution.getString(1), resolution.getString(0));
                zkNvrCompressAbilityRespond.getResolution().add(resolutionMap);
            }
        }
        if (Objects.nonNull(frameRates = compressAbility.getJSONArray("FrameRate")) && frameRates.size() > 0) {
            for (int j = 0; j < frameRates.size(); ++j) {
                HashMap<String, String> frameRateMap = new HashMap<String, String>();
                JSONArray frameRate = frameRates.getJSONArray(j);
                frameRateMap.put(frameRate.getString(1), frameRate.getString(0));
                zkNvrCompressAbilityRespond.getFrameRate().add(frameRateMap);
            }
        }
        if (Objects.nonNull(bitrates = compressAbility.getJSONArray("Bitrate")) && bitrates.size() > 0) {
            for (int k = 0; k < bitrates.size(); ++k) {
                HashMap<String, String> bitrateMap = new HashMap<String, String>();
                JSONArray bitrate = bitrates.getJSONArray(k);
                bitrateMap.put(bitrate.getString(1), bitrate.getString(0));
                zkNvrCompressAbilityRespond.getBitrate().add(bitrateMap);
            }
        }
        if (Objects.nonNull(videoEncTypes = compressAbility.getJSONArray("VideoEncType")) && videoEncTypes.size() > 0) {
            for (int h = 0; h < videoEncTypes.size(); ++h) {
                HashMap<String, String> videoEncTypeMap = new HashMap<String, String>();
                JSONArray videoEncType = videoEncTypes.getJSONArray(h);
                videoEncTypeMap.put(videoEncType.getString(1), videoEncType.getString(0));
                zkNvrCompressAbilityRespond.getVideoEncType().add(videoEncTypeMap);
            }
        }
        return zkNvrCompressAbilityRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

