/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.CruiseRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseDetailRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PresetPositionRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.bean.CruisePoint;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.AbstractZKNvrService;
import com.zkteco.zkbiosecurity.cuserver.service.v2.CruiseV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cruiseZKNvrV2Service")
public class CruiseZKNvrV2ServiceImpl
extends AbstractZKNvrService
implements CruiseV2Service<IServerType.ZKNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CruiseZKNvrV2ServiceImpl.class);

    public JSONObject getCruiseNo(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("resultCode", (Object)"0");
        jsonObject.put("content", (Object)new JSONObject());
        jsonObject.getJSONObject("content").put("cruiseNo", (Object)"1");
        return jsonObject;
    }

    public CruiseRespond upt(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        return null;
    }

    public CruiseRespond add(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        cruiseRespond.setCruiseNo(req.getCruiseNo());
        CruiseDetailRespond detail = this.detail(vcmInfo, req);
        if (Objects.nonNull(detail.getCruisePoints()) && detail.getCruisePoints().size() > 0) {
            cruiseRespond = this.del(vcmInfo, req);
        }
        if (Objects.nonNull(cruiseRespond)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Type", (Object)1);
            jsonObject.put("Ch", (Object)Integer.valueOf(req.getChannelCode().substring(2)));
            JSONObject data = new JSONObject();
            data.put("CruisePath", (Object)1);
            List cruisePoints = req.getCruisePoints();
            if (Objects.nonNull(cruisePoints) && cruisePoints.size() > 0) {
                for (CruisePoint cruisePoint : cruisePoints) {
                    data.put("PresetNo", (Object)cruisePoint.getPresetIndex());
                    data.put("Dwell", (Object)cruisePoint.getDwellTime());
                    data.put("Speed", (Object)cruisePoint.getSpeed());
                    jsonObject.put("Data", (Object)data);
                    try {
                        JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_PTZ_CRUISE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
                        this.checkJsonRespond(rsp);
                    }
                    catch (SDKException e) {
                        LOGGER.debug("zkteco nvr add cruise control error..");
                        throw new InvokeException("500", e.getMessage());
                    }
                }
                return cruiseRespond;
            }
        }
        return cruiseRespond;
    }

    public CruiseRespond set(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        return this.add(vcmInfo, req);
    }

    public CruiseRespond del(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)3);
        jsonObject.put("Ch", (Object)Integer.valueOf(req.getChannelCode().substring(2)));
        JSONObject data = new JSONObject();
        data.put("CruisePath", (Object)Integer.valueOf(req.getCruiseNo()));
        jsonObject.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_PTZ_CRUISE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            CruiseRespond cruiseRespond = new CruiseRespond();
            cruiseRespond.setCruiseNo(req.getCruiseNo());
            return cruiseRespond;
        }
        catch (SDKException e) {
            LOGGER.debug("zkteco nvr del cruise control error..");
            throw new InvokeException("500", e.getMessage());
        }
    }

    public CruiseListRespond list(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        return null;
    }

    public CruiseDetailRespond detail(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        jsonObject.put("Ch", (Object)Integer.valueOf(req.getChannelCode().substring(2)));
        JSONObject data = new JSONObject();
        data.put("CruisePath", (Object)Integer.valueOf(req.getCruiseNo()));
        jsonObject.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_PTZ_CRUISE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return this.buildCruiseDetailResult(req, rsp.getJSONObject("Data"));
        }
        catch (SDKException e) {
            LOGGER.debug("zkteco nvr detail cruise control error..");
            throw new InvokeException("500", e.getMessage());
        }
    }

    private CruiseDetailRespond buildCruiseDetailResult(CruiseRequest req, JSONObject data) {
        CruiseDetailRespond cruiseDetailRespond = new CruiseDetailRespond();
        cruiseDetailRespond.setCruiseNo(req.getCruiseNo());
        cruiseDetailRespond.setChannelCode(req.getChannelCode());
        JSONArray cruises = data.getJSONArray("Cruise");
        if (Objects.nonNull(cruises) && cruises.size() > 0) {
            ArrayList<PresetPositionRespond> presetPositionResponds = new ArrayList<PresetPositionRespond>();
            for (int i = 0; i < cruises.size(); ++i) {
                PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
                JSONObject cruise = cruises.getJSONObject(i);
                presetPositionRespond.setPresetName(cruise.getString("PresetNo"));
                presetPositionRespond.setPresetIndex(cruise.getInteger("PresetNo").intValue());
                presetPositionRespond.setSpeed(cruise.getInteger("Speed"));
                presetPositionRespond.setPointCruiseTime(cruise.getInteger("Dwell").intValue());
                presetPositionRespond.setHasTime(false);
                presetPositionResponds.add(presetPositionRespond);
            }
            cruiseDetailRespond.setCruisePoints(presetPositionResponds);
        }
        return cruiseDetailRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

