/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorGetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.IgtAlarmConfigSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.VehicleParameterSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.ThirdAlgorithm;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.ThirdAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.VehicleParameterRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.IgtAlarmConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrAudioConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrCounterPara;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrDetectionCommonConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrMotionHandleType;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrPtz;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.BehaviorAnalysisService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.AbstractZKNvrService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.ZKNvrUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="behaviorAnalysisZKNvrService")
public class BehaviorAnalysisZKNvrServiceImpl
extends AbstractZKNvrService
implements BehaviorAnalysisService<IServerType.ZKNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BehaviorAnalysisZKNvrServiceImpl.class);

    public BehaviorRespond getPerimeterZone(ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond behaviorRespond = new BehaviorRespond();
        JSONObject jsonObject = this.perimeterZone(Integer.valueOf(0), obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        ZKNvrDetectionCommonConfig config = new ZKNvrDetectionCommonConfig();
        if (Objects.nonNull(data)) {
            List alarmTimes;
            JSONArray audioConfigJsonArr;
            config.setSmartVersion(data.getInteger("SmartVersion"));
            config.setSupportNum(data.getInteger("SupportRegionNum"));
            config.setSupportPointNum(data.getInteger("SupportPointNum"));
            config.setEnable(Boolean.valueOf(data.getInteger("EnableRegiDect") == 1));
            config.setEnablePreviewDisplay(Boolean.valueOf(data.getInteger("EnablePreviewDisplay") == 1));
            JSONArray counterParaJsonArr = data.getJSONArray("AreaDetParam");
            if (Objects.nonNull(counterParaJsonArr)) {
                ArrayList<ZKNvrCounterPara> counterPara = new ArrayList<ZKNvrCounterPara>();
                for (int i = 0; i < counterParaJsonArr.size(); ++i) {
                    ZKNvrCounterPara zkNvrCounterPara = new ZKNvrCounterPara();
                    JSONObject counterParaJson = (JSONObject)counterParaJsonArr.get(i);
                    zkNvrCounterPara.setDetType(counterParaJson.getInteger("DetType"));
                    zkNvrCounterPara.setObjType(counterParaJson.getInteger("ObjType"));
                    zkNvrCounterPara.setCounterPoint(counterParaJson.getJSONArray("CounterPoint").toJavaList(Integer[].class));
                    zkNvrCounterPara.setScale(counterParaJson.getInteger("Scale"));
                    zkNvrCounterPara.setIntervalTime(counterParaJson.getInteger("IntervalTime"));
                    zkNvrCounterPara.setPointNum(counterParaJson.getInteger("PointNum"));
                    counterPara.add(zkNvrCounterPara);
                }
                config.setCounterPara(counterPara);
            }
            if (Objects.nonNull(audioConfigJsonArr = data.getJSONArray("AudioConfig"))) {
                ArrayList<ZKNvrAudioConfig> audioConfigs = new ArrayList<ZKNvrAudioConfig>();
                for (int i = 0; i < audioConfigJsonArr.size(); ++i) {
                    JSONObject audioConfigJson = (JSONObject)audioConfigJsonArr.get(i);
                    ZKNvrAudioConfig audioConfig = new ZKNvrAudioConfig();
                    audioConfig.setAudioIdx(audioConfigJson.getInteger("AudioIdx"));
                    audioConfig.setAudioName(audioConfigJson.getString("AudioName"));
                    audioConfigs.add(audioConfig);
                }
                config.setAudioConfig(audioConfigs);
            }
            if (data.getInteger("AudioEnable") != null) {
                config.setAudioEnable(Boolean.valueOf(data.getInteger("AudioEnable") == 1));
            }
            if (data.getInteger("CurrentAudio") != null) {
                config.setCurrentAudio(data.getInteger("CurrentAudio"));
            }
            if (data.getInteger("LightEnable") != null) {
                config.setLightEnable(Boolean.valueOf(data.getInteger("LightEnable") == 1));
            }
            if (Objects.nonNull(alarmTimes = ZKNvrUtils.buildJsonToAlarmTime((JSONArray)data.getJSONArray("AlarmTime")))) {
                config.setAlarmTime(alarmTimes);
            }
            JSONObject motionDetHandleType = data.getJSONObject("AreaDetHandleType");
            ZKNvrMotionHandleType smartMotionHandleType = new ZKNvrMotionHandleType();
            smartMotionHandleType.setHandleType(motionDetHandleType.getInteger("HandleType"));
            try {
                smartMotionHandleType.setRelAlarmOut(motionDetHandleType.getJSONArray("RelAlarmOut").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                smartMotionHandleType.setRelAlarmOut(new ArrayList());
            }
            config.setCounterHandleType(smartMotionHandleType);
            try {
                config.setRelRecordChan(data.getJSONArray("RelRecordChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                config.setRelRecordChan(new ArrayList());
            }
            try {
                config.setRelPreviewChan(data.getJSONArray("RelPreviewChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                config.setRelPreviewChan(new ArrayList());
            }
            try {
                config.setRelSnapChan(data.getJSONArray("RelSnapChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                config.setRelSnapChan(new ArrayList());
            }
            config.setPtz(ZKNvrUtils.buildJsonToPtz((JSONObject)data.getJSONObject("PTZ")));
        }
        behaviorRespond.setZknvrDetectionCommonConfig(config);
        return behaviorRespond;
    }

    public BehaviorRespond getPerimeterLine(ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond behaviorRespond = new BehaviorRespond();
        JSONObject jsonObject = this.igtAlarmConfig(Integer.valueOf(0), obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        ZKNvrDetectionCommonConfig config = new ZKNvrDetectionCommonConfig();
        if (Objects.nonNull(data)) {
            List alarmTimes;
            JSONArray audioConfigJsonArr;
            config.setSmartVersion(data.getInteger("SmartVersion"));
            config.setSupportNum(data.getInteger("SupportLineNum"));
            config.setSupportPointNum(data.getInteger("SupportPointNum"));
            config.setEnable(Boolean.valueOf(data.getInteger("EnableVirtuLine") == 1));
            config.setEnablePreviewDisplay(Boolean.valueOf(data.getInteger("EnablePreviewDisplay") == 1));
            JSONArray counterParaJsonArr = data.getJSONArray("VirtualLineParam");
            if (Objects.nonNull(counterParaJsonArr)) {
                ArrayList<ZKNvrCounterPara> counterPara = new ArrayList<ZKNvrCounterPara>();
                for (int i = 0; i < counterParaJsonArr.size(); ++i) {
                    ZKNvrCounterPara zkNvrCounterPara = new ZKNvrCounterPara();
                    JSONObject counterParaJson = (JSONObject)counterParaJsonArr.get(i);
                    zkNvrCounterPara.setDetType(counterParaJson.getInteger("DetType"));
                    zkNvrCounterPara.setObjType(counterParaJson.getInteger("ObjType"));
                    zkNvrCounterPara.setCounterPoint(counterParaJson.getJSONArray("CounterPoint").toJavaList(Integer[].class));
                    zkNvrCounterPara.setScale(counterParaJson.getInteger("Scale"));
                    zkNvrCounterPara.setIntervalTime(counterParaJson.getInteger("IntervalTime"));
                    zkNvrCounterPara.setPointNum(counterParaJson.getInteger("PointNum"));
                    counterPara.add(zkNvrCounterPara);
                }
                config.setCounterPara(counterPara);
            }
            if (Objects.nonNull(audioConfigJsonArr = data.getJSONArray("AudioConfig"))) {
                ArrayList<ZKNvrAudioConfig> audioConfigs = new ArrayList<ZKNvrAudioConfig>();
                for (int i = 0; i < audioConfigJsonArr.size(); ++i) {
                    JSONObject audioConfigJson = (JSONObject)audioConfigJsonArr.get(i);
                    ZKNvrAudioConfig audioConfig = new ZKNvrAudioConfig();
                    audioConfig.setAudioIdx(audioConfigJson.getInteger("AudioIdx"));
                    audioConfig.setAudioName(audioConfigJson.getString("AudioName"));
                    audioConfigs.add(audioConfig);
                }
                config.setAudioConfig(audioConfigs);
            }
            if (Objects.nonNull(alarmTimes = ZKNvrUtils.buildJsonToAlarmTime((JSONArray)data.getJSONArray("AlarmTime")))) {
                config.setAlarmTime(alarmTimes);
            }
            JSONObject motionDetHandleType = data.getJSONObject("VirtualLineHandleType");
            ZKNvrMotionHandleType smartMotionHandleType = new ZKNvrMotionHandleType();
            smartMotionHandleType.setHandleType(motionDetHandleType.getInteger("HandleType"));
            try {
                smartMotionHandleType.setRelAlarmOut(motionDetHandleType.getJSONArray("RelAlarmOut").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                smartMotionHandleType.setRelAlarmOut(new ArrayList());
            }
            config.setCounterHandleType(smartMotionHandleType);
            try {
                config.setRelRecordChan(data.getJSONArray("RelRecordChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                config.setRelRecordChan(new ArrayList());
            }
            try {
                config.setRelPreviewChan(data.getJSONArray("RelPreviewChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                config.setRelPreviewChan(new ArrayList());
            }
            try {
                config.setRelSnapChan(data.getJSONArray("RelSnapChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                config.setRelSnapChan(new ArrayList());
            }
            config.setPtz(ZKNvrUtils.buildJsonToPtz((JSONObject)data.getJSONObject("PTZ")));
        }
        behaviorRespond.setZknvrDetectionCommonConfig(config);
        return behaviorRespond;
    }

    public BehaviorRespond getItemLeave(ParamBean<BehaviorGetRequest> obj) {
        return this.getObjectDectPara(obj, Integer.valueOf(1));
    }

    public boolean setItemLeave(ParamBean<BehaviorSetRequest> obj) {
        return this.setObjectDectPara(obj);
    }

    public BehaviorRespond getItemMove(ParamBean<BehaviorGetRequest> obj) {
        return this.getObjectDectPara(obj, Integer.valueOf(0));
    }

    public boolean setItemMove(ParamBean<BehaviorSetRequest> obj) {
        return this.setObjectDectPara(obj);
    }

    public BehaviorRespond getAreaEnter(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public BehaviorRespond getAreaExit(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public BehaviorRespond getLoitering(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public BehaviorRespond getFastMovement(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public IgtAlarmConfigRespond getIgtAlarmConfig(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public boolean setPerimeterZone(ParamBean<BehaviorSetRequest> obj) {
        ZKNvrPtz ptz;
        List relSnapChan;
        List relPreviewChan;
        List relRecordChan;
        ZKNvrMotionHandleType counterHandleType;
        List alarmTime;
        Boolean lightEnable;
        Integer currentAudio;
        Boolean audioEnable;
        List audioConfig;
        List counterPara;
        Boolean enableTargetCount;
        Integer supportPointNum;
        ZKNvrDetectionCommonConfig config = ((BehaviorSetRequest)obj.getRequestBody()).getZknvrDetectionCommonConfig();
        JSONObject jsonObject = this.perimeterZone(Integer.valueOf(0), obj.getVcmInfo(), ((BehaviorSetRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        Integer supportLineNum = config.getSupportNum();
        if (Objects.nonNull(supportLineNum)) {
            data.put("SupportLineNum", (Object)supportLineNum);
        }
        if (Objects.nonNull(supportPointNum = config.getSupportPointNum())) {
            data.put("SupportPointNum", (Object)supportPointNum);
        }
        if (Objects.nonNull(enableTargetCount = config.getEnable())) {
            data.put("EnableRegiDect", (Object)(enableTargetCount != false ? 1 : 0));
        }
        if (Objects.nonNull(counterPara = config.getCounterPara())) {
            data.put("AreaDetParam", JSONArray.toJSON((Object)counterPara));
        }
        if (Objects.nonNull(audioConfig = config.getAudioConfig())) {
            data.put("AudioConfig", JSONArray.toJSON((Object)audioConfig));
        }
        if (Objects.nonNull(audioEnable = config.getAudioEnable())) {
            data.put("AudioEnable", (Object)(audioEnable != false ? 1 : 0));
        }
        if (Objects.nonNull(currentAudio = config.getCurrentAudio())) {
            data.put("CurrentAudio", (Object)currentAudio);
        }
        if (Objects.nonNull(lightEnable = config.getLightEnable())) {
            data.put("LightEnable", (Object)(lightEnable != false ? 1 : 0));
        }
        if (Objects.nonNull(alarmTime = config.getAlarmTime())) {
            data.put("AlarmTime", (Object)ZKNvrUtils.buildAlarmTimeToJson((List)alarmTime));
        }
        if (Objects.nonNull(counterHandleType = config.getCounterHandleType())) {
            data.put("AreaDetHandleType", (Object)ZKNvrUtils.buildMotionHandleTypeToJson((JSONObject)data.getJSONObject("AreaDetHandleType"), (ZKNvrMotionHandleType)counterHandleType));
        }
        if (Objects.nonNull(relRecordChan = config.getRelRecordChan())) {
            data.put("RelRecordChan", (Object)relRecordChan.toArray());
        }
        if (Objects.nonNull(relPreviewChan = config.getRelPreviewChan())) {
            data.put("RelPreviewChan", (Object)relPreviewChan.toArray());
        }
        if (Objects.nonNull(relSnapChan = config.getRelSnapChan())) {
            data.put("RelSnapChan", (Object)relSnapChan.toArray());
        }
        if (Objects.nonNull(ptz = config.getPtz())) {
            data.put("PTZ", (Object)ZKNvrUtils.buildPtzToJson((JSONObject)data.getJSONObject("PTZ"), (ZKNvrPtz)ptz));
        }
        this.perimeterZone(Integer.valueOf(1), obj.getVcmInfo(), ((BehaviorSetRequest)obj.getRequestBody()).getChannelCode(), data);
        return true;
    }

    public boolean setPerimeterLine(ParamBean<BehaviorSetRequest> obj) {
        ZKNvrPtz ptz;
        List relSnapChan;
        List relPreviewChan;
        List relRecordChan;
        ZKNvrMotionHandleType counterHandleType;
        List alarmTime;
        List audioConfig;
        List counterPara;
        Boolean enableTargetCount;
        Integer supportPointNum;
        ZKNvrDetectionCommonConfig config = ((BehaviorSetRequest)obj.getRequestBody()).getZknvrDetectionCommonConfig();
        JSONObject jsonObject = this.igtAlarmConfig(Integer.valueOf(0), obj.getVcmInfo(), ((BehaviorSetRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        Integer supportLineNum = config.getSupportNum();
        if (Objects.nonNull(supportLineNum)) {
            data.put("SupportRegionNum", (Object)supportLineNum);
        }
        if (Objects.nonNull(supportPointNum = config.getSupportPointNum())) {
            data.put("SupportPointNum", (Object)supportPointNum);
        }
        if (Objects.nonNull(enableTargetCount = config.getEnable())) {
            data.put("EnableVirtuLine", (Object)(enableTargetCount != false ? 1 : 0));
        }
        if (Objects.nonNull(counterPara = config.getCounterPara())) {
            data.put("VirtualLineParam", JSONArray.toJSON((Object)counterPara));
        }
        if (Objects.nonNull(audioConfig = config.getAudioConfig())) {
            data.put("AudioConfig", JSONArray.toJSON((Object)audioConfig));
        }
        if (Objects.nonNull(alarmTime = config.getAlarmTime())) {
            data.put("AlarmTime", (Object)ZKNvrUtils.buildAlarmTimeToJson((List)alarmTime));
        }
        if (Objects.nonNull(counterHandleType = config.getCounterHandleType())) {
            data.put("VirtualLineHandleType", (Object)ZKNvrUtils.buildMotionHandleTypeToJson((JSONObject)data.getJSONObject("VirtualLineHandleType"), (ZKNvrMotionHandleType)counterHandleType));
        }
        if (Objects.nonNull(relRecordChan = config.getRelRecordChan())) {
            data.put("RelRecordChan", (Object)relRecordChan.toArray());
        }
        if (Objects.nonNull(relPreviewChan = config.getRelPreviewChan())) {
            data.put("RelPreviewChan", (Object)relPreviewChan.toArray());
        }
        if (Objects.nonNull(relSnapChan = config.getRelSnapChan())) {
            data.put("RelSnapChan", (Object)relSnapChan.toArray());
        }
        if (Objects.nonNull(ptz = config.getPtz())) {
            data.put("PTZ", (Object)ZKNvrUtils.buildPtzToJson((JSONObject)data.getJSONObject("PTZ"), (ZKNvrPtz)ptz));
        }
        this.igtAlarmConfig(Integer.valueOf(1), obj.getVcmInfo(), ((BehaviorSetRequest)obj.getRequestBody()).getChannelCode(), data);
        return true;
    }

    public boolean setAreaEnter(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    public boolean setAreaExit(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    public boolean setLoitering(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    public boolean setFastMovement(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    public boolean setIgtAlarmConfig(ParamBean<IgtAlarmConfigSetRequest> obj) {
        return false;
    }

    public boolean setVehicleIllegal(ParamBean<VehicleParameterSetRequest> obj) {
        return false;
    }

    public BehaviorRespond getElectroMobile(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public boolean setElectroMobile(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    public boolean setVehicleDetect(ParamBean<VehicleParameterSetRequest> obj) {
        return false;
    }

    public boolean setVehicleParameter(ParamBean<VehicleParameterSetRequest> obj) {
        return false;
    }

    public VehicleParameterRespond getVehicleIllegal(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public VehicleParameterRespond getVehicleParameter(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public VehicleParameterRespond getVehicleDetect(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public ThirdAlgorithmRespond thirdAlgorithm(VcmReqBaseInfo vcmInfo) {
        return null;
    }

    public ThirdAlgorithmRespond thirdalgorithmParam(VcmReqBaseInfo vcmInfo, ThirdAlgorithm request) {
        return null;
    }

    public Boolean updateThirdalgorithmParam(VcmReqBaseInfo vcmInfo, ThirdAlgorithm request) {
        return null;
    }

    private boolean setObjectDectPara(ParamBean<BehaviorSetRequest> obj) {
        ZKNvrPtz ptz;
        List relSnapChan;
        List relPreviewChan;
        List relRecordChan;
        ZKNvrMotionHandleType counterHandleType;
        List alarmTime;
        Boolean lightEnable;
        Integer currentAudio;
        Boolean audioEnable;
        List audioConfig;
        List counterPara;
        Boolean enable;
        Integer supportPointNum;
        ZKNvrDetectionCommonConfig config = ((BehaviorSetRequest)obj.getRequestBody()).getZknvrDetectionCommonConfig();
        JSONObject jsonObject = this.frmObjectDectPara(Integer.valueOf(0), obj.getVcmInfo(), ((BehaviorSetRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        Integer supportLineNum = config.getSupportNum();
        if (Objects.nonNull(supportLineNum)) {
            data.put("SupportLineNum", (Object)supportLineNum);
        }
        if (Objects.nonNull(supportPointNum = config.getSupportPointNum())) {
            data.put("SupportPointNum", (Object)supportPointNum);
        }
        if (Objects.nonNull(enable = config.getEnable())) {
            data.put("EnableObjDect", (Object)(enable != false ? 1 : 0));
        }
        if (Objects.nonNull(counterPara = config.getCounterPara())) {
            data.put("GoodsDetParam", JSONArray.toJSON((Object)counterPara));
        }
        if (Objects.nonNull(audioConfig = config.getAudioConfig())) {
            data.put("AudioConfig", JSONArray.toJSON((Object)audioConfig));
        }
        if (Objects.nonNull(audioEnable = config.getAudioEnable())) {
            data.put("AudioEnable", (Object)(audioEnable != false ? 1 : 0));
        }
        if (Objects.nonNull(currentAudio = config.getCurrentAudio())) {
            data.put("CurrentAudio", (Object)currentAudio);
        }
        if (Objects.nonNull(lightEnable = config.getLightEnable())) {
            data.put("LightEnable", (Object)(lightEnable != false ? 1 : 0));
        }
        if (Objects.nonNull(alarmTime = config.getAlarmTime())) {
            data.put("AlarmTime", (Object)ZKNvrUtils.buildAlarmTimeToJson((List)alarmTime));
        }
        if (Objects.nonNull(counterHandleType = config.getCounterHandleType())) {
            data.put("GoodsDetHandleType", (Object)ZKNvrUtils.buildMotionHandleTypeToJson((JSONObject)data.getJSONObject("GoodsDetHandleType"), (ZKNvrMotionHandleType)counterHandleType));
        }
        if (Objects.nonNull(relRecordChan = config.getRelRecordChan())) {
            data.put("RelRecordChan", (Object)relRecordChan.toArray());
        }
        if (Objects.nonNull(relPreviewChan = config.getRelPreviewChan())) {
            data.put("RelPreviewChan", (Object)relPreviewChan.toArray());
        }
        if (Objects.nonNull(relSnapChan = config.getRelSnapChan())) {
            data.put("RelSnapChan", (Object)relSnapChan.toArray());
        }
        if (Objects.nonNull(ptz = config.getPtz())) {
            data.put("PTZ", (Object)ZKNvrUtils.buildPtzToJson((JSONObject)data.getJSONObject("PTZ"), (ZKNvrPtz)ptz));
        }
        this.frmObjectDectPara(Integer.valueOf(1), obj.getVcmInfo(), ((BehaviorSetRequest)obj.getRequestBody()).getChannelCode(), data);
        return true;
    }

    private BehaviorRespond getObjectDectPara(ParamBean<BehaviorGetRequest> obj, Integer detType) {
        BehaviorRespond behaviorRespond = new BehaviorRespond();
        JSONObject jsonObject = this.frmObjectDectPara(Integer.valueOf(0), obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        ZKNvrDetectionCommonConfig config = new ZKNvrDetectionCommonConfig();
        if (Objects.nonNull(data)) {
            List alarmTimes;
            JSONArray audioConfigJsonArr;
            config.setSmartVersion(data.getInteger("SmartVersion"));
            config.setSupportNum(data.getInteger("SupportRegionNum"));
            config.setSupportPointNum(data.getInteger("SupportPointNum"));
            config.setEnable(Boolean.valueOf(data.getInteger("EnableObjDect") == 1));
            config.setEnablePreviewDisplay(Boolean.valueOf(data.getInteger("EnablePreviewDisplay") == 1));
            JSONArray goodsDetParam = data.getJSONArray("GoodsDetParam");
            if (Objects.nonNull(goodsDetParam)) {
                ArrayList<ZKNvrCounterPara> counterPara = new ArrayList<ZKNvrCounterPara>();
                for (int i = 0; i < goodsDetParam.size(); ++i) {
                    ZKNvrCounterPara zkNvrCounterPara = new ZKNvrCounterPara();
                    JSONObject counterParaJson = (JSONObject)goodsDetParam.get(i);
                    zkNvrCounterPara.setDetType(counterParaJson.getInteger("DetType"));
                    zkNvrCounterPara.setCounterPoint(counterParaJson.getJSONArray("CounterPoint").toJavaList(Integer[].class));
                    zkNvrCounterPara.setScale(counterParaJson.getInteger("Scale"));
                    zkNvrCounterPara.setIntervalTime(counterParaJson.getInteger("IntervalTime"));
                    zkNvrCounterPara.setPointNum(counterParaJson.getInteger("PointNum"));
                    counterPara.add(zkNvrCounterPara);
                }
                config.setCounterPara(counterPara);
            }
            if (Objects.nonNull(audioConfigJsonArr = data.getJSONArray("AudioConfig"))) {
                ArrayList<ZKNvrAudioConfig> audioConfigs = new ArrayList<ZKNvrAudioConfig>();
                for (int i = 0; i < audioConfigJsonArr.size(); ++i) {
                    JSONObject audioConfigJson = (JSONObject)audioConfigJsonArr.get(i);
                    ZKNvrAudioConfig audioConfig = new ZKNvrAudioConfig();
                    audioConfig.setAudioIdx(audioConfigJson.getInteger("AudioIdx"));
                    audioConfig.setAudioName(audioConfigJson.getString("AudioName"));
                    audioConfigs.add(audioConfig);
                }
                config.setAudioConfig(audioConfigs);
            }
            if (Objects.nonNull(alarmTimes = ZKNvrUtils.buildJsonToAlarmTime((JSONArray)data.getJSONArray("AlarmTime")))) {
                config.setAlarmTime(alarmTimes);
            }
            JSONObject handleType = data.getJSONObject("GoodsDetHandleType");
            ZKNvrMotionHandleType smartMotionHandleType = new ZKNvrMotionHandleType();
            smartMotionHandleType.setHandleType(handleType.getInteger("HandleType"));
            try {
                smartMotionHandleType.setRelAlarmOut(handleType.getJSONArray("RelAlarmOut").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                smartMotionHandleType.setRelAlarmOut(new ArrayList());
            }
            config.setCounterHandleType(smartMotionHandleType);
            try {
                config.setRelRecordChan(data.getJSONArray("RelRecordChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                config.setRelRecordChan(new ArrayList());
            }
            try {
                config.setRelPreviewChan(data.getJSONArray("RelPreviewChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                config.setRelPreviewChan(new ArrayList());
            }
            try {
                config.setRelSnapChan(data.getJSONArray("RelSnapChan").toJavaList(Integer.class));
            }
            catch (ClassCastException e) {
                config.setRelSnapChan(new ArrayList());
            }
            config.setPtz(ZKNvrUtils.buildJsonToPtz((JSONObject)data.getJSONObject("PTZ")));
        }
        behaviorRespond.setZknvrDetectionCommonConfig(config);
        return behaviorRespond;
    }

    private JSONObject perimeterZone(Integer type, VcmReqBaseInfo vcmInfo, String channel, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)Integer.valueOf(channel.substring(2)));
        reqJson.put("IsLocal", (Object)1);
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_REGION_DECT_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr motionConfig error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject frmObjectDectPara(Integer type, VcmReqBaseInfo vcmInfo, String channel, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)Integer.valueOf(channel.substring(2)));
        reqJson.put("IsLocal", (Object)1);
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.frm_Object_Dect_Para, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr motionConfig error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject igtAlarmConfig(Integer type, VcmReqBaseInfo vcmInfo, String channel, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)Integer.valueOf(channel.substring(2)));
        reqJson.put("IsLocal", (Object)1);
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_VIRTUAL_LINE_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr motionConfig error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

