/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrConstants;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmDealRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmSearch.AlarmSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.websocket.SubscriptionRequest;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmCodeTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.AbstractZKNvrService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.EventZkGetThread;
import com.zkteco.zkbiosecurity.cuserver.utils.DateUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.EventNameHelper;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlarmZKNvrServiceImpl
extends AbstractZKNvrService
implements AlarmService<IServerType.ZKNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmZKNvrServiceImpl.class);
    @Autowired
    private SubscriptionHelp subscriptionHelp;

    public boolean subscribe(ParamBean<SubscriptionRequest> obj) {
        if (this.subscriptionHelp.get(((SubscriptionRequest)obj.getRequestBody()).getDomainCode()) == null) {
            this.subscriptionHelp.add(((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), obj.getVcmInfo(), null);
            EventZkGetThread eventZkGetThread = new EventZkGetThread(((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), obj.getVcmInfo().getVcmIp());
            eventZkGetThread.start();
            SubscriptionHelp.updateZkThread((String)((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), (EventZkGetThread)eventZkGetThread);
        } else {
            this.subscriptionHelp.add(((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), obj.getVcmInfo(), null);
        }
        return true;
    }

    public boolean delSubscribe(ParamBean<SubscriptionRequest> obj) {
        this.subscriptionHelp.remove(((SubscriptionRequest)obj.getRequestBody()).getDomainCode());
        SubscriptionHelp.removeZkThread((String)((SubscriptionRequest)obj.getRequestBody()).getDomainCode());
        return true;
    }

    public boolean confirm(ParamBean<AlarmDealRequest> obj) {
        return false;
    }

    public boolean cancel(ParamBean<AlarmDealRequest> obj) {
        return false;
    }

    public PageRespond<AlarmSearchRespond> search(ParamBean<AlarmSearchRequest> obj) {
        JSONObject reqJson = this.buildAlarmRqeBody((AlarmSearchRequest)obj.getRequestBody());
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)ZKNvrMsgType.FRM_LOG_CTRL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(obj.getVcmInfo()));
            return this.buildAlarmResult(rsp, Integer.valueOf(((AlarmSearchRequest)obj.getRequestBody()).getPageSize()));
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr alarm search error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private PageRespond<AlarmSearchRespond> buildAlarmResult(JSONObject rsp, Integer pageSize) {
        PageRespond result = new PageRespond();
        if (null == rsp) {
            throw new InvokeException("500", "cu_device_not_return");
        }
        Integer resultCode = rsp.getInteger("Result");
        if ("0".equals(String.valueOf(resultCode))) {
            JSONObject data = rsp.getJSONObject("Data");
            Integer logItemCount = data.getInteger("LogItemCount");
            if (logItemCount > 0) {
                ArrayList<AlarmSearchRespond> alarmSearchResponds = new ArrayList<AlarmSearchRespond>();
                JSONObject logResults = data.getJSONObject("LogResults");
                JSONArray items = logResults.getJSONArray("Items");
                for (int i = 0; i < items.size(); ++i) {
                    JSONObject item = items.getJSONObject(i);
                    AlarmSearchRespond alarmSearchRespond = new AlarmSearchRespond();
                    Integer minorType = item.getInteger("MinorType");
                    if (minorType != null) {
                        if (ZKNvrConstants.ZK_NVR_LOG_ABNORMAL_LIST.contains(minorType)) {
                            alarmSearchRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_OPERATIONS.toString());
                            alarmSearchRespond.setAlarmLevel((AlarmLevelEnum)ZKNvrConstants.ZK_NVR_ALARM_LEVEL_MAP.get(item.getInteger("MajorType")));
                        } else {
                            alarmSearchRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_GENERAL_BUSINESS.toString());
                            if (item.getInteger("ChannelOrPort") != -1) {
                                alarmSearchRespond.setChannelCode("CH" + String.valueOf(item.getInteger("ChannelOrPort") + 1));
                            }
                            alarmSearchRespond.setAlarmLevel((AlarmLevelEnum)ZKNvrConstants.ZK_NVR_ALARM_LEVEL_MAP.get(item.getInteger("MajorType")));
                        }
                        String minorTypeName = (String)ZKNvrConstants.ZK_NVR_LOG_CODE_MAP.get(minorType);
                        if (StringUtils.isBlank((CharSequence)minorTypeName)) {
                            minorTypeName = (String)ZKNvrConstants.OLD_ZK_NVR_LOG_CODE_MAP.get(minorType);
                        }
                        alarmSearchRespond.setName(EventNameHelper.getEventName((String)minorTypeName));
                        alarmSearchRespond.setCode(minorTypeName);
                    }
                    alarmSearchRespond.setTime(item.getString("LogDateTime"));
                    alarmSearchResponds.add(alarmSearchRespond);
                }
                result.setData(alarmSearchResponds);
            }
            result.setTotal(logItemCount.intValue());
            result.setPage(data.getInteger("TotalPages").intValue());
            result.setPageSize(pageSize.intValue());
        }
        return result;
    }

    private JSONObject buildAlarmRqeBody(AlarmSearchRequest requestBody) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        JSONObject data = new JSONObject();
        Integer SubType = 0;
        for (Integer code : ZKNvrConstants.ZK_NVR_LOG_CODE_MAP.keySet()) {
            if (!((String)requestBody.getAlarmTypeList().get(0)).equals(ZKNvrConstants.ZK_NVR_LOG_CODE_MAP.get(code))) continue;
            SubType = code;
            break;
        }
        data.put("SubType", (Object)SubType);
        ArrayList<Integer> subTypeArr = new ArrayList<Integer>();
        subTypeArr.add(SubType);
        for (Integer code : ZKNvrConstants.OLD_ZK_NVR_LOG_CODE_MAP.keySet()) {
            if (!((String)requestBody.getAlarmTypeList().get(0)).equals(ZKNvrConstants.OLD_ZK_NVR_LOG_CODE_MAP.get(code))) continue;
            subTypeArr.add(code);
            data.put("SubTypeArr", (Object)subTypeArr.toArray());
            data.put("SubType", (Object)code);
            break;
        }
        if (ZKNvrConstants.ZK_NVR_LOG_ABNORMAL_LIST.contains(SubType)) {
            data.put("MajorType", (Object)2);
        } else if (ZKNvrConstants.ZK_NVR_LOG_ALARM_LIST.contains(SubType)) {
            data.put("MajorType", (Object)1);
        } else {
            data.put("MajorType", (Object)0);
        }
        data.put("StartTime", (Object)((DateUtil.stringToDate((String)requestBody.getStartTime(), (String)"yyyyMMddHHmmss").getTime() + (long)TimeZone.getDefault().getRawOffset()) / 1000L));
        data.put("EndTime", (Object)((DateUtil.stringToDate((String)requestBody.getEndTime(), (String)"yyyyMMddHHmmss").getTime() + (long)TimeZone.getDefault().getRawOffset()) / 1000L));
        data.put("Step", (Object)0);
        data.put("CurrentPage", (Object)requestBody.getPage());
        data.put("PageNum", (Object)requestBody.getPageSize());
        jsonObject.put("Data", (Object)data);
        return jsonObject;
    }

    public boolean register(VcmReqBaseInfo vcmReqBaseInfo, String url) {
        return false;
    }

    public String getRegisterUrlList(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

