/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKIpcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RecordConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.VideoItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordStatusRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoBookMarkRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.RecordTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VideoService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc.AbstractZKIpcService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="videoZKIpcService")
public class VideoZKIpcServiceImpl
extends AbstractZKIpcService
implements VideoService<IServerType.ZKIPC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoZKIpcServiceImpl.class);
    private static final String TIME_STYLE = "%s-%s-%s %s:%s:%s";

    public VideoRespond videoList(VcmReqBaseInfo vcmInfo, VideoListRequest req) {
        VideoRespond videoRespond = new VideoRespond();
        JSONObject jsonObject = this.buildVideoReq(req);
        try {
            JSONArray searchResults;
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_VIDEO_RECORDS_QUERY, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            if (null == rsp) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            Integer resultCode = rsp.getInteger("Result");
            if ("-1".equals(String.valueOf(resultCode))) {
                return videoRespond;
            }
            if ("0".equals(String.valueOf(resultCode)) && (searchResults = rsp.getJSONObject("Data").getJSONArray("SearchResults")).size() > 0) {
                videoRespond = this.buildVideoList(searchResults);
            }
        }
        catch (SDKException e) {
            LOGGER.error("zk ipc videoList error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
        return videoRespond;
    }

    public Boolean videoStart(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        return null;
    }

    public Boolean videoStop(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        return null;
    }

    public List<VideoBookMarkRespond> getVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkSearchRequest req) {
        return null;
    }

    public String createVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return null;
    }

    public boolean uptVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return false;
    }

    public boolean delVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return false;
    }

    public VideoLockInfoListRespond getVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoListRequest req) {
        return null;
    }

    public VideoLockInfoRespond createVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public VideoLockInfoRespond delVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public VideoLockInfoRespond uptVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public List<RecordStatusRespond> getRecordStatus(ParamBean<ChannelListRequest> obj) {
        return null;
    }

    public RecordConfigRespond getConfig(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public boolean setConfig(ParamBean<RecordConfigRequest> obj) {
        return false;
    }

    private VideoRespond buildVideoList(JSONArray searchResults) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        VideoRespond videoRespond = new VideoRespond();
        ArrayList<VideoItem> videoItemList = new ArrayList<VideoItem>();
        JSONObject searchResult = searchResults.getJSONObject(0);
        JSONArray records = searchResult.getJSONArray("Records");
        for (int i = 0; i < records.size(); ++i) {
            JSONArray record = (JSONArray)records.get(i);
            VideoItem videoItem = new VideoItem();
            videoItem.setType(RecordTypeEnum.PLAN);
            videoItem.setStartTime(sdf.format(new Date(Long.parseLong(record.getString(1)) * 1000L - 28800000L)));
            videoItem.setEndTime(sdf.format(new Date(Long.parseLong(record.getString(2)) * 1000L - 28800000L)));
            videoItemList.add(videoItem);
        }
        videoRespond.setVideoItemList(videoItemList);
        return videoRespond;
    }

    private JSONObject buildVideoReq(VideoListRequest req) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        jsonObject.put("Ch", (Object)1);
        jsonObject.put("Dev", (Object)1);
        JSONObject data = new JSONObject();
        int[] channels = new int[]{1};
        data.put("Channels", (Object)channels);
        data.put("DeviceLocalDateTimeStart", (Object)VideoZKIpcServiceImpl.getFormatDate((String)req.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss", (String)"yyyyMMddHHmmss"));
        data.put("DeviceLocalDateTimeStop", (Object)VideoZKIpcServiceImpl.getFormatDate((String)req.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss", (String)"yyyyMMddHHmmss"));
        jsonObject.put("Data", (Object)data);
        return jsonObject;
    }

    public static String getFormatDate(String date, String oldPattern, String newPattern) {
        try {
            SimpleDateFormat sdf1 = new SimpleDateFormat(oldPattern);
            SimpleDateFormat sdf2 = new SimpleDateFormat(newPattern);
            Date date1Date = sdf1.parse(date);
            return sdf2.format(date1Date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

