/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKIpcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SnapshotService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc.AbstractZKIpcService;
import com.zkteco.zkbiosecurity.cuserver.utils.FileUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="snapshotZKIpcService")
public class SnapshotZKIpcServiceImpl
extends AbstractZKIpcService
implements SnapshotService<IServerType.ZKIPC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotZKIpcServiceImpl.class);

    public SnapshotRespond createSnapshot(VcmReqBaseInfo vcmReqBaseInfo, SnapshotRequest req) {
        SnapshotRespond snapshotRespond = new SnapshotRespond();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Ch", (Object)1);
        CloseableHttpResponse result = null;
        try {
            result = (CloseableHttpResponse)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKIpcMsgType.CAPTURE_V2, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CloseableHttpResponse.class), (List)this.getHeaders(vcmReqBaseInfo));
        }
        catch (SDKException e) {
            throw new InvokeException("500", e.getMessage());
        }
        String content = "";
        try (InputStream inputStream = result.getEntity().getContent();){
            content = FileUtil.getContentFromInputStream((InputStream)inputStream, (CloseableHttpResponse)result);
        }
        catch (IOException e) {
            LOGGER.error("stream failed", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        if (content.length() > 0) {
            content = content.replaceAll("[\\s*\t\n\r]", "");
            snapshotRespond.setImgBase64Str(content);
        }
        return snapshotRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

