/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKIpcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPPlayBackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPRealPlayRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVideoDownloadRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVoiceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPPlayBackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPRealPlayRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVideoDownloadRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVoiceRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.RTSPService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc.AbstractZKIpcService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.ZKNvrUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="rtspZKIpcService")
public class RTSPZKIpcServiceImpl
extends AbstractZKIpcService
implements RTSPService<IServerType.ZKIPC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTSPZKIpcServiceImpl.class);
    private static final String RTSP_STR_SUB = "rtsp://%s:%s@%s:%s/%s.%s?ptype=udp";
    private static final String RTSP_STR_RECORDING = "rtsp://%s:%s@%s:%s/recording%s?ch=%s&stream=%s&start=%s&stop=%s";

    public RTSPRealPlayRespond realPlay(VcmReqBaseInfo vcmInfo, RTSPRealPlayRequest request) {
        String videoEncodeType;
        JSONObject rtspUrl;
        RTSPRealPlayRespond rtspRealPlayRespond = new RTSPRealPlayRespond();
        ArrayList<JSONObject> rtspUrls = new ArrayList<JSONObject>();
        String exRtspPort = ZKNvrUtils.getConfig((String)(vcmInfo.getVcmIp() + "_" + vcmInfo.getVcmPort()));
        if (StringUtils.isBlank((CharSequence)exRtspPort)) {
            exRtspPort = this.getExRtspPort(vcmInfo);
            ZKNvrUtils.setConfig((String)(vcmInfo.getVcmIp() + "_" + vcmInfo.getVcmPort()), (String)exRtspPort);
        }
        if (request.getType() == 0 || request.getType() == 1) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                videoEncodeType = this.getVideoEncodeType(vcmInfo, request.getType());
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "living_comb1", videoEncodeType));
                rtspUrl.put("type", (Object)1);
                rtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "ch1", 264));
                rtspUrl.put("type", (Object)1);
                rtspUrls.add(rtspUrl);
            }
        }
        if (request.getType() == 0 || request.getType() == 2) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                videoEncodeType = this.getVideoEncodeType(vcmInfo, request.getType());
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "living_comb1_sub", videoEncodeType));
                rtspUrl.put("type", (Object)2);
                rtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "ch1_sub", 264));
                rtspUrl.put("type", (Object)2);
                rtspUrls.add(rtspUrl);
            }
        }
        rtspRealPlayRespond.setRtspUrls(rtspUrls);
        return rtspRealPlayRespond;
    }

    private String getVideoEncodeType(VcmReqBaseInfo vcmInfo, int streamType) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        jsonObject.put("Ch", (Object)1);
        jsonObject.put("Dev", (Object)1);
        int abilityType = 0;
        JSONObject data = new JSONObject();
        if (streamType == 2) {
            abilityType = 1;
        }
        data.put("AbilityType", (Object)abilityType);
        jsonObject.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_VIDEO_IPC_SET_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp.getJSONObject("Data").getInteger("VideoEncType") == 0 ? "264" : "265";
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr frmVideoCompressPara error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private String getExRtspPort(VcmReqBaseInfo vcmInfo) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)0);
        reqJson.put("Ch", (Object)1);
        reqJson.put("Dev", (Object)1);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_NETWORK_SETTINGS, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp.getJSONObject("Data").getString("RtspPort");
        }
        catch (SDKException e) {
            LOGGER.error("zk ipc getExRtspPort error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    public RTSPPlayBackRespond playBack(VcmReqBaseInfo vcmInfo, RTSPPlayBackRequest request) {
        JSONObject rtspUrl;
        RTSPPlayBackRespond rtspPlayBackRespond = new RTSPPlayBackRespond();
        ArrayList<JSONObject> playBackRtspUrls = new ArrayList<JSONObject>();
        String startDate = request.getStartDate().replace("-", "").replace(":", "").replace(" ", "");
        String endDate = request.getEndDate().replace("-", "").replace(":", "").replace(" ", "");
        String exRtspPort = this.getExRtspPort(vcmInfo);
        request.setClientType("0");
        if (request.getType() == 0 || request.getType() == 1) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "_comb", 1, 0, startDate, endDate + "&rec_inquiry_type=2147483647"));
                rtspUrl.put("type", (Object)1);
                playBackRtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "", 1, 0, startDate, endDate));
                rtspUrl.put("type", (Object)1);
                playBackRtspUrls.add(rtspUrl);
            }
        }
        if (request.getType() == 0 || request.getType() == 2) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "_comb", 1, 1, startDate, endDate + "&rec_inquiry_type=2147483647"));
                rtspUrl.put("type", (Object)2);
                playBackRtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), exRtspPort, "", 1, 1, startDate, endDate));
                rtspUrl.put("type", (Object)2);
                playBackRtspUrls.add(rtspUrl);
            }
        }
        rtspPlayBackRespond.setRtspUrls(playBackRtspUrls);
        return rtspPlayBackRespond;
    }

    public RTSPVoiceRespond voice(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVoiceRespond broadcast(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVideoDownloadRespond videoDownload(VcmReqBaseInfo vcmInfo, RTSPVideoDownloadRequest request) {
        return null;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

