/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKIpcMsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrConstants;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraAddRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRebootRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRemoveRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraValidRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.MasterDeviceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.PasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAndChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.MasterDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.ChannelStatusEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.DeviceManageNvr800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc.AbstractZKIpcService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc.DeviceManageZKIpcServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="deviceManageZKIpcService")
public class DeviceManageZKIpcServiceImpl
extends AbstractZKIpcService
implements DeviceManageService<IServerType.ZKIPC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageZKIpcServiceImpl.class);
    @Autowired
    private WebSocketService webSocketService;
    public static final Predicate<InetAddress> FILTER_IPV4 = addr -> addr instanceof Inet4Address;
    public static final Predicate<InetAddress> FILTER_NOT_LINK_LOCAL = addr -> !addr.isLinkLocalAddress();
    private static byte[][] invalidMacs = new byte[][]{{0, 5, 105}, {0, 28, 20}, {0, 12, 41}, {0, 80, 86}, {8, 0, 39}, {10, 0, 39}, {0, 3, -1}, {0, 21, 93}};

    public CameraAndChannelRespond listCamerasAndChannels(VcmReqBaseInfo vcmInfo) {
        CameraAndChannelRespond cameraAndChannelRespond = new CameraAndChannelRespond();
        cameraAndChannelRespond.setIp(vcmInfo.getVcmIp());
        cameraAndChannelRespond.setType(vcmInfo.getVcmType());
        List cameraResponds = this.listCamera(vcmInfo);
        List channelResponds = this.listChannel(vcmInfo);
        cameraResponds.stream().forEach(cameraRespond -> cameraRespond.setChannelResponds(channelResponds.stream().collect(Collectors.groupingBy(ChannelRespond::getParentCode)).get(cameraRespond.getCameraCode())));
        cameraAndChannelRespond.setCameras(cameraResponds);
        return cameraAndChannelRespond;
    }

    public List<CameraRespond> listCamera(VcmReqBaseInfo vcmReqBaseInfo) {
        List<Object> cameraResponds = new ArrayList<CameraRespond>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        JSONObject channel = this.getChannelList(vcmReqBaseInfo, jsonObject);
        if (Objects.nonNull(channel)) {
            cameraResponds = this.buildCamera(channel, vcmReqBaseInfo);
        }
        return cameraResponds;
    }

    private JSONObject getChannelList(VcmReqBaseInfo vcmReqBaseInfo, JSONObject reqJson) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKIpcMsgType.FRM_DEVICE_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            return rsp.getJSONObject("Data");
        }
        catch (SDKException e) {
            LOGGER.error("zkIpc getChannelList error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private String getLocalChannelName(VcmReqBaseInfo vcmReqBaseInfo, int channelNo, int type) {
        try {
            JSONObject req = new JSONObject();
            req.put("Type", (Object)type);
            req.put("Ch", (Object)channelNo);
            req.put("Data", (Object)new JSONObject());
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.FRM_DEVICE_CHANNEL_NAME, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)req, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            if (Objects.nonNull(rsp) && Objects.nonNull(rsp.getJSONObject("Data"))) {
                return rsp.getJSONObject("Data").getJSONObject("DeviceChannel").getString("DeviceChanName");
            }
            return "";
        }
        catch (SDKException e) {
            LOGGER.error("zkIpc getLocalChannelName error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private List<CameraRespond> buildCamera(JSONObject channel, VcmReqBaseInfo vcmReqBaseInfo) {
        ArrayList<CameraRespond> cameraResponds = new ArrayList<CameraRespond>();
        if (Objects.nonNull(channel)) {
            CameraRespond cameraRespond = new CameraRespond();
            cameraRespond.setStatus(ChannelStatusEnum.ONLINE);
            cameraRespond.setCameraCode("CH1");
            String chanName = channel.getString("DVRName");
            if (StringUtils.isNotBlank((CharSequence)chanName)) {
                cameraRespond.setCameraName(chanName);
            } else {
                cameraRespond.setCameraName("CH1");
            }
            cameraRespond.setProtocolType("ZKTeco");
            cameraRespond.setVendor("ZKTeco");
            cameraRespond.setSerialNumber(channel.getString("SerialNumber"));
            cameraRespond.setModel(channel.getString("HardwareVersion"));
            cameraRespond.setIp(vcmReqBaseInfo.getVcmIp());
            cameraRespond.setPort(Integer.valueOf(vcmReqBaseInfo.getVcmPort()).intValue());
            cameraRespond.setUserName(vcmReqBaseInfo.getSdcUserName());
            cameraRespond.setCameraType("IPC");
            cameraResponds.add(cameraRespond);
        }
        return cameraResponds;
    }

    public List<ChannelRespond> listChannel(VcmReqBaseInfo vcmReqBaseInfo) {
        List<Object> channelRespond = new ArrayList<ChannelRespond>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        JSONObject channelList = this.getChannelList(vcmReqBaseInfo, jsonObject);
        if (Objects.nonNull(channelList)) {
            channelRespond = this.buildChannel(channelList, vcmReqBaseInfo);
        }
        return channelRespond;
    }

    private List<ChannelRespond> buildChannel(JSONObject data, VcmReqBaseInfo vcmReqBaseInfo) {
        ArrayList<ChannelRespond> channelResponds = new ArrayList<ChannelRespond>();
        if (Objects.nonNull(data)) {
            ChannelRespond channelRespond = new ChannelRespond();
            channelRespond.setCategory(DeviceTypeEnum.ZKIPC.val());
            channelRespond.setChannelCode("1");
            String chanName = data.getString("DVRName");
            if (StringUtils.isNotBlank((CharSequence)chanName)) {
                channelRespond.setCameraName(chanName);
            } else {
                channelRespond.setCameraName("CH1");
            }
            channelRespond.setChannel(1);
            channelRespond.setChannelCode("CH1");
            channelRespond.setParentCode(vcmReqBaseInfo.getDomainCode());
            channelRespond.setType(2);
            channelRespond.setCameraType("FIX");
            channelRespond.setStatus(ChannelStatusEnum.ONLINE);
            channelRespond.setProtocolType((String)ZKNvrConstants.PROTOCOL_TYPE_MAP_CODE.get("25"));
            channelRespond.setUserName(vcmReqBaseInfo.getSdcUserName());
            channelRespond.setVendor("ZKTECO");
            channelRespond.setIp(vcmReqBaseInfo.getVcmIp());
            channelRespond.setPort(Integer.valueOf(vcmReqBaseInfo.getVcmPort()).intValue());
            channelResponds.add(channelRespond);
        }
        return channelResponds;
    }

    public ChannelRespond getChannel(ParamBean<ChannelRequest> obj) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        JSONObject data = new JSONObject();
        data.put("IsOnlyOne", (Object)1);
        data.put("ChIdx", (Object)Integer.valueOf(((ChannelRequest)obj.getRequestBody()).getChannelCode().substring(2)));
        jsonObject.put("Data", (Object)data);
        JSONObject channelList = this.getChannelList(obj.getVcmInfo(), jsonObject);
        if (Objects.nonNull(channelList)) {
            return (ChannelRespond)this.buildChannel(channelList.getJSONObject("Data"), obj.getVcmInfo()).get(0);
        }
        return null;
    }

    public List<String> getEmptyChannel(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean updateChannel(ParamBean<ChannelUpdateRequest> obj) {
        JSONObject requestJson = new JSONObject();
        requestJson.put("Type", (Object)1);
        requestJson.put("Dev", (Object)1);
        requestJson.put("Ch", (Object)1);
        JSONObject data = new JSONObject();
        data.put("DVRName", (Object)((ChannelUpdateRequest)obj.getRequestBody()).getName());
        requestJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)ZKIpcMsgType.FRM_DEVICE_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("zkipc updateChannel error ip: " + obj.getVcmInfo().getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
        return true;
    }

    private JSONObject operationOSD(VcmReqBaseInfo vcmInfo, JSONObject json) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_SINGLE_LINE_OSD, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)json, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkIpc operationOSD error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    public List<ChannelRespond> listChannelsByCamera(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode) {
        List channelResponds = this.listChannel(vcmReqBaseInfo);
        ArrayList<ChannelRespond> resultList = new ArrayList<ChannelRespond>();
        channelResponds.forEach(channelRespond -> {
            if (cameraCode.equals(channelRespond.getParentCode())) {
                resultList.add((ChannelRespond)channelRespond);
            }
        });
        return resultList;
    }

    public CameraAddRespond addCamera(ParamBean<CameraAddRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject jsonObject = this.buildAddCameraReq(vcmInfo, (CameraAddRequest)obj.getRequestBody());
        boolean isAddSucceed = this.setCameraInfo(obj.getVcmInfo(), jsonObject);
        CameraAddRespond cameraAddRespond = new CameraAddRespond();
        if (isAddSucceed) {
            cameraAddRespond.setCameraCode("CH" + jsonObject.getJSONObject("Data").getJSONObject("NetChannelList").getString("ChIdx"));
        }
        return cameraAddRespond;
    }

    private JSONObject buildAddCameraReq(VcmReqBaseInfo vcmInfo, CameraAddRequest requestBody) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)1);
        JSONObject data = new JSONObject();
        JSONObject netChannelList = new JSONObject();
        netChannelList.put("ChIdx", (Object)this.getCameraIndex(vcmInfo));
        netChannelList.put("Domain", (Object)requestBody.getIp());
        netChannelList.put("DomainAux", (Object)"");
        netChannelList.put("UserName", (Object)requestBody.getDeviceUser());
        netChannelList.put("Password", (Object)requestBody.getDevicePassword());
        netChannelList.put("ProtocolType", ZKNvrConstants.PROTOCOL_TYPE_MAP_NAME.get(requestBody.getProtocol()));
        netChannelList.put("VideoPort", (Object)Integer.valueOf(requestBody.getPort()));
        netChannelList.put("LinkProtocol", (Object)0);
        netChannelList.put("Mac", (Object)"");
        netChannelList.put("PhyIdx", (Object)(this.getFrmNetWorkCap(vcmInfo) - 1));
        netChannelList.put("IP", (Object)requestBody.getIp());
        netChannelList.put("Enable", (Object)1);
        netChannelList.put("Description", (Object)"");
        data.put("NetChannelList", (Object)netChannelList);
        jsonObject.put("Data", (Object)data);
        return jsonObject;
    }

    private Integer getFrmNetWorkCap(VcmReqBaseInfo vcmInfo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_NET_WORK_CAP, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONObject data = rsp.getJSONObject("Data");
            return data.getJSONArray("NetInterfaceCap").size();
        }
        catch (SDKException e) {
            LOGGER.error("zkIpc getFrmNetWorkCap error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private Integer getCameraIndex(VcmReqBaseInfo vcmInfo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        Integer cameraIndex = 1;
        JSONObject channelList = this.getChannelList(vcmInfo, jsonObject);
        JSONObject data = channelList.getJSONObject("Data");
        JSONArray netChannelList = data.getJSONArray("NetChannelList");
        Integer maxChNum = data.getInteger("MaxChNum");
        if (Objects.nonNull(netChannelList) && netChannelList.size() > 0) {
            if (netChannelList.size() < maxChNum) {
                JSONObject firstChannel = netChannelList.getJSONObject(0);
                Integer firstChIdx = firstChannel.getInteger("ChIdx");
                if (firstChIdx == 1) {
                    for (int i = 0; i < netChannelList.size(); ++i) {
                        JSONObject netChannel = netChannelList.getJSONObject(i);
                        Integer chIdx = netChannel.getInteger("ChIdx");
                        if (i + 1 == netChannelList.size()) {
                            cameraIndex = chIdx + 1;
                            continue;
                        }
                        JSONObject nextNetChannel = netChannelList.getJSONObject(i + 1);
                        Integer nextChIdx = nextNetChannel.getInteger("ChIdx");
                        if (nextChIdx - chIdx <= 1) continue;
                        cameraIndex = chIdx + 1;
                        break;
                    }
                }
            } else {
                throw new InvokeException("500", "maximum number of connections exceeded");
            }
        }
        return cameraIndex;
    }

    public boolean removeCamera(ParamBean<CameraRemoveRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject jsonObject = this.buildRemoveCameraReq((CameraRemoveRequest)obj.getRequestBody());
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_SET_DEV_CHN_INFO, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("zkIpc removeCamera error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject buildRemoveCameraReq(CameraRemoveRequest cameraRemoveRequest) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)1);
        JSONObject data = new JSONObject();
        JSONObject netChannelList = new JSONObject();
        netChannelList.put("ChIdx", (Object)Integer.valueOf(cameraRemoveRequest.getCameraCode().substring(2)));
        netChannelList.put("Domain", (Object)"");
        netChannelList.put("DomainAux", (Object)"");
        netChannelList.put("UserName", (Object)"");
        netChannelList.put("Password", (Object)"");
        netChannelList.put("ProtocolType", (Object)"");
        netChannelList.put("VideoPort", (Object)"");
        netChannelList.put("LinkProtocol", (Object)"");
        netChannelList.put("Mac", (Object)"");
        netChannelList.put("PhyIdx", (Object)"");
        netChannelList.put("IP", (Object)"");
        netChannelList.put("Enable", (Object)"");
        netChannelList.put("Description", (Object)"");
        data.put("NetChannelList", (Object)netChannelList);
        jsonObject.put("data", (Object)data);
        return jsonObject;
    }

    public boolean updatePassword(ParamBean<PasswordUpdateRequest> obj) {
        PasswordUpdateRequest requestBody = (PasswordUpdateRequest)obj.getRequestBody();
        if (Objects.nonNull(requestBody)) {
            return this.updateCameraInfo(obj.getVcmInfo(), requestBody.getCameraCode(), requestBody.getNewPassword());
        }
        return false;
    }

    private boolean updateCameraInfo(VcmReqBaseInfo vcmInfo, String cameraCode, String newPassword) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        JSONObject channelList = this.getChannelList(vcmInfo, jsonObject);
        if (Objects.nonNull(channelList)) {
            cameraCode = cameraCode.substring(2);
            JSONObject data = channelList.getJSONObject("Data");
            JSONArray netChannelList = data.getJSONArray("NetChannelList");
            if (Objects.nonNull(netChannelList) && netChannelList.size() > 0) {
                for (int i = 0; i < netChannelList.size(); ++i) {
                    JSONObject netChannel = netChannelList.getJSONObject(i);
                    if (!cameraCode.equals(netChannel.getString("ChIdx"))) continue;
                    netChannel.put("Password", (Object)newPassword);
                    jsonObject.put("Type", (Object)1);
                    JSONObject newChannel = new JSONObject();
                    newChannel.put("NetChannelList", (Object)netChannel);
                    jsonObject.put("Data", (Object)newChannel);
                    return this.setCameraInfo(vcmInfo, jsonObject);
                }
            }
        }
        return false;
    }

    public boolean updateOfflinePassword(ParamBean<CameraAddRequest> obj) {
        CameraAddRequest requestBody = (CameraAddRequest)obj.getRequestBody();
        if (Objects.nonNull(requestBody)) {
            return this.updateCameraInfo(obj.getVcmInfo(), requestBody.getChannelCode(), requestBody.getDevicePassword());
        }
        return false;
    }

    private boolean setCameraInfo(VcmReqBaseInfo vcmInfo, JSONObject jsonObject) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_SET_DEV_CHN_INFO, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("zkIpc setCameraInfo error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    public boolean rebootCamera(ParamBean<CameraRebootRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        jsonObject.put("Dev", (Object)1);
        jsonObject.put("Ch", (Object)1);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_DEVICE_REBOOT, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("zkIpc rebootCamera error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    public List<CameraSearchRespond> searchCamera(VcmReqBaseInfo vcmReqBaseInfo, CameraSearchRequest request) {
        CompletableFuture.runAsync(() -> {
            JSONArray searchResult = new JSONArray();
            try {
                this.requestFrmDoSearch(vcmReqBaseInfo, Integer.valueOf(0));
                Thread.sleep(8000L);
                JSONObject jsonObject = this.requestFrmDoSearch(vcmReqBaseInfo, Integer.valueOf(1));
                this.checkJsonRespond(jsonObject);
                JSONObject data = jsonObject.getJSONObject("Data");
                Integer ipc_num = data.getInteger("ipc_num");
                if (0 < ipc_num) {
                    searchResult.addAll((Collection)data.getJSONArray("SearchList"));
                }
                this.requestFrmDoSearch(vcmReqBaseInfo, Integer.valueOf(2));
            }
            catch (InterruptedException e) {
                LOGGER.error("search error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            }
            catch (SDKException ee) {
                LOGGER.error("search error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)ee);
            }
            DeviceEventRespond deviceEventRespond = new DeviceEventRespond();
            deviceEventRespond.setType(EventTypeEnum.OPERATE_RESULT);
            deviceEventRespond.setDomainCode(request.getDomainCode());
            deviceEventRespond.setPercent("100");
            deviceEventRespond.setSubtype("searchCamera");
            if (searchResult.size() > 0) {
                deviceEventRespond.getData().getCameras().addAll(this.buildCameraSearchRespondList(searchResult, request.getProtocolType(), request.getIpList()));
            }
            LOGGER.info("ZK NVR search camera data:{}", (Object)deviceEventRespond.toJSON());
            this.webSocketService.send((BaseEventRespond)deviceEventRespond);
        });
        return new ArrayList<CameraSearchRespond>();
    }

    public Boolean stopSearch(VcmReqBaseInfo vcmInfo, CameraValidRequest request) {
        try {
            this.requestFrmDoSearch(vcmInfo, Integer.valueOf(2));
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("zkIpc stopSearch error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private List<CameraSearchRespond> buildCameraSearchRespondList(JSONArray searchResult, String protocolType, List<CameraSearchRequest.IpInfo> ipList) {
        ArrayList<CameraSearchRespond> cameraSearchResponds = new ArrayList<CameraSearchRespond>();
        for (int i = 0; i < searchResult.size(); ++i) {
            JSONObject cameraObject = searchResult.getJSONObject(i);
            String zkIpcProtocolType = cameraObject.getString("ProtocolType");
            String videoPort = cameraObject.getString("VideoPort");
            if (!zkIpcProtocolType.equals(protocolType)) continue;
            CameraSearchRespond searchRespond = new CameraSearchRespond();
            searchRespond.setCameraType(cameraObject.getString("CameraType"));
            searchRespond.setIp(cameraObject.getString("Domain"));
            searchRespond.setProtocol((String)ZKNvrConstants.PROTOCOL_TYPE_MAP_CODE.get(Integer.parseInt(zkIpcProtocolType)));
            searchRespond.setWebPort(videoPort);
            searchRespond.setChannelNumber(cameraObject.getIntValue(""));
            searchRespond.setSerialNumber(cameraObject.getString("Description"));
            searchRespond.setSubnetMask(cameraObject.getString("NetMask"));
            searchRespond.setVendor(cameraObject.getString("Vendor"));
            searchRespond.setPort(videoPort);
            searchRespond.setDeviceType((String)ZKNvrConstants.ZK_NVR_DEVICE_TYPE.get(cameraObject.getInteger("DeviceType")));
            searchRespond.setGateway(cameraObject.getString("Gateway"));
            cameraSearchResponds.add(searchRespond);
        }
        return cameraSearchResponds;
    }

    JSONObject requestFrmDoSearch(VcmReqBaseInfo vcmReqBaseInfo, Integer type) throws SDKException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)type);
        JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)ZKNvrMsgType.FRM_DO_SEARCH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo));
        this.checkJsonRespond(rsp);
        return rsp;
    }

    private JSONArray getAllChannel(VcmReqBaseInfo vcmInfo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKNvrMsgType.FRM_GET_DEV_CHN_INFO, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            Integer maxChNum = rsp.getJSONObject("Data").getInteger("MaxChNum");
            JSONArray channelArr = new JSONArray();
            for (int i = 0; i < maxChNum; ++i) {
                channelArr.add((Object)0);
            }
            return channelArr;
        }
        catch (SDKException e) {
            LOGGER.error("zkIpc getAllChannel error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMulticast(InetAddress group, int port, byte[] message, Integer ttl, NetworkInterface nic) throws IOException {
        UnmodifiableIterator nifAddresses = Iterators.filter((Iterator)Iterators.forEnumeration(nic.getInetAddresses()), (Predicate)Predicates.and((Predicate)FILTER_IPV4, (Predicate)FILTER_NOT_LINK_LOCAL));
        if (!nifAddresses.hasNext()) {
            return;
        }
        InetSocketAddress inetAddr = new InetSocketAddress((InetAddress)nifAddresses.next(), 20000);
        try (DatagramSocket ds = null;){
            ds = new DatagramSocket(inetAddr);
            ds.setBroadcast(true);
            ds.send(new DatagramPacket(message, message.length, group, port));
        }
    }

    public static byte[] hexStr2ByteArray(String hexString) {
        if (StringUtils.isEmpty((CharSequence)hexString)) {
            throw new IllegalArgumentException("this hexString must not be empty");
        }
        hexString = hexString.toLowerCase();
        byte[] byteArray = new byte[hexString.length() / 2];
        int k = 0;
        for (int i = 0; i < byteArray.length; ++i) {
            byte high = (byte)(Character.digit(hexString.charAt(k), 16) & 0xFF);
            byte low = (byte)(Character.digit(hexString.charAt(k + 1), 16) & 0xFF);
            byteArray[i] = (byte)(high << 4 | low);
            k += 2;
        }
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MasterDeviceRespond> searchMasterDevice(MasterDeviceSearchRequest request) {
        ArrayList<MasterDeviceRespond> respondList = new ArrayList<MasterDeviceRespond>();
        ArrayList<String> ipList = new ArrayList<String>();
        DatagramSocket ds = null;
        try {
            try {
                String str = "000001ca390000003c4d4553534147452056455253494f4e3d2231223e0a093c48454144455220545950453d223431313722202f3e0a3c2f4d4553534147453e0a";
                InetAddress group = InetAddress.getByName("255.255.255.255");
                for (NetworkInterface nic : DeviceManageZKIpcServiceImpl.getNICs((Predicate[])new Predicate[]{Filter.UP, Filter.PHYICAL_ONLY})) {
                    DeviceManageZKIpcServiceImpl.sendMulticast((InetAddress)group, (int)10000, (byte[])DeviceManageZKIpcServiceImpl.hexStr2ByteArray((String)str), (Integer)20, (NetworkInterface)nic);
                }
                byte[] buffer = new byte[0x100000];
                DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
                ds = new DatagramSocket(20000);
                ds.setSoTimeout(10000);
                ds.setBroadcast(true);
                while (true) {
                    ds.receive(dp);
                    String ip = dp.getAddress().getHostAddress();
                    if (ipList.contains(ip)) continue;
                    int port = dp.getPort();
                    String text = new String(dp.getData(), 0, dp.getLength());
                    if (!StringUtils.isNotBlank((CharSequence)text)) continue;
                    text = text.substring(text.indexOf("<"), text.length() - 2);
                    text = text.replaceAll("\\s+", " ");
                    text = text.substring(text.indexOf("<MESSAGE"), text.length());
                    respondList.add(this.buildUDPTextToBean(ip, Integer.valueOf(port), text));
                    ipList.add(ip);
                }
            }
            catch (Exception e) {
                LOGGER.error("ZKNVR search master device error", (Throwable)e);
                if (Objects.nonNull(ds)) {
                    ds.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (Objects.nonNull(ds)) {
                ds.close();
            }
            throw throwable;
        }
        return respondList;
    }

    private MasterDeviceRespond buildUDPTextToBean(String ip, Integer port, String text) throws DocumentException {
        MasterDeviceRespond masterDeviceRespond = new MasterDeviceRespond();
        masterDeviceRespond.setIp(ip);
        masterDeviceRespond.setWebPort("8081");
        Document document = DocumentHelper.parseText((String)text);
        Element message = document.getRootElement();
        List messageChild = message.elements();
        if (messageChild.size() == 3) {
            List parametersChild;
            Element parameters = (Element)messageChild.get(2);
            if (Objects.nonNull(parameters) && (parametersChild = parameters.elements()).size() == 16) {
                List eth0Child;
                masterDeviceRespond.setVersion(((Element)parametersChild.get(14)).getStringValue());
                Element eth0 = (Element)parametersChild.get(10);
                if (Objects.nonNull(eth0) && (eth0Child = eth0.elements()).size() == 6) {
                    masterDeviceRespond.setMacAddress(((Element)eth0Child.get(0)).getStringValue());
                }
            }
            masterDeviceRespond.setType(String.valueOf(DeviceTypeEnum.ZKNVR.val()));
        }
        return masterDeviceRespond;
    }

    @SafeVarargs
    public static Set<NetworkInterface> getNICs(Predicate<NetworkInterface> ... filters) {
        if (null == filters) {
            filters = new Predicate[]{DeviceManageNvr800ServiceImpl.Filter.ALL};
        }
        try {
            UnmodifiableIterator filtered = Iterators.filter((Iterator)Iterators.forEnumeration(NetworkInterface.getNetworkInterfaces()), (Predicate)Predicates.and(filters));
            return ImmutableSet.copyOf((Iterator)filtered);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isVMMac(byte[] mac) {
        if (null == mac) {
            return false;
        }
        for (byte[] invalid : invalidMacs) {
            if (invalid[0] != mac[0] || invalid[1] != mac[1] || invalid[2] != mac[2]) continue;
            return true;
        }
        return false;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    static /* synthetic */ boolean access$000(byte[] x0) {
        return DeviceManageZKIpcServiceImpl.isVMMac((byte[])x0);
    }
}

