/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKIpcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.ColorConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.DateTimeRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.OsdConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.ColorConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.DateTimeRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.OsdConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceInfoConfigService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc.AbstractZKIpcService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="deviceInfoConfigZKIpcService")
public class DeviceInfoConfigZKIpcServiceImpl
extends AbstractZKIpcService
implements DeviceInfoConfigService<IServerType.ZKIPC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceInfoConfigZKIpcServiceImpl.class);

    public DateTimeRespond getTimeConfig(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean setTimeConfig(ParamBean<DateTimeRequest> obj) {
        return false;
    }

    public OsdConfigRespond getOsdConfig(ParamBean<OsdConfigRequest> obj) {
        return null;
    }

    public boolean setOsdConfig(ParamBean<OsdConfigRequest> obj) {
        return false;
    }

    public ColorConfigRespond getColorConfig(ParamBean<ColorConfigRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        jsonObject.put("Ch", (Object)1);
        jsonObject.put("Dev", (Object)1);
        JSONObject rsp = this.getVideoParaex(vcmInfo, jsonObject);
        return this.buildColorConfigRep(rsp.getJSONObject("Data"));
    }

    private ColorConfigRespond buildColorConfigRep(JSONObject data) {
        ColorConfigRespond colorConfigRespond = new ColorConfigRespond();
        colorConfigRespond.setBright(data.getInteger("Brightness").intValue());
        colorConfigRespond.setContrast(data.getInteger("Contrast").intValue());
        colorConfigRespond.setHue(data.getInteger("Hue").intValue());
        colorConfigRespond.setSaturation(data.getInteger("Saturation").intValue());
        ColorConfigRespond.ColorRange colorRange = new ColorConfigRespond.ColorRange();
        colorRange.setHueMin(0);
        colorRange.setHueMax(255);
        colorRange.setContrastMin(0);
        colorRange.setContrastMax(255);
        colorRange.setBrightMin(0);
        colorRange.setBrightMax(255);
        colorRange.setSaturationMin(0);
        colorRange.setSaturationMax(255);
        colorRange.setSharpnessMin(0);
        colorRange.setSharpnessMax(0);
        colorConfigRespond.setRange(colorRange);
        return colorConfigRespond;
    }

    public boolean setColorConfig(ParamBean<ColorConfigRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)1);
        jsonObject.put("Ch", (Object)1);
        jsonObject.put("Data", (Object)this.buildColorConfigReq(((ColorConfigRequest)obj.getRequestBody()).getColorConfig()));
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_VIDEO_PARAEX, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("zkipc setColorConfig error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject buildColorConfigReq(ColorConfigRespond colorConfigRespond) {
        JSONObject data = new JSONObject();
        data.put("Brightness", (Object)colorConfigRespond.getBright());
        data.put("Contrast", (Object)colorConfigRespond.getContrast());
        data.put("Saturation", (Object)colorConfigRespond.getSaturation());
        data.put("Hue", (Object)colorConfigRespond.getHue());
        return data;
    }

    private JSONObject getVideoParaex(VcmReqBaseInfo vcmInfo, JSONObject jsonObject) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_VIDEO_PARAEX, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkipc getVideoEffect error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

