/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKIpcMsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKNvrConstants;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.StreamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.respond.cu.device.CameraV2Respond;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceConfigManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc.AbstractZKIpcService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="deviceConfigManageZKIpcService")
public class DeviceConfigManageZKIpcServiceImpl
extends AbstractZKIpcService
implements DeviceConfigManageService<IServerType.ZKIPC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceConfigManageZKIpcServiceImpl.class);

    public CameraV2Respond getBaseConfig(ParamBean<CameraRequest> obj) {
        return this.getBaseConfig(obj.getVcmInfo());
    }

    private CameraV2Respond buildBaseConfigData(JSONObject data, VcmReqBaseInfo vcmInfo) {
        CameraV2Respond cameraV2Respond = new CameraV2Respond();
        cameraV2Respond.setCameraCode("CH1");
        cameraV2Respond.setCameraName(data.getString("DVRName"));
        cameraV2Respond.setDomainCode(vcmInfo.getDomainCode());
        cameraV2Respond.setIp(vcmInfo.getVcmIp());
        cameraV2Respond.setPort(vcmInfo.getVcmPort());
        cameraV2Respond.setModel(data.getString("HardwareVersion"));
        cameraV2Respond.setVendor("ZKTECO");
        cameraV2Respond.setProtocolType("ZKTECO");
        cameraV2Respond.setCategory(Integer.valueOf(DeviceTypeEnum.ZKIPC.val()));
        cameraV2Respond.setCameraType("2");
        return cameraV2Respond;
    }

    public JSONObject getTimeConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public CameraV2Respond getCameraBaseConfig(ParamBean<CameraRequest> obj) {
        return this.getBaseConfig(obj.getVcmInfo());
    }

    private CameraV2Respond getBaseConfig(VcmReqBaseInfo vcmInfo) {
        CameraV2Respond cameraV2Respond = new CameraV2Respond();
        try {
            JSONObject reqJson = new JSONObject();
            reqJson.put("Type", (Object)0);
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_DEVICE_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            cameraV2Respond = this.buildBaseConfigData(rsp.getJSONObject("Data"), vcmInfo);
        }
        catch (SDKException e) {
            LOGGER.error("zkipc getBaseConfig error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
        return cameraV2Respond;
    }

    public JSONObject getCameraStreamConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public JSONObject getCameraOSDConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public JSONObject getCameraAudioConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public JSONObject getCameraAlarmInConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public Boolean setCameraAlarmInConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public JSONObject getCameraAlarmOutConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public Boolean setCameraAlarmOutConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public StreamBean getMainStreamConfig(ParamBean<ChannelRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject jsonObject = this.buildGetStreamConfigReq(Boolean.valueOf(true));
        JSONObject rsp = this.frmVideoCompressPara(vcmInfo, jsonObject);
        JSONObject frmVideoCompressAbility = this.getFrmVideoCompressAbility(vcmInfo, jsonObject);
        StreamBean streamBean = this.buildStreamRep(frmVideoCompressAbility, rsp.getJSONObject("Data"));
        streamBean.setChannelCode(((ChannelRequest)obj.getRequestBody()).getChannelCode());
        return streamBean;
    }

    public boolean setMainStreamConfig(ParamBean<StreamBean> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject jsonObject = this.buildSetStreamConfigReq(obj, Boolean.valueOf(true));
        this.frmVideoCompressPara(vcmInfo, jsonObject);
        return true;
    }

    public StreamBean getSubStreamConfig(ParamBean<ChannelRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject jsonObject = this.buildGetStreamConfigReq(Boolean.valueOf(false));
        JSONObject rsp = this.frmVideoCompressPara(vcmInfo, jsonObject);
        JSONObject frmVideoCompressAbility = this.getFrmVideoCompressAbility(vcmInfo, jsonObject);
        StreamBean streamBean = this.buildStreamRep(frmVideoCompressAbility, rsp.getJSONObject("Data"));
        streamBean.setChannelCode(((ChannelRequest)obj.getRequestBody()).getChannelCode());
        return streamBean;
    }

    public boolean setSubStreamConfig(ParamBean<StreamBean> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        JSONObject jsonObject = this.buildSetStreamConfigReq(obj, Boolean.valueOf(false));
        this.frmVideoCompressPara(vcmInfo, jsonObject);
        return true;
    }

    private JSONObject buildSetStreamConfigReq(ParamBean<StreamBean> obj, Boolean isMainStream) {
        JSONObject jsonObject = new JSONObject();
        StreamBean requestBody = (StreamBean)obj.getRequestBody();
        jsonObject.put("Type", (Object)1);
        jsonObject.put("Ch", (Object)1);
        int abilityType = 0;
        JSONObject data = new JSONObject();
        if (!isMainStream.booleanValue()) {
            abilityType = 1;
        }
        data.put("AbilityType", (Object)abilityType);
        JSONObject getJSON = this.buildGetStreamConfigReq(isMainStream);
        JSONObject frmVideoCompressAbility = this.getFrmVideoCompressAbility(obj.getVcmInfo(), getJSON);
        JSONObject requestData = this.frmVideoCompressPara(obj.getVcmInfo(), getJSON).getJSONObject("Data");
        requestData.put("VideoEncType", (Object)this.getVideoEncType(frmVideoCompressAbility, requestBody.getVideoEncodeType()));
        requestData.put("PicQuality", (Object)this.getVideoQualityCode(requestBody.getVideoQuality()));
        requestData.put("BitrateType", (Object)(requestBody.getBitrateControl().equals("CBR") ? 0 : 1));
        requestData.put("VideoFrameRate", (Object)requestBody.getFps());
        requestData.put("VideoBitrate", (Object)this.getVideoBitrate(frmVideoCompressAbility, Integer.valueOf(requestBody.getBitrate())));
        requestData.put("IFrameInterval", (Object)requestBody.getIFrameInterval());
        requestData.put("Resolution", (Object)this.getResolutionCode(frmVideoCompressAbility, requestBody.getResolution()));
        jsonObject.put("Data", (Object)requestData);
        return jsonObject;
    }

    private Integer getResolutionCode(JSONObject frmVideoCompressAbility, String resolution) {
        JSONArray resolutionArr = frmVideoCompressAbility.getJSONArray("Resolution");
        if (Objects.nonNull(resolutionArr)) {
            for (int i = 0; i < resolutionArr.size(); ++i) {
                JSONArray jsonArray = resolutionArr.getJSONArray(i);
                if (!resolution.equals(jsonArray.getString(0))) continue;
                return jsonArray.getInteger(1);
            }
        }
        return null;
    }

    private Integer getVideoBitrate(JSONObject frmVideoCompressAbility, Integer bitrate) {
        JSONArray bitrateArr = frmVideoCompressAbility.getJSONArray("Bitrate");
        if (Objects.nonNull(bitrateArr)) {
            for (int i = 0; i < bitrateArr.size(); ++i) {
                JSONArray jsonArray = bitrateArr.getJSONArray(i);
                Integer bitrateCode = jsonArray.getInteger(1);
                if (bitrateCode == 0) continue;
                String bitrateStr = jsonArray.getString(0);
                if (bitrateStr.contains("Mbps")) {
                    bitrateStr = bitrateStr.replace("Mbps", "");
                } else if (bitrateStr.contains("Kbps")) {
                    bitrateStr = bitrateStr.replace("Kbps", "");
                } else if (bitrateStr.contains("kbps")) {
                    bitrateStr = bitrateStr.replace("kbps", "");
                }
                if (!bitrate.equals(Integer.valueOf(bitrateStr.trim()))) continue;
                return jsonArray.getInteger(1);
            }
        }
        return null;
    }

    private Integer getVideoQualityCode(String videoQuality) {
        if ("Lower".equalsIgnoreCase(videoQuality) || "Lowest".equalsIgnoreCase(videoQuality)) {
            return 5;
        }
        if ("Medium".equalsIgnoreCase(videoQuality)) {
            return 3;
        }
        if ("Highest".equalsIgnoreCase(videoQuality) || "Higher".equalsIgnoreCase(videoQuality)) {
            return 1;
        }
        return null;
    }

    private Integer getVideoEncType(JSONObject frmVideoCompressAbility, String videoEncType) {
        JSONArray videoEncTypeArr = frmVideoCompressAbility.getJSONArray("VideoEncType");
        if (Objects.nonNull(videoEncTypeArr)) {
            for (int i = 0; i < videoEncTypeArr.size(); ++i) {
                JSONArray jsonArray = videoEncTypeArr.getJSONArray(i);
                if (!videoEncType.equals(jsonArray.getString(0))) continue;
                return jsonArray.getInteger(1);
            }
        } else {
            for (Integer key : ZKNvrConstants.ZK_NVR_ONVIF_VIDEO_ENC_TYPE.keySet()) {
                if (!videoEncType.equals(ZKNvrConstants.ZK_NVR_ONVIF_VIDEO_ENC_TYPE.get(key))) continue;
                return key;
            }
        }
        return null;
    }

    private String getVideoEncodeType(StreamBean.StreamRange streamRange, JSONObject frmVideoCompressAbility, Integer videoEncType) {
        String videoEncodeType = null;
        ArrayList<String> videoEncodeTypeRange = new ArrayList<String>();
        JSONArray videoEncTypeArr = frmVideoCompressAbility.getJSONArray("VideoEncType");
        if (Objects.nonNull(videoEncTypeArr)) {
            for (int i = 0; i < videoEncTypeArr.size(); ++i) {
                JSONArray jsonArray = videoEncTypeArr.getJSONArray(i);
                videoEncodeTypeRange.add(jsonArray.getString(0));
                if (!videoEncType.equals(jsonArray.getInteger(1))) continue;
                videoEncodeType = jsonArray.getString(0);
            }
        } else {
            videoEncodeTypeRange.add((String)ZKNvrConstants.ZK_NVR_ONVIF_VIDEO_ENC_TYPE.get(videoEncType));
            videoEncodeType = (String)ZKNvrConstants.ZK_NVR_ONVIF_VIDEO_ENC_TYPE.get(videoEncType);
        }
        streamRange.setVideoEncodeTypeRange(videoEncodeTypeRange);
        return videoEncodeType;
    }

    private String getVideoQuality(Integer picQuality) {
        if (1 == picQuality || 2 == picQuality) {
            return "Highest";
        }
        if (3 == picQuality) {
            return "Medium";
        }
        if (5 == picQuality || 4 == picQuality) {
            return "Lower";
        }
        return null;
    }

    private Integer getFps(StreamBean.StreamRange streamRange, JSONObject frmVideoCompressAbility, Integer videoFrameRate) {
        Integer fps = 0;
        ArrayList<Integer> fpsRange = new ArrayList<Integer>();
        JSONArray frameRateArr = frmVideoCompressAbility.getJSONArray("FrameRate");
        if (Objects.nonNull(frameRateArr)) {
            for (int i = 0; i < frameRateArr.size(); ++i) {
                JSONArray jsonArray = frameRateArr.getJSONArray(i);
                Integer frameRate = jsonArray.getInteger(1);
                fpsRange.add(frameRate);
                if (!videoFrameRate.equals(frameRate)) continue;
                fps = frameRate;
            }
        }
        streamRange.setFpsRange(fpsRange);
        return fps;
    }

    private Integer getBitrate(StreamBean.StreamRange streamRange, JSONObject frmVideoCompressAbility, Integer videoFrameRate) {
        Integer bitrate = 0;
        ArrayList<Integer> bitRateRange = new ArrayList<Integer>();
        JSONArray BitrateArr = frmVideoCompressAbility.getJSONArray("Bitrate");
        if (Objects.nonNull(BitrateArr)) {
            for (int i = 0; i < BitrateArr.size(); ++i) {
                JSONArray jsonArray = BitrateArr.getJSONArray(i);
                if (0 == jsonArray.getInteger(1)) continue;
                String videoFrameRateStr = jsonArray.getString(0);
                if (videoFrameRateStr.contains("Mbps")) {
                    videoFrameRateStr = videoFrameRateStr.replace("Mbps", "");
                } else if (videoFrameRateStr.contains("Kbps")) {
                    videoFrameRateStr = videoFrameRateStr.replace("Kbps", "");
                } else if (videoFrameRateStr.contains("kbps")) {
                    videoFrameRateStr = videoFrameRateStr.replace("kbps", "");
                }
                Integer frameRate = Integer.valueOf(videoFrameRateStr.trim());
                if (videoFrameRate.equals(jsonArray.getInteger(1))) {
                    bitrate = frameRate;
                }
                bitRateRange.add(frameRate);
            }
        }
        streamRange.setBitRateRange(bitRateRange);
        return bitrate;
    }

    private String getResolution(StreamBean.StreamRange streamRange, JSONObject frmVideoCompressAbility, Integer resolution) {
        ArrayList<String> resolutionRange = new ArrayList<String>();
        String resolutionStr = null;
        JSONArray resolutionArr = frmVideoCompressAbility.getJSONArray("Resolution");
        if (Objects.nonNull(resolutionArr)) {
            for (int i = 0; i < resolutionArr.size(); ++i) {
                JSONArray jsonArray = resolutionArr.getJSONArray(i);
                resolutionRange.add(jsonArray.getString(0));
                if (!resolution.equals(jsonArray.getInteger(1))) continue;
                resolutionStr = jsonArray.getString(0);
            }
        }
        streamRange.setResolutionRange(resolutionRange);
        return resolutionStr;
    }

    private StreamBean buildStreamRep(JSONObject frmVideoCompressAbility, JSONObject data) {
        StreamBean streamBean = new StreamBean();
        StreamBean.StreamRange streamRange = new StreamBean.StreamRange();
        streamBean.setVideoEncodeType(this.getVideoEncodeType(streamRange, frmVideoCompressAbility, data.getInteger("VideoEncType")));
        streamBean.setVideoQuality(this.getVideoQuality(data.getInteger("PicQuality")));
        streamBean.setBitrateControl(data.getInteger("BitrateType") == 0 ? "VBR" : "CBR");
        streamBean.setFps(this.getFps(streamRange, frmVideoCompressAbility, data.getInteger("VideoFrameRate")).intValue());
        Integer bitrate = this.getBitrate(streamRange, frmVideoCompressAbility, data.getInteger("VideoBitrate"));
        streamBean.setBitrate(bitrate.intValue());
        streamBean.setCustomBitrate(bitrate.intValue());
        streamBean.setMaxFrameRae(((Integer)Collections.max(streamRange.getBitRateRange())).intValue());
        streamBean.setIFrameInterval(data.getInteger("IFrameInterval").intValue());
        streamBean.setResolution(this.getResolution(streamRange, frmVideoCompressAbility, data.getInteger("Resolution")));
        streamBean.setBitrateMode("0");
        streamBean.setAudio(false);
        streamBean.setRange(streamRange);
        return streamBean;
    }

    private JSONObject getFrmVideoCompressAbility(VcmReqBaseInfo vcmInfo, JSONObject jsonObject) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_VIDEO_COMPRESS_ABILITY, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp.getJSONObject("Data");
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr getFrmVideoCompressAbility error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    JSONObject frmVideoCompressPara(VcmReqBaseInfo vcmInfo, JSONObject jsonObject) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_VIDEO_IPC_SET_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zkNvr frmVideoCompressPara error ip: " + vcmInfo.getVcmIp(), (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject buildGetStreamConfigReq(Boolean isMainStream) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Type", (Object)0);
        jsonObject.put("Ch", (Object)1);
        int abilityType = 0;
        JSONObject data = new JSONObject();
        if (!isMainStream.booleanValue()) {
            abilityType = 1;
        }
        data.put("AbilityType", (Object)abilityType);
        jsonObject.put("Data", (Object)data);
        return jsonObject;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

