/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.ZKIpcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorGetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.IgtAlarmConfigSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.VehicleParameterSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.ThirdAlgorithm;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.ThirdAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.VehicleParameterRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.IgtAlarmConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrCounterPara;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrDetectionCommonConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZKNvrMotionHandleType;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.BehaviorAnalysisService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zkipc.AbstractZKIpcService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.ZKNvrUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="behaviorAnalysisZKIpcService")
public class BehaviorAnalysisZKIpcServiceImpl
extends AbstractZKIpcService
implements BehaviorAnalysisService<IServerType.ZKIPC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BehaviorAnalysisZKIpcServiceImpl.class);

    public BehaviorRespond getPerimeterZone(ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond behaviorRespond = new BehaviorRespond();
        JSONObject jsonObject = this.perimeterZone(Integer.valueOf(0), obj.getVcmInfo(), new JSONObject());
        JSONObject requestBody = new JSONObject();
        requestBody.put("DetectLinkType", (Object)3);
        JSONObject frmDetectLinkPara = this.frmDetectLinkPara(Integer.valueOf(0), obj.getVcmInfo(), requestBody);
        JSONObject data = jsonObject.getJSONObject("Data");
        ZKNvrDetectionCommonConfig config = new ZKNvrDetectionCommonConfig();
        if (Objects.nonNull(data)) {
            JSONObject frmDetectLinkParaData;
            List alarmTimes;
            config.setSupportNum(data.getInteger("SupportRegionNum"));
            config.setSupportPointNum(data.getInteger("SupportPointNum"));
            config.setEnable(Boolean.valueOf(data.getInteger("EnableRegiDect") == 1));
            JSONArray counterParaJsonArr = data.getJSONArray("AreaDetParam");
            if (Objects.nonNull(counterParaJsonArr)) {
                ArrayList<ZKNvrCounterPara> counterPara = new ArrayList<ZKNvrCounterPara>();
                for (int i = 0; i < counterParaJsonArr.size(); ++i) {
                    ZKNvrCounterPara zkNvrCounterPara = new ZKNvrCounterPara();
                    JSONObject counterParaJson = (JSONObject)counterParaJsonArr.get(i);
                    zkNvrCounterPara.setDetType(counterParaJson.getInteger("DetType"));
                    zkNvrCounterPara.setObjType(counterParaJson.getInteger("ObjectType"));
                    zkNvrCounterPara.setCounterPoint(counterParaJson.getJSONArray("CounterPoint").toJavaList(Integer[].class));
                    zkNvrCounterPara.setScale(counterParaJson.getInteger("Scale"));
                    zkNvrCounterPara.setIntervalTime(counterParaJson.getInteger("IntervalTime"));
                    counterPara.add(zkNvrCounterPara);
                }
                config.setCounterPara(counterPara);
            }
            if (Objects.nonNull(alarmTimes = ZKNvrUtils.buildJsonToAlarmTime((JSONArray)(frmDetectLinkParaData = frmDetectLinkPara.getJSONObject("Data")).getJSONArray("AlarmTime")))) {
                config.setAlarmTime(alarmTimes);
            }
            ZKNvrMotionHandleType smartMotionHandleType = new ZKNvrMotionHandleType();
            smartMotionHandleType.setHandleType(frmDetectLinkParaData.getInteger("HandleType"));
            config.setCounterHandleType(smartMotionHandleType);
        }
        behaviorRespond.setZknvrDetectionCommonConfig(config);
        return behaviorRespond;
    }

    public BehaviorRespond getPerimeterLine(ParamBean<BehaviorGetRequest> obj) {
        BehaviorRespond behaviorRespond = new BehaviorRespond();
        JSONObject jsonObject = this.igtAlarmConfig(Integer.valueOf(0), obj.getVcmInfo(), new JSONObject());
        JSONObject requestBody = new JSONObject();
        requestBody.put("DetectLinkType", (Object)2);
        JSONObject frmDetectLinkPara = this.frmDetectLinkPara(Integer.valueOf(0), obj.getVcmInfo(), requestBody);
        JSONObject data = jsonObject.getJSONObject("Data");
        ZKNvrDetectionCommonConfig config = new ZKNvrDetectionCommonConfig();
        if (Objects.nonNull(data)) {
            JSONObject frmDetectLinkParaData;
            List alarmTimes;
            config.setSupportNum(data.getInteger("SupportLineNum"));
            config.setSupportPointNum(data.getInteger("SupportPointNum"));
            config.setEnable(Boolean.valueOf(data.getInteger("EnableVirtuLine") == 1));
            JSONArray counterParaJsonArr = data.getJSONArray("VirtualLineParam");
            if (Objects.nonNull(counterParaJsonArr)) {
                ArrayList<ZKNvrCounterPara> counterPara = new ArrayList<ZKNvrCounterPara>();
                for (int i = 0; i < counterParaJsonArr.size(); ++i) {
                    ZKNvrCounterPara zkNvrCounterPara = new ZKNvrCounterPara();
                    JSONObject counterParaJson = (JSONObject)counterParaJsonArr.get(i);
                    zkNvrCounterPara.setDetType(counterParaJson.getInteger("DetType"));
                    zkNvrCounterPara.setObjType(counterParaJson.getInteger("ObjectType"));
                    zkNvrCounterPara.setCounterPoint(counterParaJson.getJSONArray("CounterPoint").toJavaList(Integer[].class));
                    zkNvrCounterPara.setScale(counterParaJson.getInteger("Scale"));
                    counterPara.add(zkNvrCounterPara);
                }
                config.setCounterPara(counterPara);
            }
            if (Objects.nonNull(alarmTimes = ZKNvrUtils.buildJsonToAlarmTime((JSONArray)(frmDetectLinkParaData = frmDetectLinkPara.getJSONObject("Data")).getJSONArray("AlarmTime")))) {
                config.setAlarmTime(alarmTimes);
            }
            ZKNvrMotionHandleType smartMotionHandleType = new ZKNvrMotionHandleType();
            smartMotionHandleType.setHandleType(frmDetectLinkParaData.getInteger("HandleType"));
            config.setCounterHandleType(smartMotionHandleType);
        }
        behaviorRespond.setZknvrDetectionCommonConfig(config);
        return behaviorRespond;
    }

    public BehaviorRespond getItemLeave(ParamBean<BehaviorGetRequest> obj) {
        return this.getObjectDectPara(obj, Integer.valueOf(1));
    }

    public boolean setItemLeave(ParamBean<BehaviorSetRequest> obj) {
        return this.setObjectDectPara(obj);
    }

    public BehaviorRespond getItemMove(ParamBean<BehaviorGetRequest> obj) {
        return this.getObjectDectPara(obj, Integer.valueOf(0));
    }

    public boolean setItemMove(ParamBean<BehaviorSetRequest> obj) {
        return this.setObjectDectPara(obj);
    }

    public BehaviorRespond getAreaEnter(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public BehaviorRespond getAreaExit(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public BehaviorRespond getLoitering(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public BehaviorRespond getFastMovement(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public IgtAlarmConfigRespond getIgtAlarmConfig(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public boolean setPerimeterZone(ParamBean<BehaviorSetRequest> obj) {
        Boolean enableTargetCount;
        Integer supportPointNum;
        ZKNvrDetectionCommonConfig config = ((BehaviorSetRequest)obj.getRequestBody()).getZknvrDetectionCommonConfig();
        JSONObject jsonObject = this.perimeterZone(Integer.valueOf(0), obj.getVcmInfo(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        Integer supportLineNum = config.getSupportNum();
        if (Objects.nonNull(supportLineNum)) {
            data.put("SupportLineNum", (Object)supportLineNum);
        }
        if (Objects.nonNull(supportPointNum = config.getSupportPointNum())) {
            data.put("SupportPointNum", (Object)supportPointNum);
        }
        if (Objects.nonNull(enableTargetCount = config.getEnable())) {
            data.put("EnableRegiDect", (Object)(enableTargetCount != false ? 1 : 0));
        }
        List counterPara = config.getCounterPara();
        JSONArray areaDetParams = (JSONArray)JSONArray.toJSON((Object)counterPara);
        areaDetParams.forEach(item -> {
            JSONObject areaDetParam = (JSONObject)item;
            areaDetParam.put("ObjectType", (Object)areaDetParam.getInteger("ObjType"));
        });
        if (Objects.nonNull(counterPara)) {
            data.put("AreaDetParam", (Object)areaDetParams);
        }
        this.perimeterZone(Integer.valueOf(1), obj.getVcmInfo(), data);
        this.setFrmDetectLinkPara(obj.getVcmInfo(), config, Integer.valueOf(3));
        return true;
    }

    public boolean setPerimeterLine(ParamBean<BehaviorSetRequest> obj) {
        Boolean enableTargetCount;
        Integer supportPointNum;
        ZKNvrDetectionCommonConfig config = ((BehaviorSetRequest)obj.getRequestBody()).getZknvrDetectionCommonConfig();
        JSONObject jsonObject = this.igtAlarmConfig(Integer.valueOf(0), obj.getVcmInfo(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        Integer supportLineNum = config.getSupportNum();
        if (Objects.nonNull(supportLineNum)) {
            data.put("SupportRegionNum", (Object)supportLineNum);
        }
        if (Objects.nonNull(supportPointNum = config.getSupportPointNum())) {
            data.put("SupportPointNum", (Object)supportPointNum);
        }
        if (Objects.nonNull(enableTargetCount = config.getEnable())) {
            data.put("EnableVirtuLine", (Object)(enableTargetCount != false ? 1 : 0));
        }
        List counterPara = config.getCounterPara();
        JSONArray areaDetParams = (JSONArray)JSONArray.toJSON((Object)counterPara);
        areaDetParams.forEach(item -> {
            JSONObject areaDetParam = (JSONObject)item;
            areaDetParam.put("ObjectType", (Object)areaDetParam.getInteger("ObjType"));
        });
        if (Objects.nonNull(counterPara)) {
            data.put("VirtualLineParam", (Object)areaDetParams);
        }
        this.igtAlarmConfig(Integer.valueOf(1), obj.getVcmInfo(), data);
        this.setFrmDetectLinkPara(obj.getVcmInfo(), config, Integer.valueOf(2));
        return true;
    }

    public boolean setAreaEnter(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    public boolean setAreaExit(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    public boolean setLoitering(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    public boolean setFastMovement(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    public boolean setIgtAlarmConfig(ParamBean<IgtAlarmConfigSetRequest> obj) {
        return false;
    }

    public boolean setVehicleIllegal(ParamBean<VehicleParameterSetRequest> obj) {
        return false;
    }

    public BehaviorRespond getElectroMobile(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public boolean setElectroMobile(ParamBean<BehaviorSetRequest> obj) {
        return false;
    }

    public boolean setVehicleDetect(ParamBean<VehicleParameterSetRequest> obj) {
        return false;
    }

    public boolean setVehicleParameter(ParamBean<VehicleParameterSetRequest> obj) {
        return false;
    }

    public VehicleParameterRespond getVehicleIllegal(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public VehicleParameterRespond getVehicleParameter(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public VehicleParameterRespond getVehicleDetect(ParamBean<BehaviorGetRequest> obj) {
        return null;
    }

    public ThirdAlgorithmRespond thirdAlgorithm(VcmReqBaseInfo vcmInfo) {
        return null;
    }

    public ThirdAlgorithmRespond thirdalgorithmParam(VcmReqBaseInfo vcmInfo, ThirdAlgorithm request) {
        return null;
    }

    public Boolean updateThirdalgorithmParam(VcmReqBaseInfo vcmInfo, ThirdAlgorithm request) {
        return null;
    }

    private JSONObject perimeterZone(Integer type, VcmReqBaseInfo vcmInfo, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)1);
        reqJson.put("Dev", (Object)1);
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_REGION_DECT_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zk ipc perimeterZone error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private JSONObject igtAlarmConfig(Integer type, VcmReqBaseInfo vcmInfo, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)1);
        reqJson.put("Dev", (Object)1);
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_VIRTUAL_LINE_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zk ipc igtAlarmConfig error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private void setFrmDetectLinkPara(VcmReqBaseInfo vcmInfo, ZKNvrDetectionCommonConfig config, Integer detectLinkType) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("DetectLinkType", (Object)detectLinkType);
        JSONObject frmDetectLinkPara = this.frmDetectLinkPara(Integer.valueOf(0), vcmInfo, requestBody);
        JSONObject frmDetectLinkData = frmDetectLinkPara.getJSONObject("Data");
        List alarmTime = config.getAlarmTime();
        if (Objects.nonNull(alarmTime)) {
            frmDetectLinkData.put("AlarmTime", (Object)ZKNvrUtils.buildAlarmTimeToJson((List)alarmTime));
        }
        frmDetectLinkData.put("HandleType", (Object)config.getCounterHandleType().getHandleType());
        frmDetectLinkData.put("DetectLinkType", (Object)detectLinkType);
        this.frmDetectLinkPara(Integer.valueOf(1), vcmInfo, frmDetectLinkData);
    }

    private JSONObject frmDetectLinkPara(Integer type, VcmReqBaseInfo vcmInfo, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)1);
        reqJson.put("Dev", (Object)1);
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_DETECT_LINK_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zk ipc frmDetectLinkPara error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    private BehaviorRespond getObjectDectPara(ParamBean<BehaviorGetRequest> obj, Integer detType) {
        BehaviorRespond behaviorRespond = new BehaviorRespond();
        JSONObject jsonObject = this.frmObjectDectPara(Integer.valueOf(0), obj.getVcmInfo(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        JSONObject requestBody = new JSONObject();
        requestBody.put("DetectLinkType", (Object)4);
        JSONObject frmDetectLinkPara = this.frmDetectLinkPara(Integer.valueOf(0), obj.getVcmInfo(), requestBody);
        ZKNvrDetectionCommonConfig config = new ZKNvrDetectionCommonConfig();
        if (Objects.nonNull(data)) {
            JSONObject frmDetectLinkParaData;
            List alarmTimes;
            config.setSupportNum(data.getInteger("SupportRegionNum"));
            config.setSupportPointNum(data.getInteger("SupportPointNum"));
            config.setEnable(Boolean.valueOf(data.getInteger("EnableObjDect") == 1));
            JSONArray goodsDetParam = data.getJSONArray("GoodsDetParam");
            if (Objects.nonNull(goodsDetParam)) {
                ArrayList<ZKNvrCounterPara> counterPara = new ArrayList<ZKNvrCounterPara>();
                for (int i = 0; i < goodsDetParam.size(); ++i) {
                    ZKNvrCounterPara zkNvrCounterPara = new ZKNvrCounterPara();
                    JSONObject counterParaJson = (JSONObject)goodsDetParam.get(i);
                    zkNvrCounterPara.setDetType(counterParaJson.getInteger("DetType"));
                    zkNvrCounterPara.setCounterPoint(counterParaJson.getJSONArray("CounterPoint").toJavaList(Integer[].class));
                    zkNvrCounterPara.setScale(counterParaJson.getInteger("Scale"));
                    zkNvrCounterPara.setIntervalTime(counterParaJson.getInteger("IntervalTime"));
                    zkNvrCounterPara.setPointNum(counterParaJson.getInteger("PointNum"));
                    counterPara.add(zkNvrCounterPara);
                }
                config.setCounterPara(counterPara);
            }
            if (Objects.nonNull(alarmTimes = ZKNvrUtils.buildJsonToAlarmTime((JSONArray)(frmDetectLinkParaData = frmDetectLinkPara.getJSONObject("Data")).getJSONArray("AlarmTime")))) {
                config.setAlarmTime(alarmTimes);
            }
            ZKNvrMotionHandleType smartMotionHandleType = new ZKNvrMotionHandleType();
            smartMotionHandleType.setHandleType(frmDetectLinkParaData.getInteger("HandleType"));
            config.setCounterHandleType(smartMotionHandleType);
        }
        behaviorRespond.setZknvrDetectionCommonConfig(config);
        return behaviorRespond;
    }

    private boolean setObjectDectPara(ParamBean<BehaviorSetRequest> obj) {
        List counterPara;
        Boolean enable;
        Integer supportPointNum;
        ZKNvrDetectionCommonConfig config = ((BehaviorSetRequest)obj.getRequestBody()).getZknvrDetectionCommonConfig();
        JSONObject jsonObject = this.frmObjectDectPara(Integer.valueOf(0), obj.getVcmInfo(), new JSONObject());
        JSONObject data = jsonObject.getJSONObject("Data");
        Integer supportLineNum = config.getSupportNum();
        if (Objects.nonNull(supportLineNum)) {
            data.put("SupportLineNum", (Object)supportLineNum);
        }
        if (Objects.nonNull(supportPointNum = config.getSupportPointNum())) {
            data.put("SupportPointNum", (Object)supportPointNum);
        }
        if (Objects.nonNull(enable = config.getEnable())) {
            data.put("EnableObjDect", (Object)(enable != false ? 1 : 0));
        }
        if (Objects.nonNull(counterPara = config.getCounterPara())) {
            data.put("GoodsDetParam", JSONArray.toJSON((Object)counterPara));
        }
        this.frmObjectDectPara(Integer.valueOf(1), obj.getVcmInfo(), data);
        this.setFrmDetectLinkPara(obj.getVcmInfo(), config, Integer.valueOf(4));
        return true;
    }

    private JSONObject frmObjectDectPara(Integer type, VcmReqBaseInfo vcmInfo, JSONObject data) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("Type", (Object)type);
        reqJson.put("Ch", (Object)1);
        reqJson.put("Dev", (Object)1);
        reqJson.put("Data", (Object)data);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestDigest((VcmReqBaseInfo)vcmInfo, (MsgType)ZKIpcMsgType.FRM_OBJECT_DECT_PARA, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)reqJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("zk ipc frmObjectDectPara error ", (Object)e.getMessage());
            throw new InvokeException("500", e.getMessage());
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

