/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy;

import com.zkteco.zkbiosecurity.cuserver.contants.TianDyMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RecordConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.VideoItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordStatusRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoBookMarkRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.tiandy.TianDyVideoNumOfMatchesBean;
import com.zkteco.zkbiosecurity.cuserver.enums.RecordTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VideoService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy.AbstractTIANDYService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.TDYUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XMLConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="videoTIANDYService")
public class VideoTIANDYServiceImpl
extends AbstractTIANDYService
implements VideoService<IServerType.Tiandy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoTIANDYServiceImpl.class);
    private static String getTemplate = null;

    public VideoRespond videoList(VcmReqBaseInfo vcmInfo, VideoListRequest req) {
        VideoRespond videoRespond = new VideoRespond();
        ArrayList videoItems = new ArrayList();
        if (req.getTypeList().size() == 3) {
            videoItems.addAll(Objects.requireNonNull(this.buildVideoListReq(vcmInfo, req, "ALL")));
        } else if (req.getTypeList().size() == 2) {
            List typeList = req.getTypeList();
            if (typeList.contains(RecordTypeEnum.MANUAL) && typeList.contains(RecordTypeEnum.PLAN)) {
                videoItems.addAll(Objects.requireNonNull(this.buildVideoListReq(vcmInfo, req, "Manual")));
                videoItems.addAll(Objects.requireNonNull(this.buildVideoListReq(vcmInfo, req, "Timer")));
            } else if (typeList.contains(RecordTypeEnum.MANUAL) && typeList.contains(RecordTypeEnum.ALARM)) {
                videoItems.addAll(Objects.requireNonNull(this.buildVideoListReq(vcmInfo, req, "Manual")));
                videoItems.addAll(Objects.requireNonNull(this.buildVideoListReq(vcmInfo, req, "Alarm")));
            } else if (typeList.contains(RecordTypeEnum.PLAN) && typeList.contains(RecordTypeEnum.ALARM)) {
                videoItems.addAll(Objects.requireNonNull(this.buildVideoListReq(vcmInfo, req, "Timer")));
                videoItems.addAll(Objects.requireNonNull(this.buildVideoListReq(vcmInfo, req, "Alarm")));
            }
        } else if (req.getTypeList().size() == 1) {
            if (req.getTypeList().contains(RecordTypeEnum.MANUAL)) {
                videoItems.addAll(Objects.requireNonNull(this.buildVideoListReq(vcmInfo, req, "Manual")));
            } else if (req.getTypeList().contains(RecordTypeEnum.PLAN)) {
                videoItems.addAll(Objects.requireNonNull(this.buildVideoListReq(vcmInfo, req, "Timer")));
            } else if (req.getTypeList().contains(RecordTypeEnum.ALARM)) {
                videoItems.addAll(Objects.requireNonNull(this.buildVideoListReq(vcmInfo, req, "Alarm")));
            }
        }
        videoRespond.setVideoItemList(videoItems);
        return videoRespond;
    }

    private List<VideoItem> buildVideoListReq(VcmReqBaseInfo vcmInfo, VideoListRequest req, String videoType) {
        ArrayList<VideoItem> videoItems = new ArrayList<VideoItem>();
        try {
            String searchResult = this.buildVideoListTemplate(vcmInfo, req, videoType, "0", "0");
            TianDyVideoNumOfMatchesBean maxSum = (TianDyVideoNumOfMatchesBean)XMLConvertor.convertXMLToBean((String)searchResult, TianDyVideoNumOfMatchesBean.class);
            int numOfMatches = Integer.parseInt(maxSum.getNumOfMatches());
            int pageSize = 40;
            int pageNum = numOfMatches % pageSize == 0 ? numOfMatches / pageSize : numOfMatches / pageSize + 1;
            int offset = 1;
            for (int i = 0; i < pageNum; ++i) {
                String videoResult = this.buildVideoListTemplate(vcmInfo, req, videoType, String.valueOf(offset), String.valueOf(pageSize));
                TianDyVideoNumOfMatchesBean videoObject = (TianDyVideoNumOfMatchesBean)XMLConvertor.convertXMLToBean((String)videoResult, TianDyVideoNumOfMatchesBean.class);
                List matchList = videoObject.getMatchList().getMatchElement();
                for (TianDyVideoNumOfMatchesBean.MatchList.MatchElement matchElement : matchList) {
                    VideoItem videoItem = new VideoItem();
                    videoItem.setChannelCode(req.getChannelCode());
                    videoItem.setRecordFileName(matchElement.getFileName());
                    videoItem.setStartTime(this.timeSpanConvertRes(matchElement.getTimeSpan().getStartTime()));
                    videoItem.setEndTime(this.timeSpanConvertRes(matchElement.getTimeSpan().getEndTime()));
                    if ("Timer".equals(matchElement.getType())) {
                        videoItem.setType(RecordTypeEnum.PLAN);
                    } else if ("Manual".equals(matchElement.getType())) {
                        videoItem.setType(RecordTypeEnum.MANUAL);
                    } else if ("Alarm".equals(matchElement.getType())) {
                        videoItem.setType(RecordTypeEnum.ALARM);
                    }
                    videoItems.add(videoItem);
                }
                offset += pageSize;
            }
        }
        catch (JAXBException e) {
            LOGGER.error("search Result convert exception", (Throwable)e);
        }
        return videoItems;
    }

    private String buildVideoListTemplate(VcmReqBaseInfo vcmInfo, VideoListRequest req, String videoType, String searchResultPostion, String maxResults) {
        String rsp = null;
        try {
            if (!StringUtils.isNotBlank((CharSequence)getTemplate)) {
                getTemplate = (String)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmInfo, (MsgType)TianDyMsgType.GET_VIDEO_RECORD_TEMPLATE, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
            }
            Document doc = DocumentHelper.parseText((String)getTemplate);
            Element root = doc.getRootElement();
            Element timeSpanElement = root.element("timeSpanList").element("timeSpan");
            timeSpanElement.element("startTime").setText(this.timeSpanConvertReq(req.getStartTime()));
            timeSpanElement.element("endTime").setText(this.timeSpanConvertReq(req.getEndTime()));
            root.element("contentTypeList").element("contentType").setText("video");
            root.element("RecTypeList").element("recType").setText(videoType);
            root.element("maxResults").setText(maxResults);
            root.element("searchResultPostion").setText(searchResultPostion);
            root.element("channelID").setText(String.valueOf(Integer.parseInt(req.getChannelCode().replaceAll("CH", "")) - 1));
            root.element("streamType").setText("main");
            root.element("queryType").setText("0");
            rsp = (String)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmInfo, (MsgType)TianDyMsgType.GET_VIDEO_RECORD, null, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)doc.asXML(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
        }
        catch (SDKException e) {
            LOGGER.error("TianDy nvr build VideoList Respond Req", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
        catch (DocumentException e) {
            LOGGER.error("Document Exception", (Throwable)e);
        }
        return rsp;
    }

    private String timeSpanConvertReq(String dateParam) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat sdfUtc = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String timeSpan = null;
        try {
            Date date = sdf.parse(dateParam);
            timeSpan = sdfUtc.format(date);
        }
        catch (ParseException e) {
            LOGGER.error("Time format conversion error", (Throwable)e);
        }
        return timeSpan;
    }

    private String timeSpanConvertRes(String dateParam) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdfUtc = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String timeSpan = null;
        try {
            Date date = sdfUtc.parse(dateParam);
            timeSpan = sdf.format(date);
        }
        catch (ParseException e) {
            LOGGER.error("Time format conversion error", (Throwable)e);
        }
        return timeSpan;
    }

    public Boolean videoStart(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        return null;
    }

    public Boolean videoStop(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        return null;
    }

    public List<VideoBookMarkRespond> getVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkSearchRequest req) {
        return null;
    }

    public String createVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return null;
    }

    public boolean uptVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return false;
    }

    public boolean delVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return false;
    }

    public VideoLockInfoListRespond getVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoListRequest req) {
        return null;
    }

    public VideoLockInfoRespond createVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public VideoLockInfoRespond delVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public VideoLockInfoRespond uptVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public List<RecordStatusRespond> getRecordStatus(ParamBean<ChannelListRequest> obj) {
        return null;
    }

    public RecordConfigRespond getConfig(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public boolean setConfig(ParamBean<RecordConfigRequest> obj) {
        return false;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

