/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy;

import com.zkteco.zkbiosecurity.cuserver.contants.TianDyMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.SystemConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.TimeConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.TimeConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.SystemConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SystemConfigService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.TDYUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="systemConfigTIANDYService")
public class SystemConfigTIANDYServiceImpl
implements SystemConfigService<IServerType.Tiandy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfigTIANDYServiceImpl.class);

    public boolean setTimeConfig(ParamBean<TimeConfigRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        TimeConfigRequest requestBody = (TimeConfigRequest)obj.getRequestBody();
        try {
            Document document = DocumentHelper.createDocument();
            Element time = document.addElement("Time");
            time.addElement("timeMode").setText("manual");
            time.addElement("localTime").setText(this.formatToLocalDate(requestBody.getTime()));
            time.addElement("timeZone").setText("CST+8:00:00");
            HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmInfo, (MsgType)TianDyMsgType.PUT_SYSTEM_TIME, null, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)document.asXML(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set Time Config", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
    }

    private String formatToLocalDate(String strDate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = sdf.parse(strDate);
            SimpleDateFormat sdfLocal = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdfLocal.format(date);
        }
        catch (ParseException e) {
            LOGGER.info("Date[{}] format error", (Object)strDate);
            throw new InvokeException("500", "cu_param_convert_error");
        }
    }

    public TimeConfigRespond getDateConfig(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean setSystemConfig(ParamBean<SystemConfigRequest> obj) {
        return false;
    }

    public SystemConfigRespond getSystemConfig(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

