/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.TianDyMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPPlayBackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPRealPlayRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVideoDownloadRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVoiceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPPlayBackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPRealPlayRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVideoDownloadRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVoiceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.tiandy.TianDyDeviceIpAndPortBean;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.RTSPService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy.AbstractTIANDYService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.TDYUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="rtspTIANDYService")
public class RTSPTIANDYServiceImpl
extends AbstractTIANDYService
implements RTSPService<IServerType.Tiandy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTSPTIANDYServiceImpl.class);
    private static final String RTSP_STR_SUB = "rtsp://%s:%s@%s:%s/%s/%s";
    private static final String RTSP_STR_RECORDING = "rtsp://%s:%s@%s:%s/replay/%s/%s?starttime=%s&endtime=%s";

    public RTSPRealPlayRespond realPlay(VcmReqBaseInfo vcmInfo, RTSPRealPlayRequest request) {
        JSONObject rtspUrl;
        RTSPRealPlayRespond rtspRealPlayRespond = new RTSPRealPlayRespond();
        ArrayList<JSONObject> rtspUrls = new ArrayList<JSONObject>();
        String channelCode = this.splitChannelCode(request.getChannelCode());
        String rtspPort = this.getRtspPort(vcmInfo);
        if (request.getType() == 0 || request.getType() == 1) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, 1));
                rtspUrl.put("type", (Object)1);
                rtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, 1));
                rtspUrl.put("type", (Object)1);
                rtspUrls.add(rtspUrl);
            }
        }
        if (request.getType() == 0 || request.getType() == 2) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, 2));
                rtspUrl.put("type", (Object)2);
                rtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, 2));
                rtspUrl.put("type", (Object)2);
                rtspUrls.add(rtspUrl);
            }
        }
        rtspRealPlayRespond.setRtspUrls(rtspUrls);
        return rtspRealPlayRespond;
    }

    private String getRtspPort(VcmReqBaseInfo vcmInfo) {
        String port = "554";
        try {
            TianDyDeviceIpAndPortBean rsp = (TianDyDeviceIpAndPortBean)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmInfo, (MsgType)TianDyMsgType.GET_IP_PORT_PARAM, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, TianDyDeviceIpAndPortBean.class), (List)this.getJSONHeaders(vcmInfo));
            List apList = rsp.getAdminAccessProtocolList().getAdminAccessProtocol();
            for (TianDyDeviceIpAndPortBean.AdminAccessProtocolList.AdminAccessProtocol ap : apList) {
                if (!StringUtils.isNotBlank((CharSequence)ap.getProtocol()) || !"RTSP".equals(ap.getProtocol()) || !StringUtils.isNotBlank((CharSequence)ap.getPortNo())) continue;
                port = ap.getPortNo();
            }
        }
        catch (SDKException e) {
            LOGGER.error("TianDy nvr get Rtsp Port fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
        return port;
    }

    public RTSPPlayBackRespond playBack(VcmReqBaseInfo vcmInfo, RTSPPlayBackRequest request) {
        JSONObject rtspUrl;
        RTSPPlayBackRespond rtspPlayBackRespond = new RTSPPlayBackRespond();
        ArrayList<JSONObject> playBackRtspUrls = new ArrayList<JSONObject>();
        String channelCode = this.splitChannelCode(request.getChannelCode());
        String startDate = request.getStartDate();
        String endDate = request.getEndDate();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdfUtc = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        try {
            Date start = sdf.parse(startDate);
            sdfUtc.setTimeZone(TimeZone.getTimeZone("UTC"));
            startDate = sdfUtc.format(start);
            Date end = sdf.parse(endDate);
            endDate = sdfUtc.format(end);
        }
        catch (ParseException e) {
            LOGGER.error("Time format conversion error", (Throwable)e);
        }
        String rtspPort = this.getRtspPort(vcmInfo);
        if (request.getType() == 0 || request.getType() == 1) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, 1, startDate, endDate));
                rtspUrl.put("type", (Object)1);
                playBackRtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, 1, startDate, endDate));
                rtspUrl.put("type", (Object)1);
                playBackRtspUrls.add(rtspUrl);
            }
        }
        if (request.getType() == 0 || request.getType() == 2) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, 2, startDate, endDate));
                rtspUrl.put("type", (Object)2);
                playBackRtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, 2, startDate, endDate));
                rtspUrl.put("type", (Object)2);
                playBackRtspUrls.add(rtspUrl);
            }
        }
        rtspPlayBackRespond.setRtspUrls(playBackRtspUrls);
        return rtspPlayBackRespond;
    }

    public RTSPVoiceRespond voice(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVoiceRespond broadcast(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVideoDownloadRespond videoDownload(VcmReqBaseInfo vcmInfo, RTSPVideoDownloadRequest request) {
        return null;
    }

    private String splitChannelCode(String channelCode) {
        if (StringUtils.isNotBlank((CharSequence)channelCode)) {
            if (channelCode.startsWith("CH")) {
                return channelCode.substring(2);
            }
            return channelCode;
        }
        return "";
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

