/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy;

import com.zkteco.zkbiosecurity.cuserver.contants.TianDyConstants;
import com.zkteco.zkbiosecurity.cuserver.contants.TianDyMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.tiandy.TianDyAlarmStateBean;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmCodeTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.MetaTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.util.DateUtil;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XMLConvertor;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EventTianDyGetThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventTianDyGetThread.class);
    private final String domainCode;
    private Integer readerId;
    private Integer sequence;
    private Integer lapNumber;
    private final WebSocketService webSocketService;
    private final SubscriptionHelp subscriptionHelp;

    public EventTianDyGetThread(String domainCode, String ip) {
        super("TianDy-" + ip + "-eventThread");
        this.domainCode = domainCode;
        this.webSocketService = (WebSocketService)SpringContextUtil.getBean((String)"webSocketService");
        this.subscriptionHelp = (SubscriptionHelp)SpringContextUtil.getBean((String)"subscriptionHelp");
    }

    @Override
    public void run() {
        int errorCount = 0;
        while (this.subscriptionHelp.get(this.domainCode) != null) {
            boolean getFail = false;
            VcmReqBaseInfo vcmReqBaseInfo = this.subscriptionHelp.get(this.domainCode);
            if (StringUtils.isBlank((CharSequence)vcmReqBaseInfo.getSdcUserName()) || StringUtils.isBlank((CharSequence)vcmReqBaseInfo.getSdcPassword())) {
                LOGGER.error("TianDy re-subscription failed :" + vcmReqBaseInfo.getVcmIp() + " please manually open");
                return;
            }
            TianDyAlarmStateBean alarmState = null;
            try {
                String xmlRsp = (String)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)TianDyMsgType.GET_ALARM_EVENT_STATE, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), null);
                alarmState = (TianDyAlarmStateBean)XMLConvertor.convertXMLToBean((String)xmlRsp, TianDyAlarmStateBean.class);
            }
            catch (Exception e) {
                LOGGER.error("TianDy get event fail,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
                this.readerId = null;
                this.sequence = null;
                this.lapNumber = null;
                getFail = true;
                try {
                    if (errorCount < 300) {
                        ++errorCount;
                    }
                    Thread.sleep(1000 * errorCount);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.error("sleep error", (Throwable)interruptedException);
                }
            }
            if (getFail) continue;
            errorCount = 0;
            if (ObjectUtils.isNotEmpty((Object)alarmState)) {
                try {
                    this.dealData(alarmState);
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    LOGGER.error("deal data error", (Throwable)e);
                }
                continue;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.error("sleep error", (Throwable)interruptedException);
            }
        }
        this.subscriptionHelp.remove(this.domainCode);
        LOGGER.info("Event check exit,domainCode:{}", (Object)this.domainCode);
    }

    private void dealData(TianDyAlarmStateBean data) {
        if (CollectionUtils.isEmpty((Collection)data.getAlertState())) {
            return;
        }
        List alarmData = data.getAlertState();
        for (TianDyAlarmStateBean.AlertState alertState : alarmData) {
            String eventType = alertState.getEventType();
            if (!Objects.nonNull(eventType) || !StringUtils.isNotBlank((CharSequence)((CharSequence)TianDyConstants.TIANDY_ALARM_MAP.get(eventType)))) continue;
            AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
            alarmEventRespond.setType(EventTypeEnum.ALARM);
            alarmEventRespond.setTime(DateUtil.dateToString((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
            alarmEventRespond.setDomainCode(this.domainCode);
            alarmEventRespond.setChannelCode("CH" + alertState.getChannelId());
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
            alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
            String alarmType = (String)TianDyConstants.TIANDY_ALARM_MAP.get(eventType);
            alarmEventRespond.setCode(alarmType);
            alarmEventRespond.setName(alarmType);
            alarmEventRespond.setId(UUID.randomUUID().toString());
            alarmEventRespond.setAlarmCodeType(AlarmCodeTypeEnum.ALARM_GENERAL_BUSINESS.toString());
            alarmEventRespond.setStatus(0);
            alarmEventRespond.setDeviceSubType(String.valueOf(DeviceTypeEnum.TIANDY.val()));
            this.webSocketService.send((BaseEventRespond)alarmEventRespond);
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

