/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.TianDyMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraAddRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRebootRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRemoveRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.PasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceDataBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceRouteRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.tiandy.TianDyChannelInfoBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.tiandy.TianDyChannelInfoStatusBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.tiandy.TianDyChannelSearchListBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.tiandy.TianDyDeviceInfoBean;
import com.zkteco.zkbiosecurity.cuserver.enums.ChannelStatusEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy.AbstractTIANDYService;
import com.zkteco.zkbiosecurity.cuserver.service.v2.tianDy.impl.DeviceManageTIANDYV2ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.TDYUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deviceManageTIANDYService")
public class DeviceManageTIANDYServiceImpl
extends AbstractTIANDYService
implements DeviceManageService<IServerType.Tiandy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageTIANDYServiceImpl.class);
    @Autowired
    private DeviceManageTIANDYV2ServiceImpl deviceManageTIANDYV2Service;
    @Autowired
    private WebSocketService webSocketService;

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public List<CameraRespond> listCamera(VcmReqBaseInfo vcmReqBaseInfo) {
        ArrayList<CameraRespond> cameraRespondList = new ArrayList<CameraRespond>();
        JSONArray channelArray = this.getChannelArray(vcmReqBaseInfo);
        Map channelStatus = this.getChannelStatus(vcmReqBaseInfo);
        for (int i = 0; i < channelArray.size(); ++i) {
            JSONObject channelObj = channelArray.getJSONObject(i);
            JSONObject channelInfo = channelObj.getJSONObject("sourceInputPortDescriptor");
            CameraRespond cameraRespond = new CameraRespond();
            cameraRespond.setCameraCode(channelObj.getString("id"));
            cameraRespond.setCameraName(channelInfo.getString("channelName"));
            cameraRespond.setIp(channelInfo.getString("ipAddress"));
            cameraRespond.setPort(channelInfo.getIntValue("adminPortNo"));
            cameraRespond.setUserName(channelInfo.getString("userName"));
            cameraRespond.setVendor("");
            cameraRespond.setCameraType("FIX");
            cameraRespond.setProtocolType(channelInfo.getString("adminProtocol"));
            if (!channelStatus.containsKey(cameraRespond.getCameraCode())) continue;
            JSONObject channel = (JSONObject)channelStatus.get(cameraRespond.getCameraCode());
            cameraRespond.setCameraCode("CH" + channelObj.getString("id"));
            if ("true".equals(channel.getString("online"))) {
                cameraRespond.setStatus(ChannelStatusEnum.ONLINE);
            } else {
                cameraRespond.setStatus(ChannelStatusEnum.OFFLINE);
            }
            if (!"true".equals(channel.getJSONObject("sourceInputBasicDescriptor").getString("enable"))) continue;
            cameraRespondList.add(cameraRespond);
        }
        return cameraRespondList;
    }

    public List<ChannelRespond> listChannel(VcmReqBaseInfo vcmReqBaseInfo) {
        return this.listChannel(vcmReqBaseInfo, false);
    }

    private List<ChannelRespond> listChannel(VcmReqBaseInfo vcmReqBaseInfo, boolean containNotConfigured) {
        ArrayList<ChannelRespond> channelRespondList = new ArrayList<ChannelRespond>();
        JSONArray channelArray = this.getChannelArray(vcmReqBaseInfo);
        Map channelStatus = this.getChannelStatus(vcmReqBaseInfo);
        for (int i = 0; i < channelArray.size(); ++i) {
            JSONObject channelObj = channelArray.getJSONObject(i);
            JSONObject channelInfo = channelObj.getJSONObject("sourceInputPortDescriptor");
            ChannelRespond channelRespond = new ChannelRespond();
            channelRespond.setCategory(DeviceTypeEnum.TIANDY.val());
            channelRespond.setChannelCode(channelObj.getString("id"));
            channelRespond.setParentCode("CH" + channelRespond.getChannelCode());
            channelRespond.setCameraName(channelInfo.getString("channelName"));
            channelRespond.setChannel(Integer.parseInt(channelInfo.getString("channel")));
            channelRespond.setProtocolType(channelInfo.getString("adminProtocol"));
            channelRespond.setVendor("");
            channelRespond.setIp(channelInfo.getString("ipAddress"));
            channelRespond.setPort(channelInfo.getIntValue("adminPortNo"));
            channelRespond.setModel("");
            channelRespond.setType(0);
            channelRespond.setCameraType("FIX");
            channelRespond.setUserName(channelInfo.getString("userName"));
            if (!channelStatus.containsKey(channelRespond.getChannelCode())) continue;
            JSONObject channel = (JSONObject)channelStatus.get(channelRespond.getChannelCode());
            channelRespond.setChannelCode("CH" + channelObj.getString("id"));
            if ("true".equals(channel.getString("online"))) {
                channelRespond.setStatus(ChannelStatusEnum.ONLINE);
            } else {
                channelRespond.setStatus(ChannelStatusEnum.OFFLINE);
            }
            if (!"true".equals(channel.getJSONObject("sourceInputBasicDescriptor").getString("enable"))) {
                if (!containNotConfigured) continue;
                channelRespondList.add(channelRespond);
                continue;
            }
            channelRespondList.add(channelRespond);
        }
        return channelRespondList;
    }

    private JSONArray getChannelArray(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            TianDyChannelInfoBean rsp = (TianDyChannelInfoBean)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)TianDyMsgType.GET_ALL_CHANNELS, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, TianDyChannelInfoBean.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            return JSONObject.parseObject((String)JSON.toJSONString((Object)rsp)).getJSONArray("inputProxyChannel");
        }
        catch (SDKException e) {
            LOGGER.error("get Channel Array fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
    }

    private Map<String, JSONObject> getChannelStatus(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            TianDyChannelInfoStatusBean rsp = (TianDyChannelInfoStatusBean)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)TianDyMsgType.GET_ALL_CHANNELS_STATUS, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, TianDyChannelInfoStatusBean.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>();
            JSONArray infoJson = JSONObject.parseObject((String)JSON.toJSONString((Object)rsp)).getJSONArray("inputProxyChnBasicStatus");
            for (int i = 0; i < infoJson.size(); ++i) {
                resultMap.put(infoJson.getJSONObject(i).getString("id"), infoJson.getJSONObject(i));
            }
            return resultMap;
        }
        catch (SDKException e) {
            LOGGER.error("get Channel Status fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
    }

    public ChannelRespond getChannel(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public List<String> getEmptyChannel(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean updateChannel(ParamBean<ChannelUpdateRequest> obj) {
        try {
            String uri = String.format(TianDyMsgType.GET_CHANNEL_OTHER.getUri(), ((ChannelUpdateRequest)obj.getRequestBody()).getChannelCode().replaceAll("CH", ""), 1);
            TianDyMsgType url = new TianDyMsgType(HttpMethodEnum.HTTP_METHOD_PUT, uri);
            String channel = this.getChannelInfo(obj, uri);
            Document doc = DocumentHelper.parseText((String)channel);
            Element root = doc.getRootElement();
            Element element = root.element("channelNameOverlay");
            element.element("channelName").setText(((ChannelUpdateRequest)obj.getRequestBody()).getName());
            HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)url, null, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)doc.asXML(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            return true;
        }
        catch (SDKException | DocumentException e) {
            LOGGER.error("update Channel fail", e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)((SDKException)e)));
        }
    }

    private String getChannelInfo(ParamBean<ChannelUpdateRequest> obj, String uri) {
        try {
            TianDyMsgType url = new TianDyMsgType(HttpMethodEnum.HTTP_METHOD_GET, uri);
            String rsp = (String)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)url, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("get Channel fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
    }

    public List<ChannelRespond> listChannelsByCamera(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode) {
        return null;
    }

    public CameraAddRespond addCamera(ParamBean<CameraAddRequest> obj) {
        return null;
    }

    public boolean removeCamera(ParamBean<CameraRemoveRequest> obj) {
        try {
            HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new TianDyMsgType(HttpMethodEnum.HTTP_METHOD_DELETE, TianDyMsgType.UPDATE_CHANNEL_INFO.getUri() + ((CameraRemoveRequest)obj.getRequestBody()).getCameraCode().replaceAll("CH", "")), null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("remove Camera fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
    }

    public boolean updatePassword(ParamBean<PasswordUpdateRequest> obj) {
        return false;
    }

    public boolean rebootCamera(ParamBean<CameraRebootRequest> obj) {
        try {
            String uri = String.format(TianDyMsgType.CHANNEL_REBOOT.getUri(), ((CameraRebootRequest)obj.getRequestBody()).getCameraCode().replaceAll("CH", ""));
            TianDyMsgType url = new TianDyMsgType(HttpMethodEnum.HTTP_METHOD_PUT, uri);
            HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)url, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("reboot Camera fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
    }

    public DeviceInfoRespond getDeviceInfo(VcmReqBaseInfo vcmInfo) {
        DeviceInfoRespond respond = new DeviceInfoRespond();
        try {
            TianDyDeviceInfoBean rsp = (TianDyDeviceInfoBean)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmInfo, (MsgType)TianDyMsgType.GET_DEVICE_INFO, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, TianDyDeviceInfoBean.class), (List)this.getJSONHeaders(vcmInfo));
            respond.setModel(rsp.getModel());
            JSONObject channelSum = this.deviceManageTIANDYV2Service.getChannelSum(vcmInfo);
            Integer maxChNum = Integer.parseInt(channelSum.getString("iDigitalChanNums"));
            respond.setDeviceVersion(rsp.getFirmwareVersion());
            respond.setProductName(rsp.getDeviceName());
            respond.setMaxChannelNumber(maxChNum);
        }
        catch (SDKException e) {
            LOGGER.error("TianDy NVR get Device Info error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public DeviceRouteRespond getDeviceVersion(VcmReqBaseInfo vcmInfo) {
        DeviceInfoRespond deviceInfo = this.getDeviceInfo(vcmInfo);
        DeviceRouteRespond respond = new DeviceRouteRespond();
        respond.setDeviceVersion(deviceInfo.getDeviceVersion());
        respond.setIp(vcmInfo.getVcmIp());
        respond.setModel(deviceInfo.getModel());
        respond.setProductName(deviceInfo.getProductName());
        return respond;
    }

    public boolean updateOfflinePassword(ParamBean<CameraAddRequest> obj) {
        try {
            String channelInfo = this.getChannelInfo(obj);
            Document doc = DocumentHelper.parseText((String)channelInfo);
            Element root = doc.getRootElement();
            Element element = root.element("sourceInputPortDescriptor");
            element.addElement("access").setText(((CameraAddRequest)obj.getRequestBody()).getConnectCode());
            element.element("userName").setText(((CameraAddRequest)obj.getRequestBody()).getDeviceUser());
            element.element("password").setText(((CameraAddRequest)obj.getRequestBody()).getDevicePassword());
            HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new TianDyMsgType(HttpMethodEnum.HTTP_METHOD_PUT, TianDyMsgType.UPDATE_CHANNEL_INFO.getUri() + ((CameraAddRequest)obj.getRequestBody()).getChannelCode().replaceAll("CH", "")), null, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)doc.getRootElement().asXML(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            return true;
        }
        catch (SDKException | DocumentException e) {
            LOGGER.error("update Offline Password", e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)((SDKException)e)));
        }
    }

    private String getChannelInfo(ParamBean<CameraAddRequest> obj) {
        try {
            String res = (String)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new TianDyMsgType(HttpMethodEnum.HTTP_METHOD_GET, TianDyMsgType.UPDATE_CHANNEL_INFO.getUri() + ((CameraAddRequest)obj.getRequestBody()).getChannelCode().replaceAll("CH", "")), null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            return res;
        }
        catch (SDKException e) {
            LOGGER.error("get Channel Info fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
    }

    public List<CameraSearchRespond> searchCamera(VcmReqBaseInfo vcmInfo, CameraSearchRequest request) {
        CompletableFuture.runAsync(() -> {
            String protocolType = Objects.nonNull(request) && "0".equals(request.getProtocolType()) ? "Onvif" : "private";
            DeviceEventRespond deviceEventRespond = new DeviceEventRespond();
            deviceEventRespond.setType(EventTypeEnum.OPERATE_RESULT);
            deviceEventRespond.setDomainCode(request.getDomainCode());
            deviceEventRespond.setPercent("100");
            deviceEventRespond.setSubtype("searchCamera");
            try {
                Document doc = DocumentHelper.createDocument();
                Element searchParam = doc.addElement("SearchParam");
                Element searchType = searchParam.addElement("SearchType");
                searchType.setText("1");
                Element searchMode = searchParam.addElement("SearchMode");
                searchMode.setText("0");
                this.searchCamera(vcmInfo, doc.asXML(), HttpMethodEnum.HTTP_METHOD_POST);
                long t1 = System.currentTimeMillis();
                ArrayList<CameraSearchRespond> cameras = new ArrayList<CameraSearchRespond>();
                while (true) {
                    long t2 = System.currentTimeMillis();
                    TianDyChannelSearchListBean res = this.getCameraList(vcmInfo);
                    JSONObject channelSearch = JSONObject.parseObject((String)JSON.toJSONString((Object)res));
                    JSONArray videoList = channelSearch.getJSONArray("videoSourceDescriptor");
                    for (int i = 0; i < videoList.size(); ++i) {
                        JSONObject cameraObject = videoList.getJSONObject(i);
                        DeviceDataBean data = new DeviceDataBean();
                        CameraSearchRespond cameraInfo = new CameraSearchRespond();
                        cameraInfo.setIp(cameraObject.getString("ipAddress"));
                        cameraInfo.setProtocol(cameraObject.getString("proxyProtocol"));
                        cameraInfo.setChannelNumber(cameraObject.getIntValue(""));
                        cameraInfo.setSubnetMask(cameraObject.getString("mask"));
                        cameraInfo.setPort(cameraObject.getString("managePortNo"));
                        cameraInfo.setGateway(cameraObject.getString("gateway"));
                        if (protocolType.equalsIgnoreCase(cameraObject.getString("proxyProtocol"))) {
                            cameras.add(cameraInfo);
                        }
                        data.setCameras(cameras);
                        deviceEventRespond.setData(data);
                    }
                    if ("true".equals(res.getEnding()) || t2 - t1 > 60000L) {
                        searchType.setText("0");
                        this.searchCamera(vcmInfo, doc.asXML(), HttpMethodEnum.HTTP_METHOD_POST);
                        break;
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("TianDY Nvr search Thread sleep error:{0}", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("search error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            }
            LOGGER.info("TianDY Nvr search camera data:{}", (Object)deviceEventRespond.toJSON());
            this.webSocketService.send((BaseEventRespond)deviceEventRespond);
        });
        return new ArrayList<CameraSearchRespond>();
    }

    private String searchCamera(VcmReqBaseInfo vcmInfo, String xmlStr, HttpMethodEnum methodEnum) {
        String res;
        try {
            res = (String)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmInfo, (MsgType)new TianDyMsgType(methodEnum, TianDyMsgType.GET_CHANNEL_SEARCH_RESULT.getUri()), null, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)xmlStr, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
        }
        catch (SDKException e) {
            LOGGER.error("TianDY Nvr start or stop search Camera fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
        return res;
    }

    private TianDyChannelSearchListBean getCameraList(VcmReqBaseInfo vcmInfo) {
        TianDyChannelSearchListBean res;
        try {
            res = (TianDyChannelSearchListBean)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)vcmInfo, (MsgType)new TianDyMsgType(HttpMethodEnum.HTTP_METHOD_GET, TianDyMsgType.GET_CHANNEL_SEARCH_RESULT.getUri()), null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, TianDyChannelSearchListBean.class), (List)this.getJSONHeaders(vcmInfo));
        }
        catch (SDKException e) {
            LOGGER.error("TianDY Nvr get Camera List fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
        return res;
    }
}

