/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.TianDyMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.StreamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.tiandy.TianDyDeviceActBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.tiandy.TianDyDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.respond.cu.device.CameraV2Respond;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceConfigManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy.AbstractTIANDYService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy.DeviceManageTIANDYServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.TDYUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deviceConfigManageTIANDYService")
public class DeviceConfigManageTIANDYServiceImpl
extends AbstractTIANDYService
implements DeviceConfigManageService<IServerType.Tiandy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceConfigManageTIANDYServiceImpl.class);
    @Autowired
    private DeviceManageTIANDYServiceImpl deviceManageTIANDYService;

    public TianDyDeviceRespond getActStatus(ParamBean<EmptyRequest> obj) {
        TianDyDeviceRespond respond;
        try {
            TianDyDeviceActBean rsp = (TianDyDeviceActBean)HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)TianDyMsgType.ACTIVE_STATUS, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, TianDyDeviceActBean.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            respond = new TianDyDeviceRespond();
            respond.setAdministrator(rsp.getAdministrator());
            respond.setActivated(rsp.getActivated());
        }
        catch (SDKException e) {
            LOGGER.error("get ActStatus error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), TDYUtils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public CameraV2Respond getBaseConfig(ParamBean<CameraRequest> obj) {
        List respondList = this.deviceManageTIANDYService.listCamera(obj.getVcmInfo());
        CameraV2Respond respond = new CameraV2Respond();
        for (CameraRespond cameraRespond : respondList) {
            if (!((CameraRequest)obj.getRequestBody()).getCameraCode().equals(cameraRespond.getCameraCode())) continue;
            respond.setCameraCode(cameraRespond.getCameraCode());
            respond.setCameraName(cameraRespond.getCameraName());
            respond.setConnectCode(cameraRespond.getConnectCode());
            respond.setDomainCode(cameraRespond.getDomainCode());
            respond.setIp(cameraRespond.getIp());
            respond.setPort(String.valueOf(cameraRespond.getPort()));
            respond.setModel(cameraRespond.getModel());
            respond.setVendor(cameraRespond.getVendor());
            respond.setProtocolType(cameraRespond.getProtocolType());
            respond.setUserName(cameraRespond.getUserName());
            respond.setCategory(Integer.valueOf(DeviceTypeEnum.TIANDY.val()));
            String cameraType = "1";
            if ("DOME".equals(cameraRespond.getCameraType())) {
                cameraType = "2";
            } else if ("HALFDOME".equals(cameraRespond.getCameraType())) {
                cameraType = "3";
            } else if ("BULLET".equals(cameraRespond.getCameraType())) {
                cameraType = "4";
            }
            respond.setCameraType(cameraType);
            return respond;
        }
        throw new InvokeException("500", "object_not_exist");
    }

    public JSONObject getTimeConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public CameraV2Respond getCameraBaseConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public JSONObject getCameraStreamConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public JSONObject getCameraOSDConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public JSONObject getCameraAudioConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public JSONObject getCameraAlarmInConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public Boolean setCameraAlarmInConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public JSONObject getCameraAlarmOutConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public Boolean setCameraAlarmOutConfig(ParamBean<CameraRequest> obj) {
        return null;
    }

    public StreamBean getMainStreamConfig(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public boolean setMainStreamConfig(ParamBean<StreamBean> obj) {
        return false;
    }

    public StreamBean getSubStreamConfig(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public boolean setSubStreamConfig(ParamBean<StreamBean> obj) {
        return false;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

